/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.project;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectTaskLabel;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectTaskLabelService;
import com.ym.tlifang.service.task.TaskLabelRelationService;
import com.ym.tlifang.task.TaskLabelRelation;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"projectTaskLabels"})
@Api(value="projectTaskLabels", description="\u9879\u76ee\u4efb\u52a1\u6807\u7b7e")
public class ProjectTaskLabelController
extends BaseController {
    @Reference
    private ProjectService projectService;
    @Reference
    private ProjectTaskLabelService projectTaskLabelService;
    @Reference
    private TaskLabelRelationService taskLabelRelationService;

    @GetMapping(value={"/{projectId}"})
    @ApiOperation(value="\u9879\u76ee\u4efb\u52a1\u6807\u7b7e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<ProjectTaskLabel>> findList(@PathVariable Long projectId) {
        List projectTaskLabelList = this.projectTaskLabelService.findByProjectId(projectId);
        return ResultModel.suc((Object)projectTaskLabelList);
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u9879\u76ee\u4efb\u52a1\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ProjectTaskLabel> add(@RequestBody ProjectTaskLabel projectTaskLabel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectTaskLabel.getProjectId()) || StringUtils.isEmpty((Object)projectTaskLabel.getName()) || StringUtils.isEmpty((Object)projectTaskLabel.getColor())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByProjectId(projectTaskLabel.getProjectId());
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        projectTaskLabel = this.projectTaskLabelService.save(projectTaskLabel);
        return ResultModel.suc((Object)projectTaskLabel);
    }

    @PutMapping(value={"/{projectTaskLabelId}"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u4efb\u52a1\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ProjectTaskLabel> update(@RequestBody ProjectTaskLabel projectTaskLabel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectTaskLabel) || StringUtils.isEmpty((Object)projectTaskLabel.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ProjectTaskLabel oldProjectTaskLabel = this.projectTaskLabelService.findById(projectTaskLabel.getId());
        if (oldProjectTaskLabel == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_LABEL_NO_EXIST, (String)languageType);
        }
        if (StringUtils.isNotBlank((String)projectTaskLabel.getName())) {
            oldProjectTaskLabel.setName(projectTaskLabel.getName());
        }
        if (StringUtils.isNotBlank((String)projectTaskLabel.getColor())) {
            oldProjectTaskLabel.setColor(projectTaskLabel.getColor());
        }
        oldProjectTaskLabel = this.projectTaskLabelService.save(oldProjectTaskLabel);
        return ResultModel.suc((Object)oldProjectTaskLabel);
    }

    @DeleteMapping(value={"/{projectTaskLabelId}"})
    @ApiOperation(value="\u79fb\u9664\u9879\u76ee\u4efb\u52a1\u6807\u7b7e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel detele(@PathVariable Long projectTaskLabelId, @LanguageType String languageType) {
        ProjectTaskLabel projectTaskLabel = this.projectTaskLabelService.findById(projectTaskLabelId);
        if (projectTaskLabel == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_LABEL_NO_EXIST, (String)languageType);
        }
        projectTaskLabel.setDelFlag(Boolean.valueOf(true));
        this.projectTaskLabelService.save(projectTaskLabel);
        List taskLabelRelationList = this.taskLabelRelationService.findByTagsId(projectTaskLabelId);
        for (TaskLabelRelation taskLabelRelation : taskLabelRelationList) {
            taskLabelRelation.setDelFlag(Boolean.valueOf(true));
            this.taskLabelRelationService.save(taskLabelRelation);
        }
        return ResultModel.ok();
    }
}

