/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.company;

import com.alibaba.dubbo.config.annotation.Reference;
import com.google.common.base.Joiner;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.excel.ExportExcel;
import com.ym.tlifang.model.attendance.AttendanceMemberModel;
import com.ym.tlifang.model.company.AccountSearchModel;
import com.ym.tlifang.model.company.InviteLinkModel;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.DictionaryService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.Dictionary;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"company"})
@Api(value="company", description="\u56e2\u961f\u76f8\u5173")
public class CompanyPersonController
extends BaseController {
    @Reference
    private UserService userService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private StringRedisTemplate redis;
    @Reference
    private CompanyService companyService;
    @Reference
    private ProjectService projectService;
    @Reference
    private AttendanceUserService attendanceUserService;
    @Reference
    private ProjectUserService projectUserService;
    @Reference
    private DictionaryService dictionaryService;

    @GetMapping(value={"/member/account"})
    @ApiOperation(value="\u5e10\u53f7\u641c\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="areaCode", value="\u624b\u673a\u533a\u53f7", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="account", value="\u5e10\u53f7", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AccountSearchModel> personalInfo(String account, Long companyId, String areaCode) {
        User user = this.userService.findByEmailOrMobile(account, areaCode);
        if (user != null) {
            CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
            Boolean isMember = false;
            if (companyMemberInfo != null) {
                isMember = true;
            }
            AccountSearchModel accountSearchModel = this.companyMemberInfoService.queryInfo(user, isMember);
            return ResultModel.suc((Object)accountSearchModel);
        }
        return ResultModel.ok();
    }

    @PostMapping(value={"/{companyId}/member/{userId}"})
    @ApiOperation(value="\u56e2\u961f\u6dfb\u52a0\u6210\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyMemberInfo> createMember(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long userId, @LanguageType String languageType) {
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMember == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMember != null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        User addUser = this.userService.findOne(userId);
        if (addUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        ResultModel memberInfoResultModel = this.companyMemberInfoService.createMember(company, addUser);
        return memberInfoResultModel;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{companyId}/uuid"})
    @ApiOperation(value="\u9080\u8bf7\u6210\u5458\u94fe\u63a5\u4ee4\u724c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<InviteLinkModel> inviteUuid(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        String uuid = InviteLinkModel.get32UUID();
        List urlType = this.dictionaryService.findByApplicationTypeAndDelFlagFalse("url_type");
        if (urlType == null) {
            return ResultModel.error((ResultStatus)ResultStatus.URL_NO_EXIST, (String)languageType);
        }
        String linkUrl = ((Dictionary)urlType.get(0)).getLabelCh() + "?uuid=" + uuid;
        String title = user.getName() + (Constants.LanguageType.US.getName().equals(languageType) ? "Invite you to join" : "\u9080\u8bf7\u4f60\u52a0\u5165") + companyMemberInfo.getCompany().getName();
        this.redis.boundValueOps((Object)uuid).set((Object)(companyId.toString() + "_" + user.getId().toString()), 1L, TimeUnit.DAYS);
        InviteLinkModel inviteLinkModel = new InviteLinkModel(companyId, user.getId().longValue(), linkUrl, title);
        return ResultModel.suc((Object)inviteLinkModel);
    }

    @GetMapping(value={"/companyAndUserInfo"})
    @ApiOperation(value="\u6839\u636ecode\u83b7\u53d6\u9080\u8bf7\u4eba\u548c\u56e2\u961f\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="code", value="\u94fe\u63a5\u7801", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel companyAndUserInfo(String code, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)code)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String s = (String)this.redis.boundValueOps((Object)code).get();
        String[] split = s.split("_");
        String companyIds = split[0];
        Long companyId = Long.parseLong(companyIds);
        String userIds = split[1];
        Long userId = Long.parseLong(userIds);
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMember == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        User users = this.userService.findById(userId);
        HashMap<String, String> companyMap = new HashMap<String, String>(2);
        companyMap.put("companyName", company.getName());
        companyMap.put("userName", users.getName());
        return ResultModel.suc(companyMap);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{code}"})
    @ApiOperation(value="\u9080\u8bf7\u6210\u5458\u94fe\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="code", value="\u94fe\u63a5\u7801", required=true, dataType="string", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel inviteCompanyInfo(@CurrentUser User user, @PathVariable String code, @LanguageType String languageType) {
        if (!this.redis.hasKey((Object)code).booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        String s = (String)this.redis.boundValueOps((Object)code).get();
        String[] split = s.split("_");
        String companyIds = split[0];
        Long companyId = Long.parseLong(companyIds);
        String userIds = split[1];
        Long userId = Long.parseLong(userIds);
        Company company = this.companyService.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMember != null) {
            return ResultModel.ok();
        }
        companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.AuditMember.getType());
        if (companyMember != null) {
            return ResultModel.ok();
        }
        this.companyMemberInfoService.createCompanyMemberInfo(user, company, userId);
        return ResultModel.ok();
    }

    @PutMapping(value={"/{companyId}/auditId/{auditId}"})
    @ApiOperation(value="\u63a5\u53d7/\u62d2\u7edd\u6210\u5458\u52a0\u5165\u56e2\u961f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="auditId", value="\u88ab\u5ba1\u6838\u8005id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="status", value="\u72b6\u6001\uff081\uff1a\u63a5\u53d7 2\uff1a\u62d2\u7edd\uff09", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Company> auditCompanyInfo(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long auditId, String status, @LanguageType String languageType) {
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, auditId, Constants.AuditStatus.AuditMember.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYAUDIT_NO_MEMVER, (String)languageType);
        }
        ResultModel companyResultModel = this.companyMemberInfoService.updateAuditCompanyMember(user, companyMemberInfo, status, languageType);
        return companyResultModel;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}/member"})
    @ApiOperation(value="\u516c\u53f8\u6210\u5458\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyMemberInfo> companyMember(@CurrentUser User currentUser, @PathVariable Long companyId, @LanguageType String languageType) {
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, currentUser.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMember == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List companyMemberInfoList = this.companyMemberInfoService.findByCompanyId(companyId);
        if (StringUtils.isEmpty((Object)companyMemberInfoList)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        ArrayList companyMemberInfos = new ArrayList();
        for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
            User user = companyMemberInfo.getUser();
            user.setManager(companyMemberInfo.getManager());
        }
        return ResultModel.suc((Object)companyMemberInfoList);
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u516c\u53f8\u6210\u5458\u8868-\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="token", value="token\u4e32", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel addRecord(@LanguageType String languageType, String token, HttpServletResponse response, Long companyId) throws Exception {
        Long userId = Long.valueOf(JwtUtil.checkTokenRtnUserId((String)token));
        Boolean bl = this.companyMemberInfoService.havePower(companyId, userId);
        if (bl.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List companyMemberInfoList = this.companyMemberInfoService.findByCompanyId(companyId);
        if (companyMemberInfoList.size() == 0) {
            return ResultModel.error((ResultStatus)ResultStatus.ATTENDENCE_COUNT, (String)languageType);
        }
        Boolean firstTime = true;
        ExportExcel exportExcel = null;
        Row row = null;
        for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
            if (firstTime.booleanValue()) {
                ArrayList<String> strings = new ArrayList<String>();
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Workers" : "\u5de5\u53f7");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Name" : "\u59d3\u540d");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Sex" : "\u6027\u522b");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Department" : "\u6240\u5c5e\u90e8\u95e8");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Position" : "\u804c\u4f4d");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Mobile" : "\u624b\u673a");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Mailbox" : "\u90ae\u7bb1");
                strings.add(Constants.LanguageType.US.getName().equals(languageType) ? "Birthday" : "\u751f\u65e5");
                exportExcel = new ExportExcel(Constants.LanguageType.US.getName().equals(languageType) ? "Member info" : "\u6210\u5458\u4fe1\u606f", strings, "1", null);
                firstTime = false;
            }
            row = exportExcel.addRow();
            row.setHeightInPoints(22.0f);
            exportExcel.addCellColor(row, 0, null, companyMemberInfo.getWorkers());
            exportExcel.addCellColor(row, 1, null, companyMemberInfo.getUser().getName());
            String sexName = "1".equals(companyMemberInfo.getUser().getSex()) ? "\u7537" : ("2".equals(companyMemberInfo.getUser().getSex()) ? "\u5973" : "\u672a\u9009");
            exportExcel.addCellColor(row, 2, null, sexName);
            List stringList = this.companyUserRelationService.findDepartmentByCompanyId(companyId, companyMemberInfo.getUserId());
            exportExcel.addCellColor(row, 3, null, stringList.size() > 0 ? Joiner.on((String)"/").join((Iterable)stringList) : "\u65e0");
            List positionNameList = this.companyUserRelationService.findPositionNameListByUserIdAndCompanyId(companyId, companyMemberInfo.getUserId());
            exportExcel.addCellColor(row, 4, null, positionNameList.size() > 0 ? Joiner.on((String)"/").join((Iterable)positionNameList) : "\u65e0");
            exportExcel.addCellColor(row, 5, null, companyMemberInfo.getMobile());
            exportExcel.addCellColor(row, 6, null, companyMemberInfo.getEmail());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            exportExcel.addCellColor(row, 7, null, companyMemberInfo.getUser().getBirthdate() == null ? null : formatter.format(companyMemberInfo.getUser().getBirthdate()));
        }
        exportExcel.addListCellColor();
        String fileName = ((CompanyMemberInfo)companyMemberInfoList.get(0)).getCompany().getName() + (Constants.LanguageType.US.getName().equals(languageType) ? "Member info" : "\u56e2\u961f\u6210\u5458\u4fe1\u606f") + ".xlsx";
        exportExcel.write(response, fileName).dispose();
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{companyId}/member/{userId}"})
    @ApiOperation(value="\u6210\u5458\u4fe1\u606f\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237(\u53ef\u4e0d\u4f20)", required=false, dataType="Long", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyMemberInfo> updateMember(@RequestBody CompanyMemberInfo companyMemberInfo, @CurrentUser User user, @PathVariable Long userId, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyManager = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyManager == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyManager.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        CompanyMemberInfo oldCompanyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (StringUtils.isEmpty((Object)oldCompanyMemberInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        this.companyMemberInfoService.updateCompanyMember(oldCompanyMemberInfo, companyMemberInfo);
        return ResultModel.ok();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{companyId}/member/{companyMemberinfoId}"})
    @ApiOperation(value="\u6210\u5458\u4fe1\u606f\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="companyMemberinfoId", value="\u516c\u53f8\u6210\u5458id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<CompanyMemberInfo> memberDel(@CurrentUser User user, @PathVariable Long companyMemberinfoId, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyMemberinfoId) || StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfos = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (StringUtils.isEmpty((Object)companyMemberInfos)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfos.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, companyMemberinfoId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyManager.getType()) && companyMemberInfos.getManager().equals(Constants.ManagerStatus.companyManager.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBER_NO_PERMISSION, (String)languageType);
        }
        User companyMember = this.userService.findById(companyMemberinfoId);
        ResultModel companyMemberInfoResultModel = this.companyMemberInfoService.deleteCompanyMember(user, companyMember, companyMemberInfo, languageType);
        return companyMemberInfoResultModel;
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{companyId}/member"})
    @ApiOperation(value="\u6210\u5458\u9000\u51fa\u56e2\u961f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<User> memberQuit(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company company = this.companyService.findById(companyId);
        if (company.getOwnerId().equals(user.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_OWNER, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (StringUtils.isEmpty((Object)companyMemberInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel companyMemberInfoResultModel = this.companyMemberInfoService.reduceCompanyMember(user, companyMemberInfo, companyId);
        return companyMemberInfoResultModel;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}/user"})
    @ApiOperation(value="\u516c\u53f8\u6210\u5458\u4e2a\u4eba\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<CompanyMemberInfo> infoCompany(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        return ResultModel.suc((Object)companyMemberInfo);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{companyId}/manager/{userId}"})
    @ApiOperation(value="\u8bbe\u7f6e\u7ba1\u7406\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<CompanyMemberInfo> manager(@CurrentUser User user, @PathVariable Long userId, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company company = this.companyService.findByOwnerIdAndId(user.getId(), companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel companyMemberInfoResultModel = this.companyMemberInfoService.updateManager(user, companyMemberInfo, languageType);
        return companyMemberInfoResultModel;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}/attendance/{attendanceClassesId}/members"})
    @ApiOperation(value="\u516c\u53f8\u8003\u52e4\u5269\u4f59\u6210\u5458\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="attendanceClassesId", value="\u5f53\u524d\u8003\u52e4\u73ed\u6b21id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyMemberInfo> attendanceMember(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long attendanceClassesId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)attendanceClassesId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMember = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMember == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMember.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        List attendanceUserList = this.attendanceUserService.findByCompanyIdAndDelFlagFalse(companyId);
        List companyMemberInfoList = this.companyMemberInfoService.findByCompanyIdAndStatus(companyId, Constants.AuditStatus.adopt.getType());
        ArrayList<CompanyMemberInfo> companyMemberInfos = new ArrayList<CompanyMemberInfo>();
        if (StringUtils.isEmpty((Object)companyMemberInfoList)) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
            Boolean flag = true;
            for (AttendanceUser attendanceUser : attendanceUserList) {
                if (!attendanceUser.getUserId().equals(companyMemberInfo.getUserId())) continue;
                flag = false;
                break;
            }
            if (!flag.booleanValue()) continue;
            companyMemberInfos.add(companyMemberInfo);
        }
        List classesIdUserIdList = this.attendanceUserService.findByClassesIdUserId(attendanceClassesId);
        AttendanceMemberModel attendanceMemberModel = new AttendanceMemberModel();
        attendanceMemberModel.setCompanyMemberInfos(companyMemberInfos);
        attendanceMemberModel.setSelectedMemberInfo(classesIdUserIdList);
        return ResultModel.suc((Object)attendanceMemberModel);
    }
}

