/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.system;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.dao.system.EnclosureDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=EnclosureService.class, timeout=30000, retries=-1)
public class EnclosureServiceImpl
extends AbstractBaseService<EnclosureEntity, EnclosureDao>
implements EnclosureService {
    @Autowired
    UserService userService;

    public List<Map<String, Object>> findByKeyIdAndType(Long keyId, String type) {
        List enclosureLists = ((EnclosureDao)this.dao).findByKeyIdAndTypeAndDelFlag(keyId, type, Boolean.valueOf(false));
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (EnclosureEntity entity : enclosureLists) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            User user = this.userService.findById(entity.getCreateBy());
            map.put("enclosureInfo", entity);
            map.put("createByName", user.getName());
            map.put("createByAvatar", user.getAvatar());
            mapList.add(map);
        }
        return mapList;
    }

    public EnclosureEntity saveEnclosure(EnclosureEntity enclosureEntity) {
        return (EnclosureEntity)((EnclosureDao)this.dao).save((Object)enclosureEntity);
    }

    public void deleteEnclosure(Long id, Long userId) {
        EnclosureEntity entity = ((EnclosureDao)this.dao).findByIdAndDelFlag(id, Boolean.valueOf(false));
        entity.setDelFlag(Boolean.valueOf(true));
        entity.setUpdateBy(userId);
        ((EnclosureDao)this.dao).save((Object)entity);
    }

    public EnclosureEntity findById(Long id) {
        return ((EnclosureDao)this.dao).findByIdAndDelFlag(id, Boolean.valueOf(false));
    }

    public List<EnclosureEntity> findAppendix(Long keyId, String type) {
        return ((EnclosureDao)this.dao).findByKeyIdAndTypeAndDelFlag(keyId, type, Boolean.valueOf(false));
    }

    public EnclosureEntity save(EnclosureEntity entity) {
        return (EnclosureEntity)super.save((BaseEntity)entity);
    }

    public EnclosureEntity findByMongodbId(String mongodbId) {
        return ((EnclosureDao)this.dao).findByMongodbId(mongodbId);
    }

    public void updateEnclosureKeyIdByAttendanceOutsideId(Long enclosureId, Long attendanceOutsideId) {
        ((EnclosureDao)this.dao).updateEnclosureKeyIdByAttendanceOutsideId(enclosureId, attendanceOutsideId);
    }

    public void deleteMeetingEnclosure(Long meetingId) {
        ((EnclosureDao)this.dao).deleteMeetingEnclosure(meetingId);
    }

    public String repeatAttachmentCheck(String type, Long keyId, Long createBy, String name) {
        String resultFileNmae = name.substring(0, name.indexOf("."));
        Integer attachCount = ((EnclosureDao)this.dao).countNameByTypeAndKeyIdAndCreateByAndDelFlagFalseAndNameLike(type, keyId, createBy, resultFileNmae + "%");
        if (attachCount > 0) {
            return resultFileNmae + "(" + attachCount + ")" + name.substring(name.lastIndexOf("."));
        }
        return name;
    }
}

