/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.project;

import com.alibaba.dubbo.config.annotation.Service;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.project.ProjectDao;
import com.ym.tlifang.dao.task.TaskPanelDao;
import com.ym.tlifang.model.project.ProjectColorAvatarModel;
import com.ym.tlifang.model.project.ProjectMemberAddDelModel;
import com.ym.tlifang.model.user.OwnerModle;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.DictionaryService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.Dictionary;
import com.ym.tlifang.task.TaskPanel;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ProjectService.class, timeout=30000, retries=-1)
public class ProjectServiceImpl
extends AbstractBaseService<Project, ProjectDao>
implements ProjectService {
    Logger logger = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Autowired
    private TaskPanelDao taskPanelDao;
    @Autowired
    private ProjectUserService projectUserService;
    @Autowired
    private UserService userService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FileFolderService fileFolderService;
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private TaskConcernService taskConcernService;
    @Autowired
    private DynamicService dynamicService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();
    @Autowired
    private XgPushService xgPushService;

    public Project findByProjectId(Long projectId) {
        return ((ProjectDao)this.dao).findByIdAndDelFlag(projectId, Boolean.valueOf(false));
    }

    public Boolean findByProjectIdAndCompanyId(Long projectId) {
        return ((ProjectDao)this.dao).findByIdAndCompanyIdIsNotNullAndDelFlagFalse(projectId) != null;
    }

    public Project findByProjectIdNotFlag(Long projectId) {
        return ((ProjectDao)this.dao).findById(projectId);
    }

    public Project save(Project project) {
        return (Project)super.save((BaseEntity)project);
    }

    public void saveDefaultProjectAndDefaultPanel(Long userId, Long comanyId, String languageType) {
        if (StringUtils.isEmpty((Object)comanyId)) {
            Project personalProject = (Project)super.save((BaseEntity)new Project(Constants.LanguageType.US.getName().equals(languageType) ? "Default personal project" : "\u9ed8\u8ba4\u4e2a\u4eba\u9879\u76ee", "0", userId, "cloud-b", "#ffdc2e", "0", "1"));
            this.projectUserService.save(new ProjectUser(userId, personalProject.getId(), "1", "0"));
            this.taskPanelDao.save((Object)new TaskPanel(personalProject.getId(), Constants.LanguageType.US.getName().equals(languageType) ? "Default panel" : "\u9ed8\u8ba4\u9762\u677f", Long.valueOf(1L), "1"));
            this.fileFolderService.autoGenerateFolder(personalProject.getId(), Constants.FileType.project.getType(), userId, "0", languageType);
        } else {
            Project companyProject = (Project)super.save((BaseEntity)new Project(Constants.LanguageType.US.getName().equals(languageType) ? "Default company project" : "\u9ed8\u8ba4\u516c\u53f8\u9879\u76ee", comanyId, "0", userId, "sun-b", "#f1aceb", "0", "1"));
            this.projectUserService.save(new ProjectUser(userId, comanyId, companyProject.getId(), "1", "0"));
            this.taskPanelDao.save((Object)new TaskPanel(companyProject.getId(), Constants.LanguageType.US.getName().equals(languageType) ? "Default panel" : "\u9ed8\u8ba4\u9762\u677f", Long.valueOf(1L), "1"));
            this.fileFolderService.autoGenerateFolder(companyProject.getId(), Constants.FileType.project.getType(), userId, "1", languageType);
        }
    }

    public Project findByOwnerIdAndType(Long ownerId, String type) {
        return ((ProjectDao)this.dao).findByOwnerIdAndTypeAndCompanyIdIsNullAndDelFlag(ownerId, type, Boolean.valueOf(false));
    }

    public Project findByOwnerIdAndTypeAndCompanyId(Long ownerId, String type, Long companyId) {
        return ((ProjectDao)this.dao).findByOwnerIdAndTypeAndCompanyIdAndDelFlag(ownerId, type, companyId, Boolean.valueOf(false));
    }

    public Project findByOwnerIdAndCompanyIdAndId(Long ownerId, Long companyId, Long projectId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectDao)this.dao).findByOwnerIdAndCompanyIdIsNullAndIdAndDelFlagFalse(ownerId, projectId);
        }
        return ((ProjectDao)this.dao).findByOwnerIdAndCompanyIdAndIdAndDelFlagFalse(ownerId, companyId, projectId);
    }

    public Project findByCompanyIdAndName(Long companyId, String name) {
        return ((ProjectDao)this.dao).findByCompanyIdAndNameAndDelFlagFalse(companyId, name);
    }

    public Project findByOwnerIdAndCompanyIdAndName(Long ownerId, Long companyId, String name) {
        if (!StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectDao)this.dao).findByOwnerIdAndCompanyIdAndNameAndDelFlagFalse(ownerId, companyId, name);
        }
        return ((ProjectDao)this.dao).findByOwnerIdAndCompanyIdIsNullAndNameAndDelFlagFalse(ownerId, name);
    }

    public Project findByOwnerIdAndId(Long ownerId, Long id) {
        return ((ProjectDao)this.dao).findByOwnerIdAndIdAndDelFlagFalse(ownerId, id);
    }

    public List<Project> findListByCompanyIdAndOwnerId(Long companyId, Long ownerId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectDao)this.dao).findListByCompanyIdIsNullAndOwnerIdAndDelFlagFalse(ownerId);
        }
        return ((ProjectDao)this.dao).findListByCompanyIdAndOwnerIdAndDelFlagFalse(companyId, ownerId);
    }

    public Project findByCompanyIdAndProjectId(Long companyId, Long projectId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectDao)this.dao).findByCompanyIdIsNullAndIdAndDelFlagFalse(projectId);
        }
        return ((ProjectDao)this.dao).findByCompanyIdAndIdAndDelFlagFalse(companyId, projectId);
    }

    public List<Project> findByIdAndDelFlagFalse(List<Project> projects, User user, Long companyId, String languageType) {
        Project projectId = this.findByProjectId(projects.get(0).getId());
        List projectList = this.projectList(user, projects, companyId, languageType);
        return projectList;
    }

    public List<Project> projectList(User user, List<Project> projects, Long companyId, String languageType) {
        ArrayList<Project> projectList = new ArrayList<Project>();
        if (projects != null) {
            for (Project project : projects) {
                project = (Project)this.projectInfo(user, project, companyId, languageType).getData();
                projectList.add(project);
            }
        }
        return projectList;
    }

    public ResultModel<Project> projectInfo(User user, Project project, Long companyId, String languageType) {
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), project.getId(), languageType);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        project.setAsterisk(projectUser.getStatus());
        List projectUsers = this.projectUserService.findListByCompanyIdAndProjectId(companyId, project.getId());
        if (projectUsers == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        int memberCount = projectUsers.size();
        project.setMemberCount(Integer.valueOf(memberCount));
        user = this.userService.findById(project.getOwnerId());
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        projectUser = this.projectUserService.findByCompanyIdAndUserIdAndProjectId(companyId, user.getId(), project.getId());
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        OwnerModle owner = new OwnerModle(user.getId(), user.getName(), user.getAvatar(), projectUser.getType());
        project.setOwnerModle(owner);
        List projectUserList = this.projectUserService.findListByCompanyIdAndProjectId(companyId, project.getId());
        if (projectUserList == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        ArrayList<User> ownerModelList = new ArrayList<User>();
        for (ProjectUser users : projectUserList) {
            user = users.getUser();
            user.setManager(users.getType());
            ownerModelList.add(user);
        }
        project.setMembers(ownerModelList);
        Integer todayTask = this.taskService.countByProjectIdAndUpdateDateAndDelFlagFalse(project.getId());
        project.setTodayTask(todayTask);
        Integer finishTask = this.taskService.countByProjectIdAndStatusAndDelFlagFalse(project.getId(), "1");
        project.setFinishTask(finishTask);
        Integer taskCount = this.taskService.countByProjectIdAndDelFlagFalse(project.getId());
        project.setTasksCount(taskCount);
        return ResultModel.suc((Object)project);
    }

    public ResultModel<Project> createProject(Project project, User user, String languageType) {
        Dictionary color_type = this.dictionaryService.findByTypeAndDelFlagFalse("color_type");
        if (color_type == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PCOLOR_NO_EXIST, (String)languageType);
        }
        project.setColor(color_type.getLabelCh());
        Dictionary logo_type = this.dictionaryService.findByTypeAndDelFlagFalse("logo_type");
        if (logo_type == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PLOGO_NO_EXIST, (String)languageType);
        }
        project.setLogo(logo_type.getLabelCh());
        project.setOwnerId(user.getId());
        project.setName(emojiConverter.toAlias(project.getName()));
        project.setDescription(emojiConverter.toAlias(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        if (project.getDateDue() != null && !project.getDateDue().after(new Date())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if ((project = this.save(project)).getAdduser() != null) {
            for (Long addUser : project.getAdduser()) {
                ProjectUser projectUser = new ProjectUser(addUser, project.getCompanyId(), project.getId(), Constants.AsteriskStatus.noAsterisk.getType());
                if (addUser.equals(project.getOwnerId())) {
                    projectUser.setType(Constants.TypeStatus.projectOwner.getType());
                } else {
                    projectUser.setType(Constants.TypeStatus.projectOrdinaryMember.getType());
                }
                this.projectUserService.save(projectUser);
                if (projectUser.getType().equals(Constants.TypeStatus.projectOwner.getType())) continue;
                if ("0".equals("0")) {
                    if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.projectInvitation.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                    continue;
                }
                if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                this.xgPushService.pushTokenForeign(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getEnglishName(), user.getName() + Constants.ContentNotify.projectInvitation.getEnglishName() + project.getName(), Constants.SHOWFLAG);
            }
        }
        this.taskPanelDao.save((Object)new TaskPanel(project.getId(), Constants.LanguageType.US.getName().equals(languageType) ? "Default panel" : "\u9ed8\u8ba4\u9762\u677f", Long.valueOf(1L), "1"));
        return ResultModel.suc((Object)project);
    }

    public ResultModel<Project> updateProject(User user, Project projectOwner, Project project, String languageType) {
        if (!StringUtils.isEmpty((Object)project.getName())) {
            projectOwner.setName(emojiConverter.toAlias(project.getName()));
        }
        if (!StringUtils.isEmpty((Object)project.getDescription())) {
            projectOwner.setDescription(emojiConverter.toAlias(project.getDescription()));
        }
        if (!StringUtils.isEmpty((Object)project.getTaskLayoutStyle())) {
            projectOwner.setTaskLayoutStyle(project.getTaskLayoutStyle());
        }
        if (!StringUtils.isEmpty((Object)project.getDateDue())) {
            Date date1 = project.getDateDue();
            boolean after = date1.after(new Date());
            if (!after) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            projectOwner.setDateDue(project.getDateDue());
        }
        project = this.save(projectOwner);
        return ResultModel.suc((Object)project);
    }

    public ResultModel<Project> updateHandProject(User user, ProjectUser projectOwnerUser, Project project, Long userId, String languageType) {
        projectOwnerUser.setType(Constants.TypeStatus.projectManager.getType());
        this.projectUserService.save(projectOwnerUser);
        projectOwnerUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(userId, project.getId(), languageType);
        if (projectOwnerUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        projectOwnerUser.setType(Constants.TypeStatus.projectOwner.getType());
        this.projectUserService.save(projectOwnerUser);
        project.setOwnerId(userId);
        project = this.save(project);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", project.getId());
        map.put("action", "\u79fb\u4ea4\u9879\u76ee");
        map.put("msg", user.getName() + Constants.NoticeContent.letProject.getName() + project.getName() + Constants.NoticeContent.removeToYou.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.letProject.getNameEnglish() + project.getName() + Constants.NoticeContent.removeToYou.getNameEnglish());
        try {
            this.noticeService.saveSendNotice(userId, Constants.NoticeParentType.project, Constants.NoticeType.ProjectMakeOver, Constants.Originator.member, user.getId(), map, "2");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        this.dynamicService.saveDynamic(user.getId(), Constants.DynamicParentType.project, project.getId(), Constants.DynamicOriginatorType.project, project.getId(), Constants.DynamicType.moveProject.getName(), Constants.DynamicActionType.postProject, Constants.DynamicType.moveProject.getNameEnglish());
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)projectOwnerUser.getUser()) && StringUtils.isNotBlank((String)projectOwnerUser.getUser().getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(projectOwnerUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.handOverProject.getName() + "\u79fb\u4ea4\u7ed9\u4f60", null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)projectOwnerUser.getUser()) && StringUtils.isNotBlank((String)projectOwnerUser.getUser().getPushToken())) {
            this.xgPushService.pushTokenForeign(projectOwnerUser.getUser().getPushToken(), Constants.TitleNotify.project.getEnglishName(), user.getName() + Constants.ContentNotify.handOverProject.getEnglishName(), Constants.SHOWFLAG);
        }
        return ResultModel.suc((Object)project);
    }

    public ResultModel<Project> updateLogoAndColorProject(User user, ProjectColorAvatarModel projectColorAvatarModel, Project project) {
        if (!StringUtils.isEmpty((Object)projectColorAvatarModel.getColor())) {
            project.setColor(projectColorAvatarModel.getColor());
        }
        if (!StringUtils.isEmpty((Object)projectColorAvatarModel.getLogo())) {
            project.setLogo(projectColorAvatarModel.getLogo());
        }
        project = this.save(project);
        return ResultModel.suc((Object)project);
    }

    public ResultModel<Project> updateProjectStatus(User user, Project project, ProjectMemberAddDelModel projectMemberAddDelModel, String languageType) {
        HashMap<String, Object> map;
        List projectUserList;
        if (Constants.ProjectStatus.projectConduct.getType().equals(projectMemberAddDelModel.getStatus())) {
            project.setStatus(Constants.ProjectStatus.projectConduct.getType());
            this.save(project);
            if (project.getCompanyId() != null) {
                projectUserList = this.projectUserService.findListByCompanyIdAndProjectId(project.getCompanyId(), project.getId());
                if (projectUserList == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
                }
                for (ProjectUser projectUser : projectUserList) {
                    map = new HashMap<String, Object>();
                    map.put("projectId", project.getId());
                    map.put("action", "\u91cd\u65b0\u6fc0\u6d3b\u9879\u76ee");
                    map.put("msg", user.getName() + Constants.NoticeContent.letProject.getName() + project.getName() + Constants.NoticeContent.restart.getName());
                    map.put("msgEn", user.getName() + Constants.NoticeContent.letProject.getNameEnglish() + project.getName() + Constants.NoticeContent.restart.getNameEnglish());
                    try {
                        this.noticeService.saveSendNotice(projectUser.getUserId(), Constants.NoticeParentType.project, Constants.NoticeType.ProjectReactivate, Constants.Originator.member, user.getId(), map, "2");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.handOverProject.getName() + "\u91cd\u65b0\u6fc0\u6d3b", null, Constants.IntentType.systemNotice.getType());
                }
            }
        }
        if (Constants.ProjectStatus.projectAccomplish.getType().equals(projectMemberAddDelModel.getStatus())) {
            project.setStatus(Constants.ProjectStatus.projectAccomplish.getType());
            this.save(project);
            if (project.getCompanyId() != null) {
                projectUserList = this.projectUserService.findListByCompanyIdAndProjectId(project.getCompanyId(), project.getId());
                if (projectUserList == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
                }
                for (ProjectUser projectUser : projectUserList) {
                    map = new HashMap();
                    map.put("projectId", project.getId());
                    map.put("action", "\u5b8c\u6210\u9879\u76ee");
                    map.put("msg", user.getName() + Constants.NoticeContent.finishProject.getName() + project.getName());
                    map.put("msgEn", user.getName() + Constants.NoticeContent.finishProject.getNameEnglish() + project.getName());
                    try {
                        this.noticeService.saveSendNotice(projectUser.getUserId(), Constants.NoticeParentType.project, Constants.NoticeType.projectFinish, Constants.Originator.member, user.getId(), map, "2");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    if ("0".equals("0")) {
                        if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                        this.xgPushService.pushTokenIosOrAndroidBelievers(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.finishProject.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                    this.xgPushService.pushTokenForeign(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getEnglishName(), user.getName() + Constants.ContentNotify.finishProject.getEnglishName() + project.getName(), Constants.SHOWFLAG);
                }
            }
            this.dynamicService.saveDynamic(user.getId(), Constants.DynamicParentType.project, project.getId(), Constants.DynamicOriginatorType.project, project.getId(), Constants.DynamicType.commitProject.getName(), Constants.DynamicActionType.completeProject, Constants.DynamicType.commitProject.getNameEnglish());
        }
        return ResultModel.suc((Object)project);
    }

    public Project findByMongodbId(String mongodbId) {
        return ((ProjectDao)this.dao).findByMongodbId(mongodbId);
    }

    public List<Project> findByCompanyIdAndDelFlagFalse(Long companyId) {
        return ((ProjectDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public Long findProjectNumByDepartmentId(Long departmentId) {
        return ((ProjectDao)this.dao).findProjectNumByDepartmentId(departmentId);
    }

    public Long findCompeteNumByDepartmentId(Long departmentId) {
        return ((ProjectDao)this.dao).findCompeteNumByDepartmentId(departmentId);
    }

    public Long findOngoingNumByDepartmentId(Long departmentId) {
        return ((ProjectDao)this.dao).findOngoingNumByDepartmentId(departmentId);
    }

    public Long findStopNumByDepartmentId(Long departmentId) {
        return ((ProjectDao)this.dao).findStopNumByDepartmentId(departmentId);
    }

    public Long findOverdueNumByDepartmentId(Long departmentId, Date nowDate) {
        return ((ProjectDao)this.dao).findOverdueNumByDepartmentId(departmentId, nowDate);
    }

    public Long findProjectNumByDepartmentIdAndUserId(Long departmentId, Long userId) {
        return ((ProjectDao)this.dao).findProjectNumByDepartmentIdAndUserId(departmentId, userId);
    }

    public Long findCompeteNumByDepartmentIdAndUserId(Long departmentId, Long userId) {
        return ((ProjectDao)this.dao).findCompeteNumByDepartmentIdAndUserId(departmentId, userId);
    }

    public Long findOngoingNumByDepartmentIdAndUserId(Long departmentId, Long userId) {
        return ((ProjectDao)this.dao).findOngoingNumByDepartmentIdAndUserId(departmentId, userId);
    }

    public Long findStopNumByDepartmentIdAndUserId(Long departmentId, Long userId) {
        return ((ProjectDao)this.dao).findStopNumByDepartmentIdAndUserId(departmentId, userId);
    }

    public Long findOverdueNumByDepartmentIdAndUserIdAndDateDue(Long departmentId, Long userId, Date dateDue) {
        return ((ProjectDao)this.dao).findOverdueNumByDepartmentIdAndUserIdAndDateDue(departmentId, userId, dateDue);
    }

    public Long findMemberNumByCompanyIdAndProjectId(Long companyId, Long projectId) {
        return ((ProjectDao)this.dao).findMemberNumByCompanyIdAndProjectId(companyId, projectId);
    }

    public Long findByCompanyIdAndStatus(Long companyId, String status) {
        return ((ProjectDao)this.dao).findByCompanyIdAndStatus(companyId, status);
    }

    public Long findByCompanyIdAndStatusIsNull(Long companyId) {
        return ((ProjectDao)this.dao).findByCompanyIdAndStatusIsNull(companyId);
    }

    public ResultModel delProject(Long projectId, String languageType) {
        Project project = ((ProjectDao)this.dao).findByIdAndDelFlag(projectId, Boolean.valueOf(false));
        if (StringUtils.isEmpty((Object)project)) {
            ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        project.setDelFlag(Boolean.valueOf(true));
        this.save(project);
        List projectUserList = this.projectUserService.findByProjectIdAndDelFlagFalse(projectId);
        if (projectUserList.size() > 0) {
            for (ProjectUser projectUser : projectUserList) {
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.projectUserService.save(projectUser);
                if ("0".equals("0")) {
                    if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(projectUser.getUser().getPushToken(), Constants.TitleNotify.projectDel.getName(), project.getName() + Constants.ContentNotify.delProject.getName(), null, Constants.IntentType.systemNotice.getType());
                    continue;
                }
                if (StringUtils.isEmpty((Object)projectUser.getUser()) || !StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) continue;
                this.xgPushService.pushTokenForeign(projectUser.getUser().getPushToken(), Constants.TitleNotify.projectDel.getEnglishName(), project.getName() + Constants.ContentNotify.delProject.getEnglishName(), Constants.SHOWFLAG);
            }
        }
        return ResultModel.ok();
    }

    public List<Project> findByIdIn(List<Long> id) {
        ArrayList<Project> projects = new ArrayList<Project>();
        List byIdIn = ((ProjectDao)this.dao).findByIdIn(id);
        for (Object[] objects : byIdIn) {
            Project project = new Project();
            project.setId(Long.valueOf(objects[0].toString()));
            project.setName(objects[1].toString());
            projects.add(project);
        }
        return projects;
    }
}

