/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.meeting;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.meeting.MeetingDao;
import com.ym.tlifang.dao.meeting.MeetingDiscussDao;
import com.ym.tlifang.dao.meeting.MeetingMemberDao;
import com.ym.tlifang.dao.meeting.MeetingRoomDao;
import com.ym.tlifang.meeting.MeetingEntity;
import com.ym.tlifang.meeting.MeetingMemberEntity;
import com.ym.tlifang.meeting.MeetingRoomEntity;
import com.ym.tlifang.model.meeting.CurrentMonthMeetingModel;
import com.ym.tlifang.model.meeting.MeetingDynamicModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.meeting.MeetingMemberService;
import com.ym.tlifang.service.meeting.MeetingService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=MeetingService.class, timeout=30000, retries=-1)
public class MeetingServiceImpl
extends AbstractBaseService<MeetingEntity, MeetingDao>
implements MeetingService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MeetingMemberDao meetingMemberDao;
    @Autowired
    UserService userService;
    @Autowired
    EnclosureService enclosureService;
    @Autowired
    private StringRedisTemplate redis;
    @Autowired
    MeetingDao meetingDao;
    @Autowired
    MeetingRoomDao meetingRoomDao;
    @Autowired
    MeetingDiscussDao meetingDiscussDao;
    @Autowired
    NoticeService noticeService;
    @Autowired
    private MeetingMemberService meetingMemberService;

    public MeetingEntity saveMeeting(MeetingEntity meetingEntity) {
        if ((meetingEntity = (MeetingEntity)((MeetingDao)this.dao).save((Object)meetingEntity)).getMemberIds() != null && meetingEntity.getMemberIds().length > 0) {
            for (Long id : meetingEntity.getMemberIds()) {
                MeetingMemberEntity memberEntity = new MeetingMemberEntity();
                memberEntity.setMeetingId(meetingEntity.getId());
                memberEntity.setMemberId(id);
                memberEntity.setCompanyId(meetingEntity.getCompanyId());
                this.meetingMemberDao.save((Object)memberEntity);
            }
        }
        if (meetingEntity.getEnclosureIds() != null && meetingEntity.getEnclosureIds().length > 0) {
            for (Long id : meetingEntity.getEnclosureIds()) {
                EnclosureEntity entity = this.enclosureService.findById(id);
                entity.setKeyId(meetingEntity.getId());
                this.enclosureService.saveEnclosure(entity);
            }
        }
        List memberEntities = this.meetingMemberService.findByMeetingIds(meetingEntity.getId());
        for (MeetingMemberEntity entity : memberEntities) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("meetingId", meetingEntity.getId());
            map.put("action", "\u4f1a\u8bae");
            map.put("msg", Constants.NoticeContent.youHaveOneMeet.getName() + meetingEntity.getTitle() + Constants.NoticeContent.attendOnTime.getName());
            map.put("msgEn", Constants.NoticeContent.youHaveOneMeet.getNameEnglish() + meetingEntity.getTitle() + Constants.NoticeContent.attendOnTime.getNameEnglish());
            this.noticeService.saveSendNotice(entity.getMemberId(), Constants.NoticeParentType.meeting, Constants.NoticeType.meetingBegin, Constants.Originator.company, entity.getCompanyId(), map, "1");
        }
        this.addMeetingLoop(meetingEntity);
        return meetingEntity;
    }

    public MeetingEntity updateMeeting(MeetingEntity meetingEntity) {
        MeetingEntity oldMeeting = this.meetingDao.findByIdAndDelFlagIsFalse(meetingEntity.getId());
        if (!(oldMeeting.getBeginTime().compareTo(meetingEntity.getBeginTime()) == 0 && oldMeeting.getEndTime().compareTo(meetingEntity.getEndTime()) == 0 && oldMeeting.getLoopSign() == meetingEntity.getLoopSign() || Constants.LoopTaskType.noRepeat.getType().equals(oldMeeting.getLoopSign()))) {
            String key = Constants.SCHEDULE_MEETING + meetingEntity.getId();
            this.redis.delete((Object)key);
            String noticeKey = Constants.SCHEDULE_MEETING_TIME + meetingEntity.getId();
            this.redis.delete((Object)noticeKey);
            this.addMeetingLoop(meetingEntity);
        }
        meetingEntity = (MeetingEntity)((MeetingDao)this.dao).save((Object)meetingEntity);
        return meetingEntity;
    }

    public Map<String, Object> findById(Long id) {
        MeetingEntity meetingEntity = ((MeetingDao)this.dao).findByIdAndDelFlag(id, Boolean.valueOf(false));
        HashMap<String, Object> meetingMap = new HashMap<String, Object>();
        meetingMap.put("meeting", meetingEntity);
        HashMap<String, Object> initiatorInfoMap = new HashMap<String, Object>();
        User user = this.userService.findById(meetingEntity.getInitiatorId());
        initiatorInfoMap.put("id", user.getId());
        initiatorInfoMap.put("name", user.getName());
        initiatorInfoMap.put("avatar", user.getAvatar());
        meetingMap.put("initiatorInfo", initiatorInfoMap);
        MeetingRoomEntity meetingRoomEntity = this.meetingRoomDao.findByIdAndDelFlagIsFalse(meetingEntity.getMeetingRoomId());
        meetingMap.put("meetingRoomName", meetingRoomEntity == null ? "" : meetingRoomEntity.getName());
        meetingMap.put("enclosures", this.enclosureService.findByKeyIdAndType(meetingEntity.getId(), "1"));
        return meetingMap;
    }

    public MeetingEntity findByMeetingId(Long meetingId) {
        return ((MeetingDao)this.dao).findByIdAndDelFlagIsFalse(meetingId);
    }

    public PageInfo findByCompanyIdDesc(Long companyId, Integer pageNo, Integer pages) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, Integer.valueOf(StringUtils.isNullToZero((Object)pages)).intValue());
        Page list = ((MeetingDao)this.dao).findByCompanyIdAndDelFlagOrderByCreateDateDesc(companyId, Boolean.valueOf(false), (Pageable)pageable);
        List mapList = this.getMeetingList(list.getContent());
        PageInfo pageInfo = PageInfo.fromPage((Page)list);
        pageInfo.setRows(mapList);
        return pageInfo;
    }

    public Map<String, Object> findUserMonthMeetingList(Long companyId, Long memberId, String monthStr) {
        List Dates = ((MeetingDao)this.dao).findUserMonthDateList(companyId, memberId, monthStr);
        List mapList = ((MeetingDao)this.dao).findUserMonthMeetingList(companyId, memberId, monthStr);
        List currentMonthMeetingModels = this.listMapConvertModel(mapList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object date : Dates) {
            ArrayList<CurrentMonthMeetingModel> dateList = new ArrayList<CurrentMonthMeetingModel>();
            for (CurrentMonthMeetingModel currentMonthMeetingModel : currentMonthMeetingModels) {
                if (!DateUtils.isSameDay((Date)DateUtils.parseDate(date), (Date)currentMonthMeetingModel.getBeginTime())) continue;
                dateList.add(currentMonthMeetingModel);
            }
            map.put(date.toString(), dateList);
        }
        return map;
    }

    public boolean setNextMeetingTimeScheduleTask(Long meetingId) {
        try {
            String noticeKey;
            MeetingEntity oldMeeting = ((MeetingDao)this.dao).findByIdAndDelFlagIsFalse(meetingId);
            List oldMemberList = this.meetingMemberDao.findByMeetingIdAndDelFlag(meetingId, Boolean.valueOf(false));
            MeetingEntity newMeeting = oldMeeting;
            newMeeting.setId(null);
            newMeeting.setUpdateDate(null);
            newMeeting.setCreateDate(null);
            Map mapTime = this.getMeetingNextTime(oldMeeting);
            newMeeting.setBeginTime((Date)mapTime.get("beginTime"));
            newMeeting.setEndTime((Date)mapTime.get("endTime"));
            newMeeting = (MeetingEntity)this.meetingDao.save((Object)newMeeting);
            Iterator iterator = oldMemberList.iterator();
            while (iterator.hasNext()) {
                MeetingMemberEntity entity;
                MeetingMemberEntity oldMember = entity = (MeetingMemberEntity)iterator.next();
                oldMember.setId(null);
                oldMember.setMeetingId(newMeeting.getId());
                oldMember.setCreateDate(null);
                oldMember.setUpdateDate(null);
                this.meetingMemberDao.save((Object)oldMember);
            }
            String key = Constants.SCHEDULE_MEETING + newMeeting.getId();
            if (!this.redis.hasKey((Object)key).booleanValue()) {
                this.redis.boundValueOps((Object)key).set((Object)key);
                this.redis.boundValueOps((Object)key).expireAt(newMeeting.getEndTime());
            }
            if (!this.redis.hasKey((Object)(noticeKey = Constants.SCHEDULE_MEETING_TIME + newMeeting.getId())).booleanValue()) {
                this.redis.boundValueOps((Object)noticeKey).set((Object)noticeKey);
                this.redis.boundValueOps((Object)noticeKey).expireAt(DateUtils.addDateMinute((Date)newMeeting.getBeginTime(), (int)Constants.MEETING_REMIND_TIME));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public ResultModel validateMeetingRoomTime(Long meetingId, Long companyId, Long meetingRoomId, Date beginTime, Date endTime, String languageType) {
        boolean flag = true;
        List entityList = ((MeetingDao)this.dao).findByCompanyIdAndMeetingRoomIdAndDelFlagFalseAndEndTimeGreaterThanEqual(companyId, meetingRoomId, new Date());
        for (int i = 0; i < entityList.size(); ++i) {
            MeetingEntity meetingEntity = (MeetingEntity)entityList.get(i);
            if (meetingId != null && meetingEntity.getId().equals(meetingId)) {
                entityList.remove(i);
                continue;
            }
            if (Constants.LoopTaskType.noRepeat.getType().equals(meetingEntity.getLoopSign()) && DateUtils.sameDay((Date)beginTime, (Date)meetingEntity.getBeginTime()) && (flag = DateUtils.periodDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime(), (Date)beginTime, (Date)endTime))) {
                return ResultModel.error((ResultStatus)ResultStatus.MEETING_TIME_EXIST, (String)languageType);
            }
            if (Constants.LoopTaskType.everyday.getType().equals(meetingEntity.getLoopSign()) && (flag = DateUtils.periodDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime(), (Date)beginTime, (Date)endTime))) {
                return ResultModel.error((ResultStatus)ResultStatus.MEETING_TIME_EXIST, (String)languageType);
            }
            if (Constants.LoopTaskType.weekly.getType().equals(meetingEntity.getLoopSign()) && DateUtils.getDateWeek((Date)beginTime).equals(DateUtils.getDateWeek((Date)meetingEntity.getBeginTime())) && (flag = DateUtils.periodDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime(), (Date)beginTime, (Date)endTime))) {
                return ResultModel.error((ResultStatus)ResultStatus.MEETING_TIME_EXIST, (String)languageType);
            }
            if (!Constants.LoopTaskType.manthly.equals((Object)meetingEntity.getLoopSign()) || !DateUtils.getDay((Date)beginTime).equals(DateUtils.getDay((Date)meetingEntity.getBeginTime())) || !(flag = DateUtils.periodDate((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime(), (Date)beginTime, (Date)endTime))) continue;
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_TIME_EXIST, (String)languageType);
        }
        return ResultModel.ok((String)languageType);
    }

    public int getMemberCompanyMeetingCount(Long companyId, Long memberId) {
        int count = ((MeetingDao)this.dao).getMemberCompanyMeetingCount(companyId, memberId);
        return count;
    }

    public List<MeetingDynamicModel> getMeetingDynamic(Long meetingId) {
        List objects = ((MeetingDao)this.dao).getMeetingDynamic(meetingId);
        ArrayList<MeetingDynamicModel> mapList = new ArrayList<MeetingDynamicModel>();
        for (Object[] objectArray : objects) {
            MeetingDynamicModel model = new MeetingDynamicModel();
            for (int i = 0; i <= objectArray.length; ++i) {
                model.setId(Long.valueOf(objectArray[0].toString()));
                model.setType(objectArray[1].toString());
                model.setMeetingId(Long.valueOf(objectArray[2].toString()));
                model.setUserId(Long.valueOf(objectArray[3].toString()));
                model.setName(objectArray[4].toString());
                model.setUrl(objectArray[5].toString());
                model.setMimeType(objectArray[6].toString());
                model.setContent(objectArray[7].toString());
                model.setCreateDate(DateUtils.parseDate((Object)objectArray[8].toString().substring(0, objectArray[8].toString().length() - 2)));
            }
            mapList.add(model);
        }
        return mapList;
    }

    public ResultModel deleteMeeting(Long[] meetingIds, Long userId, String languageType) {
        try {
            for (Long meetingId : meetingIds) {
                MeetingEntity meeting = ((MeetingDao)this.dao).findByIdAndDelFlag(meetingId, Boolean.valueOf(false));
                if (meeting == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.MEETING_NO_EXIST, (String)languageType);
                }
                if (!meeting.getInitiatorId().equals(userId)) {
                    return ResultModel.error((ResultStatus)ResultStatus.MEETING_INITIATOR_DELETE, (String)languageType);
                }
                if (DateUtils.isEffectiveDate((Date)new Date(), (Date)meeting.getBeginTime(), (Date)meeting.getEndTime())) {
                    return ResultModel.error((ResultStatus)ResultStatus.MEETING_PROCESSING_NOT_DELETE, (String)languageType);
                }
                this.meetingMemberDao.deleteMeetingMember(meetingId);
                this.meetingDiscussDao.deleteMeetingDiscuss(meetingId);
                this.enclosureService.deleteMeetingEnclosure(meetingId);
                meeting.setDelFlag(Boolean.valueOf(true));
                ((MeetingDao)this.dao).save((Object)meeting);
                if (DateUtils.compareDate((Date)meeting.getEndTime(), (Date)new Date()) != 1 || Constants.LoopTaskType.noRepeat.getType().equals(meeting.getLoopSign())) continue;
                String key = Constants.SCHEDULE_MEETING + meeting.getId();
                this.redis.delete((Object)key);
                String noticeKey = Constants.SCHEDULE_MEETING_TIME + meeting.getId();
                this.redis.delete((Object)noticeKey);
            }
            return ResultModel.ok((String)languageType);
        }
        catch (Exception e) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_DELETE_ERROR, (String)languageType);
        }
    }

    private List<Map<String, Object>> getMeetingList(List<MeetingEntity> list) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (MeetingEntity meetingEntity : list) {
            User user = this.userService.findById(meetingEntity.getInitiatorId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", meetingEntity.getId());
            map.put("title", meetingEntity.getTitle());
            map.put("initiatorId", meetingEntity.getInitiatorId());
            map.put("time", DateUtils.getBeginTimeBetweenEndTime((Date)meetingEntity.getBeginTime(), (Date)meetingEntity.getEndTime()));
            map.put("initiatorName", user.getName());
            map.put("address", meetingEntity.getAddress());
            map.put("createTime", meetingEntity.getCreateBy());
            map.put("meetingRoomName", this.meetingRoomDao.findByIdAndDelFlagIsFalse(meetingEntity.getMeetingRoomId()).getName());
            mapList.add(map);
        }
        return mapList;
    }

    private List<CurrentMonthMeetingModel> listMapConvertModel(List<Object> objectList) {
        ArrayList<CurrentMonthMeetingModel> meeting = new ArrayList<CurrentMonthMeetingModel>();
        for (int i = 0; i < objectList.size(); ++i) {
            CurrentMonthMeetingModel model = new CurrentMonthMeetingModel();
            Object[] objs = (Object[])objectList.get(i);
            model.setId(Long.valueOf(objs[0].toString()));
            model.setCompanyId(Long.valueOf(objs[1].toString()));
            model.setInitiatorId(Long.valueOf(objs[2].toString()));
            String beginTime = objs[3].toString();
            model.setBeginTime(DateUtils.parseDate((Object)beginTime.substring(0, beginTime.length() - 2)));
            String endTime = objs[4].toString();
            model.setEndTime(DateUtils.parseDate((Object)endTime.substring(0, endTime.length() - 2)));
            String createDate = objs[5].toString();
            model.setCreateDate(DateUtils.parseDate((Object)createDate.substring(0, createDate.length() - 2)));
            model.setName(objs[6].toString());
            model.setAvatar(objs[7].toString());
            model.setTitle(objs[8].toString());
            meeting.add(model);
        }
        return meeting;
    }

    private Map<String, Date> getMeetingNextTime(MeetingEntity entity) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        if (Constants.LoopTaskType.everyday.getType().equals(entity.getLoopSign())) {
            map.put("beginTime", DateUtils.addDateNum((Date)entity.getBeginTime(), (int)1));
            map.put("endTime", DateUtils.addDateNum((Date)entity.getEndTime(), (int)1));
        }
        if (Constants.LoopTaskType.weekly.getType().equals(entity.getLoopSign())) {
            map.put("beginTime", DateUtils.addDateNum((Date)entity.getBeginTime(), (int)7));
            map.put("endTime", DateUtils.addDateNum((Date)entity.getEndTime(), (int)7));
        }
        if (Constants.LoopTaskType.manthly.getType().equals(entity.getLoopSign())) {
            map.put("beginTime", DateUtils.getNextMonth((Date)entity.getBeginTime()));
            map.put("endTime", DateUtils.getNextMonth((Date)entity.getEndTime()));
        }
        return map;
    }

    private void addMeetingLoop(MeetingEntity meetingEntity) {
        if (Constants.LoopTaskType.everyday.getType().equals(meetingEntity.getLoopSign()) || Constants.LoopTaskType.weekly.getType().equals(meetingEntity.getLoopSign())) {
            String key = Constants.SCHEDULE_MEETING + meetingEntity.getId();
            this.redis.boundValueOps((Object)key).set((Object)key);
            this.redis.boundValueOps((Object)key).expireAt(meetingEntity.getEndTime());
        }
        String noticeKey = Constants.SCHEDULE_MEETING_TIME + meetingEntity.getId();
        this.redis.boundValueOps((Object)noticeKey).set((Object)noticeKey);
        this.redis.boundValueOps((Object)noticeKey).expireAt(DateUtils.addDateMinute((Date)meetingEntity.getBeginTime(), (int)Constants.MEETING_REMIND_TIME));
    }
}

