/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.model.approval.LoopModel;
import com.ym.tlifang.model.task.TaskModel;
import com.ym.tlifang.model.user.UserModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectTaskLabel;
import com.ym.tlifang.service.common.LandConfig;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskLabelRelationService;
import com.ym.tlifang.service.task.TaskPanelRelationService;
import com.ym.tlifang.service.task.TaskPanelService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.task.subtask.SubtaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.task.TaskLabelRelation;
import com.ym.tlifang.task.TaskPanel;
import com.ym.tlifang.task.TaskPanelRelation;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tasks"})
@Api(value="tasks", description="\u4efb\u52a1\u76f8\u5173")
public class TaskController
extends BaseController {
    Logger logger = LoggerFactory.getLogger(TaskController.class);
    @Reference
    private TaskService taskService;
    @Reference
    private TaskConcernService taskConcernService;
    @Reference(timeout=6000)
    private TaskPanelService taskPanelService;
    @Reference
    private TaskPanelRelationService taskPanelRelationService;
    @Reference
    private TaskLabelRelationService taskLabelRelationService;
    @Reference
    private ProjectService projectService;
    @Reference
    private CompanyService companyService;
    @Reference
    private NoticeService noticeService;
    @Reference
    private EnclosureService enclosureService;
    @Reference
    private DynamicService dynamicService;
    @Reference
    private UserService userService;
    @Reference
    private XgPushService xgPushService;
    @Reference
    private SubtaskService subtaskService;
    @Reference
    private LandConfig landConfig;

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Task> createTask(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody Task task) {
        TaskPanel taskPanel;
        Project project;
        if (StringUtils.isEmpty((Object)task.getProjectId()) || StringUtils.isEmpty((Object)task.getTitle())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (StringUtils.containsEmoji((String)task.getTitle())) {
            task.setTitle(StringEscapeUtils.escapeJava((String)task.getTitle()));
        }
        if ((project = this.projectService.findByProjectId(task.getProjectId())) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_EXIST, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)project.getCompanyId())) {
            task.setType(Constants.TaskType.personarTask.getType());
        } else {
            task.setType(Constants.TaskType.companyTask.getType());
            Company company = this.companyService.findById(project.getCompanyId());
            if (company == null) {
                return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
            }
            task.setCompanyId(project.getCompanyId());
        }
        Long panelId = task.getPanelId();
        if (!StringUtils.isEmpty((Object)project.getType()) && "1".equals(project.getType())) {
            taskPanel = !StringUtils.isEmpty((Object)panelId) ? this.taskPanelService.findByPanelId(panelId) : this.taskPanelService.findByProjectIdAndType(project.getId(), "1");
            if (taskPanel == null) {
                return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST, (String)languageType);
            }
            panelId = taskPanel.getId();
            task.setProjectId(project.getId());
        } else {
            if (StringUtils.isEmpty((Object)task.getPanelId())) {
                taskPanel = this.taskPanelService.findByProjectIdAndType(project.getId(), "1");
                if (taskPanel == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST, (String)languageType);
                }
                panelId = taskPanel.getId();
                task.setProjectId(project.getId());
            }
            task.setProjectId(project.getId());
        }
        task.setProject(project);
        task.setCreatorId(currentUser.getId());
        task.setStatus("0");
        task.setDateStart(StringUtils.isEmpty((Object)task.getDateStart()) ? new Date() : task.getDateStart());
        task = this.taskService.save(task);
        task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
        TaskPanelRelation taskPanelRelation = new TaskPanelRelation();
        taskPanelRelation.setTaskId(task.getId());
        taskPanelRelation.setPanelId(panelId);
        this.taskPanelRelationService.save(taskPanelRelation);
        if (!StringUtils.isEmpty((Object)task.getAssigneeId())) {
            String[] followersIds = task.getFollowers();
            if (task.getFollowers() == null || task.getFollowers().length == 0) {
                followersIds = task.getAssigneeId().equals(currentUser.getId()) ? new String[]{currentUser.getId().toString()} : new String[]{currentUser.getId().toString(), task.getAssigneeId().toString()};
            }
            for (int i = 0; i < followersIds.length; ++i) {
                TaskConcern taskConcern = new TaskConcern(task.getId(), Long.valueOf(followersIds[i]), "1", Long.valueOf(0L));
                taskConcern.setTaskStatus(Constants.TaskStatus.taskToDo.getType());
                this.taskConcernService.save(taskConcern);
                if (task.getCompanyId() == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("projectId", task.getProjectId());
                map.put("taskId", task.getId());
                map.put("action", "\u6dfb\u52a0\u5173\u6ce8");
                map.put("msg", currentUser.getName() + Constants.NoticeContent.addYou.getName() + task.getTitle() + Constants.NoticeContent.taskConcern.getName());
                map.put("msgEn", currentUser.getName() + Constants.NoticeContent.addYou.getNameEnglish() + Constants.NoticeContent.taskConcern.getNameEnglish() + task.getTitle());
                try {
                    this.noticeService.saveSendNotice(Long.valueOf(followersIds[i]), Constants.NoticeParentType.task, Constants.NoticeType.taskConcern, Constants.Originator.member, task.getCreatorId(), map, "2");
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        } else {
            TaskConcern taskConcern = new TaskConcern(task.getId(), currentUser.getId(), "1", Long.valueOf(0L));
            taskConcern.setTaskStatus(Constants.TaskStatus.taskToDo.getType());
            this.taskConcernService.save(taskConcern);
        }
        if (task.getCompanyId() != null && task.getAssigneeId() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("projectId", task.getProjectId());
            map.put("taskId", task.getId());
            map.put("action", "\u63a5\u5230\u4efb\u52a1");
            map.put("msg", currentUser.getName() + Constants.NoticeContent.giveYouCreateTask.getName() + task.getTitle());
            map.put("msgEn", currentUser.getName() + Constants.NoticeContent.giveYouCreateTask.getNameEnglish() + task.getTitle());
            try {
                this.noticeService.saveSendNotice(task.getAssigneeId(), Constants.NoticeParentType.task, Constants.NoticeType.receiveTask, Constants.Originator.member, task.getCreatorId(), map, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            User user = this.userService.findById(task.getAssigneeId());
            if (this.landConfig.getInlandFlag().booleanValue()) {
                if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.task.getName(), currentUser.getName() + Constants.ContentNotify.task.getName() + task.getTitle(), null, Constants.IntentType.systemNotice.getType());
                }
            } else if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
                this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.task.getEnglishName(), currentUser.getName() + Constants.ContentNotify.task.getEnglishName() + "for you", Constants.SHOWFLAG);
            }
        }
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.project, task.getProjectId(), Constants.DynamicOriginatorType.task, task.getId(), Constants.DynamicType.createTask.getName(), Constants.DynamicActionType.taskAdd, task.getTitle(), Constants.DynamicType.createTask.getNameEnglish());
        return ResultModel.suc((Object)task, (String)languageType);
    }

    @GetMapping(value={"/{taskId}"})
    @ApiOperation(value="\u67e5\u770b\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskModel> getTaskDetail(@LanguageType String languageType, @PathVariable Long taskId) {
        Task task = this.taskService.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)task)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        List taskConcernList = this.taskConcernService.findListByTaskId(taskId);
        task.setTaskConcernList(taskConcernList);
        task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
        task.setDescription(StringEscapeUtils.unescapeJava((String)task.getDescription()));
        List taskEnclosures = this.enclosureService.findByKeyIdAndType(taskId, Constants.EnclosureType.task.getType());
        TaskModel taskModel = new TaskModel();
        taskModel.init(task);
        taskModel.setEnclosures(taskEnclosures);
        List taskLabelRelationList = task.getTaskLabelRelationList();
        ArrayList<ProjectTaskLabel> projectTaskLabelList = new ArrayList<ProjectTaskLabel>();
        for (TaskLabelRelation taskLabelRelation : taskLabelRelationList) {
            projectTaskLabelList.add(taskLabelRelation.getProjectTaskLabel());
        }
        taskModel.setProjectTaskLabelList(projectTaskLabelList);
        taskModel.setLoopModel(this.getLoopModel(task));
        taskModel.setAssignee(UserModel.getUserModel((User)this.userService.findById(task.getAssigneeId())));
        taskModel.setCreator(UserModel.getUserModel((User)this.userService.findById(task.getCreatorId())));
        taskModel.setCreateDate(task.getCreateDate());
        return ResultModel.suc((Object)taskModel, (String)languageType);
    }

    @PutMapping(value={"/{taskId}"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="user", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel updateTaskDetail(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long taskId, @RequestBody Task task) {
        Task oldTask = this.taskService.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)oldTask)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        if (Constants.TaskType.taskComplete.getType().equals(oldTask.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NOT_MODIFY, (String)languageType);
        }
        if (task != null) {
            if (StringUtils.containsEmoji((String)task.getTitle())) {
                oldTask.setTitle(StringEscapeUtils.escapeJava((String)task.getTitle()));
            }
            if ("".equals(task.getDescription())) {
                oldTask.setDescription(null);
            } else if (task.getDescription() != null) {
                oldTask.setDescription(task.getDescription());
            }
            if (StringUtils.containsEmoji((String)task.getDescription())) {
                oldTask.setTitle(StringEscapeUtils.escapeJava((String)task.getDescription()));
            }
            if (!StringUtils.isEmpty((Object)task.getPriority())) {
                oldTask.setPriority(task.getPriority());
            }
            if (!StringUtils.isEmpty((Object)task.getDateStart())) {
                oldTask.setDateStart(task.getDateStart());
            }
            if (!StringUtils.isEmpty((Object)task.getDateDue())) {
                oldTask.setDateDue(task.getDateDue());
            }
            if (!StringUtils.isEmpty((Object)task.getAssigneeId())) {
                if (!"-1".equals(task.getAssigneeId().toString())) {
                    oldTask.setAssigneeId(task.getAssigneeId());
                    TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(taskId, task.getAssigneeId());
                    if (taskConcern == null) {
                        taskConcern = new TaskConcern();
                        taskConcern.setTaskId(taskId);
                        taskConcern.setUserId(task.getAssigneeId());
                    }
                    taskConcern.setStatus("1");
                    this.taskConcernService.save(taskConcern);
                } else {
                    oldTask.setAssigneeId(null);
                }
            }
            oldTask = this.taskService.save(oldTask);
            oldTask.setAssignee(UserModel.getUserModel((User)this.userService.findById(oldTask.getAssigneeId())));
            oldTask.setTitle(StringEscapeUtils.unescapeJava((String)oldTask.getTitle()));
            oldTask.setDescription(StringEscapeUtils.unescapeJava((String)oldTask.getDescription()));
        }
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.project, task.getProjectId(), Constants.DynamicOriginatorType.task, task.getId(), Constants.DynamicType.updateTask.getName(), Constants.DynamicActionType.taskUpdate, task.getTitle(), Constants.DynamicType.updateTask.getNameEnglish());
        return ResultModel.suc((Object)oldTask, (String)languageType);
    }

    @DeleteMapping(value={"/{taskId}"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="str@ing", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="user", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteTask(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long taskId) {
        Task task = this.taskService.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)task)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        task.setDelFlag(Boolean.valueOf(true));
        this.taskService.save(task);
        TaskPanelRelation taskPanelRelation = this.taskPanelRelationService.findByTaskId(taskId, Boolean.valueOf(false));
        taskPanelRelation.setDelFlag(Boolean.valueOf(true));
        this.taskPanelRelationService.save(taskPanelRelation);
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.project, task.getProjectId(), Constants.DynamicOriginatorType.task, task.getId(), Constants.DynamicType.delTask.getName(), Constants.DynamicActionType.taskComplete, task.getTitle(), Constants.DynamicType.delTask.getNameEnglish());
        return ResultModel.ok((String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u6211\u7684\u5de5\u4f5c\u53f0\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id(\u4e2a\u4eba\u4e0d\u4f20)", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="sortType", value="\u6392\u5e8f\u7c7b\u578b \u4e0d\u4f20 \u9ed8\u8ba4\u81ea\u5b9a\u4e49  1 \u6309\u6743\u91cd", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u7b2c\u51e0\u9875", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel workbenchTaskList(@LanguageType String languageType, @CurrentUser User currentUser, Long companyId, String sortType, Integer pageNo, Integer pageSize) {
        PageInfo todoTaskPage = this.taskService.findByWorkPage(companyId, Constants.TaskStatus.taskToDo.getType(), currentUser.getId(), pageNo, pageSize);
        PageInfo ongoingTaskPage = this.taskService.findByWorkPage(companyId, Constants.TaskStatus.taskOngoing.getType(), currentUser.getId(), pageNo, pageSize);
        PageInfo completeTaskPage = this.taskService.findByWorkPage(companyId, Constants.TaskStatus.taskComplete.getType(), currentUser.getId(), pageNo, pageSize);
        HashMap<String, PageInfo> data = new HashMap<String, PageInfo>();
        data.put("todoTaskList", todoTaskPage);
        data.put("ongoingTaskList", ongoingTaskPage);
        data.put("completeTaskList", completeTaskPage);
        return ResultModel.suc(data, (String)languageType);
    }

    @GetMapping(value={"/project/{projectId}"})
    @ApiOperation(value="\u9879\u76ee\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="sortType", value="\u6392\u5e8f\u7c7b\u578b \u4e0d\u4f20 \u9ed8\u8ba4\u81ea\u5b9a\u4e49  1 \u6309\u6743\u91cd", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001\u7b5b\u9009\uff08\u4e0d\u4f20\u4e3a\u5168\u90e8\uff090 \u8fdb\u884c\u4e2d 1 \u5df2\u5b8c\u6210", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="assigneeId", value="\u6267\u884c\u8005id", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="tagsId", value="\u9879\u76ee\u6807\u7b7eid", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="page", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="taskName", value="\u9879\u76ee\u540d(\u6709\u5219\u4f20)", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="type", value="\u65b0\u65e7\u7248\u672c\u4ea4\u66ff\u4f7f\u7528/\u9ed8\u8ba4\u4e0d\u4f20\uff0c\u65b0\u7248\u672c\u4f201", required=false, dataType="String", paramType="query")})
    @Authorization
    public ResultModel projectTaskList(@LanguageType String languageType, @PathVariable Long projectId, String status, Long assigneeId, Long tagsId, String taskName, Integer page, Integer pageSize, String type) {
        if (this.projectService.findByProjectId(projectId) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        return this.taskPanelService.findByAllPaneAndTask(projectId, status, assigneeId, tagsId, taskName, page, pageSize, type, languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/search/{projectId}"})
    @ApiOperation(value="App\u4efb\u52a1\u641c\u7d22\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="page", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="taskName", value="\u9879\u76ee\u540d(\u6709\u5219\u4f20)", required=true, dataType="String", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<Task>> projectTaskList(@LanguageType String languageType, @PathVariable Long projectId, Integer page, Integer pageSize, String taskName) {
        if (StringUtils.isEmpty((Object)projectId) || StringUtils.isEmpty((Object)taskName)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByProjectId(projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        taskName = "%" + taskName + "%";
        ResultModel taskList = this.taskService.findByAppProjectIdAndTaskNameLike(page, pageSize, projectId, taskName, languageType);
        return taskList;
    }

    @GetMapping(value={"/project/panel/{panelId}"})
    @ApiOperation(value="\u9879\u76ee\u4efb\u52a1\u9762\u677f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="panelId", value="\u9762\u677fid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="page", value="\u9875\u7801", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u663e\u793a\u6570\u91cf", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskPanel> projectTaskPanelList(@LanguageType String languageType, @PathVariable Long panelId, Integer page, Integer pageSize) {
        PageInfo pageInfo = this.taskPanelRelationService.findListByPanelId(panelId, null, null, null, null, page, pageSize, null);
        ArrayList<Task> taskList = new ArrayList<Task>();
        List taskPanelRelationList = pageInfo.getRows();
        for (TaskPanelRelation taskPanelRelation : taskPanelRelationList) {
            Task task = taskPanelRelation.getTask();
            task.setAssignee(UserModel.getUserModel((User)this.userService.findById(task.getAssigneeId())));
            task.setTitle(StringEscapeUtils.unescapeJava((String)task.getTitle()));
            task.setDescription(StringEscapeUtils.unescapeJava((String)task.getDescription()));
            task.setSubtaskNum(this.subtaskService.countByTaskId(task.getId()));
            task.setSubtaskCompleteNum(this.subtaskService.countByTaskIdAndStatus(task.getId(), Constants.Subtask.complete.getType()));
            taskList.add(task);
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("taskTotal", Long.valueOf(pageInfo.getTotal()));
        data.put("taskList", taskList);
        data.put("panelId", panelId);
        return ResultModel.suc(data, (String)languageType);
    }

    @PutMapping(value={"/operation/{taskId}"})
    @ApiOperation(value="\u5f00\u542f/\u5b8c\u6210\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel operationTaskStatus(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long taskId) {
        Task oldTask = this.taskService.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)oldTask)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        if (!this.subtaskService.countByTaskIdAndStatus(taskId, Constants.Subtask.unfinished.getType()).equals(0)) {
            return ResultModel.error((ResultStatus)ResultStatus.SUBTASK_UNDONE, (String)languageType);
        }
        String content = Constants.DynamicType.commitTask.getName();
        String contentEnglish = Constants.DynamicType.commitTask.getNameEnglish();
        if (StringUtils.isNotBlank((String)oldTask.getStatus()) && oldTask.getStatus().equals("0")) {
            String loop;
            oldTask.setStatus("1");
            oldTask = this.taskService.save(oldTask);
            oldTask.setTitle(StringEscapeUtils.unescapeJava((String)oldTask.getTitle()));
            if (oldTask.getCompanyId() != null && oldTask.getAssigneeId() != null) {
                User user = this.userService.findById(oldTask.getAssigneeId());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("projectId", oldTask.getProjectId());
                map.put("taskId", oldTask.getId());
                map.put("action", "\u5b8c\u6210\u4efb\u52a1");
                map.put("msg", user.getName() + Constants.NoticeContent.finishTast.getName() + oldTask.getTitle());
                map.put("msgEn", user.getName() + Constants.NoticeContent.finishTast.getNameEnglish() + oldTask.getTitle());
                try {
                    this.noticeService.saveSendNotice(oldTask.getCreatorId(), Constants.NoticeParentType.task, Constants.NoticeType.competeTask, Constants.Originator.member, oldTask.getCreatorId(), map, "2");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                User users = this.userService.findById(oldTask.getProject().getOwnerId());
                if (this.landConfig.getInlandFlag().booleanValue()) {
                    if (!StringUtils.isEmpty((Object)users) && StringUtils.isNotBlank((String)users.getPushToken())) {
                        this.xgPushService.pushTokenIosOrAndroidBelievers(users.getPushToken(), Constants.TitleNotify.task.getName(), user.getName() + Constants.ContentNotify.taskOver.getName() + oldTask.getTitle(), null, Constants.IntentType.systemNotice.getType());
                    }
                } else if (!StringUtils.isEmpty((Object)users) && StringUtils.isNotBlank((String)users.getPushToken())) {
                    this.xgPushService.pushTokenForeign(users.getPushToken(), Constants.TitleNotify.task.getEnglishName(), user.getName() + Constants.ContentNotify.taskOver.getEnglishName() + oldTask.getTitle(), Constants.SHOWFLAG);
                }
            }
            if (StringUtils.isNotBlank((String)(loop = oldTask.getLoop()))) {
                Task newTask = new Task();
                newTask = oldTask;
                newTask.setId(null);
                this.taskService.updateTaskStatus(taskId, oldTask, newTask, loop);
            }
            oldTask.setStatus("1");
        } else {
            oldTask.setStatus("0");
            oldTask = this.taskService.save(oldTask);
            content = Constants.DynamicType.restartTask.getName();
            contentEnglish = Constants.DynamicType.restartTask.getNameEnglish();
        }
        oldTask.setAssignee(UserModel.getUserModel((User)this.userService.findById(oldTask.getAssigneeId())));
        this.dynamicService.saveTaskDynamic(currentUser.getId(), Constants.DynamicParentType.project, oldTask.getProjectId(), Constants.DynamicOriginatorType.task, oldTask.getId(), content, Constants.DynamicActionType.taskComplete, oldTask.getTitle(), contentEnglish);
        return ResultModel.suc((Object)oldTask, (String)languageType);
    }

    @PutMapping(value={"/loop/{taskId}"})
    @ApiOperation(value="\u8bbe\u7f6e\u5faa\u73af\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<LoopModel> setTaskLoop(@LanguageType String languageType, @PathVariable Long taskId, @RequestBody LoopModel loopModel) {
        if (StringUtils.isEmpty((Object)loopModel) || StringUtils.isEmpty((Object)loopModel.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task oldTask = this.taskService.findByTaskId(taskId);
        if (StringUtils.isEmpty((Object)oldTask)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        if (loopModel.getType().equals(Constants.LoopTaskType.custom.getType()) && (StringUtils.isEmpty((Object)loopModel.getCustomType()) || StringUtils.isEmpty((Object)loopModel.getInfo()) || loopModel.getInfo().length <= 0)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (loopModel.getType().equals(Constants.LoopTaskType.noRepeat.getType())) {
            loopModel.setCustomType(null);
            loopModel.setInfo(null);
            loopModel.setInterval(null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("type", loopModel.getType());
            map.put("customType", loopModel.getCustomType());
            map.put("interval", loopModel.getInterval());
            map.put("info", loopModel.getInfo());
            oldTask.setLoop(JsonUtil.jackson.writeValueAsString(map));
            this.taskService.updateLoop(taskId, JsonUtil.jackson.writeValueAsString(map));
            oldTask.setLoopModel(this.getLoopModel(oldTask));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResultModel.suc((Object)oldTask, (String)languageType);
    }

    @PutMapping(value={"/remind/{taskId}"})
    @ApiOperation(value="\u8bbe\u7f6e\u4efb\u52a1\u63d0\u9192")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="date", value="\u63d0\u9192\u65f6\u95f4\u6233(\u4e0d\u63d0\u9192\u4f20\u7a7a)", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Task> setTaskRemind(@LanguageType String languageType, @PathVariable Long taskId, String date) throws ParseException {
        return this.taskService.updateRemind(taskId, date, languageType);
    }

    private LoopModel getLoopModel(Task task) {
        LoopModel loopModel = new LoopModel("0", null, null, null);
        if (StringUtils.isNotBlank((String)task.getLoop())) {
            JSONObject jsonObject = new JSONObject(task.getLoop());
            String type = jsonObject.get("type").toString();
            loopModel.setType(type);
            if (StringUtils.isNotBlank((String)type) && type.equals(Constants.LoopTaskType.custom.getType())) {
                loopModel.setInterval(jsonObject.get("interval").toString());
                loopModel.setCustomType(jsonObject.get("customType").toString());
                String infoStr = jsonObject.get("info").toString();
                String[] info = new String[]{};
                if (StringUtils.isNotBlank((String)infoStr) && infoStr.length() > 1) {
                    infoStr = infoStr.replace("\"", "");
                    info = infoStr.substring(1, infoStr.length() - 1).split(",");
                }
                loopModel.setInfo(info);
            }
        }
        return loopModel;
    }

    @GetMapping(value={"/taskPage"})
    @ApiOperation(value="\u6211\u7684\u5de5\u4f5c\u53f0\u5206\u9875\u663e\u793a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id(\u4e2a\u4eba\u4e0d\u4f20)", required=false, dataType="long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u7b2c\u51e0\u9875", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001 \uff080\uff1a\u5f85\u529e,1\uff1a\u8fdb\u884c,2\uff1a\u5b8c\u6210\uff09", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<Task>> workbenchTaskPage(@LanguageType String languageType, @CurrentUser User currentUser, Long companyId, Integer pageNo, Integer pageSize, String status) {
        return ResultModel.suc((Object)this.taskService.findByWorkPage(companyId, status, currentUser.getId(), pageNo, pageSize), (String)languageType);
    }

    @GetMapping(value={"/taskCount"})
    @ApiOperation(value="\u4efb\u52a1\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="language_type", value="language_type", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pages", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel taskCount(@LanguageType String languageType, Long projectId, Integer pageNo, Integer pages) {
        String nowDateTime = DateUtils.getDateTime();
        if (projectId == null || " ".equals(nowDateTime)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.taskService.taskCount(nowDateTime, projectId, pageNo, pages), (String)languageType);
    }
}

