/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.task.TaskCommentService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskComment;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskComments"})
@Api(value="taskComments", description="\u4efb\u52a1\u8bc4\u8bba")
public class TaskCommentController
extends BaseController {
    @Reference
    private TaskCommentService taskCommentService;
    @Reference
    private TaskService taskService;
    @Reference
    private UserService userService;
    @Reference
    private EnclosureService enclosureService;

    @RequestMapping(method={RequestMethod.GET}, value={"/{taskId}"})
    @ApiOperation(value="\u67e5\u770b\u4efb\u52a1\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<TaskComment>> getOne(@LanguageType String languageType, @PathVariable Long taskId) {
        List taskCommentList = this.taskCommentService.findByTaskId(taskId);
        for (TaskComment comment : taskCommentList) {
            comment.setEnclosures(this.enclosureService.findByKeyIdAndType(comment.getId(), Constants.EnclosureType.taskComment.getType()));
            comment.setContent(StringEscapeUtils.unescapeJava((String)comment.getContent()));
        }
        return ResultModel.suc((Object)taskCommentList, (String)languageType);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskComment> addTaskComment(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody TaskComment taskComment) {
        if (StringUtils.isEmpty((Object)taskComment) || StringUtils.isEmpty((Object)taskComment.getContent()) || StringUtils.isEmpty((Object)taskComment.getTaskId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskComment.getTaskId());
        if (task == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        String comment = taskComment.getContent();
        if (StringUtils.containsEmoji((String)comment)) {
            taskComment.setContent(StringEscapeUtils.escapeJava((String)comment));
        }
        taskComment.setUserId(currentUser.getId());
        taskComment = this.taskCommentService.save(taskComment);
        if (!StringUtils.isEmpty((Object)taskComment.getEnclosureIds()) && taskComment.getEnclosureIds().length > 0) {
            for (Long enclosureId : taskComment.getEnclosureIds()) {
                EnclosureEntity enclosure = this.enclosureService.findById(enclosureId);
                enclosure.setKeyId(taskComment.getId());
                this.enclosureService.saveEnclosure(enclosure);
            }
        }
        taskComment.setEnclosures(this.enclosureService.findByKeyIdAndType(taskComment.getId(), Constants.EnclosureType.taskComment.getType()));
        taskComment.setUser(currentUser);
        taskComment.setContent(comment);
        return ResultModel.suc((Object)taskComment, (String)languageType);
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u8bc4\u8bbaid", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskComment> deleteTaskComment(@LanguageType String languageType, @CurrentUser User currentUser, Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        TaskComment taskComment = this.taskCommentService.findById(id);
        if (StringUtils.isEmpty((Object)taskComment)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_COMMENT_EXIST, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskComment.getTaskId());
        if (StringUtils.isEmpty((Object)task)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        if (!taskComment.getUserId().equals(currentUser.getId()) && !task.getAssigneeId().equals(currentUser.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_COMMENT_POWER, (String)languageType);
        }
        taskComment.setDelFlag(Boolean.valueOf(true));
        this.taskCommentService.save(taskComment);
        return ResultModel.ok((String)languageType);
    }
}

