/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.sys;

import com.alibaba.dubbo.config.annotation.Reference;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.config.ApiConfig;
import com.ym.tlifang.file.ImFileEntity;
import com.ym.tlifang.service.file.ImFileService;
import com.ym.tlifang.util.AmazonStorageUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"im"})
@Api(value="im", description="im\u4f1a\u8bdd\u6587\u4ef6\u76f8\u5173")
public class imStorageController {
    @Reference
    ImFileService imFileService;
    @Autowired
    ApiConfig apiConfig;

    @PostMapping(value={"/file/{conversationId}/{encrypt}"})
    @ApiOperation(value="im\u4f1a\u8bdd\u6587\u4ef6\u4e0a\u4f20\u76f8\u5173")
    @ApiImplicitParams(value={@ApiImplicitParam(name="conversationId", value="\u4f1a\u8bddid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="encrypt", value="\u662f\u5426\u52a0\u5bc6\uff080.\u975e\u52a0\u5bc6 1.\u52a0\u5bc6\uff09", required=true, dataType="int", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel newUploadImFileToS3(@LanguageType String languageType, @PathVariable Long conversationId, @PathVariable Integer encrypt, @RequestParam(value="file") MultipartFile multfile) throws IOException {
        String url = null;
        String decodeName = URLDecoder.decode(multfile.getOriginalFilename(), "UTF-8");
        String resultFileName = decodeName.substring(0, decodeName.indexOf(".")) + System.currentTimeMillis() + decodeName.substring(decodeName.lastIndexOf("."));
        File file = this.transferToTempFile(multfile, Boolean.valueOf(encrypt == 1));
        if (!file.exists()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR);
        }
        url = AmazonStorageUtil.uploadToS3((String)Constants.AMAZON_S3_BUCKET_NAME_IM, (File)file, (String)resultFileName);
        file.delete();
        if (StringUtils.isEmpty((Object)url)) {
            return ResultModel.error((ResultStatus)ResultStatus.UPLOAD_FAILED, (String)languageType);
        }
        ImFileEntity imFileEntity = new ImFileEntity();
        imFileEntity.setConversationId(conversationId);
        imFileEntity.setSize(Long.valueOf(multfile.getSize()));
        imFileEntity.setUrl(url);
        imFileEntity.setName(decodeName);
        imFileEntity.setBucketName(Constants.AMAZON_S3_BUCKET_NAME_IM);
        imFileEntity.setEncrypt(encrypt);
        imFileEntity.setCreateBy(Long.valueOf(123L));
        imFileEntity = this.imFileService.sava(imFileEntity);
        String urlResult = this.apiConfig.getImUrl() + imFileEntity.getId();
        return ResultModel.suc((Object)urlResult);
    }

    @GetMapping(value={"/download/{id}"})
    @ApiOperation(value="im\u4f1a\u8bdd\u6587\u4ef6\u4e0b\u8f7d\u76f8\u5173")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public void downloadToS3(@PathVariable Long id, HttpServletResponse response) throws IOException {
        ImFileEntity fileEntity = this.imFileService.findOne(id);
        String substring = fileEntity.getUrl().substring(fileEntity.getUrl().lastIndexOf("/") + 1);
        String decode = URLDecoder.decode(substring, "UTF-8");
        S3Object object = AmazonStorageUtil.doToS3((String)Constants.AMAZON_S3_BUCKET_NAME, (String)("im/" + decode));
        response.reset();
        response.setContentType("application/x-msdownload");
        response.setHeader("Content-Disposition", "attachment; filename=" + substring);
        try (ServletOutputStream outputStream = response.getOutputStream();
             S3ObjectInputStream input = object.getObjectContent();){
            int numOfEncAndDec = 137;
            int dataOfFile = 0;
            if (fileEntity.getEncrypt() == 1) {
                while ((dataOfFile = input.read()) > -1) {
                    outputStream.write(dataOfFile ^ 0x89);
                }
            } else {
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = input.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File transferToTempFile(MultipartFile multFile, Boolean encrypt) throws IOException, IllegalStateException {
        String fileName = multFile.getOriginalFilename();
        File desc = File.createTempFile(UUID.randomUUID().toString(), AmazonStorageUtil.getFileSuffix((String)fileName));
        try (InputStream in = multFile.getInputStream();
             OutputStream out = Files.newOutputStream(desc.toPath(), new OpenOption[0]);){
            if (encrypt.booleanValue()) {
                int numOfEncAndDec = 137;
                int bytesRead = -1;
                while ((bytesRead = in.read()) != -1) {
                    out.write(bytesRead ^ numOfEncAndDec);
                }
                out.flush();
            } else {
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
            }
        }
        return desc;
    }
}

