/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.meeting;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.meeting.MeetingEntity;
import com.ym.tlifang.meeting.MeetingMemberEntity;
import com.ym.tlifang.model.meeting.MyMeetingModel;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.meeting.MeetingMemberService;
import com.ym.tlifang.service.meeting.MeetingService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"meetingMember"})
@Api(value="meetingMember", description="\u4f1a\u8bae\u6210\u5458")
public class MeetingMemberController {
    @Reference
    MeetingMemberService meetingMemberService;
    @Reference
    MeetingService meetingService;
    @Reference
    CompanyService companyService;

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u4f1a\u8bae\u6210\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MeetingMemberEntity> add(@LanguageType String languageType, @RequestBody MeetingMemberEntity meetingMemberEntity) {
        if (meetingMemberEntity == null || meetingMemberEntity.getCompanyId() == null || meetingMemberEntity.getMeetingId() == null || meetingMemberEntity.getMemberId() == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        MeetingEntity meetingEntity = this.meetingService.findByMeetingId(meetingMemberEntity.getMeetingId());
        if (meetingEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_NO_EXIST, (String)languageType);
        }
        Company company = this.companyService.findById(meetingMemberEntity.getCompanyId());
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingMemberService.saveMeetingMember(meetingMemberEntity), (String)languageType);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u6210\u5458")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="id", value="\u4f1a\u8bae\u6210\u5458id", required=false, dataType="long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel delete(@LanguageType String languageType, @PathVariable Long id, @CurrentUser User currentUser) {
        if (id == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        MeetingMemberEntity memberEntity = this.meetingMemberService.findById(id);
        if (memberEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_MEMBER_NOT_EXIT, (String)languageType);
        }
        MeetingEntity meetingEntity = this.meetingService.findByMeetingId(memberEntity.getMeetingId());
        if (!currentUser.getId().equals(meetingEntity.getInitiatorId())) {
            return ResultModel.error((ResultStatus)ResultStatus.MEETING_INITIATOR_DELETE_MEMBER, (String)languageType);
        }
        memberEntity.setDelFlag(Boolean.valueOf(true));
        memberEntity.setUpdateDate(new Date());
        this.meetingMemberService.saveMeetingMember(memberEntity);
        return ResultModel.ok((String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bae\u6210\u5458\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="meetingId", value="\u4f1a\u8baeid", required=true, dataType="long", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel getList(@LanguageType String languageType, Long meetingId) {
        if (StringUtils.isEmpty((Object)meetingId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List list = this.meetingMemberService.findByMeetingId(meetingId);
        return ResultModel.suc((Object)list, (String)languageType);
    }

    @GetMapping(value={"/getMemberIdList"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u53c2\u4e0e\u7684\u516c\u53f8\u4f1a\u8bae\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001\uff080\u672a\u7ed3\u675f\uff0c1\u5df2\u7ed3\u675f\uff09", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pages", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MyMeetingModel> getList(@LanguageType String languageType, @CurrentUser User currentUser, Long companyId, String status, Integer pageNo, Integer pages) {
        if (companyId == null || currentUser.getId() == null || StringUtils.isEmpty((Object)status)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingMemberService.findByCompanyIdAndMemberId(companyId, currentUser.getId(), status, pageNo, pages, languageType), (String)languageType);
    }

    @GetMapping(value={"/getMyInitiatorMeetingList"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u521b\u5efa\u7684\u516c\u53f8\u4f1a\u8bae\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001\uff080\u672a\u7ed3\u675f\uff0c1\u5df2\u7ed3\u675f\uff09", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u5206\u9875\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pages", value="\u5206\u9875\u6761\u6570", required=true, dataType="Integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<MyMeetingModel> getMyInitiatorMeetingList(@LanguageType String languageType, @CurrentUser User currentUser, Long companyId, String status, Integer pageNo, Integer pages) {
        if (companyId == null || currentUser.getId() == null || StringUtils.isEmpty((Object)status)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)this.meetingMemberService.findMyInitiatorMeetingList(companyId, currentUser.getId(), status, pageNo, pages, languageType), (String)languageType);
    }
}

