/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.approval;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.task.TaskController;
import com.ym.tlifang.api.redis.MessageService;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.approval.ApprovalTemplateCopy;
import com.ym.tlifang.approval.ApprovalTemplateFlow;
import com.ym.tlifang.approval.ApprovalTemplateFlowSort;
import com.ym.tlifang.approval.ApprovalTemplateForm;
import com.ym.tlifang.approval.ApprovalTemplateFormType;
import com.ym.tlifang.approval.ApprovalUserApply;
import com.ym.tlifang.approval.ApprovalUserApplyForm;
import com.ym.tlifang.excel.ExportExcel;
import com.ym.tlifang.model.approval.ApprovalOperationModel;
import com.ym.tlifang.model.approval.ApprovalUserApplyExportEnModel;
import com.ym.tlifang.model.approval.ApprovalUserApplyExportModel;
import com.ym.tlifang.model.approval.ApprovalUserApplyModel;
import com.ym.tlifang.model.approval.FormModel;
import com.ym.tlifang.model.approval.StatisticsListModel;
import com.ym.tlifang.model.approval.StatisticsModel;
import com.ym.tlifang.model.notice.NoticeModel;
import com.ym.tlifang.service.approval.ApprovalTemplateCopyService;
import com.ym.tlifang.service.approval.ApprovalTemplateFlowService;
import com.ym.tlifang.service.approval.ApprovalTemplateFlowSortService;
import com.ym.tlifang.service.approval.ApprovalTemplateFormService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.approval.ApprovalUserApplyFormService;
import com.ym.tlifang.service.approval.ApprovalUserApplyService;
import com.ym.tlifang.service.common.LandConfig;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.system.Notice;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"approvalUserApplys"})
@Api(value="approvalUserApplys", description="\u5ba1\u6279\u7533\u8bf7\u76f8\u5173")
public class ApprovalUserApplyController {
    Logger logger = LoggerFactory.getLogger(TaskController.class);
    @Reference
    private ApprovalUserApplyService approvalUserApplyService;
    @Reference
    private ApprovalUserApplyFormService approvalUserApplyFormService;
    @Reference
    private ApprovalTemplateFlowService approvalTemplateFlowService;
    @Reference
    private ApprovalTemplateCopyService approvalTemplateCopyService;
    @Reference
    private ApprovalTemplateFlowSortService approvalTemplateFlowSortService;
    @Reference
    private UserService userService;
    @Reference
    private NoticeService noticeService;
    @Reference
    private EnclosureService enclosureService;
    @Reference
    private ApprovalTemplateService approvalTemplateService;
    @Reference
    private ApprovalTemplateFormService approvalTemplateFormService;
    @Autowired
    private MessageService messageService;
    @Reference
    private XgPushService xgPushService;
    @Reference
    private LandConfig landConfig;

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u5ba1\u6279\u7533\u8bf7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalUserApplyModel> createApprovalUserApply(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody ApprovalUserApplyModel approvalUserApplyModel) {
        Long[] copyUserIds;
        if (StringUtils.isEmpty((Object)approvalUserApplyModel) || StringUtils.isEmpty((Object)approvalUserApplyModel.getTemplateId()) || StringUtils.isEmpty((Object)approvalUserApplyModel.getContent()) || StringUtils.isEmpty((Object)approvalUserApplyModel.getApproverUserIds())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ApprovalUserApply approvalUserApply = new ApprovalUserApply();
        approvalUserApply.setUserId(currentUser.getId());
        approvalUserApply.setTemplateId(approvalUserApplyModel.getTemplateId());
        approvalUserApply.setContent(approvalUserApplyModel.getContent());
        approvalUserApply.setState(Constants.ApplyStatus.applyDoing.getType());
        approvalUserApply = this.approvalUserApplyService.save(approvalUserApply);
        Long[] longArray = copyUserIds = StringUtils.isEmpty((Object)approvalUserApplyModel.getCopyUserIds()) ? null : approvalUserApplyModel.getCopyUserIds();
        if (approvalUserApplyModel.getEnclosureIds() != null && approvalUserApplyModel.getEnclosureIds().length > 0) {
            for (Long id : approvalUserApplyModel.getEnclosureIds()) {
                EnclosureEntity entity = this.enclosureService.findById(id);
                entity.setKeyId(approvalUserApply.getId());
                this.enclosureService.saveEnclosure(entity);
            }
        }
        List approvalTemplateFormSet = approvalUserApplyModel.getForms();
        for (FormModel form : approvalTemplateFormSet) {
            ApprovalUserApplyForm approvalUserApplyForm = new ApprovalUserApplyForm(approvalUserApply.getId(), form.getFormId(), form.getValue());
            this.approvalUserApplyFormService.save(approvalUserApplyForm);
            ApprovalTemplateForm templateForm = this.approvalTemplateFormService.findById(form.getFormId());
            if (templateForm == null || !StringUtils.isNotBlank((String)templateForm.getFieldType()) || !StringUtils.isNotBlank((String)form.getValue()) || !templateForm.getFieldType().equals(Constants.TemplateFormType.file.getType())) continue;
            String[] enclosureIds = form.getValue().split(",");
            for (int i = 0; i < enclosureIds.length; ++i) {
                EnclosureEntity enclosure = this.enclosureService.findById(Long.valueOf(enclosureIds[i]));
                if (enclosure == null) continue;
                enclosure.setKeyId(approvalUserApply.getId());
                enclosure.setType(Constants.EnclosureType.approval.getType());
                this.enclosureService.saveEnclosure(enclosure);
            }
        }
        EnclosureEntity approverUserIds = approvalUserApplyModel.getApproverUserIds();
        Long i = 1L;
        for (Long approverUserId : approverUserIds) {
            ApprovalTemplateFlow approvalTemplateFlow = new ApprovalTemplateFlow(approvalUserApply.getId(), approverUserId, Boolean.valueOf(false));
            if (i == 1L) {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowDoing.getType());
            } else {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowNotAudit.getType());
            }
            approvalTemplateFlow = this.approvalTemplateFlowService.save(approvalTemplateFlow);
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            ApprovalTemplateFlowSort approvalTemplateFlowSort = new ApprovalTemplateFlowSort(approvalTemplateFlow.getId(), l);
            this.approvalTemplateFlowSortService.save(approvalTemplateFlowSort);
            if (!approverUserId.equals(approverUserIds[0])) continue;
            approvalUserApply.setCurrentProcessId(approvalTemplateFlow.getId());
            approvalUserApply = this.approvalUserApplyService.save(approvalUserApply);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("approvalUserApplyId", approvalUserApply.getId());
            map.put("action", "\u6536\u5230\u5ba1\u6279");
            map.put("msg", Constants.NoticeContent.youHaveNewApproval.getName());
            map.put("msgEn", Constants.NoticeContent.youHaveNewApproval.getNameEnglish());
            try {
                Notice notice = this.noticeService.saveSendNotice(approverUserId, Constants.NoticeParentType.approval, Constants.NoticeType.approvalGet, Constants.Originator.member, currentUser.getId(), map, "1");
                this.messageService.sendTopicMessage(new NoticeModel(new String[]{approverUserId.toString()}, new String[]{notice.getId().toString()}, map.get("msg").toString(), Integer.valueOf(0), Constants.NoticeParentType.approval.getType()), Boolean.valueOf(true));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            User user = this.userService.findById(approverUserId);
            ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(approvalUserApply.getTemplateId());
            if (StringUtils.isEmpty((Object)approvalTemplate)) continue;
            if (this.landConfig.getInlandFlag().booleanValue()) {
                if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getName(), Constants.ContentNotify.head.getName() + currentUser.getName() + Constants.ContentNotify.approvalTemplateFlowBefore.getName() + approvalTemplate.getName() + Constants.ContentNotify.approvalTemplateFlowAfter.getName(), null, Constants.IntentType.systemNotice.getType());
                continue;
            }
            if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
            this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + approvalTemplate.getName() + Constants.ContentNotify.approvalTemplateFlowBefore.getEnglishName() + currentUser.getName() + Constants.ContentNotify.approvalTemplateFlowAfter.getEnglishName(), Constants.SHOWFLAG);
        }
        if (!StringUtils.isEmpty((Object)copyUserIds) && copyUserIds.length > 0) {
            for (Long copyUserId : copyUserIds) {
                ApprovalTemplateCopy approvalTemplateCopy = new ApprovalTemplateCopy(approvalUserApply.getId(), copyUserId);
                approvalTemplateCopy = this.approvalTemplateCopyService.save(approvalTemplateCopy);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("approvalUserApplyId", approvalUserApply.getId());
                map.put("action", "\u6284\u9001");
                map.put("msg", currentUser.getName() + Constants.NoticeContent.approvalWaitDeal.getName());
                map.put("msgEn", currentUser.getName() + Constants.NoticeContent.approvalWaitDeal.getNameEnglish());
                try {
                    this.noticeService.saveSendNotice(copyUserId, Constants.NoticeParentType.approval, Constants.NoticeType.approvalCopy, Constants.Originator.member, currentUser.getId(), map, "2");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                User user = this.userService.findById(copyUserId);
                ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(approvalUserApply.getTemplateId());
                if (StringUtils.isEmpty((Object)approvalTemplate)) continue;
                if (this.landConfig.getInlandFlag().booleanValue()) {
                    if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.approvalTemplateCopy.getName(), currentUser.getName() + "\u7684" + approvalTemplate.getName() + Constants.ContentNotify.approvalTemplateCopy.getName(), null, Constants.IntentType.systemNotice.getType());
                    continue;
                }
                if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.approvalTemplateCopy.getEnglishName(), approvalTemplate.getName() + " of " + currentUser.getName() + Constants.ContentNotify.approvalTemplateCopy.getEnglishName(), Constants.SHOWFLAG);
            }
        }
        return ResultModel.suc((Object)approvalUserApply, (String)languageType);
    }

    @GetMapping(value={"/{applyId}"})
    @ApiOperation(value="\u67e5\u770b\u5ba1\u6279\u7533\u8bf7\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="applyId", value="\u7533\u8bf7id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalUserApplyModel> gApprovalUserApply(@LanguageType String languageType, @PathVariable Long applyId) {
        ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId(applyId);
        if (StringUtils.isEmpty((Object)approvalUserApply)) {
            return ResultModel.error((ResultStatus)ResultStatus.APPLYFORM_NO_EXIST, (String)languageType);
        }
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findByOne(approvalUserApply.getTemplateId());
        if (Constants.LanguageType.US.getName().equals(languageType) && approvalTemplate.getEnName() != null) {
            ArrayList<ApprovalTemplateForm> approvalTemplateFormList = new ArrayList<ApprovalTemplateForm>();
            for (ApprovalTemplateForm approvalTemplateForm : approvalTemplate.getApprovalTemplateFormSet()) {
                ArrayList<ApprovalTemplateFormType> approvalTemplateFormTypeList = new ArrayList<ApprovalTemplateFormType>();
                for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateForm.getApprovalTemplateFormTypeSet()) {
                    approvalTemplateFormType.setValue(approvalTemplateFormType.getEnName());
                    approvalTemplateFormType.setLabel(approvalTemplateFormType.getEnName());
                    approvalTemplateFormTypeList.add(approvalTemplateFormType);
                }
                approvalTemplateForm.setApprovalTemplateFormTypeSet(approvalTemplateFormTypeList);
                approvalTemplateForm.setFieldName(approvalTemplateForm.getEnName());
                approvalTemplateFormList.add(approvalTemplateForm);
            }
            approvalTemplate.setApprovalTemplateFormSet(approvalTemplateFormList);
            approvalTemplate.setName(approvalTemplate.getEnName());
        }
        approvalUserApply.setApprovalTemplate(approvalTemplate);
        ApprovalUserApplyModel approvalUserApplyModel = new ApprovalUserApplyModel();
        approvalUserApplyModel.init(approvalUserApply);
        approvalUserApplyModel.setCopyList(this.approvalTemplateCopyService.findCopyListByApplyId(approvalUserApply.getId()));
        List appendix = this.enclosureService.findAppendix(applyId, Constants.EnclosureType.approval.getType());
        if (!StringUtils.isEmpty((Object)appendix)) {
            approvalUserApplyModel.setEnclosureMap(appendix);
        }
        if (!StringUtils.isEmpty((Object)approvalUserApply.getApprovalTemplate())) {
            List approvalTemplateFormList = approvalUserApply.getApprovalTemplate().getApprovalTemplateFormSet();
            Iterator iterator = approvalTemplateFormList.iterator();
            ArrayList<FormModel> forms = new ArrayList<FormModel>();
            FormModel formModel = new FormModel();
            while (iterator.hasNext()) {
                ApprovalTemplateForm approvalTemplateForm = (ApprovalTemplateForm)iterator.next();
                ApprovalUserApplyForm approvalUserApplyForm = this.approvalUserApplyFormService.findByApplyIdAndFieldId(applyId, approvalTemplateForm.getId());
                if (StringUtils.isEmpty((Object)approvalUserApplyForm)) {
                    formModel = new FormModel(approvalTemplateForm.getId(), "", approvalTemplateForm.getFieldType(), approvalTemplateForm.getFieldName());
                } else {
                    formModel = new FormModel(approvalTemplateForm.getId(), approvalUserApplyForm.getFieldValue(), approvalTemplateForm.getFieldType(), approvalTemplateForm.getFieldName());
                    if (approvalTemplateForm.getFieldType().equals(Constants.TemplateFormType.file.getType()) && StringUtils.isNotBlank((String)approvalUserApplyForm.getFieldValue())) {
                        String[] enclosureIds = approvalUserApplyForm.getFieldValue().split(",");
                        ArrayList<EnclosureEntity> enclosures = new ArrayList<EnclosureEntity>();
                        for (int i = 0; i < enclosureIds.length; ++i) {
                            enclosures.add(this.enclosureService.findById(Long.valueOf(enclosureIds[i])));
                        }
                        formModel.setEnclosures(enclosures);
                    }
                }
                forms.add(formModel);
            }
            approvalUserApplyModel.setForms(forms);
        }
        approvalUserApplyModel.setApprovalTemplate(approvalUserApply.getApprovalTemplate());
        List approvalTemplateFlows = this.approvalTemplateFlowSortService.findByApplyId(applyId);
        for (ApprovalTemplateFlow approvalTemplateFlow : approvalTemplateFlows) {
            approvalTemplateFlow.setApprovalUserApply(null);
        }
        approvalUserApplyModel.setSteps(approvalTemplateFlows);
        return ResultModel.suc((Object)approvalUserApplyModel, (String)languageType);
    }

    @GetMapping(value={"/submitted/company/{companyId}"})
    @ApiOperation(value="\u6211\u63d0\u4ea4\u7684\u7533\u8bf7\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="type", value="\u7c7b\u578b \u9ed8\u8ba4 0\uff1a\u5f85\u5904\u7406 1\uff1a\u5df2\u5904\u7406\uff0c3\uff1a\u5168\u90e8", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalUserApply> submittedList(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String type, Integer pageNo, Integer pageSize) {
        Map approvalUserApplyList = this.approvalUserApplyService.findByUserIdAndCompanyIdAndType(currentUser.getId(), companyId, StringUtils.isNullToZero((Object)type), pageNo, pageSize, languageType);
        return ResultModel.suc((Object)approvalUserApplyList, (String)languageType);
    }

    @GetMapping(value={"/approval/company/{companyId}"})
    @ApiOperation(value="\u6211\u5ba1\u6279\u7684\u7533\u8bf7\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Integer", paramType="path"), @ApiImplicitParam(name="type", value="\u7c7b\u578b \u9ed8\u8ba4 0\uff1a\u5f85\u5904\u7406 1\uff1a\u5df2\u5904\u7406 2\uff1a\u6284\u9001\u6211 3:\u5168\u90e8", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalUserApply> approvalList(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String type, Integer pageNo, Integer pageSize) {
        Map approvalUserApplyList = this.approvalUserApplyService.findApprovalUserIdAndCompanyIdAndType(currentUser.getId(), companyId, StringUtils.isNullToZero((Object)type), pageNo, pageSize, languageType);
        return ResultModel.suc((Object)approvalUserApplyList, (String)languageType);
    }

    @GetMapping(value={"/all/company/{companyId}/{type}"})
    @ApiOperation(value="\u6211\u5ba1\u6279\u7684/\u6211\u7533\u8bf7\u7684/\u6284\u9001\u7ed9\u6211\u7684\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Integer", paramType="path"), @ApiImplicitParam(name="type", value="0.\u672a\u5904\u7406\u30011.\u5df2\u5904\u7406\u30013.\u5168\u90e8", required=true, dataType="Integer", paramType="path"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=true, dataType="Integer", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel allApprovalList(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, @PathVariable Long type, Integer pageNo, Integer pageSize) {
        Map approvalUserApplyList = this.approvalUserApplyService.findApprovalUserIdAndCompanyId(currentUser.getId(), companyId, type, pageNo, pageSize, languageType);
        return ResultModel.suc((Object)approvalUserApplyList, (String)languageType);
    }

    @PutMapping(value={"/approval/statistics/{companyId}"})
    @ApiOperation(value="\u5ba1\u6279\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<StatisticsListModel>> approvalList(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, @RequestBody StatisticsModel statisticsModel) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        PageInfo statisticsList = null;
        try {
            statisticsList = this.approvalUserApplyService.findByStatisticsList(statisticsModel, companyId);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ResultModel.suc((Object)statisticsList, (String)languageType);
    }

    @GetMapping(value={"/search/{companyId}"})
    @ApiOperation(value="\u5ba1\u6279\u641c\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="content", value="\u641c\u7d22\u5185\u5bb9", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalUserApply> search(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long companyId, String content) {
        List approvalUserApplyList = this.approvalUserApplyService.findByUserIdAndCompanyIdAndContent(currentUser.getId(), companyId, content);
        return ResultModel.suc((Object)approvalUserApplyList, (String)languageType);
    }

    @PutMapping(value={"/press/{applyId}"})
    @ApiOperation(value="\u7533\u8bf7\u8005\u50ac\u529e\u63d0\u9192")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="applyId", value="\u7533\u8bf7id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel approvalPress(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long applyId) {
        ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId(applyId);
        if (StringUtils.isEmpty((Object)approvalUserApply)) {
            return ResultModel.error((ResultStatus)ResultStatus.APPLYFORM_NO_EXIST, (String)languageType);
        }
        if (approvalUserApply.getUserId().equals(currentUser.getId())) {
            if (approvalUserApply.getState().equals(Constants.ApplyStatus.applyDoing.getType()) || approvalUserApply.getState().equals(Constants.ApplyStatus.applyTurnBatch.getType())) {
                ApprovalTemplateFlow approvalTemplateFlow = this.approvalTemplateFlowService.findByProcessId(approvalUserApply.getCurrentProcessId());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("approvalUserApplyId", approvalUserApply.getId());
                map.put("action", "\u6536\u5230\u5ba1\u6279");
                map.put("msg", Constants.NoticeContent.youHaveNewApproval.getName());
                map.put("msgEn", Constants.NoticeContent.youHaveNewApproval.getNameEnglish());
                try {
                    this.noticeService.saveSendNotice(approvalTemplateFlow.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalGet, Constants.Originator.member, currentUser.getId(), map, "1");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
        } else {
            return ResultModel.error((ResultStatus)ResultStatus.NOT_THE_APPLICANT, (String)languageType);
        }
        return ResultModel.ok((String)languageType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PutMapping(value={"/{applyId}"})
    @ApiOperation(value="\u5ba1\u6279\u8005\u5ba1\u6279\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="applyId", value="\u7533\u8bf7id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalOperationModel> approvalUserApply(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long applyId, @RequestBody ApprovalOperationModel approvalOperationModel) {
        HashMap<String, Object> map;
        if (StringUtils.isEmpty((Object)applyId) || StringUtils.isEmpty((Object)approvalOperationModel) || StringUtils.isEmpty((Object)approvalOperationModel.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId(applyId);
        if (StringUtils.isEmpty((Object)approvalUserApply)) {
            return ResultModel.error((ResultStatus)ResultStatus.APPLYFORM_NO_EXIST, (String)languageType);
        }
        ApprovalTemplateFlow approvalTemplateFlow = this.approvalTemplateFlowService.findByProcessId(approvalUserApply.getCurrentProcessId());
        if (StringUtils.isEmpty((Object)approvalTemplateFlow)) {
            return ResultModel.error((ResultStatus)ResultStatus.PROCESS_NO_EXIST, (String)languageType);
        }
        String status = approvalOperationModel.getStatus();
        if (status.equals(Constants.ApplyStatus.applyWithdraw.getType())) {
            if (!approvalUserApply.getUserId().equals(currentUser.getId())) return ResultModel.error((ResultStatus)ResultStatus.NOT_THE_APPLICANT, (String)languageType);
            approvalUserApply.setState(status);
            this.approvalUserApplyService.save(approvalUserApply);
            return ResultModel.suc((Object)approvalOperationModel, (String)languageType);
        }
        if (!status.equals(Constants.ApplyStatus.applyRejected.getType()) && !status.equals(Constants.ApplyStatus.applyTurnBatch.getType()) && !status.equals(Constants.ApplyStatus.applyThrough.getType())) return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        if (!approvalTemplateFlow.getUserId().equals(currentUser.getId())) return ResultModel.error((ResultStatus)ResultStatus.NOT_THE_APPROVER, (String)languageType);
        approvalTemplateFlow.setStatus(Boolean.valueOf(true));
        approvalTemplateFlow.setReplyContent(StringUtils.isNullStr((Object)approvalOperationModel.getReplyContent()));
        if (status.equals(Constants.ApplyStatus.applyRejected.getType())) {
            approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowRejected.getType());
            approvalUserApply.setState(status);
            HashMap<String, Object> map2 = new HashMap<String, Object>();
            map2.put("approvalUserApplyId", approvalUserApply.getId());
            map2.put("action", "\u6536\u5230\u5ba1\u6279");
            map2.put("msg", Constants.NoticeContent.yours.getName() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalReject.getName());
            map2.put("msgEn", Constants.NoticeContent.yours.getNameEnglish() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalReject.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(approvalUserApply.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalRespond, Constants.Originator.member, currentUser.getId(), map2, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            if (this.landConfig.getInlandFlag().booleanValue()) {
                if (!StringUtils.isEmpty((Object)approvalUserApply.getUser()) && StringUtils.isNotBlank((String)approvalUserApply.getUser().getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(approvalUserApply.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFalse.getName(), "\u60a8\u7684" + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFalse.getName(), null, Constants.IntentType.systemNotice.getType());
                }
            } else if (!StringUtils.isEmpty((Object)approvalUserApply.getUser()) && StringUtils.isNotBlank((String)approvalUserApply.getUser().getPushToken())) {
                this.xgPushService.pushTokenForeign(approvalUserApply.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFalse.getEnglishName(), "Your " + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFalse.getEnglishName(), Constants.SHOWFLAG);
            }
        }
        if (status.equals(Constants.ApplyStatus.applyTurnBatch.getType())) {
            approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowTurned.getType());
            approvalUserApply.setState(status);
            if (StringUtils.isEmpty((Object)approvalOperationModel.getTurnAprovalId())) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            ApprovalTemplateFlow turnApprovalTemplateFlow = new ApprovalTemplateFlow(approvalUserApply.getId(), approvalOperationModel.getTurnAprovalId(), Boolean.valueOf(false));
            turnApprovalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowTurning.getType());
            turnApprovalTemplateFlow = this.approvalTemplateFlowService.save(turnApprovalTemplateFlow);
            approvalUserApply.setCurrentProcessId(turnApprovalTemplateFlow.getId());
            ApprovalTemplateFlowSort currentApprovalTemplateFlowSort = this.approvalTemplateFlowSortService.findByFlowId(approvalTemplateFlow.getId());
            if (StringUtils.isEmpty((Object)currentApprovalTemplateFlowSort)) {
                return ResultModel.error((ResultStatus)ResultStatus.PROCESS_SORT_NO_EXIST, (String)languageType);
            }
            ApprovalTemplateFlowSort approvalTemplateFlowSort = new ApprovalTemplateFlowSort(turnApprovalTemplateFlow.getId(), currentApprovalTemplateFlowSort.getSort());
            this.approvalTemplateFlowSortService.save(approvalTemplateFlowSort);
            map = new HashMap<String, Object>();
            map.put("approvalUserApplyId", approvalUserApply.getId());
            map.put("action", "\u6536\u5230\u5ba1\u6279");
            map.put("msg", Constants.NoticeContent.youHaveNewApproval.getName());
            map.put("msgEn", Constants.NoticeContent.youHaveNewApproval.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(turnApprovalTemplateFlow.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalGet, Constants.Originator.member, currentUser.getId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            if (this.landConfig.getInlandFlag().booleanValue()) {
                if (!StringUtils.isEmpty((Object)turnApprovalTemplateFlow.getUser()) && StringUtils.isNotBlank((String)turnApprovalTemplateFlow.getUser().getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(turnApprovalTemplateFlow.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getName(), Constants.ContentNotify.head.getName() + approvalUserApply.getUser().getName() + Constants.ContentNotify.approvalTemplateFlowBefore.getName() + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFlowAfter.getName(), null, Constants.IntentType.systemNotice.getType());
                }
            } else if (!StringUtils.isEmpty((Object)turnApprovalTemplateFlow.getUser()) && StringUtils.isNotBlank((String)turnApprovalTemplateFlow.getUser().getPushToken())) {
                this.xgPushService.pushTokenForeign(turnApprovalTemplateFlow.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + approvalUserApply.getUser().getName() + Constants.ContentNotify.approvalTemplateFlowBefore.getEnglishName() + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFlowAfter.getEnglishName(), Constants.SHOWFLAG);
            }
        }
        if (status.equals(Constants.ApplyStatus.applyThrough.getType())) {
            if (approvalUserApply.getState().equals(Constants.ApplyStatus.applyTurnBatch.getType())) {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowTurned.getType());
            } else {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowThrough.getType());
            }
            approvalUserApply.setState(status);
            List flowIds = this.approvalTemplateFlowSortService.findFlowIdsByApplyId(applyId);
            if (!StringUtils.isEmpty((Object)flowIds) && flowIds.size() > 0) {
                if (!((BigInteger)flowIds.get(flowIds.size() - 1)).toString().equals(approvalTemplateFlow.getId().toString())) {
                    approvalUserApply.setState(Constants.ApplyStatus.applyDoing.getType());
                    Iterator iterator = flowIds.iterator();
                    while (iterator.hasNext()) {
                        BigInteger flowId = (BigInteger)iterator.next();
                        iterator.remove();
                        if (!flowId.toString().equals(approvalTemplateFlow.getId().toString())) continue;
                        break;
                    }
                    approvalUserApply.setCurrentProcessId(Long.valueOf(((BigInteger)flowIds.get(0)).toString()));
                    ApprovalTemplateFlow approvalTemplateFlowTwo = this.approvalTemplateFlowService.findByProcessId(Long.valueOf(((BigInteger)flowIds.get(0)).toString()));
                    approvalTemplateFlowTwo.setFlowType(Constants.ApplyFlowStatus.applyFlowDoing.getType());
                    this.approvalTemplateFlowService.save(approvalTemplateFlowTwo);
                    map = new HashMap();
                    map.put("approvalUserApplyId", approvalUserApply.getId());
                    map.put("action", "\u6536\u5230\u5ba1\u6279");
                    map.put("msg", Constants.NoticeContent.youHaveNewApproval.getName());
                    map.put("msgEn", Constants.NoticeContent.youHaveNewApproval.getNameEnglish());
                    try {
                        this.noticeService.saveSendNotice(approvalTemplateFlowTwo.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalGet, Constants.Originator.member, currentUser.getId(), map, "1");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    String name = approvalTemplateFlowTwo.getApprovalUserApply().getUser().getName();
                    if (this.landConfig.getInlandFlag().booleanValue()) {
                        if (!StringUtils.isEmpty((Object)approvalTemplateFlowTwo.getUser()) && StringUtils.isNotBlank((String)approvalTemplateFlowTwo.getUser().getPushToken())) {
                            this.xgPushService.pushTokenIosOrAndroidBelievers(approvalTemplateFlowTwo.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getName(), Constants.ContentNotify.head.getName() + name + Constants.ContentNotify.approvalTemplateFlowBefore.getName() + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFlowAfter.getName(), null, Constants.IntentType.systemNotice.getType());
                        }
                    } else if (!StringUtils.isEmpty((Object)approvalTemplateFlowTwo.getUser()) && StringUtils.isNotBlank((String)approvalTemplateFlowTwo.getUser().getPushToken())) {
                        this.xgPushService.pushTokenForeign(approvalTemplateFlowTwo.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateFlow.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateFlowBefore.getEnglishName() + name + Constants.ContentNotify.approvalTemplateFlowAfter.getEnglishName(), Constants.SHOWFLAG);
                    }
                } else {
                    HashMap<String, Object> map3 = new HashMap<String, Object>();
                    map3.put("approvalUserApplyId", approvalUserApply.getId());
                    map3.put("action", "\u5ba1\u6279\u56de\u590d");
                    map3.put("msg", Constants.NoticeContent.yours.getName() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalThrough.getName());
                    map3.put("msgEn", Constants.NoticeContent.yours.getNameEnglish() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalThrough.getNameEnglish());
                    try {
                        this.noticeService.saveSendNotice(approvalUserApply.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalRespond, Constants.Originator.member, currentUser.getId(), map3, "2");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    if (Constants.AttendanceCount.retroactive.getType().equals(approvalUserApply.getApprovalTemplate().getSign())) {
                        // empty if block
                    }
                    if (this.landConfig.getInlandFlag().booleanValue()) {
                        if (!StringUtils.isEmpty((Object)approvalUserApply.getUser()) && StringUtils.isNotBlank((String)approvalUserApply.getUser().getPushToken())) {
                            this.xgPushService.pushTokenIosOrAndroidBelievers(approvalUserApply.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateTrue.getName(), "\u60a8\u7684" + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateTrue.getName(), null, Constants.IntentType.systemNotice.getType());
                        }
                    } else if (!StringUtils.isEmpty((Object)approvalUserApply.getUser()) && StringUtils.isNotBlank((String)approvalUserApply.getUser().getPushToken())) {
                        this.xgPushService.pushTokenForeign(approvalUserApply.getUser().getPushToken(), Constants.TitleNotify.approvalTemplateTrue.getEnglishName(), "Your " + approvalUserApply.getApprovalTemplate().getName() + Constants.ContentNotify.approvalTemplateTrue.getEnglishName(), Constants.SHOWFLAG);
                    }
                }
            }
        }
        this.approvalTemplateFlowService.save(approvalTemplateFlow);
        this.approvalUserApplyService.save(approvalUserApply);
        return ResultModel.suc((Object)approvalOperationModel, (String)languageType);
    }

    @PutMapping(value={"/oneOperation"})
    @ApiOperation(value="\u4e00\u952e\u5ba1\u6279\u901a\u8fc7\u64cd\u4f5c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel oneClickApprovalThrough(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody Long[] applyIds) {
        if (StringUtils.isEmpty((Object)applyIds) || applyIds.length <= 0) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        for (Long applyId : applyIds) {
            ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId(applyId);
            ApprovalTemplateFlow approvalTemplateFlow = this.approvalTemplateFlowService.findByProcessId(approvalUserApply.getCurrentProcessId());
            if (!approvalTemplateFlow.getUserId().equals(currentUser.getId())) {
                return ResultModel.error((ResultStatus)ResultStatus.NOT_THE_APPROVER, (String)languageType);
            }
            if (approvalUserApply.getState().equals(Constants.ApplyStatus.applyTurnBatch.getType())) {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowTurned.getType());
            } else {
                approvalTemplateFlow.setFlowType(Constants.ApplyFlowStatus.applyFlowThrough.getType());
            }
            approvalTemplateFlow.setStatus(Boolean.valueOf(true));
            this.approvalTemplateFlowService.save(approvalTemplateFlow);
            List flowIds = this.approvalTemplateFlowSortService.findFlowIdsByApplyId(approvalUserApply.getId());
            if (!StringUtils.isEmpty((Object)flowIds) && flowIds.size() > 0) {
                if (!((BigInteger)flowIds.get(flowIds.size() - 1)).toString().equals(approvalTemplateFlow.getId().toString())) {
                    approvalUserApply.setState(Constants.ApplyStatus.applyDoing.getType());
                    Iterator iterator = flowIds.iterator();
                    while (iterator.hasNext()) {
                        BigInteger flowId = (BigInteger)iterator.next();
                        iterator.remove();
                        if (!flowId.toString().equals(approvalTemplateFlow.getId().toString())) continue;
                        break;
                    }
                    approvalUserApply.setCurrentProcessId(Long.valueOf(((BigInteger)flowIds.get(0)).toString()));
                    ApprovalTemplateFlow approvalTemplateFlowTwo = this.approvalTemplateFlowService.findByProcessId(Long.valueOf(((BigInteger)flowIds.get(0)).toString()));
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("approvalUserApplyId", approvalUserApply.getId());
                    map.put("action", "\u6536\u5230\u5ba1\u6279");
                    map.put("msg", Constants.NoticeContent.youHaveNewApproval.getName());
                    map.put("msgEn", Constants.NoticeContent.youHaveNewApproval.getNameEnglish());
                    try {
                        this.noticeService.saveSendNotice(approvalTemplateFlowTwo.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalGet, Constants.Originator.member, currentUser.getId(), map, "1");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                } else {
                    approvalUserApply.setState(Constants.ApplyStatus.applyThrough.getType());
                    if (Constants.AttendanceCount.retroactive.getType().equals(approvalUserApply.getApprovalTemplate().getSign())) {
                        // empty if block
                    }
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("approvalUserApplyId", approvalUserApply.getId());
                    map.put("action", "\u5ba1\u6279\u56de\u590d");
                    map.put("msg", Constants.NoticeContent.yours.getName() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalThrough.getName());
                    map.put("msgEn", Constants.NoticeContent.yours.getNameEnglish() + approvalUserApply.getApprovalTemplate().getName() + Constants.NoticeContent.approvalThrough.getName());
                    try {
                        this.noticeService.saveSendNotice(approvalUserApply.getUserId(), Constants.NoticeParentType.approval, Constants.NoticeType.approvalRespond, Constants.Originator.member, currentUser.getId(), map, "2");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
            this.approvalUserApplyService.save(approvalUserApply);
        }
        return ResultModel.ok((String)languageType);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/export"})
    @ApiOperation(value="\u7533\u8bf7\u5355\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="token", value="Bearer token", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="applyIds", value="\u7533\u8bf7ids(\u683c\u5f0f\u4e3a[1,2,3])", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="type", value="\u5bfc\u51fa\u7c7b\u578b\uff1a0:\u6211\u5ba1\u6279\u7684  1\uff1a\u6211\u63d0\u4ea4\u7684", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel exportApprovalThrough(String languageType, String token, String applyIds, String type, HttpServletResponse response) {
        if (StringUtils.isEmpty((Object)token) || StringUtils.isEmpty((Object)applyIds) || applyIds.length() <= 1 || StringUtils.isEmpty((Object)type)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        try {
            String userId = JwtUtil.checkTokenRtnUserId((String)token);
            applyIds = applyIds.substring(1, applyIds.length() - 1);
            String[] applyIdStrs = applyIds.split(",");
            if (Constants.LanguageType.CN.getName().equals(languageType) || languageType == null) {
                void var11_15;
                ArrayList<ApprovalUserApplyExportModel> approvalUserApplyModels = new ArrayList<ApprovalUserApplyExportModel>();
                for (String applyId : applyIdStrs) {
                    ApprovalUserApplyExportModel approvalUserApplyExportModel = new ApprovalUserApplyExportModel();
                    Object data = this.approvalUserApplyService.findMapByApplyId(Long.valueOf(applyId));
                    approvalUserApplyExportModel.init(data);
                    approvalUserApplyModels.add(approvalUserApplyExportModel);
                }
                String string = "";
                if (type.equals("1")) {
                    String string2 = "\u5ba1\u6279-\u6211\u63d0\u4ea4\u7684" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".xlsx";
                } else {
                    String string3 = "\u5ba1\u6279-\u6211\u5ba1\u6279\u7684" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".xlsx";
                }
                new ExportExcel("\u5ba1\u6279-\u6211\u63d0\u4ea4\u7684", ApprovalUserApplyExportModel.class).setDataList(approvalUserApplyModels).write(response, (String)var11_15).dispose();
            } else {
                void var11_20;
                ArrayList<ApprovalUserApplyExportEnModel> approvalUserApplyEnModels = new ArrayList<ApprovalUserApplyExportEnModel>();
                for (String applyId : applyIdStrs) {
                    ApprovalUserApplyExportEnModel approvalUserApplyExportModel = new ApprovalUserApplyExportEnModel();
                    Object data = this.approvalUserApplyService.findMapByApplyId(Long.valueOf(applyId));
                    approvalUserApplyExportModel.init(data);
                    approvalUserApplyEnModels.add(approvalUserApplyExportModel);
                }
                String string = "";
                if (type.equals("1")) {
                    String string4 = "Approval-My submitted" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".xlsx";
                } else {
                    String string5 = "Approval-My approved" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".xlsx";
                }
                new ExportExcel("Approval-My approved", ApprovalUserApplyExportEnModel.class).setDataList(approvalUserApplyEnModels).write(response, (String)var11_20).dispose();
            }
            return ResultModel.ok();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(401);
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
    }

    @GetMapping(value={"/getTime"})
    @ApiOperation(value="\u8bf7\u5047\u65f6\u95f4\u83b7\u53d6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="start", value="\u5f00\u59cb\u65f6\u95f4", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="end", value="\u7ed3\u675f\u65f6\u95f4", required=false, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel approvalUserApplyMassNotification(@LanguageType String languageType, @CurrentUser User user, Long companyId, String start, String end) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("time", this.approvalUserApplyService.findTime(start, end, user.getId(), companyId));
        return ResultModel.suc(map);
    }
}

