/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.task;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.task.TaskConcernDao;
import com.ym.tlifang.model.task.TaskAddAndDelConcernsModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.common.LandConfig;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=TaskConcernService.class, timeout=30000, retries=-1)
public class TaskConcernServiceImpl
extends AbstractBaseService<TaskConcern, TaskConcernDao>
implements TaskConcernService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserService userService;
    @Autowired
    private TaskConcernService taskConcernService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private XgPushService xgPushService;
    @Autowired
    private LandConfig landConfig;

    public TaskConcern save(TaskConcern taskConcern) {
        return (TaskConcern)super.save((BaseEntity)taskConcern);
    }

    public List<TaskConcern> findListByTaskId(Long taskId) {
        return ((TaskConcernDao)this.dao).findAllByTaskIdAndStatus(taskId, "1");
    }

    public List<Long> findUserByTaskId(Long taskId) {
        return ((TaskConcernDao)this.dao).findUserIdByTaskId(taskId);
    }

    public TaskConcern findByTaskIdAndUserId(Long taskId, Long userId) {
        return ((TaskConcernDao)this.dao).findByTaskIdAndUserIdAndDelFlag(taskId, userId, Boolean.valueOf(false));
    }

    public TaskConcern findByTaskIdAndUserIdAndTaskStatus(Long taskId, Long userId, String taskStatus, Boolean delFlag) {
        return ((TaskConcernDao)this.dao).findByTaskIdAndUserIdAndTaskStatusAndDelFlag(taskId, userId, taskStatus, delFlag);
    }

    public ResultModel addDelTaskConcern(String name, Task task, TaskAddAndDelConcernsModel taskConcernsModel, String languageType) {
        List listByTaskId = this.taskConcernService.findListByTaskId(task.getId());
        if (listByTaskId.size() > 0) {
            for (TaskConcern taskConcern : listByTaskId) {
                taskConcern.setStatus("0");
                this.taskConcernService.save(taskConcern);
            }
        }
        List userByTaskId = this.taskConcernService.findUserByTaskId(task.getId());
        for (Long userId : taskConcernsModel.getUserIds()) {
            User user = this.userService.findOne(userId);
            if (user == null) {
                return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
            }
            boolean contains = userByTaskId.contains(userId);
            TaskConcern ts = this.taskConcernService.findByTaskIdAndUserId(task.getId(), userId);
            if (contains) {
                if (StringUtils.isEmpty((Object)ts)) {
                    return ResultModel.error((ResultStatus)ResultStatus.TASKCONCERN_NO_EXIST, (String)languageType);
                }
                ts.setStatus("1");
                this.taskConcernService.save(ts);
            } else {
                if (!StringUtils.isEmpty((Object)ts)) {
                    return ResultModel.error((ResultStatus)ResultStatus.TASKCONCERN_EXIST, (String)languageType);
                }
                TaskConcern taskConcern = new TaskConcern();
                taskConcern.setTaskId(task.getId());
                taskConcern.setUserId(userId);
                taskConcern.setStatus("1");
                this.taskConcernService.save(taskConcern);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("taskId", task.getId());
            map.put("action", "\u6dfb\u52a0\u5173\u6ce8\u8005");
            map.put("msg", Constants.NoticeContent.pointConcern.getName());
            map.put("msgEn", Constants.NoticeContent.pointConcern.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(user.getId(), Constants.NoticeParentType.task, Constants.NoticeType.taskConcern, Constants.Originator.member, task.getCreatorId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            if (this.landConfig.getInlandFlag().booleanValue()) {
                if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.task.getName(), name + Constants.ContentNotify.taskParticipationDel.getName() + task.getTitle() + "\u7684\u4efb\u52a1\u53c2\u4e0e\u8005", null, Constants.IntentType.systemNotice.getType());
                continue;
            }
            if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
            this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.task.getEnglishName(), name + Constants.ContentNotify.taskParticipationDel.getEnglishName() + task.getTitle(), Constants.SHOWFLAG);
        }
        return ResultModel.ok((String)languageType);
    }
}

