/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.proclamation;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.dao.proclamation.ProclamationDao;
import com.ym.tlifang.proclamation.Proclamation;
import com.ym.tlifang.proclamation.ProclamationRemind;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.common.LandConfig;
import com.ym.tlifang.service.proclamation.ProclamationRemindService;
import com.ym.tlifang.service.proclamation.ProclamationService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ProclamationService.class, timeout=100000, retries=-1)
public class ProclamationServiceImpl
extends AbstractBaseService<Proclamation, ProclamationDao>
implements ProclamationService {
    Logger logger = LoggerFactory.getLogger(ProclamationServiceImpl.class);
    @Autowired
    private ProclamationRemindService proclamationRemindService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private UserService userService;
    @Autowired
    private XgPushService xgPushService;
    @Autowired
    private LandConfig landConfig;

    public Proclamation save(Proclamation proclamation) {
        return (Proclamation)((ProclamationDao)this.dao).save((Object)proclamation);
    }

    public Proclamation findByIdAndPromulgatorIdAndDelFlagFalse(Long id, Long promulgatorId) {
        return ((ProclamationDao)this.dao).findByIdAndPromulgatorIdAndDelFlagFalse(id, promulgatorId);
    }

    public Proclamation findByIdAndDelFlagFalse(Long id) {
        return ((ProclamationDao)this.dao).findByIdAndDelFlagFalse(id);
    }

    public Proclamation findById(Long id) {
        return ((ProclamationDao)this.dao).findById(id);
    }

    public Proclamation updateDrafts(Proclamation proclamation, Proclamation proclamationInfo) {
        if (proclamation != null) {
            ProclamationRemind proclamationRemind;
            if (!StringUtils.isEmpty((Object)proclamation.getName())) {
                proclamationInfo.setName(proclamation.getName());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getStatus())) {
                proclamationInfo.setStatus(proclamation.getStatus());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getType())) {
                proclamationInfo.setType(proclamation.getType());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getSourceId())) {
                proclamationInfo.setSourceId(proclamation.getSourceId());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getPromulgatorId())) {
                proclamationInfo.setPromulgatorId(proclamation.getPromulgatorId());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getContent())) {
                proclamationInfo.setContent(proclamation.getContent());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getSnippet())) {
                proclamationInfo.setSnippet(proclamation.getSnippet());
            }
            if (!StringUtils.isEmpty((Object)proclamation.getAddUserIds())) {
                for (Long userId : proclamation.getAddUserIds()) {
                    proclamationRemind = new ProclamationRemind(userId, "0", proclamation.getId());
                    this.proclamationRemindService.save(proclamationRemind);
                }
            }
            if (!StringUtils.isEmpty((Object)proclamation.getDelUserIds())) {
                for (Long userId : proclamation.getDelUserIds()) {
                    proclamationRemind = this.proclamationRemindService.findByProclamationIdAndUserIdAndDelFlagFalse(proclamationInfo.getId(), userId);
                    proclamationRemind.setDelFlag(Boolean.valueOf(true));
                    this.proclamationRemindService.save(proclamationRemind);
                }
            }
        }
        proclamationInfo = this.save(proclamationInfo);
        List userList = this.proclamationRemindService.findUserIdsByProclamationId(proclamationInfo.getId());
        this.addProclamationNotice(proclamationInfo, userList);
        return proclamationInfo;
    }

    public ResultModel<Proclamation> delPro(Proclamation proclamation, String languageType) {
        proclamation.setDelFlag(Boolean.valueOf(true));
        this.save(proclamation);
        List proclamationRemindList = this.proclamationRemindService.findByProclamationIdAndDelFlagFalse(proclamation.getId());
        for (ProclamationRemind proclamationRemind : proclamationRemindList) {
            proclamationRemind.setDelFlag(Boolean.valueOf(true));
            this.proclamationRemindService.save(proclamationRemind);
        }
        return ResultModel.ok((String)languageType);
    }

    public void addProclamationNotice(Proclamation proclamation, List<Long> users) {
        User user = this.userService.findById(proclamation.getPromulgatorId());
        if (!StringUtils.isEmpty(users) && proclamation.getStatus().equals(Constants.ProclamationStatus.publish.getType())) {
            HashMap<String, Object> map;
            if (proclamation.getType().equals(Constants.ProclamationType.companyNews.getType())) {
                for (Long userId : users) {
                    if (userId.equals(proclamation.getPromulgatorId())) continue;
                    map = new HashMap<String, Object>();
                    map.put("proclamationId", proclamation.getId());
                    map.put("action", "\u4f01\u4e1a\u65b0\u95fb");
                    map.put("msg", user.getName() + Constants.NoticeContent.releaseNews.getName() + proclamation.getName());
                    map.put("msgEn", user.getName() + Constants.NoticeContent.releaseNews.getNameEnglish() + proclamation.getName());
                    try {
                        this.noticeService.saveSendNotice(userId, Constants.NoticeParentType.proclamation, Constants.NoticeType.proclamationNews, Constants.Originator.member, proclamation.getPromulgatorId(), map, "2");
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    User userNotice = this.userService.findById(userId);
                    if (this.landConfig.getInlandFlag().booleanValue()) {
                        if (StringUtils.isEmpty((Object)userNotice) || !StringUtils.isNotBlank((String)userNotice.getPushToken())) continue;
                        this.xgPushService.pushTokenIosOrAndroidBelievers(userNotice.getPushToken(), Constants.TitleNotify.news.getName(), user.getName() + Constants.ContentNotify.news.getName() + proclamation.getName(), null, Constants.IntentType.systemNotice.getType());
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)userNotice) || !StringUtils.isNotBlank((String)userNotice.getPushToken())) continue;
                    this.xgPushService.pushTokenForeign(userNotice.getPushToken(), Constants.TitleNotify.news.getEnglishName(), user.getName() + Constants.ContentNotify.news.getEnglishName() + proclamation.getName(), Constants.SHOWFLAG);
                }
            }
            if (proclamation.getType().equals(Constants.ProclamationType.transactionNotice.getType())) {
                for (Long userId : users) {
                    if (!userId.equals(proclamation.getPromulgatorId())) {
                        map = new HashMap();
                        map.put("proclamationId", proclamation.getId());
                        map.put("action", "\u4e8b\u52a1\u901a\u77e5");
                        map.put("msg", user.getName() + Constants.NoticeContent.releaseProclamation.getName() + proclamation.getName());
                        map.put("msgEn", user.getName() + Constants.NoticeContent.releaseProclamation.getNameEnglish() + proclamation.getName());
                        try {
                            this.noticeService.saveSendNotice(userId, Constants.NoticeParentType.proclamation, Constants.NoticeType.proclamationNotice, Constants.Originator.member, proclamation.getPromulgatorId(), map, "1");
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                    User userNotice = this.userService.findById(userId);
                    if (this.landConfig.getInlandFlag().booleanValue()) {
                        if (StringUtils.isEmpty((Object)userNotice) || !StringUtils.isNotBlank((String)userNotice.getPushToken())) continue;
                        this.xgPushService.pushTokenIosOrAndroidBelievers(userNotice.getPushToken(), Constants.TitleNotify.notice.getName(), user.getName() + Constants.ContentNotify.notice.getName() + proclamation.getName(), null, Constants.IntentType.systemNotice.getType());
                        continue;
                    }
                    if (StringUtils.isEmpty((Object)userNotice) || !StringUtils.isNotBlank((String)userNotice.getPushToken())) continue;
                    this.xgPushService.pushTokenForeign(userNotice.getPushToken(), Constants.TitleNotify.notice.getEnglishName(), user.getName() + Constants.ContentNotify.notice.getEnglishName() + proclamation.getName(), Constants.SHOWFLAG);
                }
            }
        }
    }
}

