/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.file;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.file.FileDao;
import com.ym.tlifang.file.FileEntity;
import com.ym.tlifang.file.FileFolderEntity;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.file.NewMoveFileAndFolderModel;
import com.ym.tlifang.model.file.UpdateFileNameModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.AmazonStorageUtil;
import com.ym.tlifang.util.QiNiuUtil;
import com.ym.tlifang.util.qiniu.QiNiuConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=FileService.class, timeout=30000, retries=-1)
public class FileServiceImpl
extends AbstractBaseService<FileEntity, FileDao>
implements FileService {
    Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    private FileFolderService fileFolderService;
    @Autowired
    private DynamicService dynamicService;
    @Autowired
    private UserService userService;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private CompanyMemberInfoService memberInfoService;
    @Autowired
    private ProjectUserService projectUserService;
    @Autowired
    private FileFolderPowerService fileFolderPowerService;
    @Autowired
    private ProjectService projectService;

    public FileEntity sava(FileEntity entity) {
        Long id = entity.getId();
        entity = (FileEntity)((FileDao)this.dao).save((Object)entity);
        User updateUser = this.userService.findById(entity.getUpdateBy());
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("name", updateUser.getName());
        userMap.put("id", updateUser.getId());
        userMap.put("avatar", updateUser.getAvatar());
        entity.setUpdateByMap(userMap);
        return entity;
    }

    public List<Object> findByFolderIdObject(Long folderId, Long userId, Long rootParentId) {
        return ((FileDao)this.dao).findByFolderIdObject(folderId, userId, rootParentId);
    }

    public FileEntity findByNameAndFolderId(String name, Long folderId) {
        return ((FileDao)this.dao).findByNameAndFolderIdAndDelFlag(name, folderId, Boolean.valueOf(false));
    }

    public FileEntity findById(Long id) {
        return ((FileDao)this.dao).findByIdAndDelFlag(id, Boolean.valueOf(false));
    }

    public ResultModel newDeleteFileAndFileFolder(Long userId, Long[] dirs, Long[] files, Long rootParentId, Long keyId, String type, String languageType) {
        String info = new String();
        String infoEnglish = new String();
        boolean flag = true;
        if (rootParentId != 0L) {
            Long[] fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(rootParentId, userId);
            if (fileFolderPower == null || "2".equals(fileFolderPower.getPowerType())) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
            }
            flag = false;
        }
        if (dirs.length > 0) {
            info = info + Constants.DynamicType.delFilePackage.getName();
            infoEnglish = infoEnglish + Constants.DynamicType.delFilePackage.getNameEnglish();
            for (Long folderId : dirs) {
                FileFolderEntity fileFolderEntity;
                if (flag) {
                    FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(folderId, userId);
                    if (files.length > 0 || fileFolderPower == null || !"0".equals(fileFolderPower.getPowerType())) {
                        return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
                    }
                }
                if ((fileFolderEntity = this.fileFolderService.findById(folderId)) == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
                }
                this.delCascadeFolder(folderId, userId);
                List fileFolderPowerEntities = this.fileFolderPowerService.findByFileFolderIdAndDelFlagFalse(folderId);
                for (FileFolderPowerEntity fileFolderPowerEntity : fileFolderPowerEntities) {
                    this.fileFolderPowerService.deleteFolderPower(fileFolderPowerEntity.getId());
                }
                fileFolderEntity.setDelFlag(Boolean.valueOf(true));
                fileFolderEntity.setUpdateBy(userId);
                fileFolderEntity.setUpdateDate(new Date());
                this.fileFolderService.sava(fileFolderEntity);
                info = info + fileFolderEntity.getName() + " ";
                infoEnglish = infoEnglish + fileFolderEntity.getName() + " ";
            }
        }
        if (dirs.length > 0 && files.length > 0) {
            info = info + Constants.DynamicType.andFile.getName();
            infoEnglish = infoEnglish + Constants.DynamicType.andFile.getNameEnglish();
        }
        if (files.length > 0 && dirs.length == 0) {
            info = info + Constants.DynamicType.delFile.getName();
            infoEnglish = infoEnglish + Constants.DynamicType.delFile.getNameEnglish();
        }
        if (files.length > 0 && rootParentId != 0L) {
            if (flag) {
                return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
            }
            for (Long fileId : files) {
                FileEntity fileEntity = this.findById(fileId);
                if (fileEntity == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
                }
                fileEntity.setDelFlag(Boolean.valueOf(true));
                fileEntity.setUpdateBy(userId);
                fileEntity.setUpdateDate(new Date());
                ((FileDao)this.dao).save((Object)fileEntity);
                info = info + fileEntity.getName() + "  ";
                infoEnglish = infoEnglish + fileEntity.getName() + "  ";
            }
        }
        Constants.DynamicParentType parentType = null;
        if (Constants.FileType.project.getType().equals(type)) {
            parentType = Constants.DynamicParentType.project;
        } else if (Constants.FileType.team.getType().equals(type)) {
            parentType = Constants.DynamicParentType.company;
        }
        if (Constants.FileType.team.getType().equals(type) || Constants.FileType.project.getType().equals(type)) {
            this.dynamicService.saveDynamic(userId, parentType, keyId, Constants.DynamicOriginatorType.document, null, info, Constants.DynamicActionType.documentDelete, infoEnglish);
        }
        return ResultModel.ok();
    }

    public ResultModel newMoveFileAndFileFolder(User user, NewMoveFileAndFolderModel newMoveFileAndFolderModel, String languageType) {
        Map map = null;
        if (newMoveFileAndFolderModel.getRootParentId() == 0L) {
            return ResultModel.error((ResultStatus)ResultStatus.ROOT_FILE_FOLDER_NOT_MOVE, (String)languageType);
        }
        FileFolderEntity folderEntity = this.fileFolderService.findById(newMoveFileAndFolderModel.getDestDir());
        if (folderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileFolderPowerEntity folderPowerEntity = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(newMoveFileAndFolderModel.getRootParentId(), user.getId());
        if (folderPowerEntity == null || "2".equals(folderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        try {
            if (newMoveFileAndFolderModel.getFiles() != null) {
                boolean flag = true;
                List sqlNameList = new ArrayList();
                for (Long fileId : newMoveFileAndFolderModel.getFiles()) {
                    FileEntity fileEntity = this.findById(fileId);
                    FileFolderEntity fileFolderEntity = this.fileFolderService.findById(fileEntity.getFolderId());
                    if (fileFolderEntity == null) {
                        return ResultModel.error((ResultStatus)ResultStatus.ROOT_FILE_FOLDER_NOT_MOVE, (String)languageType);
                    }
                    FileEntity fileByName = this.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), newMoveFileAndFolderModel.getDestDir(), fileEntity.getType(), fileEntity.getKeyId());
                    if (fileByName != null && fileByName.getName() != null) {
                        if (flag) {
                            sqlNameList = this.findNameByKeyIdAndTypeAndParentId(fileEntity.getKeyId(), fileEntity.getType(), newMoveFileAndFolderModel.getDestDir());
                            flag = false;
                        }
                        if (sqlNameList == null || sqlNameList.size() == 0) {
                            return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                        }
                        String rechristen = this.rechristen(sqlNameList, fileEntity.getName());
                        fileEntity.setName(rechristen);
                    }
                    fileEntity.setFolderId(newMoveFileAndFolderModel.getDestDir());
                    fileEntity.setUpdateBy(user.getId());
                    ((FileDao)this.dao).save((Object)fileEntity);
                }
            }
            if (newMoveFileAndFolderModel.getDirs() != null) {
                List sqlNameList = new ArrayList();
                boolean flag = true;
                for (Long fileFolderId : newMoveFileAndFolderModel.getDirs()) {
                    String parentIdsOld = "";
                    String parentIdOld = "";
                    FileFolderEntity fileFolderEntityOld = this.fileFolderService.findById(fileFolderId);
                    FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(fileFolderEntityOld.getKeyId(), fileFolderEntityOld.getType(), newMoveFileAndFolderModel.getDestDir(), fileFolderEntityOld.getName());
                    if (validerFileFolderName != null && fileFolderEntityOld.getName() != null) {
                        if (flag) {
                            sqlNameList = this.fileFolderService.findNameByKeyIdAndTypeAndParentId(fileFolderEntityOld.getKeyId(), fileFolderEntityOld.getType(), newMoveFileAndFolderModel.getDestDir());
                            flag = false;
                        }
                        if (sqlNameList == null || sqlNameList.size() == 0) {
                            return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                        }
                        String rechristen = this.rechristen(sqlNameList, fileFolderEntityOld.getName());
                        fileFolderEntityOld.setName(rechristen);
                    }
                    parentIdsOld = fileFolderEntityOld.getParentIds();
                    parentIdOld = fileFolderEntityOld.getParentId().toString();
                    fileFolderEntityOld.setParentId(folderEntity.getId());
                    fileFolderEntityOld.setParentIds(folderEntity.getParentIds() == null ? "," + folderEntity.getId() + "," : folderEntity.getParentIds() + "," + fileFolderEntityOld.getParentId() + ",");
                    this.fileFolderService.sava(fileFolderEntityOld);
                    List departmentList = this.fileFolderService.findByParentIdsLike("%," + fileFolderId + ",%");
                    for (FileFolderEntity fileFolderEntity : departmentList) {
                        if (StringUtils.isNotEmpty((CharSequence)parentIdsOld)) {
                            String newParentIds = fileFolderEntity.getParentIds();
                            String s = StringUtils.substringAfter((String)fileFolderEntity.getParentIds(), (String)("," + parentIdOld + ","));
                            fileFolderEntity.setParentIds(fileFolderEntityOld.getParentIds() + s);
                        }
                        fileFolderEntity.setUpdateBy(user.getId());
                        this.fileFolderService.sava(fileFolderEntity);
                    }
                }
            }
            map = this.fileFolderService.findMapByKeyIdAndTypeAndParentId(user, folderEntity.getKeyId(), folderEntity.getType(), folderEntity.getId(), newMoveFileAndFolderModel.getRootParentId());
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return ResultModel.suc((Object)map);
    }

    void delCascadeFolder(Long folderId, Long userId) {
        List departmentList = this.fileFolderService.findByParentIdsLike("%," + folderId + ",%");
        if (departmentList.size() > 0) {
            for (FileFolderEntity entity : departmentList) {
                entity.setDelFlag(Boolean.valueOf(true));
                entity.setUpdateBy(userId);
                entity.setUpdateDate(new Date());
                this.fileFolderService.sava(entity);
                List files = this.findByFolderId(entity.getId());
                for (FileEntity fileEntity : files) {
                    fileEntity.setDelFlag(Boolean.valueOf(true));
                    fileEntity.setUpdateBy(userId);
                    fileEntity.setUpdateDate(new Date());
                    ((FileDao)this.dao).save((Object)fileEntity);
                }
            }
        }
    }

    public ResultModel modifyFileAndFileFolder(Long[] files, Long[] dirs, Long destDir, User currentUser, String languageType) {
        Object map = null;
        FileFolderEntity folderEntity = null;
        Long keyId = null;
        String type = null;
        if (destDir != null || destDir != 0L) {
            folderEntity = this.fileFolderService.findById(destDir);
        }
        try {
            if (files != null) {
                boolean flag = true;
                List sqlNameList = new ArrayList();
                for (Long fileId : files) {
                    FileEntity fileEntity = this.findById(fileId);
                    keyId = fileEntity.getKeyId();
                    type = fileEntity.getType();
                    FileEntity fileByName = this.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), destDir == 0L ? null : destDir, fileEntity.getType(), fileEntity.getKeyId());
                    if (fileByName != null && fileByName.getName() != null) {
                        if (flag) {
                            sqlNameList = this.findNameByKeyIdAndTypeAndParentId(fileEntity.getKeyId(), fileEntity.getType(), destDir == 0L || destDir == null ? null : destDir);
                            flag = false;
                        }
                        if (sqlNameList == null || sqlNameList.size() == 0) {
                            return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                        }
                        String rechristen = this.rechristen(sqlNameList, fileEntity.getName());
                        fileEntity.setName(rechristen);
                    }
                    fileEntity.setFolderId(destDir == 0L ? null : destDir);
                    fileEntity.setUpdateBy(currentUser.getId());
                    ((FileDao)this.dao).save((Object)fileEntity);
                }
            }
            if (dirs != null) {
                List sqlNameList = new ArrayList();
                boolean flag = true;
                for (Long fileFolderId : dirs) {
                    String parentIdsOld = "";
                    String parentIdOld = "";
                    FileFolderEntity fileFolderEntityOld = this.fileFolderService.findById(fileFolderId);
                    keyId = fileFolderEntityOld.getKeyId();
                    type = fileFolderEntityOld.getType();
                    FileFolderEntity validerFileFolderName = this.fileFolderService.findByKeyIdAndTypeAndParentIdAndName(fileFolderEntityOld.getKeyId(), fileFolderEntityOld.getType(), Long.valueOf(destDir == null ? 0L : destDir), fileFolderEntityOld.getName());
                    if (validerFileFolderName != null && fileFolderEntityOld.getName() != null) {
                        if (flag) {
                            sqlNameList = this.fileFolderService.findNameByKeyIdAndTypeAndParentId(fileFolderEntityOld.getKeyId(), fileFolderEntityOld.getType(), Long.valueOf(destDir == null ? 0L : destDir));
                            flag = false;
                        }
                        if (sqlNameList == null || sqlNameList.size() == 0) {
                            return ResultModel.error((ResultStatus)ResultStatus.SYS_ERROR, (String)languageType);
                        }
                        String rechristen = this.rechristen(sqlNameList, fileFolderEntityOld.getName());
                        fileFolderEntityOld.setName(rechristen);
                    }
                    parentIdsOld = fileFolderEntityOld.getParentIds();
                    parentIdOld = fileFolderEntityOld.getParentId().toString();
                    fileFolderEntityOld.setParentId(Long.valueOf(destDir == null || destDir == 0L ? 0L : destDir));
                    fileFolderEntityOld.setParentIds(destDir == null || destDir == 0L ? null : (StringUtils.isEmpty((CharSequence)folderEntity.getParentIds()) ? "," + folderEntity.getId() + "," : folderEntity.getParentIds() + "," + folderEntity.getId() + ","));
                    this.fileFolderService.sava(fileFolderEntityOld);
                    List departmentList = this.fileFolderService.findByParentIdsLike("%," + fileFolderId + ",%");
                    for (FileFolderEntity fileFolderEntity : departmentList) {
                        if (StringUtils.isNotEmpty((CharSequence)parentIdsOld)) {
                            String s = StringUtils.substringAfter((String)fileFolderEntity.getParentIds(), (String)("," + parentIdOld + ","));
                            fileFolderEntity.setParentIds(fileFolderEntityOld.getParentIds() + s);
                        }
                        fileFolderEntity.setUpdateBy(currentUser.getId());
                        this.fileFolderService.sava(fileFolderEntity);
                    }
                }
            }
            return this.fileFolderService.getFileAndFolderInfo(currentUser, keyId, destDir, type, languageType);
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
    }

    public List<FileEntity> findByKeyIdAndTypeAndFolderId(Long keyId, String type) {
        return ((FileDao)this.dao).findByKeyIdAndTypeAndFolderIdIsNullAndDelFlagFalse(keyId, type);
    }

    public FileEntity findByKeyIdAndTypeAndName(Long keyId, String type, String name) {
        return ((FileDao)this.dao).findByKeyIdAndTypeAndNameAndFolderIdIsNullAndDelFlag(keyId, type, name, Boolean.valueOf(false));
    }

    public FileEntity findByNameAndFolderIdAndTypeAndKeyId(String name, Long folderId, String type, Long keyId) {
        return ((FileDao)this.dao).findByNameAndFolderIdAndTypeAndKeyIdAndDelFlagFalse(name, folderId, type, keyId);
    }

    public List<String> findNameByKeyIdAndTypeAndParentId(Long keyId, String type, Long folderId) {
        return ((FileDao)this.dao).findNameByKeyIdAndTypeAndParentId(keyId, type, folderId);
    }

    public Integer findCompanyIdCountFileSize(Long companyId) {
        return ((FileDao)this.dao).findCompanyIdCountFileSize(companyId);
    }

    public FileEntity findByMongodbId(String mongodbId) {
        return ((FileDao)this.dao).findByMongodbId(mongodbId);
    }

    public List<Object> findByRootParentIdAndNameLike(String rootParentIds, Long rootParentId, String name, Long userId) {
        return ((FileDao)this.dao).findByRootParentIdAndNameLike(rootParentIds, rootParentId, name, userId);
    }

    public String repeatFileCheck(Long keyId, String type, Long folderId, String name) {
        String resultFileNmae = name.substring(0, name.indexOf("."));
        Integer fileCount = ((FileDao)this.dao).countNameByKeyIdAndTypeAndFolderIdAndDelFlagFalseAndNameLike(keyId, type, folderId, resultFileNmae + "%");
        if (fileCount > 0) {
            return resultFileNmae + "(" + fileCount + ")" + name.substring(name.lastIndexOf("."));
        }
        return name;
    }

    public List<FileEntity> findByFolderId(Long folderId) {
        return ((FileDao)this.dao).findByFolderIdAndDelFlagFalse(folderId);
    }

    public ResultModel<FileEntity> newAddFile(Long userId, Long parentId, FileEntity fileEntity, String languageType) {
        FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(parentId, userId);
        if (fileFolderPower == null || "2".equals(fileFolderPower.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileEntity fileEntity1 = this.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), fileEntity.getFolderId(), fileEntity.getType(), fileEntity.getKeyId());
        if (fileEntity1 != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        if (fileEntity.getId() == null) {
            if (Constants.FileType.team.getType().equals(fileEntity.getType())) {
                fileEntity.setCompanyId(fileEntity.getKeyId());
            }
            if (Constants.FileType.project.getType().equals(fileEntity.getType())) {
                Project project = this.projectService.findByProjectId(fileEntity.getKeyId());
                if (project == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
                }
                if (project.getCompanyId() != null) {
                    fileEntity.setCompanyId(project.getCompanyId());
                }
            }
            fileEntity.setCdnBucket(this.qiNiuConfig.getName());
            fileEntity.setCreateBy(userId);
            fileEntity.setUpdateBy(userId);
            fileEntity = this.sava(fileEntity);
            return ResultModel.suc((Object)fileEntity);
        }
        return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
    }

    public ResultModel<FileEntity> newUpdateFileName(Long userId, UpdateFileNameModel updateFileNameModel, String languageType) {
        FileEntity fileEntity1;
        FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(updateFileNameModel.getRootParentId(), userId);
        if (fileFolderPower == null && !"2".equals(fileFolderPower.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileEntity oldFileEntity = this.findById(updateFileNameModel.getFileId());
        if (oldFileEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NO_EXIST, (String)languageType);
        }
        if (!oldFileEntity.getName().equals(updateFileNameModel.getFileName()) && (fileEntity1 = this.findByNameAndFolderIdAndTypeAndKeyId(updateFileNameModel.getFileName(), oldFileEntity.getFolderId(), oldFileEntity.getType(), oldFileEntity.getKeyId())) != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        if (oldFileEntity.getCdnBucket().equals(this.qiNiuConfig.getName())) {
            if (QiNiuUtil.updateFileName((FileEntity)oldFileEntity, (String)updateFileNameModel.getFileName()).booleanValue()) {
                oldFileEntity.setCdnKey(oldFileEntity.getCdnKey().split("/")[0] + "/" + updateFileNameModel.getFileName());
                oldFileEntity.setUrl(Constants.QINIU_ADDRESS + oldFileEntity.getCdnKey());
                oldFileEntity.setDownloadUrl(oldFileEntity.getUrl() + Constants.QINIU_LAST_ADDRESS);
            }
        } else if (AmazonStorageUtil.rename((String)oldFileEntity.getCdnBucket(), (String)oldFileEntity.getName(), (String)updateFileNameModel.getFileName())) {
            String url = AmazonStorageUtil.getUrlFromS3((String)oldFileEntity.getCdnBucket(), (String)updateFileNameModel.getFileName());
            oldFileEntity.setUrl(url);
            oldFileEntity.setDownloadUrl(url);
        } else {
            return ResultModel.error((ResultStatus)ResultStatus.RENAME_FAILED, (String)languageType);
        }
        oldFileEntity.setName(updateFileNameModel.getFileName());
        oldFileEntity.setUpdateBy(userId);
        oldFileEntity.setUpdateDate(new Date());
        oldFileEntity = this.sava(oldFileEntity);
        return ResultModel.suc((Object)oldFileEntity);
    }

    public ResultModel<FileEntity> newUpdateFile(Long userId, Long parentId, FileEntity fileEntity, String languageType) {
        FileEntity fileEntity1;
        FileFolderPowerEntity fileFolderPower = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(parentId, userId);
        if (fileFolderPower == null && !"2".equals(fileFolderPower.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_ADMIN_NO_EXIST, (String)languageType);
        }
        FileEntity oldFileEntity = this.findById(fileEntity.getId());
        if (oldFileEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NO_EXIST, (String)languageType);
        }
        if (!oldFileEntity.getName().equals(fileEntity.getName()) && (fileEntity1 = this.findByNameAndFolderIdAndTypeAndKeyId(fileEntity.getName(), fileEntity.getFolderId(), fileEntity.getType(), fileEntity.getKeyId())) != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        Boolean updateFileName = true;
        if (oldFileEntity.getCdnBucket().equals(this.qiNiuConfig.getName())) {
            if (QiNiuUtil.updateFileName((FileEntity)oldFileEntity, (String)fileEntity.getName()).booleanValue()) {
                oldFileEntity.setCdnKey(oldFileEntity.getCdnKey().split("/")[0] + "/" + fileEntity.getName());
                oldFileEntity.setUrl(Constants.QINIU_ADDRESS + oldFileEntity.getCdnKey());
                oldFileEntity.setDownloadUrl(oldFileEntity.getUrl() + Constants.QINIU_LAST_ADDRESS);
            }
        } else if (AmazonStorageUtil.rename((String)oldFileEntity.getCdnBucket(), (String)oldFileEntity.getName(), (String)fileEntity.getName())) {
            String url = AmazonStorageUtil.getUrlFromS3((String)oldFileEntity.getCdnBucket(), (String)fileEntity.getName());
            oldFileEntity.setUrl(url);
            oldFileEntity.setDownloadUrl(url);
        }
        if (!oldFileEntity.getName().equals(fileEntity.getName()) && !(updateFileName = QiNiuUtil.updateFileName((FileEntity)oldFileEntity, (String)fileEntity.getName())).booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        fileEntity.setCdnKey(oldFileEntity.getCdnKey().split("/")[0] + "/" + fileEntity.getName());
        fileEntity.setUpdateBy(userId);
        fileEntity = this.sava(fileEntity);
        return ResultModel.suc((Object)fileEntity);
    }

    public List<FileEntity> findByKeyIdAndTypeAndNameLike(Long keyId, String type, String name) {
        return ((FileDao)this.dao).findByKeyIdAndTypeAndNameLikeAndDelFlagFalse(keyId, type, name);
    }

    public ResultModel delPersonalFileAndFileFolder(Long[] files, Long[] dirs, String type, Long keyId, User user, String languageType) {
        Project project;
        if ("1".equals(type)) {
            ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        } else if ("2".equals(type) && ((project = this.projectService.findByProjectId(keyId)) == null || project.getCompanyId() != null || !project.getOwnerId().equals(user.getId()))) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        for (Long fileFolderId : dirs) {
            FileFolderEntity fileFolderEntity = this.fileFolderService.findById(fileFolderId);
            if (fileFolderEntity == null) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
            }
            List departmentList = this.fileFolderService.findByParentIdsLike("%," + fileFolderId + ",%");
            for (FileFolderEntity entity : departmentList) {
                entity.setDelFlag(Boolean.valueOf(true));
                entity.setUpdateBy(user.getId());
                this.fileFolderService.sava(entity);
                this.deleteFile(entity.getId(), user);
            }
            fileFolderEntity.setDelFlag(Boolean.valueOf(true));
            fileFolderEntity.setUpdateBy(user.getId());
            this.fileFolderService.sava(fileFolderEntity);
            this.deleteFile(fileFolderEntity.getId(), user);
        }
        for (Long fileId : files) {
            FileEntity fileEntity = this.findById(fileId);
            if (fileEntity == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            fileEntity.setDelFlag(Boolean.valueOf(true));
            fileEntity.setUpdateBy(user.getId());
            ((FileDao)this.dao).save((Object)fileEntity);
        }
        return ResultModel.ok();
    }

    private void deleteFile(Long folderId, User currentUser) {
        List files = this.findByFolderId(folderId);
        for (FileEntity fileEntity : files) {
            fileEntity.setDelFlag(Boolean.valueOf(true));
            fileEntity.setUpdateBy(currentUser.getId());
            ((FileDao)this.dao).save((Object)fileEntity);
        }
    }

    private void modifyFileFolder(Long fileFolderId, String parentIds, String parentIdsOld, String parentIdOld, User currentUser) {
        List departmentList = this.fileFolderService.findByParentIdsLike("%," + fileFolderId + ",%");
        for (FileFolderEntity fileFolderEntity : departmentList) {
            if (StringUtils.isEmpty((CharSequence)parentIdsOld)) {
                fileFolderEntity.setParentIds(parentIds + "," + fileFolderEntity.getParentIds());
            }
            if (StringUtils.isNotEmpty((CharSequence)parentIdsOld)) {
                String newParentIds = fileFolderEntity.getParentIds();
                fileFolderEntity.setParentIds(parentIds == null ? this.substringAfter(fileFolderEntity.getParentIds(), parentIdOld) : parentIds + "," + this.substringAfter(fileFolderEntity.getParentIds(), parentIdOld));
            }
            fileFolderEntity.setUpdateBy(currentUser.getId());
            this.fileFolderService.sava(fileFolderEntity);
        }
    }

    private String substringAfter(String str, String s) {
        return StringUtils.substringAfter((String)str, (String)(s + ","));
    }

    private String rechristen(List<String> sqlNameList, String name) {
        String fileSuffix;
        String resName = name;
        int number = 0;
        int i = name.lastIndexOf(".");
        String fileName = i == -1 ? name : name.substring(0, i);
        String string = fileSuffix = i == -1 ? "" : name.substring(i, name.length());
        while (sqlNameList.contains(resName)) {
            resName = fileName + "(" + ++number + ")" + fileSuffix;
        }
        sqlNameList.add(resName);
        return resName;
    }

    public List<FileFolderEntity> saveAllFold() {
        List objectList = ((FileDao)this.dao).findByCompanyIdNotNullAndFolderIdIsNuLL();
        ArrayList<FileFolderEntity> fileFolderEntities = new ArrayList<FileFolderEntity>();
        for (Object[] objects : objectList) {
            FileFolderEntity fileFolderEntity = new FileFolderEntity();
            fileFolderEntity.setCompanyId(Long.valueOf(objects[0].toString()));
            fileFolderEntity.setType(objects[1].toString());
            fileFolderEntity.setKeyId(Long.valueOf(objects[2].toString()));
            fileFolderEntity.setCreateBy(Long.valueOf("0"));
            fileFolderEntity.setParentId(Long.valueOf("0"));
            fileFolderEntity.setDefaultValue("0");
            fileFolderEntity.setName("\u5386\u53f2\u6587\u4ef6\u5939");
            fileFolderEntities.add(fileFolderEntity);
        }
        return this.fileFolderService.saveList(fileFolderEntities);
    }

    public void updateAll(List<FileFolderEntity> fileFolderEntities) {
        for (FileFolderEntity fileFolderEntity : fileFolderEntities) {
            ((FileDao)this.dao).updateByKey(fileFolderEntity.getId(), fileFolderEntity.getCompanyId(), fileFolderEntity.getType(), fileFolderEntity.getKeyId());
        }
    }
}

