/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.user;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.api.redis.MessageService;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.model.user.ForgetPasswordModel;
import com.ym.tlifang.model.user.RegisterModel;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.note.NoteBookService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.system.DictionaryService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.Dictionary;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.IpUtil;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"users"})
@Api(value="users", description="\u7528\u6237\u76f8\u5173")
public class UserController
extends BaseController {
    @Reference
    private UserService userService;
    @Autowired
    private StringRedisTemplate redis;
    @Reference
    private ProjectService projectService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private DictionaryService dictionaryService;
    @Autowired
    private MessageService messageService;
    @Reference
    private NoteBookService noteBookService;

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    public ResultModel<User> getInfo(@LanguageType String languageType, @CurrentUser User currentUser) {
        User user = this.userService.findByEmailOrMobile(currentUser.getMobile(), currentUser.getAreaCode());
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.REFRESHTOKEN_ERROR, (String)languageType);
        }
        if (user.getCurrentCompany() != null) {
            CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(user.getCurrentCompany(), user.getId(), Constants.AuditStatus.adopt.getType());
            if (companyMemberInfo == null) {
                return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
            }
            user.setManager(companyMemberInfo.getManager());
        }
        return ResultModel.suc((Object)user, (String)languageType);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @GetMapping(value={"/{id}"})
    public ResultModel<User> getUserById(@LanguageType String languageType, @PathVariable(value="id") Long id) {
        User user = this.userService.findById(id);
        return ResultModel.suc((Object)user, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ApiOperation(value="\u6ce8\u518c")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<RegisterModel> register(@LanguageType String languageType, HttpServletRequest request, @RequestBody RegisterModel registerModel) {
        if (StringUtils.isEmpty((Object)registerModel.getMobile()) || StringUtils.isEmpty((Object)registerModel.getSmsCode()) || StringUtils.isEmpty((Object)registerModel.getPassword())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ResultModel resultModel = this.checkSmsCode(languageType, registerModel.getSmsCode(), Constants.YunPianSmsType.mobileActivity.getTypeId(), registerModel.getAreaCode(), registerModel.getMobile());
        if (resultModel != null) {
            return resultModel;
        }
        User userServiceByEmailOrMobile = this.userService.findByEmailOrMobile(registerModel.getMobile(), registerModel.getAreaCode());
        if (userServiceByEmailOrMobile != null) {
            return ResultModel.error((ResultStatus)ResultStatus.MOBILE_EXIST, (String)languageType);
        }
        String platform = request.getHeader("platform");
        User user = new User();
        user.setAreaCode(registerModel.getAreaCode());
        user.setMobile(registerModel.getMobile());
        user.setName(StringUtils.isEmpty((Object)registerModel.getName()) ? registerModel.getMobile() : registerModel.getName());
        user.setPlatform(StringUtils.isEmpty((Object)platform) ? null : Integer.valueOf(Integer.parseInt(platform)));
        String ip = IpUtil.getIpAddr((HttpServletRequest)request);
        user.setRegisterIp(ip);
        user.setPassword(PasswordEncoder.encrypt((String)registerModel.getPassword(), (String)"ym2018"));
        user.setCreateDate(new Date());
        user.setLoginCount(Long.valueOf(0L));
        user = this.userService.save(user);
        this.projectService.saveDefaultProjectAndDefaultPanel(user.getId(), null, languageType);
        this.noteBookService.saveDefaultNoteBook(user.getId(), Constants.LanguageType.US.getName().equals(languageType) ? "Default notebook" : "\u9ed8\u8ba4\u7b14\u8bb0\u672c");
        this.userService.registerUserToWecloud(user);
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ApiOperation(value="\u4e2a\u4eba\u8bbe\u7f6e")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @Authorization
    public ResultModel<User> updateUserInfo(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody User user) {
        if (StringUtils.isNotBlank((String)user.getName())) {
            currentUser.setName(user.getName());
        }
        if (StringUtils.isNotBlank((String)user.getSex())) {
            currentUser.setSex(user.getSex());
        }
        if ("".equals(user.getDescription())) {
            currentUser.setDescription(null);
        }
        if (StringUtils.isNotBlank((String)user.getDescription())) {
            currentUser.setDescription(user.getDescription());
        }
        if ("".equals(user.getAddress())) {
            currentUser.setAddress(null);
        }
        if (StringUtils.isNotBlank((String)user.getAddress())) {
            currentUser.setAddress(user.getAddress());
        }
        if (StringUtils.isNotBlank((String)user.getAvatar())) {
            currentUser.setAvatar(user.getAvatar());
        }
        if (!StringUtils.isEmpty((Object)user.getBirthdate())) {
            currentUser.setBirthdate(user.getBirthdate());
        }
        if (StringUtils.isNotBlank((String)user.getEmail())) {
            currentUser.setEmail(user.getEmail());
        }
        if (user.getCurrentCompany() != null && user.getCurrentCompany() != 0L) {
            currentUser.setCurrentCompany(user.getCurrentCompany());
        }
        this.userService.save(currentUser);
        this.userService.syncUserToWecloud(currentUser);
        return ResultModel.suc((Object)currentUser, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"application"})
    @ApiOperation(value="\u4e2a\u4eba\u5e94\u7528\u8bbe\u7f6e")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @Authorization
    public ResultModel<User> updateApplicationUser(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody User user) {
        if (user.getApplicationType() != null) {
            String[] applicationType = user.getApplicationType().split(",");
            if (applicationType.length > 8) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            currentUser.setApplicationType(user.getApplicationType());
        } else {
            currentUser.setApplicationType("0");
        }
        this.userService.save(currentUser);
        return ResultModel.suc((Object)currentUser, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"password"})
    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="oldPassword", value="\u521d\u59cb\u5bc6\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="newPassword", value="\u65b0\u5bc6\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @Authorization
    public ResultModel modifyPassword(@LanguageType String languageType, @CurrentUser User currentUser, String oldPassword, String newPassword) {
        String prePassword = currentUser.getPassword();
        if (!prePassword.equals(PasswordEncoder.encrypt((String)oldPassword, (String)"ym2018"))) {
            return ResultModel.error((ResultStatus)ResultStatus.INIT_PASSWORD_ERROR, (String)languageType);
        }
        currentUser.setPassword(PasswordEncoder.encrypt((String)newPassword, (String)"ym2018"));
        this.userService.save(currentUser);
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"password/forget"})
    @ApiOperation(value="\u5fd8\u8bb0\u5bc6\u7801")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel forgetPassword(@LanguageType String languageType, @RequestBody ForgetPasswordModel forgetPasswordModel) {
        ResultModel resultModel;
        if (forgetPasswordModel.getAreaCode() == null) {
            forgetPasswordModel.setAreaCode(Constants.CHINAAREACODE);
        }
        if ((resultModel = this.checkSmsCode(languageType, forgetPasswordModel.getSmsCode(), Constants.YunPianSmsType.resetPassword.getTypeId(), forgetPasswordModel.getAreaCode(), forgetPasswordModel.getMobile())) != null) {
            return resultModel;
        }
        User user = this.userService.findByEmailOrMobile(forgetPasswordModel.getMobile(), forgetPasswordModel.getAreaCode());
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.MOBILE_NO_EXIST, (String)languageType);
        }
        if (forgetPasswordModel.getPassword() != null) {
            user.setPassword(PasswordEncoder.encrypt((String)forgetPasswordModel.getPassword(), (String)"ym2018"));
            this.userService.save(user);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"mobiles/check"})
    @ApiOperation(value="\u68c0\u9a8c\u624b\u673a\u53f7\u7801", notes="\u6ce8\u518c\u754c\u9762\u68c0\u6d4b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7\u7801", required=true, dataType="string", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel checkMobile(@LanguageType String languageType, @RequestBody String mobile) {
        User queryUser = this.userService.findByMobile(mobile);
        if (queryUser != null) {
            return ResultModel.error((ResultStatus)ResultStatus.MOBILE_EXIST, (String)languageType);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"mobiles/rebinding"})
    @ApiOperation(value="\u7ed1\u5b9a\u65b0\u7684\u624b\u673a\u53f7\u7801", notes="\u91cd\u65b0\u7ed1\u5b9a\u624b\u673a\u53f7\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="smsCode", value="\u9a8c\u8bc1\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel modifyMobile(@LanguageType String languageType, @CurrentUser User currentUser, String smsCode, String mobile) {
        ResultModel resultModel = this.checkSmsCode(languageType, smsCode, Constants.YunPianSmsType.mobileRebind.getTypeId(), Constants.CHINAAREACODE, mobile);
        if (resultModel != null) {
            return resultModel;
        }
        User queryUser = this.userService.findByMobile(mobile);
        if (queryUser != null) {
            return ResultModel.error((ResultStatus)ResultStatus.MOBILE_EXIST, (String)languageType);
        }
        currentUser.setMobile(mobile);
        this.userService.save(currentUser);
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"email/binding"})
    @ApiOperation(value="\u7ed1\u5b9a\u90ae\u7bb1", notes="\u7ed1\u5b9a\u90ae\u7bb1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="smsCode", value="\u9a8c\u8bc1\u7801", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel modifyEmail(@LanguageType String languageType, @CurrentUser User currentUser, String smsCode, String email) {
        ResultModel resultModel = this.checkEmailSmsCode(languageType, smsCode, email);
        if (resultModel != null) {
            return resultModel;
        }
        User queryUser = this.userService.findByEmailOrMobile(email, currentUser.getAreaCode());
        if (queryUser != null) {
            return ResultModel.error((ResultStatus)ResultStatus.EMAIL_EXIST, (String)languageType);
        }
        currentUser.setEmail(email);
        this.userService.save(currentUser);
        return ResultModel.ok((String)languageType);
    }

    public ResultModel checkSmsCode(@LanguageType String languageType, String smsCode, Integer type, String areaCode, String mobile) {
        String userSmsCode = (String)this.redis.boundValueOps((Object)(Constants.SMSCODE + areaCode + mobile + "_" + type)).get();
        if (StringUtils.isEmpty((Object)userSmsCode)) {
            return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_NO_EXIST, (String)languageType);
        }
        if (!userSmsCode.equals(smsCode)) {
            return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_ERROR, (String)languageType);
        }
        return null;
    }

    public ResultModel checkEmailSmsCode(@LanguageType String languageType, String smsCode, String email) {
        String userSmsCode = (String)this.redis.boundValueOps((Object)(Constants.SMSCODE + email)).get();
        if (StringUtils.isEmpty((Object)userSmsCode)) {
            return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_NO_EXIST, (String)languageType);
        }
        if (!userSmsCode.equals(smsCode)) {
            return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_ERROR, (String)languageType);
        }
        return null;
    }

    @GetMapping(value={"/password"})
    @ApiOperation(value="\u5bc6\u7801\u9a8c\u8bc1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="password", value="\u5bc6\u7801", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel createProclamation(@LanguageType String languageType, @CurrentUser User user, String password) {
        String encryptPassword = PasswordEncoder.encrypt((String)password, (String)"ym2018");
        if (!user.getPassword().equals(encryptPassword)) {
            return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
        }
        return ResultModel.ok((String)languageType);
    }

    @GetMapping(value={"/{companyId}/things"})
    @ApiOperation(value="\u6211\u7684\u4e8b\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<List<Map>> queryThings(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long companyId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        List mapList = this.userService.queryThings(user, companyId);
        return ResultModel.suc((Object)mapList, (String)languageType);
    }

    @GetMapping(value={"/application"})
    @ApiOperation(value="\u6211\u7684\u5de5\u4f5c\u53f0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<List<Dictionary>> myApps(@LanguageType String languageType, @CurrentUser User user) {
        List applicationType = this.dictionaryService.findByApplicationTypeAndDelFlagFalse("application_type");
        return ResultModel.suc((Object)applicationType, (String)languageType);
    }

    @PutMapping(value={"/guide/{guideStatus}"})
    @ApiOperation(value="\u65b0\u624b\u5f15\u5bfc")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="guideStatus", value="\u65b0\u624b\u5f15\u5bfc\u72b6\u6001(\u9ed8\u8ba40\uff1a\u5426  1\uff1a\u5df2\u7ecf\u9605\u8bfb)", required=true, dataType="String", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<User> guide(@LanguageType String languageType, @CurrentUser User user, @PathVariable String guideStatus) {
        if (StringUtils.isEmpty((Object)guideStatus)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (user.getNoviceGuide().equals("0")) {
            user.setNoviceGuide(guideStatus);
            this.userService.save(user);
        }
        return ResultModel.ok((String)languageType);
    }
}

