/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.task.TaskCardSortModel;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskPanelRelationService;
import com.ym.tlifang.service.task.TaskPanelService;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.task.TaskPanel;
import com.ym.tlifang.task.TaskPanelRelation;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskPanels"})
@Api(value="taskPanels", description="\u4efb\u52a1\u9762\u677f")
public class TaskPanelControlller
extends BaseController {
    @Reference
    private TaskPanelService taskPanelService;
    @Reference
    private TaskPanelRelationService taskPanelRelationService;
    @Reference
    private TaskConcernService taskConcernService;

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskPanel> createTaskPanel(@LanguageType String languageType, @RequestBody TaskPanel taskPanel) {
        if (StringUtils.isEmpty((Object)taskPanel.getProjectId()) || StringUtils.isEmpty((Object)taskPanel.getLabelName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Long maxSort = Long.valueOf(StringUtils.isNullToZero((Object)this.taskPanelService.findMaxSortByProjectId(taskPanel.getProjectId())));
        taskPanel.setSort(Long.valueOf(maxSort + 1L));
        taskPanel = this.taskPanelService.save(taskPanel);
        return ResultModel.suc((Object)taskPanel, (String)languageType);
    }

    @PutMapping(value={"/{panelId}"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="labelName", value="\u9762\u677f\u540d\u79f0", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskPanel> updateTaskPanel(@LanguageType String languageType, @PathVariable Long panelId, String labelName) {
        TaskPanel oldTaskPanel = this.taskPanelService.findByPanelId(panelId);
        if (StringUtils.isEmpty((Object)oldTaskPanel)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)labelName)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        oldTaskPanel.setLabelName(labelName);
        oldTaskPanel = this.taskPanelService.save(oldTaskPanel);
        return ResultModel.suc((Object)oldTaskPanel, (String)languageType);
    }

    @PutMapping(value={"/sort/{projectId}"})
    @ApiOperation(value="\u4efb\u52a1\u9762\u677f\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="sortPanelIds", value="\u9762\u677fids\u6570\u7ec4", required=true, dataType="string", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskPanel> updateTaskPanelSort(@LanguageType String languageType, @PathVariable Long projectId, @RequestBody List<Long> sortPanelIds) {
        return this.taskPanelService.updatePanelSort(sortPanelIds, projectId);
    }

    @DeleteMapping(value={"/{panelId}"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u9762\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteTaskPanel(@LanguageType String languageType, @PathVariable Long panelId) {
        TaskPanel taskPanel = this.taskPanelService.findByPanelId(panelId);
        if (StringUtils.isEmpty((Object)taskPanel)) {
            return ResultModel.error((ResultStatus)ResultStatus.TASKPANEL_NO_EXIST, (String)languageType);
        }
        if (StringUtils.isNotBlank((String)taskPanel.getType()) && "1".equals(taskPanel.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.TASPANEL_NO_DELETE, (String)languageType);
        }
        taskPanel.setDelFlag(Boolean.valueOf(true));
        this.taskPanelService.save(taskPanel);
        List taskPanelRelationList = this.taskPanelRelationService.findListByPanelId(taskPanel.getId(), null);
        for (TaskPanelRelation taskPanelRelation : taskPanelRelationList) {
            taskPanelRelation.setDelFlag(Boolean.valueOf(true));
            this.taskPanelRelationService.save(taskPanelRelation);
        }
        return ResultModel.ok((String)languageType);
    }

    @PutMapping(value={"/taskSort"})
    @ApiOperation(value="\u9879\u76ee\u4efb\u52a1\u5361\u7247\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskCardSortModel> updateTaskPanelRelationSort(@LanguageType String languageType, @RequestBody TaskCardSortModel taskCardSortModel) {
        String[] afterMoveTaskIds;
        if (taskCardSortModel == null || StringUtils.isEmpty((Object)taskCardSortModel.getMoveTaskId()) || StringUtils.isEmpty((Object)taskCardSortModel.getAfterMovePanelId()) || StringUtils.isEmpty((Object)taskCardSortModel.getAfterMoveTaskIds())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        TaskPanelRelation taskPanelRelation = this.taskPanelRelationService.findByTaskId(taskCardSortModel.getMoveTaskId(), Boolean.valueOf(false));
        if (taskPanelRelation == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_NO_EXIST, (String)languageType);
        }
        if (!taskPanelRelation.getPanelId().equals(taskCardSortModel.getAfterMovePanelId())) {
            taskPanelRelation.setDelFlag(Boolean.valueOf(true));
            this.taskPanelRelationService.save(taskPanelRelation);
            TaskPanelRelation bean = this.taskPanelRelationService.findByPanelAndTaskId(taskCardSortModel.getAfterMovePanelId(), taskCardSortModel.getMoveTaskId(), Boolean.valueOf(true));
            if (bean == null) {
                bean = new TaskPanelRelation();
                bean.setTaskId(taskCardSortModel.getMoveTaskId());
                bean.setPanelId(taskCardSortModel.getAfterMovePanelId());
            }
            bean.setDelFlag(Boolean.valueOf(false));
            this.taskPanelRelationService.save(bean);
        }
        Long i = 1L;
        for (String taskId : afterMoveTaskIds = taskCardSortModel.getAfterMoveTaskIds()) {
            TaskPanelRelation bean = this.taskPanelRelationService.findByPanelAndTaskId(taskCardSortModel.getAfterMovePanelId(), Long.valueOf(taskId), Boolean.valueOf(false));
            if (bean == null) {
                return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_NO_EXIST, (String)languageType);
            }
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            bean.setSort(l);
            this.taskPanelRelationService.save(bean);
        }
        return ResultModel.ok((String)languageType);
    }

    @PutMapping(value={"/workbenchTaskSort"})
    @ApiOperation(value="\u6211\u7684\u5de5\u4f5c\u53f0\u4efb\u52a1\u5361\u7247\u6392\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<TaskCardSortModel> updateWorkbenchTaskPanelRelationSort(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody TaskCardSortModel taskCardSortModel) {
        String[] afterMoveTaskIds;
        if (taskCardSortModel == null || StringUtils.isEmpty((Object)taskCardSortModel.getMoveTaskId()) || StringUtils.isEmpty((Object)taskCardSortModel.getAfterMovePanelId()) || StringUtils.isEmpty((Object)taskCardSortModel.getAfterMoveTaskIds())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(taskCardSortModel.getMoveTaskId(), currentUser.getId());
        if (taskConcern == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_NO_EXIST, (String)languageType);
        }
        if (!taskConcern.getTaskStatus().equals(taskCardSortModel.getAfterMovePanelId())) {
            taskConcern.setDelFlag(Boolean.valueOf(true));
            this.taskConcernService.save(taskConcern);
            TaskConcern bean = this.taskConcernService.findByTaskIdAndUserIdAndTaskStatus(taskCardSortModel.getMoveTaskId(), currentUser.getId(), taskCardSortModel.getAfterMovePanelId().toString(), Boolean.valueOf(true));
            if (bean == null) {
                bean = new TaskConcern();
                bean.setTaskId(taskCardSortModel.getMoveTaskId());
                bean.setUserId(currentUser.getId());
                bean.setTaskStatus(taskCardSortModel.getAfterMovePanelId().toString());
                bean.setStatus(taskConcern.getStatus());
            }
            bean.setDelFlag(Boolean.valueOf(false));
            this.taskConcernService.save(bean);
        }
        Long i = 1L;
        for (String taskId : afterMoveTaskIds = taskCardSortModel.getAfterMoveTaskIds()) {
            TaskConcern bean = this.taskConcernService.findByTaskIdAndUserIdAndTaskStatus(Long.valueOf(taskId), currentUser.getId(), taskCardSortModel.getAfterMovePanelId().toString(), Boolean.valueOf(false));
            if (bean == null) {
                return ResultModel.error((ResultStatus)ResultStatus.TASK_LABEL_RELATION_NO_EXIST, (String)languageType);
            }
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
            bean.setSort(l);
            this.taskConcernService.save(bean);
        }
        return ResultModel.ok((String)languageType);
    }
}

