/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.task;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.task.TaskAddAndDelConcernsModel;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taskConcerns"})
@Api(value="taskConcerns", description="\u4efb\u52a1\u5173\u6ce8")
public class TaskConcernController
extends BaseController {
    @Reference
    private TaskConcernService taskConcernService;
    @Reference
    private TaskService taskService;
    @Reference
    private UserService userService;
    @Reference
    private NoticeService noticeService;
    @Reference
    private XgPushService xgPushService;

    @RequestMapping(method={RequestMethod.POST}, value={"/{taskId}/member/{userId}"})
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel addTaskConcerns(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long taskId, @PathVariable Long userId) {
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)userId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskId);
        if (task == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        User user = this.userService.findOne(userId);
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(taskId, userId);
        if (taskConcern == null) {
            taskConcern = new TaskConcern();
            taskConcern.setTaskId(taskId);
            taskConcern.setUserId(userId);
        }
        taskConcern.setStatus("1");
        this.taskConcernService.save(taskConcern);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskId", taskId);
        map.put("action", "\u6dfb\u52a0\u5173\u6ce8\u8005");
        map.put("msg", Constants.NoticeContent.pointConcern.getName());
        map.put("msgEn", Constants.NoticeContent.pointConcern.getNameEnglish());
        try {
            this.noticeService.saveSendNotice(user.getId(), Constants.NoticeParentType.task, Constants.NoticeType.taskConcern, Constants.Originator.member, task.getCreatorId(), map, "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.task.getName(), currentUser.getName() + Constants.ContentNotify.taskParticipation.getName() + task.getTitle() + "\u7684\u4efb\u52a1\u53c2\u4e0e\u8005", null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
            this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.task.getEnglishName(), currentUser.getName() + Constants.ContentNotify.taskParticipationDel.getEnglishName() + task.getTitle(), Constants.SHOWFLAG);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{taskId}/member/{userId}"})
    @ApiOperation(value="\u79fb\u9664\u4efb\u52a1\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteTaskConcerns(@CurrentUser User currentUser, @LanguageType String languageType, @PathVariable Long taskId, @PathVariable Long userId) {
        if (StringUtils.isEmpty((Object)taskId) || StringUtils.isEmpty((Object)userId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskId);
        if (task == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        User user = this.userService.findOne(userId);
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(taskId, userId);
        if (taskConcern == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASKCONCERN_NO_EXIST, (String)languageType);
        }
        taskConcern.setStatus("0");
        this.taskConcernService.save(taskConcern);
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.task.getName(), currentUser.getName() + Constants.ContentNotify.taskParticipationDel.getName() + task.getTitle() + "\u7684\u4efb\u52a1\u53c2\u4e0e\u8005", null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)user) && StringUtils.isNotBlank((String)user.getPushToken())) {
            this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.task.getEnglishName(), currentUser.getName() + Constants.ContentNotify.taskParticipationDel.getEnglishName() + task.getTitle(), Constants.SHOWFLAG);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/appMember"})
    @ApiOperation(value="(app\u4f7f\u7528)\u6dfb\u52a0/\u79fb\u9664\u4efb\u52a1\u5173\u6ce8\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel addDelTaskConcerns(@LanguageType String languageType, @CurrentUser User user, @RequestBody TaskAddAndDelConcernsModel taskConcernsModel) {
        if (StringUtils.isEmpty((Object)taskConcernsModel.getTaskId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Task task = this.taskService.findByTaskId(taskConcernsModel.getTaskId());
        if (task == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TASK_NO_EXIST, (String)languageType);
        }
        ResultModel resultModel = this.taskConcernService.addDelTaskConcern(user.getName(), task, taskConcernsModel, languageType);
        return resultModel;
    }
}

