/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.project;

import com.alibaba.dubbo.config.annotation.Service;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.project.ProjectUserDao;
import com.ym.tlifang.model.project.ProjectMemberAddDelModel;
import com.ym.tlifang.model.user.OwnerModle;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectServiceImpl;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskConcernService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.task.TaskConcern;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ProjectUserService.class, timeout=30000, retries=-1)
public class ProjectUserServiceImpl
extends AbstractBaseService<ProjectUser, ProjectUserDao>
implements ProjectUserService {
    Logger logger = LoggerFactory.getLogger(ProjectServiceImpl.class);
    @Autowired
    private ProjectService projectService;
    @Autowired
    private UserService userService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();
    @Autowired
    private XgPushService xgPushService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskConcernService taskConcernService;

    public ProjectUser save(ProjectUser projectUser) {
        return (ProjectUser)((ProjectUserDao)this.dao).save((Object)projectUser);
    }

    public PageInfo<Project> findByUserIdAndCompanyId(Long userId, Long companyId, Integer pageNo, Integer pageSize, User user, String status, String projectName, String languageType) {
        ArrayList<Project> projects = new ArrayList<Project>();
        List projectUsers = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        String projectNames = "%" + projectName + "%";
        if (pageNo == 0) {
            projectUsers = StringUtils.isEmpty((Object)companyId) ? ((ProjectUserDao)this.dao).findByUserIdAndCompanyIdIsNull(userId) : ((ProjectUserDao)this.dao).findByUserIdAndCompanyId(userId, companyId);
            pageInfo = PageInfo.fromList(projectUsers);
        } else {
            PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
            pageInfo = StringUtils.isEmpty((Object)companyId) ? (StringUtils.isEmpty((Object)status) ? (StringUtils.isEmpty((Object)projectName) ? PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdIsNullAndDelFlagFalse(userId, (Pageable)pageable)) : PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdIsNullAndProjectNameLikeAndDelFlagFalse(userId, projectNames, (Pageable)pageable))) : (StringUtils.isEmpty((Object)projectName) ? PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdIsNullAndStatusAndDelFlagFalse(userId, status, (Pageable)pageable)) : PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdIsNullAndStatusAndProjectNameLikeAndDelFlagFalse(userId, status, projectNames, (Pageable)pageable)))) : (StringUtils.isEmpty((Object)status) ? (StringUtils.isEmpty((Object)projectName) ? PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdAndDelFlagFalse(userId, companyId, (Pageable)pageable)) : PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdAndProjectNameLikeAndDelFlagFalse(userId, companyId, projectNames, (Pageable)pageable))) : (StringUtils.isEmpty((Object)projectName) ? PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdAndStatusAndDelFlagFalse(userId, companyId, status, (Pageable)pageable)) : PageInfo.fromPage((Page)((ProjectUserDao)this.dao).findByUserIdAndCompanyIdAndStatusAndProjectNameLikeAndDelFlagFalse(userId, companyId, status, projectNames, (Pageable)pageable))));
        }
        projectUsers = pageInfo.getRows();
        for (ProjectUser projectUser : projectUsers) {
            projects.add(projectUser.getProject());
        }
        List projectList = this.projectService.projectList(user, projects, companyId, languageType);
        pageInfo = pageInfo.setRows(projectList);
        return pageInfo;
    }

    public ProjectUser findByCompanyIdAndUserIdAndProjectId(Long companyId, Long userId, Long projectId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectUserDao)this.dao).findByCompanyIdIsNullAndUserIdAndProjectIdAndDelFlagFalse(userId, projectId);
        }
        return ((ProjectUserDao)this.dao).findByCompanyIdAndUserIdAndProjectIdAndDelFlagFalse(companyId, userId, projectId);
    }

    public ProjectUser findByUserIdAndProjectIdAndDelFlagFalse(Long userId, Long projectId, String languageType) {
        return ((ProjectUserDao)this.dao).findByUserIdAndProjectIdAndDelFlagFalse(userId, projectId);
    }

    public Boolean findByUserIdAndProjectId(Long userId, Long projectId) {
        return ((ProjectUserDao)this.dao).findByUserIdAndProjectId(userId, projectId) != null;
    }

    public Project findByCompanyIdAndProjectId(Long companyId, Long projectId, Project project) {
        if (StringUtils.isEmpty((Object)companyId)) {
            List projectUserList = ((ProjectUserDao)this.dao).findByCompanyIdIsNullAndProjectIdAndDelFlagFalse(projectId);
            project = this.ownerModleInfo(projectUserList, project);
            return project;
        }
        List projectUserList = ((ProjectUserDao)this.dao).findByCompanyIdAndProjectIdAndDelFlagFalse(companyId, projectId);
        project = this.ownerModleInfo(projectUserList, project);
        return project;
    }

    public List<ProjectUser> findListByCompanyIdAndProjectId(Long companyId, Long projectId) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ((ProjectUserDao)this.dao).findByCompanyIdIsNullAndProjectIdAndDelFlagFalse(projectId);
        }
        return ((ProjectUserDao)this.dao).findByCompanyIdAndProjectIdAndDelFlagFalse(companyId, projectId);
    }

    private Project ownerModleInfo(List<ProjectUser> projectUserList, Project project) {
        ArrayList<User> Members = new ArrayList<User>();
        for (ProjectUser projectUser : projectUserList) {
            projectUser.getUser().setManager(projectUser.getType());
            Members.add(projectUser.getUser());
            if (projectUser.getType().equals(Constants.TypeStatus.projectOwner.getType())) {
                User user = this.userService.findById(projectUser.getUserId());
                OwnerModle ownerModle = new OwnerModle(user.getId(), user.getName(), user.getAvatar(), projectUser.getType());
                project.setOwnerModle(ownerModle);
            }
            project.setMembers(Members);
        }
        return project;
    }

    public ResultModel<ProjectUser> updateAsteriskProject(User user, ProjectUser projectUser) {
        if (projectUser.getStatus().equals(Constants.AsteriskStatus.noAsterisk.getType())) {
            projectUser.setStatus(Constants.AsteriskStatus.asterisk.getType());
            this.save(projectUser);
            return ResultModel.suc((Object)projectUser);
        }
        projectUser.setStatus(Constants.AsteriskStatus.noAsterisk.getType());
        this.save(projectUser);
        return ResultModel.suc((Object)projectUser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultModel<Project> updateAddAndDelProjectMember(User user, ProjectMemberAddDelModel projectMemberAddDelModel, Project project, String languageType) {
        if (projectMemberAddDelModel.getAddUserIds() != null) {
            ProjectUser projectUser = this.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), project.getId(), languageType);
            if (projectUser == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
            }
            if (projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
                return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
            }
            for (Long addUserId : projectMemberAddDelModel.getAddUserIds()) {
                ProjectUser projectOwner;
                projectUser = this.findByCompanyIdAndUserIdAndProjectId(projectMemberAddDelModel.getCompanyId(), addUserId, project.getId());
                if (projectUser != null) {
                    return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_REOEAT_EXIST, (String)languageType);
                }
                projectUser = new ProjectUser(addUserId, projectMemberAddDelModel.getCompanyId(), project.getId(), Constants.TypeStatus.projectOrdinaryMember.getType(), Constants.AsteriskStatus.noAsterisk.getType());
                this.save(projectUser);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("projectId", project.getId());
                map.put("action", "\u6dfb\u52a0\u6210\u5458");
                map.put("msg", user.getName() + Constants.NoticeContent.addYouToProject.getName() + project.getName());
                map.put("msgEn", user.getName() + Constants.NoticeContent.addYouToProject.getNameEnglish() + project.getName());
                try {
                    this.noticeService.saveSendNotice(addUserId, Constants.NoticeParentType.project, Constants.NoticeType.projectSetInfo, Constants.Originator.member, user.getId(), map, "2");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                User userTwo = this.userService.findById(addUserId);
                HashMap mapTwo = new HashMap();
                mapTwo.put("projectId", project.getId());
                mapTwo.put("action", "\u6210\u5458\u52a0\u5165");
                mapTwo.put("msg", userTwo.getName() + Constants.NoticeContent.addProject.getName() + project.getName());
                mapTwo.put("msgEn", userTwo.getName() + Constants.NoticeContent.addProject.getNameEnglish() + project.getName());
                try {
                    this.noticeService.saveSendNotice(project.getOwnerId(), Constants.NoticeParentType.project, Constants.NoticeType.personAttend, Constants.Originator.member, userTwo.getId(), (Map)mapTwo, "2");
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                if ("0".equals("0")) {
                    if (!StringUtils.isEmpty((Object)userTwo) && StringUtils.isNotBlank((String)userTwo.getPushToken())) {
                        this.xgPushService.pushTokenIosOrAndroidBelievers(userTwo.getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.projectInvitation.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                    }
                    if (StringUtils.isEmpty((Object)(projectOwner = ((ProjectUserDao)this.dao).findByProjectIdAndTypeAndDelFlagFalse(project.getId(), Constants.TypeStatus.projectOwner.getType()))) || !StringUtils.isNotBlank((String)userTwo.getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(projectOwner.getUser().getPushToken(), Constants.TitleNotify.project.getName(), userTwo.getName() + Constants.ContentNotify.joinProject.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                    continue;
                }
                if (!StringUtils.isEmpty((Object)userTwo) && StringUtils.isNotBlank((String)userTwo.getPushToken())) {
                    this.xgPushService.pushTokenForeign(userTwo.getPushToken(), Constants.TitleNotify.project.getEnglishName(), user.getName() + Constants.ContentNotify.projectInvitation.getEnglishName() + project.getName(), Constants.SHOWFLAG);
                }
                if (StringUtils.isEmpty((Object)(projectOwner = ((ProjectUserDao)this.dao).findByProjectIdAndTypeAndDelFlagFalse(project.getId(), Constants.TypeStatus.projectOwner.getType()))) || !StringUtils.isNotBlank((String)userTwo.getPushToken())) continue;
                this.xgPushService.pushTokenForeign(projectOwner.getUser().getPushToken(), Constants.TitleNotify.project.getEnglishName(), userTwo.getName() + Constants.ContentNotify.joinProject.getEnglishName() + project.getName(), Constants.SHOWFLAG);
            }
        }
        if (projectMemberAddDelModel.getDelUserIds() == null) return ResultModel.ok();
        ProjectUser projectOwner = this.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), project.getId(), languageType);
        if (projectOwner == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectOwner.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
        }
        for (Long delUserId : projectMemberAddDelModel.getDelUserIds()) {
            ProjectUser projectOwners;
            List tasks;
            ProjectUser projectUser = this.findByCompanyIdAndUserIdAndProjectId(projectMemberAddDelModel.getCompanyId(), delUserId, project.getId());
            if (projectUser == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
            }
            List taskList = this.taskService.findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(projectMemberAddDelModel.getCompanyId(), delUserId, "0");
            if (!StringUtils.isEmpty((Object)taskList)) {
                for (Object task : taskList) {
                    task.setAssigneeId(null);
                    this.taskService.save((Task)task);
                }
            }
            if (!StringUtils.isEmpty((Object)(tasks = this.taskService.findByCompanyIdAndStatusAndDelFlagFalse(projectMemberAddDelModel.getCompanyId(), "0")))) {
                Object task;
                task = tasks.iterator();
                while (task.hasNext()) {
                    Task task2 = (Task)task.next();
                    TaskConcern taskConcern = this.taskConcernService.findByTaskIdAndUserId(task2.getId(), delUserId);
                    if (StringUtils.isEmpty((Object)taskConcern)) continue;
                    taskConcern.setStatus("0");
                    this.taskConcernService.save(taskConcern);
                }
            }
            if (projectOwner.getType().equals(Constants.TypeStatus.projectManager.getType())) {
                if (!projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.save(projectUser);
                this.delUserS(delUserId, project, user);
            } else {
                if (!projectOwner.getType().equals(Constants.TypeStatus.projectOwner.getType())) return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
                if (projectUser.getType().equals(Constants.TypeStatus.projectOwner.getType())) return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.save(projectUser);
                this.delUserS(delUserId, project, user);
            }
            if ("0".equals("0")) {
                if (!StringUtils.isEmpty((Object)projectUser.getUser()) && StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.shiftOutProject.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                }
                if (StringUtils.isEmpty((Object)(projectOwners = ((ProjectUserDao)this.dao).findByProjectIdAndTypeAndDelFlagFalse(project.getId(), Constants.TypeStatus.projectOwner.getType()))) || StringUtils.isEmpty((Object)projectOwners.getUser()) || !StringUtils.isNotBlank((String)projectOwners.getUser().getPushToken())) continue;
                this.xgPushService.pushTokenIosOrAndroidBelievers(projectOwners.getUser().getPushToken(), Constants.TitleNotify.project.getName(), projectUser.getUser().getName() + Constants.ContentNotify.exitProject.getName() + project.getName(), null, Constants.IntentType.systemNotice.getType());
                continue;
            }
            if (!StringUtils.isEmpty((Object)projectUser.getUser()) && StringUtils.isNotBlank((String)projectUser.getUser().getPushToken())) {
                this.xgPushService.pushTokenForeign(projectUser.getUser().getPushToken(), Constants.TitleNotify.project.getName(), user.getName() + Constants.ContentNotify.shiftOutProject.getName() + project.getName(), Constants.SHOWFLAG);
            }
            if (StringUtils.isEmpty((Object)(projectOwners = ((ProjectUserDao)this.dao).findByProjectIdAndTypeAndDelFlagFalse(project.getId(), Constants.TypeStatus.projectOwner.getType()))) || StringUtils.isEmpty((Object)projectOwners.getUser()) || !StringUtils.isNotBlank((String)projectOwners.getUser().getPushToken())) continue;
            this.xgPushService.pushTokenForeign(projectOwners.getUser().getPushToken(), Constants.TitleNotify.project.getEnglishName(), projectUser.getUser().getName() + Constants.ContentNotify.exitProject.getEnglishName() + project.getName(), Constants.SHOWFLAG);
        }
        return ResultModel.ok();
    }

    public void deleteProjectUser(ProjectUser projectUser) {
        if (Constants.TypeStatus.projectOwner.getType().equals(projectUser.getType())) {
            Project project = this.projectService.findByProjectId(projectUser.getProjectId());
            ProjectUser projectUserOne = this.findFirstByProjectIdAndTypeNotAndDelFlagFalseOrderByTypeAsc(projectUser.getProjectId(), "1");
            if (projectUserOne != null) {
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.save(projectUser);
                project.setOwnerId(projectUserOne.getUserId());
                project.setUpdateDate(new Date());
                this.projectService.save(project);
                projectUserOne.setType("1");
                projectUserOne.setUpdateDate(new Date());
                this.save(projectUserOne);
            } else {
                project.setDelFlag(Boolean.valueOf(true));
                this.projectService.save(project);
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.save(projectUser);
            }
        } else {
            projectUser.setDelFlag(Boolean.valueOf(true));
            this.save(projectUser);
            HashMap<String, Object> mapTwo = new HashMap<String, Object>();
            mapTwo.put("projectId", projectUser.getProjectId());
            mapTwo.put("action", "\u6210\u5458\u9000\u51fa");
            mapTwo.put("msg", projectUser.getUser().getName() + Constants.NoticeContent.exitProject.getName() + projectUser.getProject().getName());
            mapTwo.put("msgEn", projectUser.getUser().getName() + Constants.NoticeContent.exitProject.getNameEnglish() + projectUser.getProject().getName());
            try {
                this.noticeService.saveSendNotice(projectUser.getProject().getOwnerId(), Constants.NoticeParentType.project, Constants.NoticeType.PersonExit, Constants.Originator.member, projectUser.getUser().getId(), mapTwo, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            ProjectUser projectOwners = ((ProjectUserDao)this.dao).findByProjectIdAndTypeAndDelFlagFalse(projectUser.getProjectId(), Constants.TypeStatus.projectOwner.getType());
            if (!StringUtils.isEmpty((Object)projectOwners) && !StringUtils.isEmpty((Object)projectOwners.getUser()) && StringUtils.isNotBlank((String)projectOwners.getUser().getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(projectOwners.getUser().getPushToken(), Constants.TitleNotify.project.getName(), projectUser.getUser().getName() + Constants.ContentNotify.exitProject.getName() + projectOwners.getProject().getName(), null, Constants.IntentType.systemNotice.getType());
            }
        }
    }

    public void delUserS(Long delUserId, Project project, User user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", project.getId());
        map.put("action", "\u5220\u9664\u6210\u5458");
        map.put("msg", user.getName() + Constants.NoticeContent.removeProject.getName() + project.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.removeProject.getNameEnglish() + project.getName());
        try {
            this.noticeService.saveSendNotice(delUserId, Constants.NoticeParentType.project, Constants.NoticeType.getProjectDelInfo, Constants.Originator.member, user.getId(), map, "2");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        User userTwo = this.userService.findById(delUserId);
        HashMap<String, Object> mapTwo = new HashMap<String, Object>();
        mapTwo.put("projectId", project.getId());
        mapTwo.put("action", "\u6210\u5458\u9000\u51fa");
        mapTwo.put("msg", userTwo.getName() + Constants.NoticeContent.exitProject.getName() + project.getName());
        map.put("msgEn", userTwo.getName() + Constants.NoticeContent.exitProject.getNameEnglish() + project.getName());
        try {
            this.noticeService.saveSendNotice(project.getOwnerId(), Constants.NoticeParentType.project, Constants.NoticeType.PersonExit, Constants.Originator.member, userTwo.getId(), mapTwo, "2");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    public ResultModel<ProjectUser> updateProjectManager(User user, ProjectUser projectUser) {
        if (projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
            projectUser.setType(Constants.TypeStatus.projectManager.getType());
            this.save(projectUser);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("projectId", projectUser.getProjectId());
            map.put("action", "\u8bbe\u4e3a\u7ba1\u7406\u5458");
            map.put("msg", user.getName() + Constants.NoticeContent.setProject.getName() + projectUser.getProject().getName() + Constants.NoticeContent.manager.getName());
            map.put("msgEn", user.getName() + Constants.NoticeContent.setProject.getNameEnglish() + Constants.NoticeContent.manager.getNameEnglish() + projectUser.getProject().getName());
            try {
                this.noticeService.saveSendNotice(projectUser.getUserId(), Constants.NoticeParentType.project, Constants.NoticeType.projectSetManager, Constants.Originator.member, user.getId(), map, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            return ResultModel.suc((Object)projectUser);
        }
        projectUser.setType(Constants.TypeStatus.projectOrdinaryMember.getType());
        this.save(projectUser);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", projectUser.getProjectId());
        map.put("action", "\u53d6\u6d88\u7ba1\u7406\u5458");
        map.put("msg", user.getName() + Constants.NoticeContent.setProject.getName() + projectUser.getProject().getName() + Constants.NoticeContent.member.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.setProject.getNameEnglish() + Constants.NoticeContent.member.getNameEnglish() + projectUser.getProject().getName());
        try {
            this.noticeService.saveSendNotice(projectUser.getUserId(), Constants.NoticeParentType.project, Constants.NoticeType.projectDelManager, Constants.Originator.member, user.getId(), map, "2");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return ResultModel.suc((Object)projectUser);
    }

    public List<ProjectUser> findByCompanyIdAndDelFlagFalse(Long companyId) {
        return ((ProjectUserDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public List<ProjectUser> findByUserIdAndCompanyIdAndDelFlagFalse(Long userId, Long companyId) {
        return ((ProjectUserDao)this.dao).findByUserIdAndCompanyIdAndDelFlagFalse(userId, companyId);
    }

    public List<ProjectUser> findByProjectIdAndDelFlagFalse(Long projectId) {
        return ((ProjectUserDao)this.dao).findByProjectIdAndDelFlagFalse(projectId);
    }

    public ProjectUser findFirstByProjectIdAndTypeNotAndDelFlagFalseOrderByTypeAsc(Long projectId, String type) {
        return ((ProjectUserDao)this.dao).findFirstByProjectIdAndTypeNotAndDelFlagFalseOrderByTypeAsc(projectId, type);
    }
}

