/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.note;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.dao.note.NoteDao;
import com.ym.tlifang.model.note.NoteMemberModel;
import com.ym.tlifang.note.Note;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.note.NoteService;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=NoteService.class, timeout=30000, retries=-1)
public class NoteServiceImpl
extends AbstractBaseService<Note, NoteDao>
implements NoteService {
    public Note save(Note note) {
        return (Note)super.save((BaseEntity)note);
    }

    public Note findByIdAndDelFlagFalse(Long id) {
        return ((NoteDao)this.dao).findByIdAndDelFlagFalse(id);
    }

    public List<Note> findByNotebookIdAndDelFlagFalse(Long noteBookId) {
        return ((NoteDao)this.dao).findByNotebookIdAndDelFlagFalse(noteBookId);
    }

    public PageInfo<Note> findByNotebookIdAndUserIdAndDelFlagFalse(Long noteBookId, Long userId, Integer pageNo, Integer pageSize, String type) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        type = StringUtils.isEmpty((Object)type) ? "0" : type;
        PageInfo pageInfo = null;
        if (type.equals("0")) {
            pageInfo = StringUtils.isEmpty((Object)noteBookId) ? PageInfo.fromPage((Page)((NoteDao)this.dao).findByUserIdAndDelFlagFalseOrderByCreateDate(userId, (Pageable)pageable)) : PageInfo.fromPage((Page)((NoteDao)this.dao).findByNotebookIdAndUserIdAndDelFlagFalseOrderByCreateDate(noteBookId, userId, (Pageable)pageable));
        }
        if (type.equals("1")) {
            pageInfo = StringUtils.isEmpty((Object)noteBookId) ? PageInfo.fromPage((Page)((NoteDao)this.dao).findByUserIdAndDelFlagFalseOrderByUpdateDate(userId, (Pageable)pageable)) : PageInfo.fromPage((Page)((NoteDao)this.dao).findByNotebookIdAndUserIdAndDelFlagFalseOrderByUpdateDate(noteBookId, userId, (Pageable)pageable));
        }
        if (pageInfo != null) {
            List pageInfoRows = pageInfo.getRows();
            ArrayList<NoteMemberModel> pageInfoList = new ArrayList<NoteMemberModel>();
            for (Note noteMember : pageInfoRows) {
                NoteMemberModel noteMemberModel = new NoteMemberModel(noteMember.getId(), noteMember.getName(), noteMember.getNotebookId(), noteMember.getNoteBook().getName(), noteMember.getCreateDate(), noteMember.getUpdateDate());
                pageInfoList.add(noteMemberModel);
            }
            return pageInfo.setRows(pageInfoList);
        }
        return null;
    }
}

