/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.job;

import com.ym.tlifang.Constants;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.attendance.AttendanceHolidays;
import com.ym.tlifang.attendance.AttendanceReport;
import com.ym.tlifang.attendance.AttendanceReportUser;
import com.ym.tlifang.attendance.AttendanceUser;
import com.ym.tlifang.attendance.AttendanceWeekday;
import com.ym.tlifang.attendance.AttendanceWorkday;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.approval.ApprovalUserApplyFormService;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceHolidaysService;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.attendance.AttendanceReportService;
import com.ym.tlifang.service.attendance.AttendanceReportUserService;
import com.ym.tlifang.service.attendance.AttendanceUserRecordService;
import com.ym.tlifang.service.attendance.AttendanceUserService;
import com.ym.tlifang.service.attendance.AttendanceWeekdayService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ApprovalStatisticsJob {
    @Autowired
    private AttendanceClassesService attendanceClassesService;
    @Autowired
    private AttendanceReportService attendanceReportService;
    @Autowired
    private AttendanceUserService attendanceUserService;
    @Autowired
    private AttendanceReportUserService attendanceReportUserService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private AttendanceWorkdayService attendanceWorkdayService;
    @Autowired
    private AttendanceWeekdayService attendanceWeekdayService;
    @Autowired
    private AttendanceUserRecordService attendanceUserRecordService;
    @Autowired
    private ApprovalUserApplyFormService approvalUserApplyFormService;
    @Autowired
    private ApprovalTemplateService approvalTemplateService;
    @Autowired
    private AttendanceOutsideService attendanceOutsideService;
    @Autowired
    private AttendanceHolidaysService attendanceHolidaysService;

    @Scheduled(cron="0 30 0 * * ?")
    public void count() {
        String dateStr = "";
        String lastDayStr = DateUtils.getYearMonthStr((Date)DateUtils.addDateNum((Date)new Date(), (int)-1), (String)"day");
        try {
            List classes = this.attendanceClassesService.findByDelFlagFalse();
            for (AttendanceClasses attendanceClasses : classes) {
                List monthAnaDaytime;
                List attendanceUserList = this.attendanceUserService.findByClassesId(attendanceClasses.getId());
                AttendanceReport report = this.attendanceReportService.findMaxByCompanyIdAndClassesId(attendanceClasses.getCompanyId(), attendanceClasses.getId());
                if (report == null) {
                    monthAnaDaytime = DateUtils.monthAndDayTime((String)lastDayStr);
                    report = new AttendanceReport(attendanceClasses.getCompanyId(), attendanceClasses.getId(), (String)monthAnaDaytime.get(0), (Integer)monthAnaDaytime.get(1), lastDayStr);
                    dateStr = lastDayStr;
                } else {
                    dateStr = report.getRecordTime();
                    if (DateUtils.isLastDayOfMonth((Date)DateUtils.parseDate((Object)dateStr))) {
                        dateStr = DateUtils.getfowardDateStr((String)dateStr, (int)1, (String)"day");
                        monthAnaDaytime = DateUtils.monthAndDayTime((String)dateStr);
                        report = new AttendanceReport(attendanceClasses.getCompanyId(), attendanceClasses.getId(), (String)monthAnaDaytime.get(0), (Integer)monthAnaDaytime.get(1), lastDayStr);
                    } else {
                        dateStr = DateUtils.getfowardDateStr((String)dateStr, (int)1, (String)"day");
                    }
                    if (dateStr.compareTo(lastDayStr) > 0) continue;
                    report.setRecordTime(dateStr);
                }
                report = this.attendanceReportService.save(report);
                if (attendanceUserList.size() == 0 || !attendanceClasses.getStatus().booleanValue()) continue;
                String[] days = report.getRecordTime().split("-");
                Integer day = Integer.parseInt(days[2]);
                for (AttendanceUser attendanceUser : attendanceUserList) {
                    AttendanceReportUser attendanceReportUser = this.attendanceReportUserService.findByReportIdAndUserId(report.getCompanyId(), attendanceUser.getUserId(), report.getDate());
                    if (attendanceReportUser == null) {
                        attendanceReportUser = new AttendanceReportUser(null, attendanceUser.getUserId(), attendanceUser.getUser().getName(), report.getId(), "[]", "[]", "[]", "[]", "[]", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
                    }
                    List companyUserRelationList = this.companyUserRelationService.findByUserIdAndCompanyIdAndDelFlagFalse(attendanceUser.getUserId(), attendanceUser.getCompanyId());
                    StringBuffer stringBuffer = new StringBuffer();
                    for (CompanyUserRelation companyUserRelation : companyUserRelationList) {
                        if (companyUserRelation.getDepartmentId().equals(companyUserRelation.getCompanyId()) && companyUserRelationList.size() != 1) continue;
                        stringBuffer.append(companyUserRelation.getDepartment().getName() + "/");
                    }
                    if (stringBuffer.length() != 0) {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                    attendanceReportUser.setDepartName(stringBuffer.toString());
                    List restArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getRestArray(), List.class);
                    List laterArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getLaterArray(), List.class);
                    List earlyArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getEarlyArray(), List.class);
                    List approvalArray = (List)JsonUtil.jackson.readValue(attendanceReportUser.getApprovalArray(), List.class);
                    List failAttendance = (List)JsonUtil.jackson.readValue(attendanceReportUser.getFailAttendanceArray(), List.class);
                    AttendanceWeekday attendanceWeekday = this.attendanceWeekdayService.findWorkday(attendanceClasses.getId(), report.getRecordTime(), "2");
                    if (attendanceWeekday != null) {
                        attendanceReportUser.setAttendanceTimes(Integer.valueOf(attendanceReportUser.getAttendanceTimes() + 1));
                        List attendanceUserRecordList = this.attendanceUserRecordService.findByTrueAttendance(attendanceUser.getUserId(), attendanceUser.getCompanyId(), report.getRecordTime());
                        if (attendanceUserRecordList.size() == 0) {
                            List earlyLater = this.attendanceUserRecordService.updateEarlyLater(attendanceReportUser.getDepartName(), attendanceUser.getUserId(), attendanceUser.getCompanyId(), report.getRecordTime());
                            if (((Boolean)earlyLater.get(0)).booleanValue()) {
                                laterArray.add(day);
                            } else if (((Boolean)earlyLater.get(1)).booleanValue()) {
                                earlyArray.add(day);
                            } else {
                                failAttendance.add(day);
                            }
                        } else {
                            attendanceReportUser.setAttendanceSuccess(Integer.valueOf(attendanceReportUser.getAttendanceSuccess() + 1));
                        }
                    } else {
                        attendanceWeekday = this.attendanceWeekdayService.findWorkday(attendanceClasses.getId(), report.getRecordTime(), "1");
                        AttendanceHolidays attendanceHolidays = null;
                        if (attendanceClasses.getLegal().booleanValue()) {
                            attendanceHolidays = this.attendanceHolidaysService.findByDate(report.getRecordTime());
                        }
                        if (attendanceWeekday != null || attendanceHolidays != null) {
                            restArray.add(day);
                        } else {
                            AttendanceWorkday attendanceWorkday = this.attendanceWorkdayService.findByClassesId(attendanceClasses.getId(), DateUtils.parseDate((Object)report.getRecordTime()));
                            if (attendanceWorkday != null) {
                                attendanceReportUser.setAttendanceTimes(Integer.valueOf(attendanceReportUser.getAttendanceTimes() + 1));
                                List attendanceUserRecordList = this.attendanceUserRecordService.findByTrueAttendance(attendanceUser.getUserId(), attendanceUser.getCompanyId(), report.getRecordTime());
                                if (attendanceUserRecordList.size() != 0) {
                                    attendanceReportUser.setAttendanceSuccess(Integer.valueOf(attendanceReportUser.getAttendanceSuccess() + 1));
                                } else {
                                    List earlyLater = this.attendanceUserRecordService.updateEarlyLater(attendanceReportUser.getDepartName(), attendanceUser.getUserId(), attendanceUser.getCompanyId(), report.getRecordTime());
                                    if (((Boolean)earlyLater.get(0)).booleanValue()) {
                                        laterArray.add(day);
                                    } else if (((Boolean)earlyLater.get(1)).booleanValue()) {
                                        earlyArray.add(day);
                                    } else {
                                        failAttendance.add(day);
                                    }
                                }
                            } else {
                                restArray.add(day);
                            }
                        }
                    }
                    List earlyLaterList = this.attendanceUserRecordService.findAttendance(attendanceUser.getUserId(), attendanceUser.getCompanyId(), report.getRecordTime());
                    attendanceReportUser.setLaterNum(Integer.valueOf(attendanceReportUser.getLaterNum() + (Integer)earlyLaterList.get(1)));
                    attendanceReportUser.setEarlyNum(Integer.valueOf(attendanceReportUser.getEarlyNum() + (Integer)earlyLaterList.get(2)));
                    attendanceReportUser.setEarlyArray(JsonUtil.jackson.writeValueAsString((Object)earlyArray));
                    attendanceReportUser.setLaterArray(JsonUtil.jackson.writeValueAsString((Object)laterArray));
                    attendanceReportUser.setFailAttendanceArray(JsonUtil.jackson.writeValueAsString((Object)failAttendance));
                    attendanceReportUser.setRestArray(JsonUtil.jackson.writeValueAsString((Object)restArray));
                    attendanceReportUser.setReportId(report.getId());
                    attendanceReportUser.setOutsideTimes(this.attendanceOutsideService.personMonth(attendanceUser.getCompanyId(), attendanceUser.getUserId(), report.getDate()));
                    this.getApprovalCount(attendanceUser.getUserId(), attendanceClasses.getCompanyId(), dateStr, attendanceReportUser, report.getDayTimes());
                    this.attendanceReportUserService.save(attendanceReportUser);
                }
            }
            this.attendanceUserRecordService.saveDayCount(lastDayStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AttendanceReportUser getApprovalCount(Long userId, Long companyId, String dateStr, AttendanceReportUser attendanceReportUser, Integer dayNum) throws Exception {
        if (this.getOpenFlag(companyId, Constants.AttendanceCount.leave.getType())) {
            List leaveIds = this.approvalUserApplyFormService.getApplyIds(userId, companyId, Constants.AttendanceCount.leave.getType(), DateUtils.getMonthBegin((String)dateStr, (int)0), DateUtils.getMonthBegin((String)dateStr, (int)1));
            attendanceReportUser.setLeaveNum(this.getDuration(leaveIds));
            ArrayList<Integer> approvalArray = new ArrayList<Integer>();
            if (leaveIds != null && leaveIds.size() > 0) {
                for (Long leaveId : leaveIds) {
                    List dateList = this.approvalUserApplyFormService.findByApplyId(leaveId, Constants.TemplateFormType.datetime.getType());
                    if (dateList == null || dateList.size() != 2) continue;
                    DateUtils.getDay((String)((String)dateList.get(0)));
                    DateUtils.getDay((String)((String)dateList.get(1)));
                    for (int i = Integer.valueOf(DateUtils.getDay((String)((String)dateList.get(0)))).intValue(); i <= Integer.valueOf(DateUtils.getDay((String)((String)dateList.get(1)))); ++i) {
                        approvalArray.add(i);
                    }
                }
                Collections.sort(approvalArray);
                HashSet set = new HashSet(approvalArray);
                approvalArray.clear();
                approvalArray.addAll(set);
            }
            attendanceReportUser.setApprovalArray(JsonUtil.jackson.writeValueAsString(approvalArray));
        }
        if (this.getOpenFlag(companyId, Constants.AttendanceCount.retroactive.getType())) {
            List retroactiveIds = this.approvalUserApplyFormService.getApplyIds(userId, companyId, Constants.AttendanceCount.retroactive.getType(), DateUtils.getMonthBegin((String)dateStr, (int)0), DateUtils.getMonthBegin((String)dateStr, (int)1));
            attendanceReportUser.setRetroactiveNum(Integer.valueOf(retroactiveIds == null ? 0 : retroactiveIds.size()));
        }
        if (this.getOpenFlag(companyId, Constants.AttendanceCount.overtime.getType())) {
            List overtimeIds = this.approvalUserApplyFormService.getApplyIds(userId, companyId, Constants.AttendanceCount.overtime.getType(), DateUtils.getMonthBegin((String)dateStr, (int)0), DateUtils.getMonthBegin((String)dateStr, (int)1));
            attendanceReportUser.setAddWork(this.getDuration(overtimeIds));
        }
        return attendanceReportUser;
    }

    private Integer getDuration(List<Long> applyIds) {
        Integer count = 0;
        if (applyIds != null && applyIds.size() > 0) {
            count = this.approvalUserApplyFormService.countByApplyIds(applyIds);
        }
        return count;
    }

    private boolean getOpenFlag(Long companyId, String sign) {
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findByCompanyIdAndStateAndSign(companyId, "1", sign);
        return approvalTemplate != null;
    }
}

