/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.attendance.AttendanceOutside;
import com.ym.tlifang.dao.attendance.AttendanceOutsideDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceOutsideService.class, timeout=30000, retries=-1)
public class AttendanceOutsideServiceImpl
extends AbstractBaseService<AttendanceOutside, AttendanceOutsideDao>
implements AttendanceOutsideService {
    @Autowired
    private UserService userService;
    @Autowired
    private EnclosureService enclosureService;

    public AttendanceOutside save(AttendanceOutside attendanceOutside) {
        return (AttendanceOutside)super.save((BaseEntity)attendanceOutside);
    }

    public PageInfo<AttendanceOutside> findByCompanyId(Long companyId, String date, String name, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        if (StringUtils.isNotBlank((String)date) && StringUtils.isNotBlank((String)name)) {
            name = "%" + name + "%";
            date = "%" + date + "%";
            return PageInfo.fromPage((Page)((AttendanceOutsideDao)this.dao).findByCompanyIdAndDateLikeAndDepartArrayLikeOrderByCreateDateDesc(companyId, date, name, (Pageable)pageable));
        }
        if (StringUtils.isNotBlank((String)date)) {
            date = "%" + date + "%";
            return PageInfo.fromPage((Page)((AttendanceOutsideDao)this.dao).findByCompanyIdAndDateLikeOrderByCreateDateDesc(companyId, date, (Pageable)pageable));
        }
        if (StringUtils.isNotBlank((String)name)) {
            name = "%" + name + "%";
            return PageInfo.fromPage((Page)((AttendanceOutsideDao)this.dao).findByCompanyIdAndDepartArrayLikeOrderByCreateDateDesc(companyId, name, (Pageable)pageable));
        }
        return PageInfo.fromPage((Page)((AttendanceOutsideDao)this.dao).findByCompanyIdOrderByCreateDateDesc(companyId, (Pageable)pageable));
    }

    public Integer personMonth(Long companyId, Long userId, String date) {
        return ((AttendanceOutsideDao)this.dao).findByCompanyIdAndUserIdAndDateLike(companyId, userId, date + "%").size();
    }

    public PageInfo<AttendanceOutside> getOutsize(String type, String monthDate, Long companyId, Long userId, Integer pageNo, Integer pageSize) throws Exception {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        Page attendanceOutsidesPage = null;
        attendanceOutsidesPage = "0".equals(type) ? ((AttendanceOutsideDao)this.dao).findByCompanyIdAndUserIdAndDateLikeAndDateIsNotLikeOrderByCreateDateDesc(companyId, userId, monthDate + "%", DateUtils.getDate() + "%", (Pageable)pageable) : ((AttendanceOutsideDao)this.dao).findByCompanyIdAndDelFlagFalseOrderByCreateDateDesc(companyId, (Pageable)pageable);
        PageInfo pageInfo = PageInfo.fromPage((Page)attendanceOutsidesPage);
        List pageInfoRows = pageInfo.getRows();
        for (AttendanceOutside attendanceOutside : pageInfoRows) {
            Map map = (Map)JsonUtil.jackson.readValue(attendanceOutside.getPosition(), Map.class);
            ArrayList address = new ArrayList();
            attendanceOutside.setLatitude(map.get("latitude").toString());
            attendanceOutside.setLongitude(map.get("longitude").toString());
            attendanceOutside.setPositionAddress(map.get("address").toString());
            attendanceOutside.setPositionName(map.get("name").toString());
            List enclosureEntityList = this.enclosureService.findAppendix(attendanceOutside.getId(), "6");
            ArrayList<String> photos = new ArrayList<String>();
            for (EnclosureEntity enclosureEntity : enclosureEntityList) {
                photos.add(enclosureEntity.getUrl());
            }
            attendanceOutside.setPhotos(photos);
            User user = this.userService.findOne(attendanceOutside.getUserId());
            attendanceOutside.setUser(user);
        }
        pageInfo = pageInfo.setRows(pageInfoRows);
        return pageInfo;
    }

    public List<AttendanceOutside> findByCompanyIdAndDate(Long companyId, String date) {
        return ((AttendanceOutsideDao)this.dao).findByCompanyIdAndDateLike(companyId, date + "%");
    }

    public List<Map<String, Object>> findOutsideRecords(Long userId, Long companyId, String date) {
        return ((AttendanceOutsideDao)this.dao).findDateByUserIdAndCompanyIdAndDateLike(userId, companyId, date + "%");
    }

    public Integer findOutsideTime(Long companyId, String date) {
        return ((AttendanceOutsideDao)this.dao).findOutsideTime(companyId, date + "%");
    }

    public Integer countByCompanyIdAndUserIdAndDateLike(Long companyId, Long userId, String date) {
        return ((AttendanceOutsideDao)this.dao).countByCompanyIdAndUserIdAndDateLike(companyId, userId, date);
    }

    public AttendanceOutside findById(Long attendanceOutsideId) {
        return ((AttendanceOutsideDao)this.dao).findByIdAndDelFlagFalse(attendanceOutsideId);
    }

    public List<Object[]> findAllOutside(Long companyId, String date) {
        return ((AttendanceOutsideDao)this.dao).findAllOutside(companyId, date);
    }
}

