/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.proclamation;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.dao.proclamation.ProclamationRemindDao;
import com.ym.tlifang.model.proclamation.ProclamationModel;
import com.ym.tlifang.proclamation.Proclamation;
import com.ym.tlifang.proclamation.ProclamationRemind;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.proclamation.ProclamationRemindService;
import com.ym.tlifang.service.proclamation.ProclamationService;
import com.ym.tlifang.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=ProclamationRemindService.class, timeout=100000, retries=-1)
public class ProclamationRemindServiceImpl
extends AbstractBaseService<ProclamationRemind, ProclamationRemindDao>
implements ProclamationRemindService {
    @Autowired
    private ProclamationService proclamationService;

    public ProclamationRemind save(ProclamationRemind proclamationRemind) {
        return (ProclamationRemind)((ProclamationRemindDao)this.dao).save((Object)proclamationRemind);
    }

    public List<Long> findUserIdsByProclamationId(Long proclamationId) {
        return ((ProclamationRemindDao)this.dao).findUserIdsByProclamationId(proclamationId);
    }

    public List<ProclamationRemind> findByProclamationIdAndDelFlagFalse(Long proclamationId) {
        return ((ProclamationRemindDao)this.dao).findByProclamationIdAndDelFlagFalse(proclamationId);
    }

    public ProclamationRemind findByProclamationIdAndUserIdAndDelFlagFalse(Long proclamationId, Long userId) {
        return ((ProclamationRemindDao)this.dao).findByProclamationIdAndUserIdAndDelFlagFalse(proclamationId, userId);
    }

    public PageInfo<Proclamation> findByUserIdAndCompanyIdAndDelFlagFalse(Long userId, Long companyId, String status, String type, Integer pageNo, Integer pageSize) {
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        PageInfo pageInfo = StringUtils.isEmpty((Object)type) ? PageInfo.fromPage((Page)((ProclamationRemindDao)this.dao).findByUserIdAndCompanyIdAndStatusAndDelFlagFalse(userId, companyId, status, (Pageable)pageable)) : ("2".equals(type) ? PageInfo.fromPage((Page)((ProclamationRemindDao)this.dao).findByUserIdAndCompanyIdAndStatusAndTypeAllAndDelFlagFalse(userId, companyId, status, (Pageable)pageable)) : PageInfo.fromPage((Page)((ProclamationRemindDao)this.dao).findByUserIdAndCompanyIdAndStatusAndTypeAndDelFlagFalse(userId, companyId, status, type, (Pageable)pageable)));
        if (pageInfo != null) {
            List pageInfoRows = pageInfo.getRows();
            ArrayList<ProclamationModel> pageInfoList = new ArrayList<ProclamationModel>();
            for (Proclamation proclamation : pageInfoRows) {
                ProclamationRemind proclamationRemindUser = this.findByProclamationIdAndUserIdAndDelFlagFalse(proclamation.getId(), userId);
                ProclamationModel proclamationModel = new ProclamationModel(proclamation.getId(), proclamation.getName(), proclamation.getSnippet(), proclamation.getUser().getName(), proclamationRemindUser.getStatus(), proclamation.getCreateDate(), proclamation.getUpdateDate());
                pageInfoList.add(proclamationModel);
            }
            pageInfo = pageInfo.setRows(pageInfoList);
        }
        return pageInfo;
    }

    public Proclamation createProclamation(Proclamation proclamation, Long[] addUserIds) {
        proclamation = this.proclamationService.save(proclamation);
        if (!StringUtils.isEmpty((Object)addUserIds)) {
            for (Long userId : addUserIds) {
                ProclamationRemind proclamationRemind = new ProclamationRemind(userId, "0", proclamation.getId());
                this.save(proclamationRemind);
            }
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (Long userId : addUserIds) {
            userIds.add(userId);
        }
        try {
            this.proclamationService.addProclamationNotice(proclamation, userIds);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return proclamation;
    }

    public int countByProclamations(Long userId, Long companyId) {
        return ((ProclamationRemindDao)this.dao).countByProclamations(userId, companyId);
    }
}

