/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.attendance.AttendanceWifi;
import com.ym.tlifang.dao.attendance.AttendanceWifiDao;
import com.ym.tlifang.model.attendance.WifiDetailModel;
import com.ym.tlifang.model.attendance.WifiModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceWifiService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceWifiService.class, timeout=30000, retries=-1)
public class AttendanceWifiServiceImpl
extends AbstractBaseService<AttendanceWifi, AttendanceWifiDao>
implements AttendanceWifiService {
    @Autowired
    private CompanyMemberInfoService companyMemberInfoService;

    public ResultModel saveWifi(WifiModel wifiModel, String languageType) {
        List wifiDetailModels = wifiModel.getWifiDetailModelList();
        Integer wifiNum = ((AttendanceWifiDao)this.dao).countByCompanyIdAndDelFlagFalse(wifiModel.getCompanyId());
        if (wifiNum + wifiDetailModels.size() > 50) {
            return ResultModel.error((ResultStatus)ResultStatus.WIFI_THROUGH, (String)languageType);
        }
        for (WifiDetailModel wifiDetailModel : wifiDetailModels) {
            AttendanceWifi attendanceWifi = ((AttendanceWifiDao)this.dao).findByCompanyIdAndAndMacAndDelFlagFalse(wifiModel.getCompanyId(), wifiDetailModel.getMac());
            if (attendanceWifi != null) continue;
            attendanceWifi = new AttendanceWifi(wifiModel.getCompanyId(), wifiDetailModel.getName(), wifiDetailModel.getMac());
            super.save((BaseEntity)attendanceWifi);
        }
        return ResultModel.ok((String)languageType);
    }

    public ResultModel deleteWifi(Long id, Long userId, String languageType) {
        AttendanceWifi attendanceWifi = ((AttendanceWifiDao)this.dao).findByIdAndDelFlagFalse(id);
        if (attendanceWifi != null) {
            Boolean bl = this.companyMemberInfoService.havePower(attendanceWifi.getCompanyId(), userId);
            if (bl.booleanValue()) {
                return ResultModel.error((ResultStatus)ResultStatus.WIFI_NO_EXIST, (String)languageType);
            }
            attendanceWifi.setDelFlag(Boolean.valueOf(true));
            super.save((BaseEntity)attendanceWifi);
        }
        return ResultModel.ok((String)languageType);
    }

    public ResultModel<List<AttendanceWifi>> findAllWifi(Long companyId, String languageType) {
        return ResultModel.suc((Object)((AttendanceWifiDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId), (String)languageType);
    }

    public List<AttendanceWifi> findSomeWifi(List<Integer> ids) {
        ArrayList<AttendanceWifi> attendanceWifiList = new ArrayList<AttendanceWifi>();
        for (Integer id : ids) {
            AttendanceWifi attendanceWifi = ((AttendanceWifiDao)this.dao).findByIdAndDelFlagFalse(Long.valueOf(id.longValue()));
            if (attendanceWifi == null) continue;
            attendanceWifiList.add(attendanceWifi);
        }
        return attendanceWifiList;
    }
}

