/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.redis;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtil.class);
    private static final long MAXLONG = 0x20000000000000L;
    private static final long LOCK_EXPIRE = 30L;
    private static final String LOCK_PREFIX = "LOCK:";
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public void saveItem(String redisKey, String redisValue) {
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)redisValue);
    }

    public void saveItem(String redisKey, String redisValue, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)redisValue, timeout, unit);
    }

    public String getItem(String redisKey) {
        return (String)this.redisTemplate.opsForValue().get((Object)redisKey);
    }

    public Set<String> keySets(String keyPattern) {
        return this.redisTemplate.keys((Object)keyPattern);
    }

    public void deleteItem(String hashKey, long rangeKey) {
        String redisKey = this.getRedisKey(hashKey, rangeKey);
        this.redisTemplate.delete((Object)redisKey);
        logger.info("remove redis key:[" + redisKey + "]");
    }

    public void deleteItem(String redisKey) {
        this.redisTemplate.delete((Object)redisKey);
        logger.debug("remove redis key:[" + redisKey + "]");
    }

    public String removeItem(String redisKey) {
        logger.debug("remove redis key:[" + redisKey + "]");
        String str = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        if (null != str) {
            this.redisTemplate.delete((Object)redisKey);
        }
        return str;
    }

    public void deleteItemWithHashKey(String hashKey) {
        this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)(hashKey + ":*")));
        logger.info("remove redis key with hashKey:[" + hashKey + "]");
    }

    public void deleteItemWithStartKey(String startKey) {
        this.redisTemplate.delete((Collection)this.redisTemplate.keys((Object)(startKey + "*")));
        logger.info("remove redis key with hashKey:[" + startKey + "]");
    }

    public void expireItem(String redisKey, long timeout, TimeUnit unit) {
        this.redisTemplate.expire((Object)redisKey, timeout, unit);
    }

    public void zAdd(String key, String member, double score) {
        this.redisTemplate.opsForZSet().add((Object)key, (Object)member, score);
    }

    public void zRemove(String key, String ... member) {
        this.redisTemplate.opsForZSet().remove((Object)key, (Object[])member);
    }

    public Long zRank(String key, String member) {
        return this.redisTemplate.opsForZSet().rank((Object)key, (Object)member);
    }

    public Set<String> zRangeByIdx(String key, long sinceIdx, long maxSize, boolean scanIndexForward) {
        if (scanIndexForward) {
            return this.redisTemplate.opsForZSet().range((Object)key, sinceIdx, sinceIdx + maxSize - 1L);
        }
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, sinceIdx, sinceIdx + maxSize - 1L);
    }

    public Set<String> zRangeByScoreAndIdx(String key, long sinceIdx, long count, boolean scanIndexForward, long min, long max) {
        if (scanIndexForward) {
            return this.redisTemplate.opsForZSet().rangeByScore((Object)key, (double)min, (double)max, sinceIdx, count);
        }
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, (double)min, (double)max, sinceIdx, count);
    }

    public Set<String> zRangeByScore(String key, long sinceId, int maxSize, boolean scanIndexForward) {
        int step = this.getStep(sinceId);
        if (scanIndexForward) {
            return this.redisTemplate.opsForZSet().rangeByScore((Object)key, (double)(sinceId + (long)step), 9.223372036854776E18, 0L, (long)maxSize);
        }
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, 0.0, sinceId > 1L ? (double)(sinceId - (long)step) : 9.223372036854776E18, 0L, (long)maxSize);
    }

    public Cursor<ZSetOperations.TypedTuple<String>> zScan(String key, ScanOptions scanOptions) {
        return this.redisTemplate.opsForZSet().scan((Object)key, scanOptions);
    }

    public void close(Cursor<ZSetOperations.TypedTuple<String>> cursor) {
        try {
            cursor.close();
        }
        catch (IOException e) {
            logger.error("\u5173\u95edcursor\u5931\u8d25", (Throwable)e);
        }
    }

    public long zSize(String key) {
        return this.redisTemplate.opsForZSet().size((Object)key);
    }

    public boolean hasKey(String hashKey, long rangeKey) {
        return this.redisTemplate.hasKey((Object)this.getRedisKey(hashKey, rangeKey));
    }

    public boolean hasKey(String redisKey) {
        return this.redisTemplate.hasKey((Object)redisKey);
    }

    public long incr(String redisKey, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)redisKey, delta);
    }

    private String getRedisKey(String hashKey, long rangeKey) {
        return hashKey + ":" + rangeKey;
    }

    private int getStep(long id) {
        if (Math.abs(id) <= 0x20000000000000L) {
            return 1;
        }
        int step = 1;
        while (Math.abs(id) > 0x20000000000000L * (long)step) {
            step *= 10;
        }
        return step;
    }

    public boolean lock(String key, long timeout, long expire) {
        long begin = 0L;
        do {
            if (this.tryLock(key, expire)) {
                return true;
            }
            begin += 3L;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                logger.error("\u83b7\u53d6\u9501\u51fa\u9519", (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
        } while (begin <= timeout);
        return false;
    }

    public boolean tryLock(String key, long expire) {
        logger.info("try get lock for:" + key);
        key = LOCK_PREFIX + key;
        RedisConnection redisConnection = this.redisTemplate.getConnectionFactory().getConnection();
        if (redisConnection.setNX(key.getBytes(), key.getBytes()).booleanValue()) {
            this.redisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
            redisConnection.close();
            return true;
        }
        redisConnection.close();
        return false;
    }

    public boolean lock(String key, long timeout) {
        return this.lock(key, timeout, 30L);
    }

    public boolean tryLock(String key) {
        return this.tryLock(key, 30L);
    }

    public void unLock(String key) {
        key = LOCK_PREFIX + key;
        this.redisTemplate.delete((Object)key);
    }

    public void publish(String channel, String message) {
        this.redisTemplate.convertAndSend(channel, (Object)message);
    }

    public List<String> range(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public long listSize(String key) {
        Long size = this.redisTemplate.opsForList().size((Object)key);
        if (size == null) {
            return 0L;
        }
        return size;
    }

    public void leftPush(String key, String value) {
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)value);
    }

    public void rightPush(String key, String value) {
        this.redisTemplate.opsForList().rightPush((Object)key, (Object)value);
    }

    public String rightPop(String key) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public String rightPop(String key, long timeout, TimeUnit unit) {
        return (String)this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }

    public String rightPopAndLeftPush(String sourceKey, String destinationKey) {
        return (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    public String rightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        return (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
    }

    public void saveHashKey(String key, String hash, String value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hash, (Object)value);
    }

    public void saveHashKey4Null(String key, String hash, String value) {
        if (null == key || null == hash || null == value) {
            return;
        }
        this.redisTemplate.opsForHash().put((Object)key, (Object)hash, (Object)value);
    }

    public void delHashKey(String key, String ... hash) {
        this.redisTemplate.opsForHash().delete((Object)key, (Object[])hash);
    }

    public String getHashKey(String key, String hash) {
        Object o = this.redisTemplate.opsForHash().get((Object)key, (Object)hash);
        if (null != o) {
            return o.toString();
        }
        return null;
    }

    public long zCount(String key, long min, long max) {
        return this.redisTemplate.opsForZSet().count((Object)key, (double)min, (double)max);
    }
}

