/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.project;

import com.alibaba.dubbo.config.annotation.Reference;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.model.project.ProjectColorAvatarModel;
import com.ym.tlifang.model.project.ProjectListModel;
import com.ym.tlifang.model.project.ProjectTaskStatisticsModel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.DictionaryService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"project"})
@Api(value="project", description="\u9879\u76ee\u76f8\u5173")
public class ProjectController
extends BaseController {
    @Reference(timeout=6000)
    private ProjectService projectService;
    @Reference(timeout=6000)
    private ProjectUserService projectUserService;
    @Reference
    private UserService userService;
    @Reference
    private TaskService taskService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private NoticeService noticeService;
    @Reference
    private DictionaryService dictionaryService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> createProject(@CurrentUser User user, @RequestBody Project project, @LanguageType String languageType) {
        CompanyMemberInfo companyMemberInfo;
        if (StringUtils.isEmpty((Object)project.getName()) || StringUtils.isEmpty((Object)project.getAdduser())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (project.getCompanyId() != null && (companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(project.getCompanyId(), user.getId(), Constants.AuditStatus.adopt.getType())) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        ResultModel projects = this.projectService.createProject(project, user, languageType);
        project = this.projectService.findByProjectId(((Project)projects.getData()).getId());
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u9879\u76ee\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id(\u6709\u5219\u4f20)", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801(\u6709\u5219\u4f20)", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf(\u6709\u5219\u4f20)", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001(\u6709\u5219\u4f200\uff1a\u8fdb\u884c\u4e2d\uff0c1\uff1a\u5b8c\u6210)", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="projectName", value="\u9879\u76ee\u540d(\u6709\u5219\u4f20)", required=false, dataType="String", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<Project>> listProject(@CurrentUser User user, Long companyId, Integer pageNo, Integer pageSize, String status, String projectName, @LanguageType String languageType) {
        PageInfo projectPageInfo = this.projectUserService.findByUserIdAndCompanyId(user.getId(), companyId, pageNo, pageSize, user, status, projectName, languageType);
        List rows = projectPageInfo.getRows();
        ArrayList<Project> projectList = new ArrayList<Project>();
        for (Project project : rows) {
            project.setName(emojiConverter.toUnicode(project.getName()));
            project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
            projectList.add(project);
        }
        projectPageInfo = projectPageInfo.setRows(projectList);
        return ResultModel.suc((Object)projectPageInfo);
    }

    @PutMapping(value={"/{projectId}"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> alterProject(@CurrentUser User user, @PathVariable Long projectId, @RequestBody Project project, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), projectId, languageType);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_OWNER_NO_EXIST, (String)languageType);
        }
        Project projectOwner = this.projectService.findByProjectId(projectId);
        if (projectOwner == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_EXIST, (String)languageType);
        }
        ResultModel projectResultModel = this.projectService.updateProject(user, projectOwner, project, languageType);
        project = (Project)projectResultModel.getData();
        project = this.projectService.findByProjectId(project.getId());
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @PutMapping(value={"/{projectId}/user/{userId}"})
    @ApiOperation(value="\u79fb\u4ea4\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u79fb\u4ea4\u8005id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="password", value="\u7528\u6237\u5bc6\u7801", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> transferProject(@CurrentUser User user, @PathVariable Long projectId, @PathVariable Long userId, String password, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId) || StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)password)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByOwnerIdAndId(user.getId(), projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_EXIST, (String)languageType);
        }
        if (user.getId().equals(userId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_OWNER, (String)languageType);
        }
        ProjectUser projectOwnerUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), projectId, languageType);
        if (projectOwnerUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(userId, projectId, languageType);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        String encryptPassword = PasswordEncoder.encrypt((String)password, (String)"ym2018");
        if (!user.getPassword().equals(encryptPassword)) {
            return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
        }
        ResultModel projectResultModel = this.projectService.updateHandProject(user, projectOwnerUser, project, userId, languageType);
        project = (Project)projectResultModel.getData();
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @PutMapping(value={"/{projectId}/del"})
    @ApiOperation(value="\u5220\u9664\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="password", value="\u7528\u6237\u5bc6\u7801", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> delProject(@CurrentUser User user, @PathVariable Long projectId, String password, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId) || StringUtils.isEmpty((Object)password)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByOwnerIdAndId(user.getId(), projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_EXIST, (String)languageType);
        }
        ProjectUser projectOwnerUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), projectId, languageType);
        if (projectOwnerUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        String encryptPassword = PasswordEncoder.encrypt((String)password, (String)"ym2018");
        if (!user.getPassword().equals(encryptPassword)) {
            return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
        }
        ResultModel resultModel = this.projectService.delProject(projectId, languageType);
        return resultModel;
    }

    @PutMapping(value={"/{projectId}/asterisk"})
    @ApiOperation(value="\u661f\u6807\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id(\u6709\u5219\u4f20)", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> asteriskProject(@CurrentUser User user, @PathVariable Long projectId, Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByCompanyIdAndUserIdAndProjectId(companyId, user.getId(), projectId);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        ResultModel projectUserResultModel = this.projectUserService.updateAsteriskProject(user, projectUser);
        projectUser = (ProjectUser)projectUserResultModel.getData();
        Project project = this.projectService.findByProjectId(projectUser.getProjectId());
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @PutMapping(value={"/{projectId}/logo"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u5934\u50cf\u3001\u989c\u8272")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> updateProject(@CurrentUser User user, @PathVariable Long projectId, @RequestBody ProjectColorAvatarModel projectColorAvatarModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Project project = this.projectService.findByCompanyIdAndProjectId(projectColorAvatarModel.getCompanyId(), projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        ProjectUser projectUser = this.projectUserService.findByCompanyIdAndUserIdAndProjectId(projectColorAvatarModel.getCompanyId(), user.getId(), projectId);
        if (projectUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        if (projectUser.getType().equals(Constants.TypeStatus.projectOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTINFO_NO_LIMITS, (String)languageType);
        }
        ResultModel projectResultModel = this.projectService.updateLogoAndColorProject(user, projectColorAvatarModel, project);
        project = (Project)projectResultModel.getData();
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @GetMapping(value={"/{projectId}/info"})
    @ApiOperation(value="\u9879\u76ee\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Project> projectDetail(@CurrentUser User user, @PathVariable Long projectId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.suc((Object)ResultStatus.PARAM_ERROR);
        }
        ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(user.getId(), projectId, languageType);
        if (StringUtils.isEmpty((Object)projectUser)) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECTMEMBER_NO_EXIST, (String)languageType);
        }
        Project project = this.projectService.findByProjectId(projectId);
        if (project == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        project.setName(emojiConverter.toUnicode(project.getName()));
        project.setDescription(emojiConverter.toUnicode(StringUtils.isEmpty((Object)project.getDescription()) ? "" : project.getDescription()));
        project = (Project)this.projectService.projectInfo(user, project, project.getCompanyId(), languageType).getData();
        return ResultModel.suc((Object)project);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{companyId}/list"})
    @ApiOperation(value="\u6210\u5458\u5b58\u5728\u7684\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="user(\u53ef\u4e0d\u4f20)", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<ProjectListModel> memberQuit(@CurrentUser User user, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        List projectList = this.projectService.findListByCompanyIdAndOwnerId(companyId, user.getId());
        ArrayList<ProjectListModel> projectListModelList = new ArrayList<ProjectListModel>();
        if (!StringUtils.isEmpty((Object)projectList)) {
            for (Project project : projectList) {
                ProjectListModel projectListModel = new ProjectListModel(project.getId(), project.getName());
                projectListModelList.add(projectListModel);
            }
            return ResultModel.suc(projectListModelList);
        }
        return ResultModel.ok();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{projectId}"})
    @ApiOperation(value="\u5220\u9664\u9879\u76ee")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeID", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Boolean> deleteProject(@PathVariable Long projectId, @LanguageType String languageType) {
        Project project = this.projectService.findByProjectId(projectId);
        if (StringUtils.isEmpty((Object)project)) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        project.setDelFlag(Boolean.valueOf(true));
        project.setUpdateDate(new Date());
        this.projectService.save(project);
        return ResultModel.ok();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/statistics/{projectId}"})
    @ApiOperation(value="\u9879\u76ee\u4efb\u52a1\u7edf\u8ba1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="projectId", value="\u9879\u76eeid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ProjectTaskStatisticsModel> ProjectTaskStatisticsModel(@PathVariable Long projectId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)projectId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        ResultModel taskStatistics = this.taskService.findByTaskStatistics(projectId);
        return taskStatistics;
    }
}

