/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.company;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyPosition;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.model.company.PositionAddDel;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyPositionService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"company"})
@Api(value="company", description="\u56e2\u961f\u76f8\u5173")
public class CompanyPositionController
extends BaseController {
    @Reference
    private CompanyPositionService companyPositionService;
    @Reference
    private CompanyService companyService;
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;

    @RequestMapping(method={RequestMethod.POST}, value={"/{companyId}/position"})
    @ApiOperation(value="\u804c\u4f4d\u6dfb\u52a0/\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<CompanyPosition> positionAdd(@CurrentUser User user, @RequestBody PositionAddDel positionAddDel, @PathVariable Long companyId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        ResultModel companyPositionResultModel = this.companyPositionService.updatePosition(positionAddDel, companyId, languageType);
        return companyPositionResultModel;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{companyId}/department/{departmentId}/position/{positionId}/member/{userId}"})
    @ApiOperation(value="\u804c\u4f4d\u8bbe\u5b9a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="departmentId", value="\u90e8\u95e8id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="positionId", value="\u804c\u4f4did", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel<CompanyUserRelation> positionSetting(@CurrentUser User user, @PathVariable Long companyId, @PathVariable Long departmentId, @PathVariable Long userId, @PathVariable Long positionId, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)companyId) || StringUtils.isEmpty((Object)departmentId) || StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)positionId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, user.getId(), Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        if (companyMemberInfo.getManager().equals(Constants.ManagerStatus.companyOrdinaryMember.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_MAMNAGER, (String)languageType);
        }
        CompanyMemberInfo companyMemberInfoSetting = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, userId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfoSetting == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(userId, companyId, departmentId);
        if (companyUserRelation == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        CompanyPosition companyPosition = this.companyPositionService.findByCompanyIdAndDepartmentIdAndId(companyId, departmentId, positionId);
        if (companyPosition == null) {
            return ResultModel.error((ResultStatus)ResultStatus.POSITION_NO_EXIST, (String)languageType);
        }
        ResultModel companyPositionResultModel = this.companyPositionService.updatePositionSetting(companyUserRelation, companyPosition);
        return companyPositionResultModel;
    }
}

