/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.authorization.interceptor;

import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AuthorizationInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private StringRedisTemplate redis;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        String platform = request.getHeader("platform");
        String authorization = request.getHeader("Authorization");
        try {
            String userId = JwtUtil.checkTokenRtnUserId((String)authorization);
            String tokenKey = "token_" + (StringUtils.isEmpty((Object)platform) ? "1" : platform) + "_" + userId;
            String validToken = (String)this.redis.boundValueOps((Object)tokenKey).get();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)validToken)) {
                response.setStatus(401);
                return false;
            }
            String thatToken = authorization.replace("Bearer ", "");
            if (!thatToken.equals(validToken)) {
                response.setStatus(401);
                return false;
            }
            request.setAttribute("CURRENT_USER_ID", (Object)userId);
            return true;
        }
        catch (Exception exception) {
            if (method.getAnnotation(Authorization.class) != null) {
                response.setStatus(401);
                return false;
            }
            return true;
        }
    }
}

