/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.user;

import com.alibaba.dubbo.config.annotation.Service;
import com.wecloud.im.sdk.WecloudIm;
import com.wecloud.im.sdk.model.Token;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.user.UserDao;
import com.ym.tlifang.model.user.LoginModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalUserApplyService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.meeting.MeetingMemberService;
import com.ym.tlifang.service.proclamation.ProclamationRemindService;
import com.ym.tlifang.service.user.LoginRecordService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.service.workreport.WorkReportService;
import com.ym.tlifang.user.LoginRecord;
import com.ym.tlifang.user.TokenModel;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.PasswordEncoder;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.wechat.ThirdUser;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=UserService.class, timeout=1000000, retries=-1)
public class UserServiceImpl
extends AbstractBaseService<User, UserDao>
implements UserService {
    @Autowired
    private MeetingMemberService meetingMemberService;
    @Autowired
    private WorkReportService workReportService;
    @Autowired
    private ApprovalUserApplyService approvalUserApplyService;
    @Autowired
    private ProclamationRemindService proclamationRemindService;
    @Autowired
    private LoginRecordService loginRecordService;
    @Autowired
    private StringRedisTemplate redis;
    @Autowired
    private CompanyMemberInfoService companyMemberInfoService;
    @Autowired
    private WecloudIm wecloudIm;

    public User findByMobile(String mobile) {
        return ((UserDao)this.dao).findByMobile(mobile);
    }

    public User save(User entity) {
        User user = (User)((UserDao)this.dao).save((Object)entity);
        return user;
    }

    public User findByEmailOrMobile(String account, String areaCode) {
        return ((UserDao)this.dao).findByEmailOrMobileAndAreaCode(account, account, areaCode);
    }

    public User findById(Long userId) {
        return ((UserDao)this.dao).findById(userId);
    }

    public User findOne(Long userId) {
        return (User)((UserDao)this.dao).findOne((Serializable)userId);
    }

    public User findByMongodbId(String mongodbId) {
        return ((UserDao)this.dao).findByMongodbId(mongodbId);
    }

    public List<Map> queryThings(User user, Long companyId) {
        ArrayList<Map> mapList = new ArrayList<Map>();
        int meetingCount = this.meetingMemberService.getMyNotEndMeetingCount(companyId, user.getId());
        HashMap<String, Object> meetingMap = new HashMap<String, Object>(2);
        meetingMap.put("type", "meeting");
        meetingMap.put("count", meetingCount);
        mapList.add(meetingMap);
        int workReportCount = this.workReportService.countByCompanyIdAndReceiveIdAndSendOutTrueAndLookedFalseAndDelFlagFalse(companyId, user.getId());
        HashMap<String, Object> workReportMap = new HashMap<String, Object>(2);
        workReportMap.put("type", "workReport");
        workReportMap.put("count", workReportCount);
        mapList.add(workReportMap);
        int approvalCount = this.approvalUserApplyService.findApprovalByParamsCount(user.getId(), companyId, Constants.ApplyStatus.applyDoing.getType(), Constants.ApplyStatus.applyTurnBatch.getType());
        HashMap<String, Object> approvalMap = new HashMap<String, Object>(2);
        approvalMap.put("type", "approval");
        approvalMap.put("count", approvalCount);
        mapList.add(approvalMap);
        int proclamationCount = this.proclamationRemindService.countByProclamations(user.getId(), companyId);
        HashMap<String, Object> proclamationMap = new HashMap<String, Object>(2);
        proclamationMap.put("type", "proclamation");
        proclamationMap.put("count", proclamationCount);
        mapList.add(proclamationMap);
        return mapList;
    }

    public ResultModel loginUser(LoginModel user, ThirdUser thirdUser, String platform, String loginIp, String pushToken, String languageType) throws IOException {
        User preUser;
        if (user.getAreaCode() == null) {
            user.setAreaCode(Constants.CHINAAREACODE);
        }
        if ((preUser = this.findByEmailOrMobile(user.getAccount(), user.getAreaCode())) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        if (user != null && thirdUser == null) {
            String encryptPassword = PasswordEncoder.encrypt((String)user.getPassword(), (String)"ym2018");
            if (!preUser.getPassword().equals(encryptPassword)) {
                return ResultModel.error((ResultStatus)ResultStatus.PASSWORD_ERROR, (String)languageType);
            }
            if (!preUser.getAreaCode().equals(user.getAreaCode())) {
                return ResultModel.error((ResultStatus)ResultStatus.ARED_CODE, (String)languageType);
            }
        }
        preUser.setLastLoginIp(loginIp);
        preUser.setLoginCount(Long.valueOf(preUser.getLoginCount() + 1L));
        preUser.setPushToken(StringUtils.isNullStr((Object)user.getPushToken()));
        this.save(preUser);
        LoginRecord loginRecord = new LoginRecord(preUser.getId(), preUser.getLastLoginIp(), new Date(), "\u4e2d\u56fd/\u798f\u5efa/\u53a6\u95e8/XX/\u7535\u4fe1/", StringUtils.isEmpty((Object)platform) ? null : Integer.valueOf(Integer.parseInt(platform)));
        this.loginRecordService.save(loginRecord);
        HashMap<String, Object> claims = new HashMap<String, Object>(10);
        claims.put("userId", preUser.getId());
        String token = JwtUtil.getToken(claims, (long)-1702967296L, (String)(preUser.getId() + ""));
        this.redis.boundValueOps((Object)token).set((Object)preUser.getId().toString(), 720L, TimeUnit.HOURS);
        this.redis.boundValueOps((Object)("user_" + preUser.getId())).set((Object)JsonUtil.jackson.writeValueAsString((Object)preUser), 720L, TimeUnit.HOURS);
        claims.put("type", Constants.TokenType.refreshToken.getType());
        String refreshToken = JwtUtil.getToken(claims, (long)-406967296L, (String)(preUser.getId() + ""));
        TokenModel model = new TokenModel(preUser.getId().longValue(), token, refreshToken);
        if (!StringUtils.isEmpty((Object)preUser.getCurrentCompany())) {
            String manager = this.companyMemberInfoService.findManagerByCompanyIdAndUserIdAndStatus(preUser.getCurrentCompany(), preUser.getId(), Constants.AuditStatus.adopt.getType());
            if (StringUtils.isEmpty((Object)manager)) {
                return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
            }
            preUser.setManager(manager);
        }
        model.setUser(preUser);
        model.setThirdUser(thirdUser);
        Token wecloudToken = this.wecloudIm.getToken(preUser.getId() + "", StringUtils.isEmpty((Object)platform) ? null : Integer.valueOf(Integer.parseInt(platform)));
        model.setImToken(wecloudToken.getToken());
        return ResultModel.suc((Object)model, (String)languageType);
    }

    public Boolean registerUserToWecloud(User user) {
        this.wecloudIm.registerUser(String.valueOf(user.getId()), user.getAvatar(), user.getName());
        return true;
    }

    public Boolean syncUserToWecloud(User user) {
        this.wecloudIm.modifyUser(user.getId() + "", user.getName(), user.getAvatar());
        return true;
    }

    public ResultModel checkSmsCode(String smsCode, Integer type, String mobile, String languageType) {
        if (!"666666".equals(smsCode)) {
            String userSmsCode = (String)this.redis.boundValueOps((Object)(Constants.SMSCODE + mobile + "_" + type)).get();
            if (StringUtils.isEmpty((Object)userSmsCode)) {
                return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_NO_EXIST, (String)languageType);
            }
            if (!userSmsCode.equals(smsCode)) {
                return ResultModel.error((ResultStatus)ResultStatus.SMSCODE_ERROR, (String)languageType);
            }
        }
        return null;
    }
}

