/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.system;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.agenda.Agenda;
import com.ym.tlifang.approval.ApprovalUserApply;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.dao.system.NoticeDao;
import com.ym.tlifang.meeting.MeetingEntity;
import com.ym.tlifang.netty.MsgBody;
import com.ym.tlifang.proclamation.Proclamation;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.agenda.AgendaService;
import com.ym.tlifang.service.approval.ApprovalUserApplyService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.meeting.MeetingService;
import com.ym.tlifang.service.proclamation.ProclamationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.service.workreport.WorkReportService;
import com.ym.tlifang.system.Notice;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.workreport.WorkReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=NoticeService.class, timeout=100000, retries=-1)
public class NoticeServiceImpl
extends AbstractBaseService<Notice, NoticeDao>
implements NoticeService {
    Logger logger = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private WorkReportService workReportService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private MeetingService meetingService;
    @Autowired
    private AgendaService agendaService;
    @Autowired
    private UserService userService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProclamationService proclamationService;
    @Autowired
    private ApprovalUserApplyService approvalUserApplyService;

    public Notice saveSendNotice(Long userId, Constants.NoticeParentType noticeParentType, Constants.NoticeType subType, Constants.Originator originator, Long originatorId, Map content, String important) {
        Notice notice = null;
        Company company = null;
        try {
            notice = new Notice(userId, noticeParentType.getType(), subType.getType(), originator.getType(), originatorId, JsonUtil.jackson.writeValueAsString((Object)content), important);
            if (notice.getParentTypeId().equals(Constants.NoticeParentType.project.getType())) {
                Project project = this.projectService.findByProjectId((Long)content.get("projectId"));
                company = this.companyService.findById(project.getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.task.getType())) {
                Task task = this.taskService.findByTaskId((Long)content.get("taskId"));
                company = this.companyService.findById(task.getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.approval.getType())) {
                ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId((Long)content.get("approvalUserApplyId"));
                company = this.companyService.findById(approvalUserApply.getApprovalTemplate().getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.proclamation.getType())) {
                Proclamation proclamation = this.proclamationService.findByIdAndDelFlagFalse((Long)content.get("proclamationId"));
                company = this.companyService.findById(proclamation.getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.company.getType()) || notice.getParentTypeId().equals(Constants.NoticeParentType.attendance.getType())) {
                company = this.companyService.findById((Long)content.get("companyId"));
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.agenda.getType())) {
                Agenda agenda = this.agendaService.findById((Long)content.get("agendaId"));
                company = this.companyService.findById(agenda.getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.workReport.getType())) {
                WorkReport workReport = this.workReportService.findByIdAndDelFlagFalse((Long)content.get("workReportId"));
                company = this.companyService.findById(workReport.getCompanyId());
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.meeting.getType())) {
                MeetingEntity meetingEntity = this.meetingService.findByMeetingId((Long)content.get("meetingId"));
                company = this.companyService.findById(meetingEntity.getCompanyId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((NoticeDao)this.dao).save(notice);
        Company companyTwo = new Company();
        if (company != null) {
            companyTwo.setId(company.getId());
            companyTwo.setName(company.getName());
            companyTwo.setLogo(company.getLogo());
        }
        notice.setCompanyTwo(companyTwo);
        MsgBody msgBody = new MsgBody();
        msgBody.setUserId(userId);
        msgBody.setData((Object)notice);
        try {
            String json = JsonUtil.jackson.writeValueAsString((Object)msgBody);
            this.stringRedisTemplate.convertAndSend("tlf_notice", (Object)json);
            return notice;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            return notice;
        }
    }

    public PageInfo<Notice> getNotice(Long userId, Integer pageNo, Integer pageSize, String type, String languageType) throws Exception {
        List companyList;
        Map contentMap;
        pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : pageNo;
        PageRequest pageable = new PageRequest(pageNo - 1, StringUtils.isEmpty((Object)pageSize) ? 10 : pageSize);
        Page noticePage = null;
        String msg = "%";
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            msg = "%msgEn%";
        }
        if (StringUtils.isEmpty((Object)type)) {
            type = "0";
        }
        if ("0".equals(type)) {
            noticePage = ((NoticeDao)this.dao).findByUserIdAndContentLikeAndDelFlagFalseOrderByCreateDateDesc(userId, msg, (Pageable)pageable);
        } else if ("1".equals(type)) {
            noticePage = ((NoticeDao)this.dao).findByUserIdAndLookedAndContentLikeAndDelFlagFalseOrderByCreateDateDesc(userId, Boolean.valueOf(false), msg, (Pageable)pageable);
        } else if ("2".equals(type)) {
            noticePage = ((NoticeDao)this.dao).findByUserIdAndLookedAndContentLikeAndDelFlagFalseOrderByCreateDateDesc(userId, Boolean.valueOf(true), msg, (Pageable)pageable);
        }
        PageInfo pageInfo = PageInfo.fromPage((Page)noticePage);
        List pageInfoRows = pageInfo.getRows();
        ArrayList<Long> companyIds = new ArrayList<Long>();
        HashMap<Long, Company> companyMap = new HashMap<Long, Company>();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        HashMap<Long, Project> projectMap = new HashMap<Long, Project>();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        HashMap<Long, Task> taskMap = new HashMap<Long, Task>();
        ArrayList<Long> reportIds = new ArrayList<Long>();
        HashMap<Long, WorkReport> reportMap = new HashMap<Long, WorkReport>();
        for (Object notice : pageInfoRows) {
            contentMap = (Map)JsonUtil.jackson.readValue(notice.getContent(), Map.class);
            if (notice.getParentTypeId().equals(Constants.NoticeParentType.company.getType()) || notice.getParentTypeId().equals(Constants.NoticeParentType.attendance.getType())) {
                companyIds.add(Long.valueOf(contentMap.get("companyId").toString()));
                continue;
            }
            if (notice.getParentTypeId().equals(Constants.NoticeParentType.project.getType())) {
                projectIds.add(Long.valueOf(contentMap.get("projectId").toString()));
                continue;
            }
            if (notice.getParentTypeId().equals(Constants.NoticeParentType.task.getType())) {
                taskIds.add(Long.valueOf(contentMap.get("taskId").toString()));
                continue;
            }
            if (!notice.getParentTypeId().equals(Constants.NoticeParentType.workReport.getType())) continue;
            reportIds.add(Long.valueOf(contentMap.get("workReportId").toString()));
        }
        if (companyIds.size() > 0) {
            companyList = this.companyService.findByIdIn(companyIds);
            for (Company company : companyList) {
                companyMap.put(company.getId(), company);
            }
        }
        if (projectIds.size() > 0) {
            companyList = this.projectService.findByIdIn(projectIds);
            for (Project project : companyList) {
                projectMap.put(project.getId(), project);
            }
        }
        if (taskIds.size() > 0) {
            List tasks = this.taskService.findByIdInAAndDelFlagFalse(taskIds);
            for (Task task : tasks) {
                taskMap.put(task.getId(), task);
            }
        }
        if (reportIds.size() > 0) {
            List workReports = this.workReportService.findByIdInAndDelFlagFalse(reportIds);
            for (WorkReport workReport : workReports) {
                reportMap.put(workReport.getId(), workReport);
            }
        }
        for (Object notice : pageInfoRows) {
            contentMap = (Map)JsonUtil.jackson.readValue(notice.getContent(), Map.class);
            notice.setContentMap(contentMap);
            if (notice.getParentTypeId().equals(Constants.NoticeParentType.project.getType())) {
                Project project = (Project)projectMap.get(Long.valueOf(contentMap.get("projectId").toString()));
                notice.setProject(project);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.task.getType())) {
                Task task = (Task)taskMap.get(Long.valueOf(contentMap.get("taskId").toString()));
                if (task != null) {
                    Task taskTwo = new Task();
                    taskTwo.setId(task.getId());
                    taskTwo.setTitle(task.getTitle());
                    Project project = task.getProject();
                    notice.setTask(taskTwo);
                    notice.setProject(project);
                }
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.approval.getType())) {
                ApprovalUserApply approvalUserApply = this.approvalUserApplyService.findByApplyId(Long.valueOf(contentMap.get("approvalUserApplyId").toString()));
                notice.setApprovalUserApply(approvalUserApply);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.proclamation.getType())) {
                Proclamation proclamation = this.proclamationService.findByIdAndDelFlagFalse(Long.valueOf(contentMap.get("proclamationId").toString()));
                notice.setProclamation(proclamation);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.company.getType()) || notice.getParentTypeId().equals(Constants.NoticeParentType.attendance.getType())) {
                Company company = (Company)companyMap.get(Long.valueOf(contentMap.get("companyId").toString()));
                notice.setCompany(company);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.agenda.getType())) {
                Agenda agenda = this.agendaService.findById(Long.valueOf(contentMap.get("agendaId").toString()));
                notice.setAgenda(agenda);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.workReport.getType())) {
                WorkReport workReport = (WorkReport)reportMap.get(Long.valueOf(contentMap.get("workReportId").toString()));
                notice.setWorkReport(workReport);
            } else if (notice.getParentTypeId().equals(Constants.NoticeParentType.meeting.getType())) {
                MeetingEntity meetingEntity = this.meetingService.findByMeetingId(Long.valueOf(contentMap.get("meetingId").toString()));
                notice.setMeetingEntity(meetingEntity);
            }
            if (notice.getOriginatorType().equals(Constants.Originator.member.getType())) {
                User user = this.userService.findById(notice.getOriginatorId());
                User userTwo = new User();
                userTwo.setName(user.getName());
                userTwo.setId(user.getId());
                notice.setUser(userTwo);
            }
            pageInfo = pageInfo.setRows(pageInfoRows);
        }
        companyMap = null;
        projectMap = null;
        reportMap = null;
        taskMap = null;
        return pageInfo;
    }

    public void updateNotice(Long id) {
        ((NoticeDao)this.dao).updateLooked(id);
    }

    public void updateAll(Long userId) {
        List noticeList = ((NoticeDao)this.dao).findByUserIdAndLookedFalseAndDelFlagFalse(userId);
        for (Notice notice : noticeList) {
            ((NoticeDao)this.dao).updateLooked(notice.getId());
        }
    }

    public List<Notice> findByOriginatorTypeAndOriginatorId(String originatorType, Long originatorId) {
        List noticeList = ((NoticeDao)this.dao).findByOriginatorTypeAndOriginatorId(originatorType, originatorId);
        for (Notice notice : noticeList) {
            notice.setDelFlag(Boolean.valueOf(true));
            super.save((BaseEntity)notice);
        }
        return noticeList;
    }

    public Integer countNotice(Long userId) {
        return ((NoticeDao)this.dao).countByUserIdAndLookedFalseAndDelFlagFalse(userId);
    }
}

