/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.push.apns;

import com.turo.pushy.apns.ApnsClient;
import com.turo.pushy.apns.ApnsClientBuilder;
import com.turo.pushy.apns.ApnsPushNotification;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.PushNotificationResponse;
import com.turo.pushy.apns.PushType;
import com.turo.pushy.apns.util.ApnsPayloadBuilder;
import com.turo.pushy.apns.util.SimpleApnsPushNotification;
import com.turo.pushy.apns.util.TokenUtil;
import com.turo.pushy.apns.util.concurrent.PushNotificationFuture;
import com.ym.tlifang.util.StringUtils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IosPush {
    private static final Logger logger = LoggerFactory.getLogger(IosPush.class);
    private static final Semaphore SEMAPHORE = new Semaphore(10000);
    private static final String MSG_CERTIFICATE_PASSWORD = "123456";
    private static ApnsClient apnsXTClient = null;

    public static void push(String apnsCertificatePath, Boolean productFlag, String deviceToken, String alertTitle, String alertBody, boolean contentAvailable, Map<String, Object> customProperty, int badge, DeliveryPriority priority, PushType pushType, String topicBundleId, String sound) {
        if (deviceToken == null || "".equals(deviceToken)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicLong successCnt = new AtomicLong(0L);
        ApnsPayloadBuilder payloadBuilder = new ApnsPayloadBuilder();
        if (alertTitle != null) {
            payloadBuilder.setAlertTitle(alertTitle);
        }
        if (alertBody != null) {
            payloadBuilder.setAlertBody(alertBody);
        }
        payloadBuilder.setMutableContent(true);
        if (badge > 0) {
            payloadBuilder.setBadgeNumber(Integer.valueOf(badge));
        }
        if (StringUtils.isNotBlank((String)sound)) {
            payloadBuilder.setSound(sound);
        }
        if (customProperty != null) {
            for (Map.Entry<String, Object> map : customProperty.entrySet()) {
                payloadBuilder.addCustomProperty(map.getKey(), map.getValue());
            }
        }
        payloadBuilder.setContentAvailable(contentAvailable);
        String payload = payloadBuilder.buildWithDefaultMaximumLength();
        String token = TokenUtil.sanitizeTokenString((String)deviceToken);
        SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(token, topicBundleId, payload, new Date(), priority, pushType);
        try {
            SEMAPHORE.acquire();
        }
        catch (Exception e) {
            logger.error("ios push get semaphore failed, deviceToken:{}", (Object)deviceToken);
            logger.error("ios push get semaphore failed", (Throwable)e);
        }
        logger.debug("token={},payload={}", (Object)token, (Object)payload);
        ApnsClient apnsClient = IosPush.getAPNSXTConnect((String)apnsCertificatePath, (Boolean)productFlag);
        PushNotificationFuture future = apnsClient.sendNotification((ApnsPushNotification)pushNotification);
        future.addListener(arg_0 -> IosPush.lambda$push$0((Future)future, token, successCnt, payload, deviceToken, alertBody, latch, arg_0));
        try {
            latch.await(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("ios push latch await failed!", (Throwable)e);
        }
        long endPushTime = System.currentTimeMillis();
        logger.debug("pushMessage success. [\u6210\u529f{}\u4e2a,\u8017\u65f6{}ms]", (Object)successCnt.get(), (Object)(endPushTime - startTime));
    }

    public static ApnsClient getAPNSXTConnect(String apnsCertificatePath, Boolean productFlag) {
        if (apnsXTClient == null) {
            try {
                NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(4);
                String environmentHost = productFlag != false ? "api.push.apple.com" : "api.development.push.apple.com";
                apnsXTClient = new ApnsClientBuilder().setApnsServer(environmentHost).setClientCredentials(ClassLoader.getSystemClassLoader().getResourceAsStream(apnsCertificatePath), "123456").setConcurrentConnections(4).setEventLoopGroup((EventLoopGroup)eventLoopGroup).build();
            }
            catch (Exception e) {
                logger.error("ios get push apns client failed!", (Throwable)e);
            }
        }
        return apnsXTClient;
    }

    private static /* synthetic */ void lambda$push$0(Future future, String token, AtomicLong successCnt, String payload, String deviceToken, String alertBody, CountDownLatch latch, Future pushNotificationResponseFuture) throws Exception {
        if (future.isSuccess()) {
            PushNotificationResponse response = (PushNotificationResponse)future.getNow();
            if (response.isAccepted()) {
                logger.debug("success token{}", (Object)token);
                successCnt.incrementAndGet();
            } else {
                Date invalidTime = response.getTokenInvalidationTimestamp();
                logger.error("Notification rejected by the APNs gateway: " + response.getRejectionReason() + ",payload:" + payload + "\n,deviceToken:" + deviceToken, (Object)(",alertBody:" + alertBody + ",sanitizeTokenString:" + token));
                if (invalidTime != null) {
                    logger.error("\t\u2026and the token is invalid as of " + response.getTokenInvalidationTimestamp());
                }
            }
        } else {
            logger.error("send notification device token={} is failed {} ", (Object)token, (Object)future.cause().getMessage());
        }
        latch.countDown();
        SEMAPHORE.release();
    }
}

