/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.job.statement;

import com.ym.tlifang.Constants;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.statement.ProjectStatisticsService;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.statement.ProjectStatistics;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ProjectStatisticsJob {
    @Autowired
    private ProjectStatisticsService projectStatisticsService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private CompanyMemberInfoService companyMemberInfoService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;

    @Scheduled(cron="0 30 1 * * ?")
    public void count() {
        String lastDayStr = DateUtils.getYearMonthStr((Date)DateUtils.addDateNum((Date)new Date(), (int)-1), (String)"day");
        List companyIds = this.companyService.findCompanyIds();
        for (Long companyId : companyIds) {
            Object department2;
            List departmentList = this.companyService.findByParentIdAndDelFlagFalse(companyId);
            ProjectStatistics projectStatistics = null;
            for (Object department2 : departmentList) {
                projectStatistics = this.projectStatisticsService.findLastRecord(companyId, department2.getId(), lastDayStr);
                if (StringUtils.isEmpty((Object)projectStatistics)) {
                    projectStatistics = new ProjectStatistics();
                }
                projectStatistics.setProjectNum(this.projectService.findProjectNumByDepartmentId(department2.getId()));
                projectStatistics.setCompletedNum(this.projectService.findCompeteNumByDepartmentId(department2.getId()));
                projectStatistics.setOngoingNum(this.projectService.findOngoingNumByDepartmentId(department2.getId()));
                projectStatistics.setStopNum(this.projectService.findStopNumByDepartmentId(department2.getId()));
                projectStatistics.setTaskNum(this.taskService.findByDepartIdAndAll(department2.getId()));
                projectStatistics.setOverdueNum(this.projectService.findOverdueNumByDepartmentId(department2.getId(), DateUtils.parseDate((Object)lastDayStr)));
                BigDecimal delayRate = BigDecimal.valueOf(0L);
                if (projectStatistics.getProjectNum() != 0L) {
                    delayRate = BigDecimal.valueOf(Double.valueOf(projectStatistics.getOverdueNum().longValue()) / (double)projectStatistics.getProjectNum().longValue());
                }
                projectStatistics.setDelayRate(delayRate);
                projectStatistics.setRecordTime(lastDayStr);
                projectStatistics.setCompanyId(companyId);
                projectStatistics.setDepartmentId(department2.getId());
                this.projectStatisticsService.save(projectStatistics);
            }
            List companyMemberInfoList = this.companyMemberInfoService.findByCompanyIdAndStatus(companyId, Constants.AuditStatus.adopt.getType());
            department2 = companyMemberInfoList.iterator();
            while (department2.hasNext()) {
                CompanyMemberInfo companyMemberInfo = (CompanyMemberInfo)department2.next();
                for (Company department3 : departmentList) {
                    CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(companyMemberInfo.getUserId(), companyId, department3.getId());
                    if (companyUserRelation == null) continue;
                    projectStatistics = this.projectStatisticsService.findByLastRecord(companyId, department3.getId(), companyMemberInfo.getUserId(), lastDayStr);
                    if (projectStatistics == null) {
                        projectStatistics = new ProjectStatistics();
                    }
                    projectStatistics.setProjectNum(this.projectService.findProjectNumByDepartmentIdAndUserId(department3.getId(), companyMemberInfo.getUserId()));
                    projectStatistics.setCompletedNum(this.projectService.findCompeteNumByDepartmentIdAndUserId(department3.getId(), companyMemberInfo.getUserId()));
                    projectStatistics.setOngoingNum(this.projectService.findOngoingNumByDepartmentIdAndUserId(department3.getId(), companyMemberInfo.getUserId()));
                    projectStatistics.setStopNum(this.projectService.findStopNumByDepartmentIdAndUserId(department3.getId(), companyMemberInfo.getUserId()));
                    projectStatistics.setOverdueNum(this.projectService.findOverdueNumByDepartmentIdAndUserIdAndDateDue(department3.getId(), companyMemberInfo.getUserId(), DateUtils.parseDate((Object)lastDayStr)));
                    BigDecimal delayRate = BigDecimal.valueOf(0L);
                    if (projectStatistics.getProjectNum() != 0L) {
                        delayRate = BigDecimal.valueOf(Double.valueOf(projectStatistics.getOverdueNum().longValue()) / (double)projectStatistics.getProjectNum().longValue());
                    }
                    projectStatistics.setDelayRate(delayRate);
                    projectStatistics.setDepartmentId(department3.getId());
                    projectStatistics.setCompanyId(companyMemberInfo.getCompanyId());
                    projectStatistics.setRecordTime(lastDayStr);
                    projectStatistics.setUserId(companyMemberInfo.getUserId());
                    this.projectStatisticsService.save(projectStatistics);
                }
            }
            List projectList = this.projectService.findByCompanyIdAndDelFlagFalse(companyId);
            if (!StringUtils.isEmpty((Object)projectList)) {
                for (Project project : projectList) {
                    projectStatistics = this.projectStatisticsService.findProjectByLastRecord(companyId, project.getId(), lastDayStr);
                    if (projectStatistics == null) {
                        projectStatistics = new ProjectStatistics();
                    }
                    projectStatistics.setMemberNum(this.projectService.findMemberNumByCompanyIdAndProjectId(companyId, project.getId()));
                    Integer integer = this.taskService.countByProjectIdAndDelFlagFalse(project.getId());
                    long count = integer.longValue();
                    projectStatistics.setTaskNum(Long.valueOf(count));
                    Integer countOngoingNum = this.taskService.countByProjectIdAndStatusAndDelFlagFalse(project.getId(), "0");
                    long countOngoingNumL = countOngoingNum.longValue();
                    projectStatistics.setOngoingNum(Long.valueOf(countOngoingNumL));
                    Integer integerCompletedNum = this.taskService.countByProjectIdAndStatusAndDelFlagFalse(project.getId(), "1");
                    long integerCompletedNumL = integerCompletedNum.longValue();
                    projectStatistics.setCompletedNum(Long.valueOf(integerCompletedNumL));
                    projectStatistics.setOverdueNum(this.taskService.countOverdueNumByProjectId(project.getId(), DateUtils.parseDate((Object)lastDayStr)));
                    BigDecimal delayRate = BigDecimal.valueOf(0L);
                    if (projectStatistics.getTaskNum() != 0L) {
                        delayRate = BigDecimal.valueOf(Double.valueOf(projectStatistics.getOverdueNum().longValue()) / (double)projectStatistics.getTaskNum().longValue());
                    }
                    projectStatistics.setDelayRate(delayRate);
                    projectStatistics.setCompanyId(companyId);
                    projectStatistics.setProjectId(project.getId());
                    projectStatistics.setRecordTime(lastDayStr);
                    this.projectStatisticsService.save(projectStatistics);
                }
            }
            if ((projectStatistics = this.projectStatisticsService.findByCompanyId(companyId)) == null) {
                projectStatistics = new ProjectStatistics();
            }
            projectStatistics.setProjectNum(this.projectService.findByCompanyIdAndStatusIsNull(companyId));
            projectStatistics.setCompletedNum(this.projectService.findByCompanyIdAndStatus(companyId, Constants.ProjectStatus.projectAccomplish.getType()));
            projectStatistics.setOngoingNum(this.projectService.findByCompanyIdAndStatus(companyId, Constants.ProjectStatus.projectConduct.getType()));
            projectStatistics.setStopNum(this.projectService.findByCompanyIdAndStatus(companyId, Constants.ProjectStatus.projectDiscontinue.getType()));
            projectStatistics.setCompanyId(companyId);
            projectStatistics.setRecordTime(lastDayStr);
            this.projectStatisticsService.save(projectStatistics);
        }
    }
}

