/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.company;

import com.alibaba.dubbo.config.annotation.Service;
import com.github.binarywang.java.emoji.EmojiConverter;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyPosition;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.dao.company.CompanyDao;
import com.ym.tlifang.model.company.CompanyInformationModel;
import com.ym.tlifang.model.company.CompanyModel;
import com.ym.tlifang.model.company.DepartmentAddDelModel;
import com.ym.tlifang.model.company.PositionAddDel;
import com.ym.tlifang.project.Project;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyPositionService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.service.version.VersionService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.version.VersionLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=CompanyService.class, timeout=30000, retries=-1)
public class CompanyServiceImpl
extends AbstractBaseService<Company, CompanyDao>
implements CompanyService {
    Logger logger = LoggerFactory.getLogger(CompanyServiceImpl.class);
    @Autowired
    private CompanyMemberInfoService companyMemberInfoService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ApprovalTemplateService approvalTemplateService;
    @Autowired
    private FileFolderService fileFolderService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private CompanyPositionService companyPositionService;
    @Autowired
    private ProjectUserService projectUserService;
    @Autowired
    private FileService fileService;
    @Autowired
    private VersionService versionService;
    @Autowired
    private UserService userService;
    @Autowired
    private static EmojiConverter emojiConverter = EmojiConverter.getInstance();
    @Autowired
    private XgPushService xgPushService;

    public Company findById(Long companyId) {
        return ((CompanyDao)this.dao).findByIdAndDelFlagFalse(companyId);
    }

    public int findByOwnerId(Long userId) {
        return ((CompanyDao)this.dao).findByOwnerIdAndParentId(userId);
    }

    public Company findByIdAndParentId(Long companyId, Long departmentId) {
        return ((CompanyDao)this.dao).findByIdAndParentId(companyId, departmentId);
    }

    public Company findByDepartmentId(Long companyId) {
        return ((CompanyDao)this.dao).findByIdAndDelFlag(companyId, Boolean.valueOf(false));
    }

    public List<Company> findByParentIdsLikeAndDelFlagFalse(String companyId) {
        return ((CompanyDao)this.dao).findByParentIdsLikeAndDelFlagFalse(companyId);
    }

    public Company findByNameAndParentId(String name, Long parentId) {
        return ((CompanyDao)this.dao).findByNameAndParentId(name, parentId);
    }

    public List<Company> findByDelFlagFalse() {
        return ((CompanyDao)this.dao).findByParentIdNullAndDelFlagFalse();
    }

    public List<Long> findCompanyIds() {
        return ((CompanyDao)this.dao).findCompanyIds();
    }

    public Company findByOwnerIdAndId(Long ownerId, Long companyId) {
        return ((CompanyDao)this.dao).findByOwnerIdAndIdAndDelFlagFalse(ownerId, companyId);
    }

    public List<Company> findByParentIdsLikeAndOwnerIdAndDelFlagFalse(String companyId, Long ownerId) {
        return ((CompanyDao)this.dao).findByParentIdsLikeAndOwnerIdAndDelFlagFalse(companyId, ownerId);
    }

    public Company findByMongodbId(String mongodbId) {
        return ((CompanyDao)this.dao).findByMongodbId(mongodbId);
    }

    public Company createCompany(User user, Company company, String logoUrl, String languageType) {
        company.setName(emojiConverter.toAlias(company.getName()));
        company.setDescription(emojiConverter.toAlias(StringUtils.isEmpty((Object)company.getDescription()) ? "" : company.getDescription()));
        company.setOwnerId(user.getId());
        company.setVersionId(Long.valueOf(1L));
        company.setLogo(logoUrl);
        company = (Company)this.save((BaseEntity)company);
        CompanyMemberInfo companyMemberInfo = new CompanyMemberInfo(user.getId(), company.getId(), user.getEmail(), user.getMobile(), "1", "1");
        this.companyMemberInfoService.save(companyMemberInfo);
        CompanyUserRelation companyUserRelation = new CompanyUserRelation(user.getId(), company.getId(), company.getId(), Constants.ExecutiveStatus.departmentExecutive.getType());
        this.companyUserRelationService.save(companyUserRelation);
        this.projectService.saveDefaultProjectAndDefaultPanel(user.getId(), company.getId(), languageType);
        this.approvalTemplateService.saveInitTemplate(company.getId(), languageType);
        this.fileFolderService.autoGenerateFolder(company.getId(), Constants.FileType.team.getType(), user.getId(), null, languageType);
        return company;
    }

    public ResultModel<Company> updateCompany(Company company, Company companyInfo) {
        if (!StringUtils.isEmpty((Object)company.getLogo())) {
            companyInfo.setLogo(company.getLogo());
        }
        if (!StringUtils.isEmpty((Object)company.getName())) {
            companyInfo.setName(emojiConverter.toAlias(company.getName()));
        }
        if (!StringUtils.isEmpty((Object)company.getDescription())) {
            companyInfo.setDescription(emojiConverter.toAlias(StringUtils.isEmpty((Object)company.getDescription()) ? "" : company.getDescription()));
        }
        if (!StringUtils.isEmpty((Object)company.getIndustry())) {
            companyInfo.setIndustry(company.getIndustry());
        }
        if (!StringUtils.isEmpty((Object)company.getSize())) {
            companyInfo.setSize(company.getSize());
        }
        if (!StringUtils.isEmpty((Object)company.getCountry())) {
            companyInfo.setCountry(company.getCountry());
        }
        if (!StringUtils.isEmpty((Object)company.getProvince())) {
            companyInfo.setProvince(company.getProvince());
        }
        if (!StringUtils.isEmpty((Object)company.getCity())) {
            companyInfo.setCity(company.getCity());
        }
        if (!StringUtils.isEmpty((Object)company.getDistrict())) {
            companyInfo.setDistrict(company.getDistrict());
        }
        this.save((BaseEntity)companyInfo);
        return ResultModel.ok();
    }

    public ResultModel<Company> updateCompanyShift(User user, Company company, CompanyModel companyModel, CompanyMemberInfo companyMemberInfo, String languageType) {
        CompanyMemberInfo memberInfo;
        company.setOwnerId(companyModel.getUserId());
        this.save((BaseEntity)company);
        List companyList = this.findByParentIdsLikeAndOwnerIdAndDelFlagFalse("%" + "," + companyModel.getCompanyId().toString() + "%" + ",", user.getId());
        if (companyList != null) {
            for (Company companyOwner : companyList) {
                companyOwner.setOwnerId(companyModel.getUserId());
                this.save((BaseEntity)companyOwner);
            }
        }
        if (StringUtils.isEmpty((Object)(memberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyModel.getCompanyId(), user.getId(), Constants.AuditStatus.adopt.getType())))) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        memberInfo.setManager(Constants.ManagerStatus.companyManager.getType());
        this.companyMemberInfoService.save(memberInfo);
        companyMemberInfo.setManager(Constants.ManagerStatus.companyOwner.getType());
        this.companyMemberInfoService.save(companyMemberInfo);
        CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(user.getId(), company.getId(), company.getId());
        if (companyUserRelation == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        companyUserRelation.setExecutive(Constants.ExecutiveStatus.departmentOrdinaryMember.getType());
        this.companyUserRelationService.save(companyUserRelation);
        CompanyUserRelation companyUserRelationUser = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(companyModel.getUserId(), company.getId(), company.getId());
        if (companyUserRelationUser == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        companyUserRelationUser.setExecutive(Constants.ExecutiveStatus.departmentExecutive.getType());
        this.companyUserRelationService.save(companyUserRelationUser);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", company.getId());
        map.put("action", "\u8f6c\u8ba9\u56e2\u961f");
        map.put("msg", user.getName() + Constants.NoticeContent.letCompany.getName() + company.getName() + Constants.NoticeContent.letToYou.getName());
        map.put("msgEn", user.getName() + Constants.NoticeContent.letCompany.getNameEnglish() + company.getName() + Constants.NoticeContent.letToYou.getNameEnglish());
        try {
            this.noticeService.saveSendNotice(companyMemberInfo.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.companyMakeOver, Constants.Originator.member, user.getId(), map, "1");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)memberInfo.getUser()) && StringUtils.isNotBlank((String)memberInfo.getUser().getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(memberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getName(), user.getName() + Constants.ContentNotify.transferCompany.getName() + company.getName() + "\u8f6c\u8ba9\u7ed9\u4f60", null, Constants.IntentType.systemNotice.getType());
            }
        } else if (!StringUtils.isEmpty((Object)memberInfo.getUser()) && StringUtils.isNotBlank((String)memberInfo.getUser().getPushToken())) {
            this.xgPushService.pushTokenForeign(memberInfo.getUser().getPushToken(), Constants.TitleNotify.company.getEnglishName(), user.getName() + Constants.ContentNotify.transferCompany.getEnglishName() + company.getName() + " to you.", Constants.SHOWFLAG);
        }
        return ResultModel.ok();
    }

    public ResultModel<Company> deleteCompany(Company company, User user, String languageType) {
        List projectUserList;
        List projectList;
        List companyUserRelationList;
        List companyPositionList;
        List companyMemberInfoList;
        company.setDelFlag(Boolean.valueOf(true));
        List companyLists = this.findByParentIdsLikeAndOwnerIdAndDelFlagFalse("%" + "," + company.getId().toString() + "," + "%", company.getOwnerId());
        if (companyLists != null) {
            for (Object companyList : companyLists) {
                companyList.setDelFlag(Boolean.valueOf(true));
                this.save((BaseEntity)companyList);
            }
        }
        if ((companyMemberInfoList = this.companyMemberInfoService.findByCompanyId(company.getId())) != null) {
            for (Object companyMemberInfo : companyMemberInfoList) {
                User userInfo = this.userService.findById(companyMemberInfo.getUserId());
                if (StringUtils.isEmpty((Object)userInfo)) {
                    return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
                }
                if (!StringUtils.isEmpty((Object)userInfo.getCurrentCompany()) && userInfo.getCurrentCompany().equals(company.getId())) {
                    userInfo.setCurrentCompany(null);
                    this.userService.save(userInfo);
                }
                companyMemberInfo.setDelFlag(Boolean.valueOf(true));
                this.companyMemberInfoService.save((CompanyMemberInfo)companyMemberInfo);
            }
        }
        if ((companyPositionList = this.companyPositionService.findByCompanyIdAndDelFlagFalse(company.getId())) != null) {
            for (Object companyPosition : companyPositionList) {
                companyPosition.setDelFlag(Boolean.valueOf(true));
                this.companyPositionService.save((CompanyPosition)companyPosition);
            }
        }
        if ((companyUserRelationList = this.companyUserRelationService.findAllByCompanyId(company.getId())) != null) {
            for (Object companyUserRelation : companyUserRelationList) {
                companyUserRelation.setDelFlag(Boolean.valueOf(true));
                this.companyUserRelationService.save((CompanyUserRelation)companyUserRelation);
            }
        }
        if ((projectList = this.projectService.findByCompanyIdAndDelFlagFalse(company.getId())) != null) {
            for (Object project : projectList) {
                project.setDelFlag(Boolean.valueOf(true));
                this.projectService.save((Project)project);
            }
        }
        if ((projectUserList = this.projectUserService.findByCompanyIdAndDelFlagFalse(company.getId())) != null) {
            for (ProjectUser projectUser : projectUserList) {
                projectUser.setDelFlag(Boolean.valueOf(true));
                this.projectUserService.save(projectUser);
            }
        }
        List noticeList = this.noticeService.findByOriginatorTypeAndOriginatorId("1", company.getId());
        for (CompanyMemberInfo companyMemberInfos : companyMemberInfoList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("companyId", company.getId());
            map.put("action", "\u5220\u9664\u56e2\u961f");
            map.put("msg", user.getName() + Constants.NoticeContent.delCompany.getName() + company.getName());
            map.put("msgEn", user.getName() + Constants.NoticeContent.delCompany.getNameEnglish() + company.getName());
            try {
                this.noticeService.saveSendNotice(companyMemberInfos.getUserId(), Constants.NoticeParentType.company, Constants.NoticeType.CompanyDel, Constants.Originator.member, user.getId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            if ("0".equals("0")) {
                if (StringUtils.isEmpty((Object)companyMemberInfos.getUser()) || !StringUtils.isNotBlank((String)companyMemberInfos.getUser().getPushToken())) continue;
                this.xgPushService.pushTokenIosOrAndroidBelievers(companyMemberInfos.getUser().getPushToken(), Constants.TitleNotify.company.getName(), user.getName() + Constants.ContentNotify.delCompany.getName() + company.getName(), null, Constants.IntentType.systemNotice.getType());
                continue;
            }
            if (StringUtils.isEmpty((Object)companyMemberInfos.getUser()) || !StringUtils.isNotBlank((String)companyMemberInfos.getUser().getPushToken())) continue;
            this.xgPushService.pushTokenForeign(companyMemberInfos.getUser().getPushToken(), Constants.TitleNotify.company.getEnglishName(), user.getName() + Constants.ContentNotify.delCompany.getEnglishName() + company.getName(), Constants.SHOWFLAG);
        }
        this.save((BaseEntity)company);
        return ResultModel.ok();
    }

    public ResultModel<Company> createDepartment(Company company, PositionAddDel positionAddDel, Company department, Long userId, String languageType) {
        Company departmentAdd = new Company(emojiConverter.toAlias(positionAddDel.getDepartmentName()), company.getOwnerId(), company.getVersionId(), Long.valueOf(department.getId()), department.getParentId() == null || department.getParentId() == 0L ? "," + department.getId() + "," : department.getParentIds() + department.getId() + ",");
        departmentAdd = (Company)this.save((BaseEntity)departmentAdd);
        CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(company.getId(), userId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfo == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(userId, company.getId(), departmentAdd.getId());
        if (!StringUtils.isEmpty((Object)companyUserRelation)) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_EXIST, (String)languageType);
        }
        companyUserRelation = new CompanyUserRelation(userId, company.getId(), departmentAdd.getId(), Constants.ExecutiveStatus.departmentExecutive.getType());
        companyUserRelation = this.companyUserRelationService.save(companyUserRelation);
        if (positionAddDel.getAddPosition() != null) {
            for (String positionName : positionAddDel.getAddPosition()) {
                CompanyPosition companyPosition = this.companyPositionService.findByCompanyIdAndDepartmentIdAndName(company.getId(), companyUserRelation.getDepartmentId(), positionName);
                if (companyPosition != null) {
                    return ResultModel.error((ResultStatus)ResultStatus.POSITION_REPEAT_EXIST, (String)languageType);
                }
                companyPosition = new CompanyPosition(company.getId(), companyUserRelation.getDepartmentId(), positionName);
                this.companyPositionService.save(companyPosition);
            }
        }
        List companyUserRelations = this.companyUserRelationService.findByCompanyIdAndDepartmentId(company.getId(), companyUserRelation.getDepartmentId());
        departmentAdd.setMembers(companyUserRelations);
        List positions = this.companyPositionService.findByCompanyIdAndDepartmentId(company.getId(), departmentAdd.getId());
        departmentAdd.setPositions(new HashSet(positions));
        return ResultModel.suc((Object)departmentAdd);
    }

    public ResultModel<List<CompanyUserRelation>> updateDepartmentMember(DepartmentAddDelModel departmentAddDelModel, Long companyId, Long departmentId, String languageType) {
        CompanyUserRelation companyUserRelation;
        CompanyMemberInfo companyMemberInfo;
        if (departmentAddDelModel.getAddUserIds() != null) {
            for (Long addUserId : departmentAddDelModel.getAddUserIds()) {
                companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, addUserId, Constants.AuditStatus.adopt.getType());
                if (StringUtils.isEmpty((Object)companyMemberInfo)) {
                    return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
                }
                companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(addUserId, companyId, departmentId);
                if (!StringUtils.isEmpty((Object)companyUserRelation)) {
                    return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_EXIST, (String)languageType);
                }
                companyUserRelation = new CompanyUserRelation(addUserId, companyId, departmentId);
                this.companyUserRelationService.save(companyUserRelation);
            }
        }
        if (departmentAddDelModel.getDelUserIds() != null) {
            for (Long delUserId : departmentAddDelModel.getDelUserIds()) {
                companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(companyId, delUserId, Constants.AuditStatus.adopt.getType());
                if (StringUtils.isEmpty((Object)companyMemberInfo)) {
                    return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
                }
                companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(delUserId, companyId, departmentId);
                if (StringUtils.isEmpty((Object)companyUserRelation)) {
                    return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_NO_EXIST, (String)languageType);
                }
                companyUserRelation.setDelFlag(Boolean.valueOf(true));
                this.companyUserRelationService.save(companyUserRelation);
            }
        }
        Company company = this.findById(companyId);
        List companyUserRelationList = this.companyUserRelationService.findByCompanyIdAndDepartmentId(companyId, departmentId);
        company.setMembers(companyUserRelationList);
        return ResultModel.suc((Object)company.getMembers());
    }

    public ResultModel<Company> updateDepartment(Long companyId, Long departmentId, Long userId, Company departmentInfo, Company updateDepartment, String languageType) {
        CompanyUserRelation companyUserRelation;
        CompanyUserRelation companyUserRelationExecutive;
        if (!StringUtils.isEmpty((Object)updateDepartment.getName())) {
            departmentInfo.setName(emojiConverter.toAlias(StringUtils.isEmpty((Object)updateDepartment.getName()) ? "" : updateDepartment.getName()));
        }
        if ((companyUserRelationExecutive = this.companyUserRelationService.findByExecutiveAndDepartmentIdAndDelFlagFalse(Constants.ExecutiveStatus.departmentExecutive.getType(), departmentId)) != null) {
            companyUserRelationExecutive.setExecutive(Constants.ExecutiveStatus.departmentOrdinaryMember.getType());
            this.companyUserRelationService.save(companyUserRelationExecutive);
        }
        if ((companyUserRelation = this.companyUserRelationService.findByUserIdAndCompanyIdAndDepartmentId(userId, companyId, departmentId)) == null) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_NO_EXIST, (String)languageType);
        }
        if (!companyUserRelation.getExecutive().equals(Constants.ExecutiveStatus.departmentExecutive.getType())) {
            companyUserRelation.setExecutive(Constants.ExecutiveStatus.departmentExecutive.getType());
            this.companyUserRelationService.save(companyUserRelation);
        }
        this.save((BaseEntity)departmentInfo);
        return ResultModel.ok();
    }

    public ResultModel<Company> deleteDepartment(Long companyId, Long departmentId, String languageType) {
        List companyUserRelations = new ArrayList();
        Company department = this.findById(departmentId);
        if (department == null) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENT_OWNER_NO_EXIST, (String)languageType);
        }
        companyUserRelations = this.companyUserRelationService.findByCompanyIdAndDepartmentId(companyId, departmentId);
        if (StringUtils.isEmpty(companyUserRelations)) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_NO_EXIST, (String)languageType);
        }
        this.updateDepartment(department, companyUserRelations);
        List departmentList = this.findByParentIdsLikeAndDelFlagFalse("%" + "," + departmentId.toString() + "," + "%");
        if (departmentList != null) {
            for (Company departmentInfo : departmentList) {
                companyUserRelations = this.companyUserRelationService.findByCompanyIdAndDepartmentId(companyId, departmentInfo.getId());
                if (StringUtils.isEmpty(companyUserRelations)) {
                    return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTMEMBERS_NO_EXIST, (String)languageType);
                }
                this.updateDepartment(departmentInfo, companyUserRelations);
            }
        }
        return ResultModel.ok();
    }

    private void updateDepartment(Company department, List<CompanyUserRelation> companyUserRelations) {
        for (CompanyUserRelation companyUserRelation : companyUserRelations) {
            companyUserRelation.setDelFlag(Boolean.valueOf(true));
            this.companyUserRelationService.save(companyUserRelation);
        }
        department.setDelFlag(Boolean.valueOf(true));
        this.save((BaseEntity)department);
    }

    public List<Company> findByParentIdAndDelFlagFalse(Long parentId) {
        return ((CompanyDao)this.dao).findByParentIdAndDelFlagFalse(parentId);
    }

    public ResultModel<CompanyInformationModel> queryCompanyInformation(Long companyId, String languageType) {
        CompanyInformationModel companyInformationModel = new CompanyInformationModel();
        Company company = this.findById(companyId);
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        companyInformationModel.setCompanyName(company.getName());
        companyInformationModel.setCompanyDescription(company.getDescription());
        companyInformationModel.setCompanyLogo(company.getLogo());
        companyInformationModel.setIndustry(company.getIndustry());
        companyInformationModel.setLocality(company.getProvince() + "/" + company.getCity() + "/" + company.getDistrict());
        User user = this.userService.findById(company.getOwnerId());
        if (user == null) {
            return ResultModel.error((ResultStatus)ResultStatus.ACCOUNT_NO_EXIST, (String)languageType);
        }
        companyInformationModel.setOwner(user.getName());
        companyInformationModel.setUserLogo(user.getAvatar());
        VersionLevel versionLevel = this.versionService.findByIdAndDelFlagFalse(company.getVersionId());
        if (StringUtils.isEmpty((Object)versionLevel)) {
            return ResultModel.error((ResultStatus)ResultStatus.VERSION_NO_EXIST, (String)languageType);
        }
        companyInformationModel.setFileMaxNumber(versionLevel.getSize());
        companyInformationModel.setMaxMembers(versionLevel.getDefaultMember());
        Integer companyIdCountFileSize = this.fileService.findCompanyIdCountFileSize(companyId);
        companyInformationModel.setFileNumber(Long.valueOf(companyIdCountFileSize.longValue()));
        List companyMemberInfoList = this.companyMemberInfoService.findByCompanyIdAndStatus(companyId, Constants.AuditStatus.adopt.getType());
        if (companyMemberInfoList == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANYMEMBERS_NO_EXIST, (String)languageType);
        }
        Integer companyMemberInfoSize = companyMemberInfoList.size();
        long companyMemberInfoCount = companyMemberInfoSize.longValue();
        companyInformationModel.setMembers(Long.valueOf(companyMemberInfoCount));
        List projectList = this.projectService.findByCompanyIdAndDelFlagFalse(companyId);
        if (projectList == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PROJECT_NO_EXIST, (String)languageType);
        }
        Integer projectSize = projectList.size();
        long projectCount = projectSize.longValue();
        companyInformationModel.setProjectNumber(Long.valueOf(projectCount));
        return ResultModel.suc((Object)companyInformationModel);
    }

    public List<Company> findByIdIn(List<Long> id) {
        ArrayList<Company> companyList = new ArrayList<Company>();
        List byIdIn = ((CompanyDao)this.dao).findByIdIn(id);
        for (Object[] objects : byIdIn) {
            Company company = new Company();
            company.setId(Long.valueOf(objects[0].toString()));
            company.setName(objects[1].toString());
            companyList.add(company);
        }
        return companyList;
    }
}

