/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.tomato;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.tomato.TomatoModel;
import com.ym.tlifang.service.task.TaskService;
import com.ym.tlifang.service.tomato.UserTomatoClockSettingService;
import com.ym.tlifang.service.tomato.UserTomatoRecordService;
import com.ym.tlifang.service.tomato.UserTomatoService;
import com.ym.tlifang.task.Task;
import com.ym.tlifang.tomato.UserTomato;
import com.ym.tlifang.tomato.UserTomatoClockSetting;
import com.ym.tlifang.tomato.UserTomatoRecord;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Date;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"tomatoClocks"})
@Api(value="tomatoClocks", description="\u756a\u8304\u949f\u76f8\u5173")
public class TomatoClockController
extends BaseController {
    @Reference
    private UserTomatoService userTomatoService;
    @Reference
    private UserTomatoRecordService userTomatoRecordService;
    @Reference
    private UserTomatoClockSettingService userTomatoClockSettingService;
    @Reference
    private TaskService taskService;

    @GetMapping(value={"/user"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u756a\u8304\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomato> getUserTomato(@LanguageType String languageType, @CurrentUser User currentUser) {
        UserTomato userTomato = this.userTomatoService.findByUserId(currentUser.getId());
        if (userTomato == null) {
            userTomato = new UserTomato(currentUser.getId(), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L));
            this.userTomatoService.save(userTomato);
        }
        userTomato.setDoingTomato(this.userTomatoRecordService.findTomatoByUserId(currentUser.getId()));
        userTomato.setUnallotTomatos(this.userTomatoRecordService.findUnallotList(currentUser.getId()));
        return ResultModel.suc((Object)userTomato, (String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u756a\u8304\u949f\u8bbe\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoClockSetting> getSetting(@LanguageType String languageType, @CurrentUser User currentUser) {
        UserTomatoClockSetting setting = this.userTomatoClockSettingService.findByUserId(currentUser.getId());
        if (StringUtils.isEmpty((Object)setting.getUserId())) {
            setting.setUserId(currentUser.getId());
            UserTomatoClockSetting userTomatoClockSetting = new UserTomatoClockSetting();
            userTomatoClockSetting.setUserId(currentUser.getId());
            userTomatoClockSetting.init(setting);
            this.userTomatoClockSettingService.save(userTomatoClockSetting);
        }
        return ResultModel.suc((Object)setting, (String)languageType);
    }

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58/\u4fee\u6539\u756a\u8304\u949f\u8bbe\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoClockSetting> saveSetting(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody UserTomatoClockSetting setting) {
        UserTomatoClockSetting userTomatoClockSetting = this.userTomatoClockSettingService.findByUserId(currentUser.getId());
        if (userTomatoClockSetting == null) {
            return ResultModel.error((ResultStatus)ResultStatus.TOMATO_SETTING_NO_EXIST, (String)languageType);
        }
        userTomatoClockSetting.init(setting);
        userTomatoClockSetting = this.userTomatoClockSettingService.save(userTomatoClockSetting);
        return ResultModel.suc((Object)userTomatoClockSetting, (String)languageType);
    }

    @PostMapping(value={"/record"})
    @ApiOperation(value="\u5f00\u542f\u756a\u8304\u949f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoRecord> saveRecord(@LanguageType String languageType, @CurrentUser User currentUser) {
        UserTomatoRecord oldUserTomatoRecord = this.userTomatoRecordService.findTomatoByUserId(currentUser.getId());
        if (oldUserTomatoRecord != null) {
            if (oldUserTomatoRecord.getEnd().after(new Date())) {
                return ResultModel.error((ResultStatus)ResultStatus.TOMATO_HAS_DOING, (String)languageType);
            }
            oldUserTomatoRecord.setStatus(Boolean.valueOf(true));
            this.userTomatoRecordService.save(oldUserTomatoRecord);
        }
        UserTomatoClockSetting userTomatoClockSetting = this.userTomatoClockSettingService.findByUserId(currentUser.getId());
        Date date = new Date();
        UserTomatoRecord userTomatoRecord = new UserTomatoRecord(currentUser.getId(), Long.valueOf(1L), Boolean.valueOf(false), date, DateUtils.addDateMinute((Date)date, (int)userTomatoClockSetting.getDuration()));
        userTomatoRecord = this.userTomatoRecordService.save(userTomatoRecord);
        return ResultModel.suc((Object)userTomatoRecord, (String)languageType);
    }

    @PutMapping(value={"/{recordId}"})
    @ApiOperation(value="\u7ed3\u675f\u756a\u8304\u949f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="recordId", value="\u756a\u8304\u8bb0\u5f55id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoRecord> updateRecord(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long recordId) {
        UserTomatoRecord record = this.userTomatoRecordService.findByRecordId(recordId);
        if (record == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        record.setStatus(Boolean.valueOf(true));
        record = this.userTomatoRecordService.save(record);
        UserTomato userTomato = this.userTomatoService.findByUserId(currentUser.getId());
        if (userTomato == null) {
            userTomato = new UserTomato();
            userTomato.setUserId(currentUser.getId());
        }
        userTomato.setTotal(Long.valueOf(StringUtils.isEmpty((Object)userTomato.getTotal()) ? 1L : userTomato.getTotal() + 1L));
        this.userTomatoService.save(userTomato);
        return ResultModel.suc((Object)record, (String)languageType);
    }

    @PutMapping(value={"/interrupt/{recordId}"})
    @ApiOperation(value="\u4e2d\u65ad\u756a\u8304\u949f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="recordId", value="\u756a\u8304\u8bb0\u5f55id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoRecord> interrupt(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long recordId) {
        UserTomatoRecord record = this.userTomatoRecordService.findByRecordId(recordId);
        if (record == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        record.setDelFlag(Boolean.valueOf(true));
        record = this.userTomatoRecordService.save(record);
        return ResultModel.suc((Object)record, (String)languageType);
    }

    @PostMapping(value={"/assigned/{recordId}"})
    @ApiOperation(value="\u5206\u914d\u756a\u8304\u949f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="recordId", value="\u756a\u8304\u8bb0\u5f55id", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomatoRecord> assigned(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody TomatoModel tomatoModel, @PathVariable Long recordId) {
        UserTomatoRecord record = this.userTomatoRecordService.findByRecordId(recordId);
        if (record == null) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (StringUtils.isEmpty((Object)tomatoModel.getTaskIds()) && StringUtils.isEmpty((Object)tomatoModel.getTaskName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (StringUtils.isNotBlank((String)tomatoModel.getTaskIds())) {
            record.setTaskIds(tomatoModel.getTaskIds());
            String[] taskIds = tomatoModel.getTaskIds().split(",");
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < taskIds.length; ++i) {
                Task task = this.taskService.findByTaskId(Long.valueOf(taskIds[i]));
                sb.append(task.getTitle());
                if (i >= taskIds.length - 1) continue;
                sb.append(",");
            }
            record.setTaskName(sb.toString());
        } else if (StringUtils.isNotBlank((String)tomatoModel.getTaskName())) {
            record.setTaskName(tomatoModel.getTaskName());
        }
        record = this.userTomatoRecordService.save(record);
        UserTomato userTomato = this.userTomatoService.findByUserId(currentUser.getId());
        if (userTomato == null) {
            userTomato = new UserTomato();
            userTomato.setUserId(currentUser.getId());
        }
        userTomato.setAllotNum(Long.valueOf(StringUtils.isEmpty((Object)userTomato.getAllotNum()) ? 1L : userTomato.getAllotNum() + 1L));
        this.userTomatoService.save(userTomato);
        return ResultModel.suc((Object)record, (String)languageType);
    }

    @GetMapping(value={"/records"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u756a\u8304\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="start", value="\u5f00\u59cb\u65f6\u95f4(2018-05-12)", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="end", value="\u7ed3\u675f\u65f6\u95f4(2018-05-12)", required=true, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<UserTomato> getUserTomato(@LanguageType String languageType, @CurrentUser User currentUser, String start, String end) {
        List list = this.userTomatoRecordService.findRecordListByUserIdAndDate(currentUser.getId(), start, end);
        return ResultModel.suc((Object)list, (String)languageType);
    }
}

