/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.note;

import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.model.note.NoteAddModel;
import com.ym.tlifang.note.Note;
import com.ym.tlifang.note.NoteUserRelation;
import com.ym.tlifang.service.note.NoteBookService;
import com.ym.tlifang.service.note.NoteService;
import com.ym.tlifang.service.note.NoteUserRelationService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.data.annotation.Reference;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"noteuserrelation"})
@Api(value="noteuserrelation", description="\u5206\u4eab\u7b14\u8bb0\u76f8\u5173")
public class NoteUserRelationController
extends BaseController {
    @Reference
    private NoteUserRelationService noteUserRelationService;
    @Reference
    private NoteBookService noteBookService;
    @Reference
    private NoteService noteService;

    @PostMapping
    @ApiOperation(value="\u5206\u4eab\u7b14\u8bb0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Note> shareNote(@LanguageType String languageType, @CurrentUser User user, @RequestBody NoteAddModel noteAddModel) {
        if (StringUtils.isEmpty((Object)noteAddModel.getNoteId()) || StringUtils.isEmpty((Object)noteAddModel.getAddNoteUsers())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Note note = this.noteService.findByIdAndDelFlagFalse(noteAddModel.getNoteId());
        if (StringUtils.isEmpty((Object)note)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTE_NO_EXIST, (String)languageType);
        }
        if (!user.getId().equals(note.getNoteBook().getOwnerId())) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_OWNER, (String)languageType);
        }
        NoteUserRelation noteUserRelation = new NoteUserRelation(noteAddModel.getNoteId(), user.getId(), Constants.NoteStatus.sharer.getType());
        this.noteUserRelationService.save(noteUserRelation);
        for (Long users : noteAddModel.getAddNoteUsers()) {
            noteUserRelation = new NoteUserRelation(noteAddModel.getNoteId(), users, Constants.NoteStatus.bySharer.getType());
            this.noteUserRelationService.save(noteUserRelation);
        }
        return ResultModel.suc((Object)note, (String)languageType);
    }
}

