/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.note;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.note.Note;
import com.ym.tlifang.note.NoteBook;
import com.ym.tlifang.service.note.NoteBookService;
import com.ym.tlifang.service.note.NoteService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"note"})
@Api(value="note", description="\u7b14\u8bb0\u76f8\u5173")
public class NoteController
extends BaseController {
    @Reference
    private NoteService noteService;
    @Reference
    private NoteBookService noteBookService;

    @PostMapping
    @ApiOperation(value="\u65b0\u5efa\u7b14\u8bb0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> createNote(@LanguageType String languageType, @CurrentUser User user, @RequestBody Note note) {
        if (StringUtils.isEmpty((Object)note.getNotebookId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        NoteBook noteBook = this.noteBookService.findByOwnerIdAndIdAndDelFlagFalse(user.getId(), note.getNotebookId());
        if (StringUtils.isEmpty((Object)noteBook)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        note = this.noteService.save(note);
        note.setNoteBook(noteBook);
        return ResultModel.suc((Object)note, (String)languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u7b14\u8bb0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> updateNote(@LanguageType String languageType, @CurrentUser User user, @RequestBody Note note) {
        NoteBook noteBook = this.noteBookService.findByOwnerIdAndIdAndDelFlagFalse(user.getId(), note.getNotebookId());
        if (StringUtils.isEmpty((Object)noteBook)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        Note noteInfo = this.noteService.findByIdAndDelFlagFalse(note.getId());
        if (StringUtils.isEmpty((Object)noteInfo)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTE_NO_EXIST, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)note.getContent())) {
            noteInfo.setContent(note.getContent());
        }
        if (!StringUtils.isEmpty((Object)note.getName())) {
            noteInfo.setName(note.getName());
        }
        noteInfo = this.noteService.save(noteInfo);
        noteInfo.setNoteBook(noteBook);
        return ResultModel.suc((Object)noteInfo, (String)languageType);
    }

    @DeleteMapping(value={"/{noteId}"})
    @ApiOperation(value="\u5220\u9664\u7b14\u8bb0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="noteId", value="\u7b14\u8bb0id", required=true, dataType="long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<NoteBook> delNote(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long noteId) {
        if (StringUtils.isEmpty((Object)noteId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Note note = this.noteService.findByIdAndDelFlagFalse(noteId);
        if (StringUtils.isEmpty((Object)note)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTE_NO_EXIST, (String)languageType);
        }
        NoteBook noteBook = this.noteBookService.findByOwnerIdAndIdAndDelFlagFalse(user.getId(), note.getNotebookId());
        if (StringUtils.isEmpty((Object)noteBook)) {
            return ResultModel.error((ResultStatus)ResultStatus.NOTEBOOK_NO_EXIST, (String)languageType);
        }
        note.setDelFlag(Boolean.valueOf(true));
        this.noteService.save(note);
        return ResultModel.ok((String)languageType);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u7b14\u8bb0\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="noteBookId", value="\u7b14\u8bb0\u672cid\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="type", value="\u6309\u66f4\u65b0\u65f6\u95f4\uff1a1\u6216\u8005\u521b\u5efa\u65f6\u95f4\u6392\u5e8f\uff1a0\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="string", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<NoteBook>> listNote(@LanguageType String languageType, @CurrentUser User user, Long noteBookId, Integer pageNo, Integer pageSize, String type) {
        PageInfo notePageInfo = this.noteService.findByNotebookIdAndUserIdAndDelFlagFalse(noteBookId, user.getId(), pageNo, pageSize, type);
        return ResultModel.suc((Object)notePageInfo, (String)languageType);
    }

    @GetMapping(value={"/{noteId}/info"})
    @ApiOperation(value="\u7b14\u8bb0\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="user", value="\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="noteId", value="\u7b14\u8bb0id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Note> noteInfo(@LanguageType String languageType, @CurrentUser User user, @PathVariable Long noteId) {
        if (StringUtils.isEmpty((Object)noteId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Note note = this.noteService.findByIdAndDelFlagFalse(noteId);
        return ResultModel.suc((Object)note, (String)languageType);
    }
}

