/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.file;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.file.FileEntity;
import com.ym.tlifang.model.file.UpdateFileNameModel;
import com.ym.tlifang.model.file.ValidateFileNameModel;
import com.ym.tlifang.project.ProjectUser;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.project.ProjectService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"files"})
@Api(value="files", description="\u6587\u4ef6\u76f8\u5173")
public class FileController
extends BaseController {
    @Reference
    private FileService fileService;
    @Reference
    private CompanyMemberInfoService memberInfoService;
    @Reference
    private ProjectUserService projectUserService;
    @Reference
    private ProjectService projectService;

    @PostMapping(value={"/{parentId}"})
    @ApiOperation(value="(\u65b0)\u65b0\u589e\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="parentId", value="\u9876\u7ea7\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> newAddFile(@PathVariable Long parentId, @RequestBody FileEntity fileEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)fileEntity) || StringUtils.isEmpty((Object)fileEntity.getName()) || StringUtils.isEmpty((Object)parentId) || StringUtils.isEmpty((Object)fileEntity.getUrl()) || StringUtils.isEmpty((Object)fileEntity.getType()) || StringUtils.isEmpty((Object)fileEntity.getKeyId()) || StringUtils.isEmpty((Object)fileEntity.getSize()) || StringUtils.isEmpty((Object)fileEntity.getMimetype()) || StringUtils.isEmpty((Object)fileEntity.getFolderId())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileService.newAddFile(currentUser.getId(), parentId, fileEntity, languageType);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> addFile(@RequestBody FileEntity fileEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @PutMapping(value={"/updateName"})
    @ApiOperation(value="(\u65b0)\u4fee\u6539\u6587\u4ef6\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> newUpdateFileName(@CurrentUser User currentUser, @RequestBody UpdateFileNameModel updateFileNameModel, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)updateFileNameModel) || StringUtils.isEmpty((Object)updateFileNameModel.getRootParentId()) || StringUtils.isEmpty((Object)updateFileNameModel.getFileId()) || StringUtils.isEmpty((Object)updateFileNameModel.getFileName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileService.newUpdateFileName(currentUser.getId(), updateFileNameModel, languageType);
    }

    @PutMapping
    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> updateFileName(@RequestBody FileEntity fileEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @PutMapping(value={"/{parentId}/updateFile"})
    @ApiOperation(value="(\u65b0)\u4fee\u6539\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body"), @ApiImplicitParam(name="parentId", value="\u9876\u7ea7\u6587\u4ef6\u5939id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> newUpdateFile(@CurrentUser User currentUser, @PathVariable Long parentId, @RequestBody FileEntity fileEntity, @LanguageType String languageType) {
        if (StringUtils.isEmpty((Object)fileEntity) || StringUtils.isEmpty((Object)fileEntity.getName()) || StringUtils.isEmpty((Object)fileEntity.getUrl()) || StringUtils.isEmpty((Object)fileEntity.getType()) || StringUtils.isEmpty((Object)fileEntity.getKeyId()) || StringUtils.isEmpty((Object)fileEntity.getSize()) || StringUtils.isEmpty((Object)fileEntity.getMimetype()) || StringUtils.isEmpty((Object)parentId)) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        return this.fileService.newUpdateFile(currentUser.getId(), parentId, fileEntity, languageType);
    }

    @PutMapping(value={"/updateFile"})
    @ApiOperation(value="\u4fee\u6539\u6587\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<FileEntity> updateFile(@RequestBody FileEntity fileEntity, @CurrentUser User currentUser, @LanguageType String languageType) {
        return ResultModel.error((ResultStatus)ResultStatus.FILE_PAGES_NOT_SUPPORT_ACCESS, (String)languageType);
    }

    @GetMapping
    @ApiOperation(value="\u9a8c\u8bc1\u6587\u4ef6\u540d\u79f0\u662f\u5426\u5b58\u5728")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel findFileFolderName(@RequestBody ValidateFileNameModel validateFileNameModel, @LanguageType String languageType) {
        if (validateFileNameModel == null || StringUtils.isEmpty((Object)validateFileNameModel.getName()) || validateFileNameModel.getKeyId() == null || StringUtils.isEmpty((Object)validateFileNameModel.getType())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        FileEntity fileEntity1 = this.fileService.findByNameAndFolderIdAndTypeAndKeyId(validateFileNameModel.getName(), validateFileNameModel.getFolderId(), validateFileNameModel.getType(), validateFileNameModel.getKeyId());
        if (fileEntity1 != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_NAME_EXIST, (String)languageType);
        }
        return ResultModel.ok();
    }

    private ResultModel vaildateFile(FileEntity fileEntity, FileEntity oldFileEntity, User currentUser, @LanguageType String languageType) {
        if (Constants.FileType.team.getType().equals(fileEntity.getType())) {
            CompanyMemberInfo companyMemberInfo = this.memberInfoService.findByCompanyIdAndUserIdAndStatus(fileEntity.getKeyId(), currentUser.getId(), Constants.AuditStatus.adopt.getType());
            if (companyMemberInfo == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if ((Constants.ManagerStatus.companyManager.getType().equals(companyMemberInfo.getManager()) || Constants.ManagerStatus.companyOrdinaryMember.getType().equals(companyMemberInfo.getManager())) && !currentUser.getId().equals(oldFileEntity.getCreateBy())) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_ONLY_UPDATE_OWN, (String)languageType);
            }
        }
        if (Constants.FileType.project.getType().equals(fileEntity.getType())) {
            ProjectUser projectUser = this.projectUserService.findByUserIdAndProjectIdAndDelFlagFalse(currentUser.getId(), oldFileEntity.getKeyId(), languageType);
            if (projectUser == null) {
                return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
            }
            if ((Constants.TypeStatus.projectManager.getType().equals(projectUser.getType()) || Constants.TypeStatus.projectOrdinaryMember.getType().equals(projectUser.getType())) && !currentUser.getId().equals(oldFileEntity.getCreateBy())) {
                return ResultModel.error((ResultStatus)ResultStatus.FILE_ONLY_UPDATE_OWN, (String)languageType);
            }
        }
        return ResultModel.ok();
    }

    @PostMapping(value={"/removeFileTo"})
    @ApiOperation(value="\u79fb\u52a8\u6240\u6709\u6587\u4ef6\u8fdb\u6587\u4ef6\u5939")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel removeFileTo() {
        List fileFolderEntities = this.fileService.saveAllFold();
        this.fileService.updateAll(fileFolderEntities);
        return ResultModel.ok();
    }
}

