/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.attendance;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.attendance.AttendanceOutside;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.excel.ExportExcel;
import com.ym.tlifang.service.attendance.AttendanceOutsideService;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.DateUtils;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.JwtUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceOutside"})
@Api(value="attendanceOutside", description="\u5916\u52e4\u8bb0\u5f55")
public class AttendanceOutsideController {
    @Reference
    private CompanyUserRelationService companyUserRelationService;
    @Reference
    private CompanyService companyService;
    @Reference
    private AttendanceOutsideService attendanceOutsideService;
    @Reference
    private UserService userService;
    @Reference
    private EnclosureService enclosureService;
    @Reference
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference
    private DynamicService dynamicService;

    @PostMapping
    @ApiOperation(value="\u5916\u52e4\u8bb0\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<AttendanceOutside> addAttendanceWeekday(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody AttendanceOutside attendanceOutside) {
        if (StringUtils.isEmpty((Object)attendanceOutside) || StringUtils.isEmpty((Object)attendanceOutside.getPosition())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        if (currentUser.getCurrentCompany() == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        if (attendanceOutside.getCompanyId() == null) {
            attendanceOutside.setCompanyId(currentUser.getCurrentCompany());
        }
        attendanceOutside.setUserId(currentUser.getId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        attendanceOutside.setDate(sdf.format(new Date()));
        List companyUserRelationList = this.companyUserRelationService.findByUserIdAndCompanyIdAndDelFlagFalse(currentUser.getId(), currentUser.getCurrentCompany());
        if (companyUserRelationList == null) {
            return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENT_OWNER_NO_EXIST, (String)languageType);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (CompanyUserRelation companyUserRelation : companyUserRelationList) {
            if (companyUserRelation.getCompanyId().equals(companyUserRelation.getDepartmentId()) && companyUserRelationList.size() != 1) continue;
            Company company = this.companyService.findById(companyUserRelation.getDepartmentId());
            stringBuffer.append(company.getName() + "/");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        attendanceOutside.setDepartArray(stringBuffer.toString());
        List photoIdList = attendanceOutside.getPhotoId();
        attendanceOutside = this.attendanceOutsideService.save(attendanceOutside);
        for (Long photoId : photoIdList) {
            EnclosureEntity enclosureEntity = this.enclosureService.findById(photoId);
            enclosureEntity.setType("6");
            enclosureEntity.setKeyId(attendanceOutside.getId());
            this.enclosureService.saveEnclosure(enclosureEntity);
        }
        this.dynamicService.saveDynamic(currentUser.getId(), Constants.DynamicParentType.company, currentUser.getCurrentCompany(), Constants.DynamicOriginatorType.attendanceOutside, attendanceOutside.getId(), Constants.DynamicType.attendanceOutside.getName(), Constants.DynamicActionType.attendanceOutside, Constants.DynamicType.attendanceOutside.getNameEnglish());
        return ResultModel.suc((Object)attendanceOutside, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/date"})
    @ApiOperation(value="\u5916\u52e4\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="date", value="\u65e5\u671f", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="name", value="\u90e8\u95e8\u540d\u5b57", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<AttendanceOutside>> getOne(@LanguageType String languageType, @CurrentUser User currentUser, String date, String name, Integer pageNo, Integer pageSize, Long companyId) {
        PageInfo attendanceOutsidePage = this.attendanceOutsideService.findByCompanyId(companyId == null ? currentUser.getCurrentCompany() : companyId, date, name, pageNo, pageSize);
        List attendanceOutsideList = attendanceOutsidePage.getRows();
        for (AttendanceOutside attendanceOutside : attendanceOutsideList) {
            List enclosureEntityList = this.enclosureService.findAppendix(attendanceOutside.getId(), "6");
            ArrayList<String> photos = new ArrayList<String>();
            for (EnclosureEntity enclosureEntity : enclosureEntityList) {
                photos.add(enclosureEntity.getUrl());
            }
            attendanceOutside.setPhotos(photos);
        }
        attendanceOutsidePage.setRows(attendanceOutsideList);
        return ResultModel.suc((Object)attendanceOutsidePage, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/date/all"})
    @ApiOperation(value="\u5916\u52e4\u79fb\u52a8\u7aef\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="type", value="\u7c7b\u578b 0\uff1a\u4e2a\u4eba\u8bb0\u5f55", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="monthDate", value="\u5e74\u6708", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=false, dataType="Long", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u9875\u7801", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u663e\u793a\u6570\u91cf", required=false, dataType="Integer", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<AttendanceOutside>> getAll(@LanguageType String languageType, @CurrentUser User currentUser, String type, String monthDate, Integer pageNo, Integer pageSize, Long companyId) throws Exception {
        return ResultModel.suc((Object)this.attendanceOutsideService.getOutsize(type, monthDate, companyId == null ? currentUser.getCurrentCompany() : companyId, currentUser.getId(), pageNo, pageSize), (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/date/all/times"})
    @ApiOperation(value="\u5916\u52e4\u6b21\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<Integer> getAll(@LanguageType String languageType, @CurrentUser User currentUser) throws Exception {
        String date = DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"yyyy-MM-dd"});
        Integer times = this.attendanceOutsideService.personMonth(currentUser.getCurrentCompany(), currentUser.getId(), date);
        return ResultModel.suc((Object)times, (String)languageType);
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5916\u52e4-\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="date", value="\u65e5\u671f", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="token", value="token\u4e32", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    public ResultModel addRecord(String languageType, String token, HttpServletResponse response, String date, Long companyId) throws Exception {
        Long userId = Long.valueOf(JwtUtil.checkTokenRtnUserId((String)token));
        List attendanceOutsideList = this.attendanceOutsideService.findByCompanyIdAndDate(companyId, date);
        if (attendanceOutsideList.size() == 0) {
            return ResultModel.error((ResultStatus)ResultStatus.OUTSIZE_NO_EXIST, (String)languageType);
        }
        ExportExcel exportExcel = null;
        Row row = null;
        String fileName = date + (Constants.LanguageType.US.getName().equals(languageType) ? "Field statistics.xlsx" : "\u5916\u52e4\u7edf\u8ba1.xlsx");
        ArrayList<String> strings = new ArrayList<String>();
        if (Constants.LanguageType.US.getName().equals(languageType)) {
            strings.add("Name");
            strings.add("Department");
            strings.add("Record location");
            strings.add("Remark");
            strings.add("Record time");
            exportExcel = new ExportExcel(date + "Field statistics", strings, "0", null);
            fileName = date + "Field statistics.xlsx";
        } else {
            strings.add("\u59d3\u540d");
            strings.add("\u6240\u5c5e\u90e8\u95e8");
            strings.add("\u6253\u5361\u5730\u70b9");
            strings.add("\u5907\u6ce8");
            strings.add("\u5916\u52e4\u6253\u5361\u65f6\u95f4");
            exportExcel = new ExportExcel(date + "\u5916\u52e4\u7edf\u8ba1", strings, "0", null);
        }
        for (AttendanceOutside attendanceOutside : attendanceOutsideList) {
            row = exportExcel.addRow();
            row.setHeightInPoints(22.0f);
            Map map = (Map)JsonUtil.jackson.readValue(attendanceOutside.getPosition(), Map.class);
            exportExcel.addCellColor(row, 0, null, attendanceOutside.getUser().getName());
            exportExcel.addCellColor(row, 1, null, attendanceOutside.getDepartArray());
            exportExcel.addCellColor(row, 2, null, map.get("address").toString());
            exportExcel.addCellColor(row, 3, null, attendanceOutside.getRemark());
            exportExcel.addCellColor(row, 4, null, attendanceOutside.getDate());
        }
        exportExcel.addListCellColor();
        exportExcel.write(response, fileName).dispose();
        return ResultModel.ok((String)languageType);
    }
}

