/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.approval;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.approval.ApprovalTemplate;
import com.ym.tlifang.approval.ApprovalTemplateForm;
import com.ym.tlifang.approval.ApprovalTemplateFormType;
import com.ym.tlifang.approval.ApprovalUserApply;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.model.approval.UserInfoModel;
import com.ym.tlifang.service.approval.ApprovalTemplateFormService;
import com.ym.tlifang.service.approval.ApprovalTemplateFormTypeService;
import com.ym.tlifang.service.approval.ApprovalTemplateService;
import com.ym.tlifang.service.approval.ApprovalUserApplyService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"approvalTemplates"})
@Api(value="approvalTemplates", description="\u5ba1\u6279\u6a21\u677f\u76f8\u5173")
public class ApprovalTemplateController {
    @Reference
    private ApprovalTemplateService approvalTemplateService;
    @Reference
    private ApprovalTemplateFormService approvalTemplateFormService;
    @Reference
    private ApprovalTemplateFormTypeService approvalTemplateFormTypeService;
    @Reference
    private CompanyService companyService;
    @Reference
    private ApprovalUserApplyService approvalUserApplyService;
    @Reference
    private DynamicService dynamicService;
    @Reference
    private UserService userService;

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u5ba1\u6279\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalTemplate> createApprovalTemplate(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody ApprovalTemplate approvalTemplate) {
        if (StringUtils.isEmpty((Object)approvalTemplate) || StringUtils.isEmpty((Object)approvalTemplate.getCompanyId()) || StringUtils.isEmpty((Object)approvalTemplate.getName())) {
            return ResultModel.error((ResultStatus)ResultStatus.PARAM_ERROR, (String)languageType);
        }
        Company company = this.companyService.findById(approvalTemplate.getCompanyId());
        if (company == null) {
            return ResultModel.error((ResultStatus)ResultStatus.COMPANY_NO_EXIST, (String)languageType);
        }
        List approvalTemplateFormList = approvalTemplate.getApprovalTemplateFormSet();
        approvalTemplate = this.approvalTemplateService.save(approvalTemplate);
        if (!StringUtils.isEmpty((Object)approvalTemplateFormList)) {
            for (ApprovalTemplateForm approvalTemplateForm : approvalTemplateFormList) {
                approvalTemplateForm.setTemplateId(approvalTemplate.getId());
                List approvalTemplateFormTypeSet = approvalTemplateForm.getApprovalTemplateFormTypeSet();
                approvalTemplateForm = this.approvalTemplateFormService.save(approvalTemplateForm);
                if (StringUtils.isEmpty((Object)approvalTemplateFormTypeSet)) continue;
                for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeSet) {
                    approvalTemplateFormType.setTemplateFormId(approvalTemplateForm.getId());
                    this.approvalTemplateFormTypeService.save(approvalTemplateFormType);
                }
            }
        }
        approvalTemplate = this.approvalTemplateService.findById(approvalTemplate.getId());
        return ResultModel.suc((Object)approvalTemplate, (String)languageType);
    }

    @PutMapping(value={"/{templateId}"})
    @ApiOperation(value="\u4fee\u6539\u5ba1\u6279\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="templateId", value="\u6a21\u677fid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalTemplate> updateApprovalTemplate(@LanguageType String languageType, @PathVariable Long templateId, @RequestBody ApprovalTemplate approvalTemplate) {
        ApprovalTemplate oldApprovalTemplate = this.approvalTemplateService.findById(templateId);
        if (StringUtils.isEmpty((Object)oldApprovalTemplate)) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_EXIST, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)oldApprovalTemplate.getDefaultis()) && oldApprovalTemplate.getDefaultis().equals("1")) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_UPDATE, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)approvalTemplate)) {
            oldApprovalTemplate.setName(approvalTemplate.getName());
            oldApprovalTemplate.setApprovalExplain(approvalTemplate.getApprovalExplain());
            if (StringUtils.isEmpty((Object)approvalTemplate.getApprovalTemplateFormSet()) || approvalTemplate.getApprovalTemplateFormSet().size() == 0) {
                List approvalTemplateFormList = this.approvalTemplateFormService.findListByTemplateId(templateId);
                for (ApprovalTemplateForm bean : approvalTemplateFormList) {
                    bean.setDelFlag(Boolean.valueOf(true));
                    this.approvalTemplateFormService.save(bean);
                    this.deleteApprovalTemplateFormTypes(bean.getId());
                }
            } else {
                List templateFormIds = this.approvalTemplateFormService.findIdsByTemplateId(templateId);
                List approvalTemplateFormList = approvalTemplate.getApprovalTemplateFormSet();
                for (ApprovalTemplateForm formData : approvalTemplateFormList) {
                    if (StringUtils.isEmpty((Object)formData.getId())) {
                        formData.setTemplateId(templateId);
                        List approvalTemplateFormTypeSet = formData.getApprovalTemplateFormTypeSet();
                        formData = this.approvalTemplateFormService.save(formData);
                        this.addApprovalTemplateFormTypes(formData.getId(), approvalTemplateFormTypeSet);
                        continue;
                    }
                    templateFormIds.remove(formData.getId());
                    ApprovalTemplateForm oldApprovalTemplateForm = this.approvalTemplateFormService.findById(formData.getId());
                    oldApprovalTemplateForm.init(formData);
                    List approvalTemplateFormTypeSet = formData.getApprovalTemplateFormTypeSet();
                    this.approvalTemplateFormService.save(oldApprovalTemplateForm);
                    this.updateApprovalTemplateFormTypes(formData, approvalTemplateFormTypeSet);
                }
                for (Long templateFormId : templateFormIds) {
                    ApprovalTemplateForm approvalTemplateForm = this.approvalTemplateFormService.findById(templateFormId);
                    approvalTemplateForm.setDelFlag(Boolean.valueOf(true));
                    this.approvalTemplateFormService.save(approvalTemplateForm);
                    this.deleteApprovalTemplateFormTypes(approvalTemplateForm.getId());
                }
            }
            oldApprovalTemplate = this.approvalTemplateService.save(oldApprovalTemplate);
        }
        return ResultModel.suc((Object)oldApprovalTemplate, (String)languageType);
    }

    @DeleteMapping(value={"/{templateId}"})
    @ApiOperation(value="\u5220\u9664\u5ba1\u6279\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="templateId", value="\u6a21\u677fid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel deleteApprovalTemplate(@LanguageType String languageType, @PathVariable Long templateId) {
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(templateId);
        if (StringUtils.isEmpty((Object)approvalTemplate)) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_EXIST, (String)languageType);
        }
        if (!StringUtils.isEmpty((Object)approvalTemplate.getDefaultis()) && approvalTemplate.getDefaultis().equals("1")) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_DELETE, (String)languageType);
        }
        approvalTemplate.setDelFlag(Boolean.valueOf(true));
        this.approvalTemplateService.save(approvalTemplate);
        List approvalUserApplyList = this.approvalUserApplyService.findByTemplateId(templateId);
        for (ApprovalUserApply approvalUserApply : approvalUserApplyList) {
            if (approvalUserApply.getState().equals(Constants.ApplyStatus.applyThrough.getType())) continue;
            approvalUserApply.setState(Constants.ApplyStatus.applyInterrupt.getType());
            this.approvalUserApplyService.save(approvalUserApply);
        }
        List approvalTemplateFormList = this.approvalTemplateFormService.findListByTemplateId(templateId);
        for (ApprovalTemplateForm approvalTemplateForm : approvalTemplateFormList) {
            approvalTemplateForm.setDelFlag(Boolean.valueOf(true));
            this.approvalTemplateFormService.save(approvalTemplateForm);
            List approvalTemplateFormTypeList = this.approvalTemplateFormTypeService.findListByTemplateFormId(approvalTemplateForm.getId());
            for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeList) {
                approvalTemplateFormType.setDelFlag(Boolean.valueOf(true));
                this.approvalTemplateFormTypeService.save(approvalTemplateFormType);
            }
        }
        return ResultModel.ok((String)languageType);
    }

    @GetMapping(value={"/{templateId}"})
    @ApiOperation(value="\u67e5\u770b\u5ba1\u6279\u6a21\u677f\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="templateId", value="\u6a21\u677fid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalTemplate> getApprovalTemplate(@LanguageType String languageType, @PathVariable Long templateId) throws IOException {
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(templateId);
        if (StringUtils.isEmpty((Object)approvalTemplate)) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_EXIST, (String)languageType);
        }
        if (Constants.LanguageType.US.getName().equals(languageType) && approvalTemplate.getEnName() != null) {
            ArrayList<ApprovalTemplateForm> approvalTemplateFormList = new ArrayList<ApprovalTemplateForm>();
            for (ApprovalTemplateForm approvalTemplateForm : approvalTemplate.getApprovalTemplateFormSet()) {
                ArrayList<ApprovalTemplateFormType> approvalTemplateFormTypeList = new ArrayList<ApprovalTemplateFormType>();
                for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateForm.getApprovalTemplateFormTypeSet()) {
                    approvalTemplateFormType.setValue(approvalTemplateFormType.getEnName());
                    approvalTemplateFormType.setLabel(approvalTemplateFormType.getEnName());
                    approvalTemplateFormTypeList.add(approvalTemplateFormType);
                }
                approvalTemplateForm.setApprovalTemplateFormTypeSet(approvalTemplateFormTypeList);
                approvalTemplateForm.setFieldName(approvalTemplateForm.getEnName());
                approvalTemplateFormList.add(approvalTemplateForm);
            }
            approvalTemplate.setApprovalTemplateFormSet(approvalTemplateFormList);
            approvalTemplate.setName(approvalTemplate.getEnName());
        }
        if (!StringUtils.isEmpty((Object)approvalTemplate.getUserIds())) {
            ArrayList<UserInfoModel> userInfoModels = new ArrayList<UserInfoModel>();
            List readValue = (List)JsonUtil.jackson.readValue(approvalTemplate.getUserIds(), List.class);
            for (Integer userId : readValue) {
                User user = this.userService.findById(Long.valueOf(userId.intValue()));
                UserInfoModel userInfoModel = new UserInfoModel(user.getId(), user.getAvatar(), user.getName());
                userInfoModels.add(userInfoModel);
                approvalTemplate.setUserInfoList(userInfoModels);
            }
        }
        return ResultModel.suc((Object)approvalTemplate, (String)languageType);
    }

    @GetMapping(value={"/company/{companyId}"})
    @ApiOperation(value="\u5ba1\u6279\u6a21\u677f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="state", value="\u6a21\u677f\u72b6\u6001 \u4e0d\u4f20\u9ed8\u8ba4\u5168\u90e8 1\uff1a \u4f7f\u7528\u4e2d ", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="companyId", value="\u516c\u53f8id", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<List<ApprovalTemplate>> getApprovalTemplateList(@LanguageType String languageType, @PathVariable Long companyId, String state) throws IOException {
        ArrayList<ApprovalTemplate> approvalTemplates = new ArrayList<ApprovalTemplate>();
        List approvalTemplateList = StringUtils.isNotBlank((String)state) && state.equals("1") ? this.approvalTemplateService.findByCompanyIdAndState(companyId, state) : this.approvalTemplateService.findByCompanyId(companyId);
        if (approvalTemplateList != null) {
            for (ApprovalTemplate approvalTemplate : approvalTemplateList) {
                if (Constants.LanguageType.US.getName().equals(languageType) && approvalTemplate.getEnName() != null) {
                    ArrayList<ApprovalTemplateForm> approvalTemplateFormList = new ArrayList<ApprovalTemplateForm>();
                    for (ApprovalTemplateForm approvalTemplateForm : approvalTemplate.getApprovalTemplateFormSet()) {
                        ArrayList<ApprovalTemplateFormType> approvalTemplateFormTypeList = new ArrayList<ApprovalTemplateFormType>();
                        for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateForm.getApprovalTemplateFormTypeSet()) {
                            approvalTemplateFormType.setValue(approvalTemplateFormType.getEnName());
                            approvalTemplateFormType.setLabel(approvalTemplateFormType.getEnName());
                            approvalTemplateFormTypeList.add(approvalTemplateFormType);
                        }
                        approvalTemplateForm.setApprovalTemplateFormTypeSet(approvalTemplateFormTypeList);
                        approvalTemplateForm.setFieldName(approvalTemplateForm.getEnName());
                        approvalTemplateFormList.add(approvalTemplateForm);
                    }
                    approvalTemplate.setName(approvalTemplate.getEnName());
                }
                if (StringUtils.isEmpty((Object)approvalTemplate.getUserIds())) continue;
                ArrayList<UserInfoModel> userInfoModels = new ArrayList<UserInfoModel>();
                List readValue = (List)JsonUtil.jackson.readValue(approvalTemplate.getUserIds(), List.class);
                for (Integer userId : readValue) {
                    User user = this.userService.findById(Long.valueOf(userId.intValue()));
                    UserInfoModel userInfoModel = new UserInfoModel(user.getId(), user.getAvatar(), user.getName());
                    userInfoModels.add(userInfoModel);
                    approvalTemplate.setUserInfoList(userInfoModels);
                    approvalTemplates.add(approvalTemplate);
                }
            }
        }
        return ResultModel.suc((Object)approvalTemplateList, (String)languageType);
    }

    @PutMapping(value={"/status/{templateId}"})
    @ApiOperation(value="\u542f\u7528/\u505c\u7528\u5ba1\u6279\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="templateId", value="\u6a21\u677fid", required=true, dataType="Long", paramType="path")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalTemplate> operateApprovalTemplateList(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long templateId) {
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(templateId);
        if (approvalTemplate.getState().equals(Constants.TemplateStatus.templateUsing.getType())) {
            approvalTemplate.setState(Constants.TemplateStatus.templateNotUse.getType());
            List approvalUserApplyList = this.approvalUserApplyService.findByTemplateId(templateId);
            for (ApprovalUserApply approvalUserApply : approvalUserApplyList) {
                if (approvalUserApply.getState().equals(Constants.ApplyStatus.applyThrough.getType())) continue;
                approvalUserApply.setState(Constants.ApplyStatus.applyInterrupt.getType());
                this.approvalUserApplyService.save(approvalUserApply);
            }
        } else {
            approvalTemplate.setState(Constants.TemplateStatus.templateUsing.getType());
        }
        approvalTemplate = this.approvalTemplateService.save(approvalTemplate);
        this.dynamicService.saveDynamic(currentUser.getId(), Constants.DynamicParentType.company, approvalTemplate.getCompanyId(), Constants.DynamicOriginatorType.approval, approvalTemplate.getId(), Constants.TemplateStatus.templateUsing.getType().equals(approvalTemplate.getState()) ? Constants.DynamicType.approvalUse.getName() : Constants.DynamicType.approvalStop.getName(), Constants.DynamicActionType.approval, Constants.TemplateStatus.templateUsing.getType().equals(approvalTemplate.getState()) ? Constants.DynamicType.approvalUse.getNameEnglish() : Constants.DynamicType.approvalStop.getNameEnglish());
        return ResultModel.suc((Object)approvalTemplate, (String)languageType);
    }

    @PutMapping(value={"/defaultCC/{templateId}"})
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u6284\u9001\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="templateId", value="\u6a21\u677fid", required=true, dataType="Long", paramType="path"), @ApiImplicitParam(name="userIds", value="\u7528\u6237ids", required=true, dataType="String", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<ApprovalTemplate> defaultCC(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable Long templateId, String userIds) {
        ApprovalTemplate approvalTemplate = this.approvalTemplateService.findById(templateId);
        if (StringUtils.isEmpty((Object)approvalTemplate)) {
            return ResultModel.error((ResultStatus)ResultStatus.TEMPLATE_NO_EXIST, (String)languageType);
        }
        String[] str = userIds.split(",");
        approvalTemplate.setUserIds(StringUtils.isEmpty((Object)str[0]) ? null : userIds);
        this.approvalTemplateService.save(approvalTemplate);
        return ResultModel.suc((Object)approvalTemplate, (String)languageType);
    }

    private void deleteApprovalTemplateFormTypes(Long templateFormId) {
        List approvalTemplateFormTypeList = this.approvalTemplateFormTypeService.findListByTemplateFormId(templateFormId);
        for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeList) {
            approvalTemplateFormType.setDelFlag(Boolean.valueOf(true));
            this.approvalTemplateFormTypeService.save(approvalTemplateFormType);
        }
    }

    private void addApprovalTemplateFormTypes(Long templateFormId, List<ApprovalTemplateFormType> approvalTemplateFormTypeSet) {
        if (!StringUtils.isEmpty(approvalTemplateFormTypeSet)) {
            for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeSet) {
                approvalTemplateFormType.setTemplateFormId(templateFormId);
                this.approvalTemplateFormTypeService.save(approvalTemplateFormType);
            }
        }
    }

    private void updateApprovalTemplateFormTypes(ApprovalTemplateForm templateForm, List<ApprovalTemplateFormType> approvalTemplateFormTypeSet) {
        if (StringUtils.isEmpty(approvalTemplateFormTypeSet) || approvalTemplateFormTypeSet.size() == 0) {
            List approvalTemplateFormTypeList = this.approvalTemplateFormTypeService.findListByTemplateFormId(templateForm.getId());
            for (ApprovalTemplateFormType approvalTemplateFormType : approvalTemplateFormTypeList) {
                approvalTemplateFormType.setDelFlag(Boolean.valueOf(true));
                this.approvalTemplateFormTypeService.save(approvalTemplateFormType);
            }
        } else {
            List templateFormTypeIds = this.approvalTemplateFormTypeService.findIdsByTemplateFormId(templateForm.getId());
            List approvalTemplateFormTypes = templateForm.getApprovalTemplateFormTypeSet();
            for (ApprovalTemplateFormType templateFormType : approvalTemplateFormTypes) {
                if (StringUtils.isEmpty((Object)templateFormType.getId())) {
                    templateFormType.setTemplateFormId(templateForm.getId());
                    this.approvalTemplateFormTypeService.save(templateFormType);
                    continue;
                }
                templateFormTypeIds.remove(templateFormType.getId());
                ApprovalTemplateFormType oldTemplateFormType = this.approvalTemplateFormTypeService.findById(templateFormType.getId());
                oldTemplateFormType.setLabel(templateFormType.getLabel());
                oldTemplateFormType.setValue(templateFormType.getValue());
                this.approvalTemplateFormTypeService.save(oldTemplateFormType);
            }
            for (Long templateFormTypeId : templateFormTypeIds) {
                ApprovalTemplateFormType templateFormType = this.approvalTemplateFormTypeService.findById(templateFormTypeId);
                templateFormType.setDelFlag(Boolean.valueOf(true));
                this.approvalTemplateFormTypeService.save(templateFormType);
            }
        }
    }
}

