/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.push;

import com.alibaba.dubbo.config.annotation.Service;
import com.turo.pushy.apns.DeliveryPriority;
import com.turo.pushy.apns.PushType;
import com.ym.tlifang.model.sys.PushParamsModel;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.push.apns.IosPush;
import com.ym.tlifang.service.push.umeng.AndroidNotification;
import com.ym.tlifang.service.push.umeng.PushClient;
import com.ym.tlifang.service.push.umeng.UmengNotification;
import com.ym.tlifang.service.push.umeng.android.AndroidUnicast;
import com.ym.tlifang.util.JsonUtil;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.util.push.apns.ApnsConfig;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=XgPushService.class, timeout=30000, retries=-1)
public class XgPushServiceImpl
implements XgPushService {
    @Autowired
    private ApnsConfig apnsConfig;
    private static Logger logger = LoggerFactory.getLogger(XgPushServiceImpl.class);
    private String certificatePath = "tlifangPushDev.p12";
    private static final String AUTH_KEY_FCM = "AAAAu7Kl9FI:APA91bGJ6ZKtZYknN2EBndCiUPRjWFRrWTket-7Gq2midwH_ZESIPvrg4T4rGqJahD8F2GVzdXF09vIjtEJY2vUtqNVxupGWG8mhaWblDxPa3zsXdtkGyYuQlvzvPVvSqRd7k8yGC1tR";
    private static final String API_URL_FCM = "https://fcm.googleapis.com/fcm/send";
    private static final String UMENG_APP_KEY = "5efbe88e570df3541c0000d6";
    private static final String UMENG_APP_SECRET = "pobf3eypsghlszzpw4hds7xma5cs7e8i";

    public void pushTokenIosOrAndroidBelievers(String pushToken, String title, String content, Map<String, Object> custom, String intent) {
        try {
            if (StringUtils.isNotBlank((String)pushToken) && pushToken.length() == 44) {
                PushClient client = new PushClient();
                AndroidUnicast unicast = new AndroidUnicast(UMENG_APP_KEY, UMENG_APP_SECRET);
                unicast.setDeviceToken(pushToken);
                unicast.setProductionMode();
                if (custom != null) {
                    for (Map.Entry<String, Object> entry : custom.entrySet()) {
                        unicast.setExtraField(entry.getKey(), entry.getValue() + "");
                    }
                }
                unicast.setTitle(title);
                unicast.setText(content);
                unicast.goAppAfterOpen();
                unicast.setUrl(intent);
                unicast.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
                boolean b = client.send((UmengNotification)unicast);
                logger.debug("umeng chat return:" + b);
            } else {
                this.apnsMessage(pushToken, custom, title, content);
            }
        }
        catch (Exception e) {
            logger.error("umeng chat or apns push failure", (Throwable)e);
        }
    }

    public void pushTokenForeign(String pushToken, String title, String content, Boolean showFlag) {
        try {
            if (StringUtils.isNotBlank((String)pushToken) && pushToken.length() == 64) {
                this.apnsMessage(pushToken, null, title, content);
            } else {
                URL url = new URL(API_URL_FCM);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setUseCaches(false);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setConnectTimeout(10000);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Authorization", "key=AAAAu7Kl9FI:APA91bGJ6ZKtZYknN2EBndCiUPRjWFRrWTket-7Gq2midwH_ZESIPvrg4T4rGqJahD8F2GVzdXF09vIjtEJY2vUtqNVxupGWG8mhaWblDxPa3zsXdtkGyYuQlvzvPVvSqRd7k8yGC1tR");
                JSONObject json = new JSONObject();
                json.put("to", (Object)pushToken);
                JSONObject info = new JSONObject();
                if (showFlag.booleanValue()) {
                    info.put("title", (Object)title);
                    info.put("body", (Object)content);
                    json.put("notification", (Object)info);
                } else {
                    PushParamsModel pushParamsModel = new PushParamsModel(title, content);
                    info.put("body", (Object)JsonUtil.jackson.writeValueAsString((Object)pushParamsModel));
                    json.put("data", (Object)info);
                }
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(json.toString());
                System.out.println(json.toString());
                wr.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
                wr.close();
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void pushAllBelievers(String title, String content, Map<String, Object> custom) {
        Object ret = null;
    }

    private void apnsMessage(String pushToken, Map<String, Object> custom, String title, String content) throws Exception {
        try {
            String certificatePath = this.apnsConfig.getApnsXTCertificatePath();
            String topicBundleId = this.apnsConfig.getTopicXTBundleId();
            String sound = "default";
            IosPush.push((String)certificatePath, (Boolean)this.apnsConfig.getProduction(), (String)pushToken, (String)title, (String)content, (boolean)Boolean.FALSE, custom, (int)1, (DeliveryPriority)DeliveryPriority.IMMEDIATE, (PushType)PushType.ALERT, (String)topicBundleId, (String)sound);
        }
        catch (Exception e) {
            logger.error("iOS13 apns push failure: ,content:" + content + ",deviceToken:" + pushToken, (Throwable)e);
        }
    }
}

