/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.file;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.dao.file.FileFolderDao;
import com.ym.tlifang.file.FileEntity;
import com.ym.tlifang.file.FileFolderEntity;
import com.ym.tlifang.file.FileFolderPowerEntity;
import com.ym.tlifang.model.file.AddRootFileFolderModel;
import com.ym.tlifang.model.file.FileFolderInfoModel;
import com.ym.tlifang.model.file.FileInfoModel;
import com.ym.tlifang.model.file.PowerUserInfo;
import com.ym.tlifang.model.file.UpdateFileFolderNameModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.file.FileFolderPowerService;
import com.ym.tlifang.service.file.FileFolderService;
import com.ym.tlifang.service.file.FileService;
import com.ym.tlifang.service.project.ProjectUserService;
import com.ym.tlifang.service.system.DynamicService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=FileFolderService.class, timeout=30000, retries=-1)
public class FileFolderServiceImpl
extends AbstractBaseService<FileFolderEntity, FileFolderDao>
implements FileFolderService {
    @Autowired
    private FileService fileService;
    @Autowired
    private DynamicService dynamicService;
    @Autowired
    private UserService userService;
    @Autowired
    private FileFolderPowerService fileFolderPowerService;
    @Autowired
    private CompanyUserRelationService companyUserRelationService;
    @Autowired
    private ProjectUserService projectUserService;

    public FileFolderEntity sava(FileFolderEntity entity) {
        Long id = entity.getId();
        entity = (FileFolderEntity)((FileFolderDao)this.dao).save((Object)entity);
        User updateUser = this.userService.findById(entity.getUpdateBy());
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("name", updateUser.getName());
        userMap.put("id", updateUser.getId());
        userMap.put("avatar", updateUser.getAvatar());
        entity.setUpdateByMap(userMap);
        if (id == null && Constants.FileType.project.getType().equals(entity.getType())) {
            this.dynamicService.saveDynamic(entity.getUpdateBy(), Constants.DynamicParentType.project, entity.getKeyId(), Constants.DynamicOriginatorType.fileFolder, entity.getId(), Constants.DynamicType.createFile.getName(), Constants.DynamicActionType.fileFolderAdd, Constants.DynamicType.createFile.getNameEnglish());
        }
        return entity;
    }

    public FileFolderEntity findById(Long id) {
        return ((FileFolderDao)this.dao).findByIdAndDelFlag(id, Boolean.valueOf(false));
    }

    public FileFolderEntity findByName(String name) {
        return ((FileFolderDao)this.dao).findByNameAndDelFlag(name, Boolean.valueOf(false));
    }

    public FileFolderEntity findByNameAndParentId(String name, Long parentId) {
        return ((FileFolderDao)this.dao).findByNameAndParentIdAndDelFlag(name, parentId, Boolean.valueOf(false));
    }

    public List<FileFolderEntity> findByChilder(Long parendId) {
        return ((FileFolderDao)this.dao).findByParentIdAndDelFlagFalse(parendId);
    }

    public List<FileFolderEntity> findByParentIdsLike(String parentId) {
        return ((FileFolderDao)this.dao).findByParentIdsLikeAndDelFlag(parentId, Boolean.valueOf(false));
    }

    public List<FileFolderEntity> findByParentIdAndDelFlag(Long parentId) {
        return ((FileFolderDao)this.dao).findByParentIdAndDelFlagFalse(parentId);
    }

    public FileFolderEntity findByKeyIdAndTypeAndParentIdAndName(Long keyId, String type, Long parentId, String name) {
        return ((FileFolderDao)this.dao).findByKeyIdAndTypeAndParentIdAndNameAndDelFlag(keyId, type, parentId, name, Boolean.valueOf(false));
    }

    public List<String> findNameByKeyIdAndTypeAndParentId(Long keyId, String type, Long parentId) {
        return ((FileFolderDao)this.dao).findNameByKeyIdAndTypeAndParentId(keyId, type, parentId);
    }

    public void autoGenerateFolder(Long keyId, String type, Long userId, String status, String languageType) {
        FileFolderEntity fileFolderEntity = new FileFolderEntity();
        fileFolderEntity.setName(Constants.LanguageType.US.getName().equals(languageType) ? "Default folder" : "\u9ed8\u8ba4\u6587\u4ef6\u5939");
        fileFolderEntity.setKeyId(keyId);
        fileFolderEntity.setType(type);
        fileFolderEntity.setCreateBy(userId);
        fileFolderEntity.setUpdateBy(userId);
        fileFolderEntity.setDefaultValue("1");
        fileFolderEntity.setParentId(Long.valueOf(0L));
        fileFolderEntity = (FileFolderEntity)((FileFolderDao)this.dao).save((Object)fileFolderEntity);
        if ("1".equals(type) || "2".equals(type) && "1".equals(status)) {
            FileFolderPowerEntity fileFolderPowerEntity = new FileFolderPowerEntity(userId, "0", fileFolderEntity.getId(), userId, userId);
            this.fileFolderPowerService.saveEntity(fileFolderPowerEntity);
        }
    }

    public Map<String, Object> findMapByKeyIdAndTypeAndParentId(User user, Long keyId, String type, Long parentId, Long rootParentId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List folderEntityList = new ArrayList();
        List folderEntityObject = null;
        List fileEntityList = new ArrayList();
        List fileEntityObject = null;
        if (parentId == 0L) {
            folderEntityObject = ((FileFolderDao)this.dao).findByKeyIdAndTypeAndParentIdAndDelFlag(user.getId(), keyId, type, parentId);
            if (folderEntityObject != null) {
                folderEntityList = this.listFileFolderInfoModel(folderEntityObject);
            }
        } else {
            folderEntityObject = ((FileFolderDao)this.dao).findByParentIdAndUserIdAndDelFlag(parentId, user.getId(), rootParentId);
            if (folderEntityObject != null) {
                folderEntityList = this.listFileFolderInfoModel(folderEntityObject);
            }
            if ((fileEntityObject = this.fileService.findByFolderIdObject(parentId, user.getId(), rootParentId)) != null) {
                fileEntityList = this.listFileInfoModel(fileEntityObject);
            }
        }
        map.put("dirs", folderEntityList);
        map.put("files", fileEntityList);
        FileFolderEntity fileFolderEntity = ((FileFolderDao)this.dao).findByIdAndDelFlag(parentId, Boolean.valueOf(false));
        if (fileFolderEntity != null) {
            map.put("name", fileFolderEntity.getName());
            map.put("id", fileFolderEntity.getId());
            map.put("path", this.getFolderNavigationList(fileFolderEntity.getParentIds() == null ? parentId.toString() : fileFolderEntity.getParentIds() + "," + parentId));
        }
        return map;
    }

    public ResultModel<Map<String, Object>> getFileAndFolderInfo(User user, Long keyId, Long parentId, String type, String languageType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List folderEntityList = null;
        List fileEntityList = null;
        if (parentId == 0L) {
            folderEntityList = ((FileFolderDao)this.dao).findByKeyIdAndTypeAndParentIdAndDelFlagFalse(keyId, type, Long.valueOf(0L));
            fileEntityList = this.fileService.findByKeyIdAndTypeAndFolderId(keyId, type);
        } else {
            folderEntityList = ((FileFolderDao)this.dao).findByParentIdAndDelFlagFalse(parentId);
            fileEntityList = this.fileService.findByFolderId(parentId);
        }
        for (FileFolderEntity fileFolderEntity : folderEntityList) {
            user = this.userService.findById(fileFolderEntity.getUpdateBy());
            fileFolderEntity.setUpdateByMap(this.getUserMapInfo(user));
        }
        for (FileEntity fileEntity : fileEntityList) {
            user = this.userService.findById(fileEntity.getUpdateBy());
            fileEntity.setUpdateByMap(this.getUserMapInfo(user));
        }
        map.put("dirs", folderEntityList);
        map.put("files", fileEntityList);
        FileFolderEntity fileFolderEntity = ((FileFolderDao)this.dao).findByIdAndDelFlag(parentId, Boolean.valueOf(false));
        if (fileFolderEntity != null) {
            map.put("name", fileFolderEntity.getName());
            map.put("id", fileFolderEntity.getId());
            map.put("path", this.getFolderNavigationList(fileFolderEntity.getParentIds() == null && parentId != 0L ? parentId + "" : fileFolderEntity.getParentIds() + "," + parentId));
        }
        return ResultModel.suc(map);
    }

    public FileFolderEntity findByIdAndParentId(Long id, Long parentId, Boolean delFlag) {
        return ((FileFolderDao)this.dao).findByIdAndParentIdAndDelFlag(id, parentId, delFlag);
    }

    public ResultModel<List<FileFolderEntity>> fileFolderTree(Long userId, Long parentId, String languageType) {
        FileFolderEntity fileFolderEntity = ((FileFolderDao)this.dao).findByUserIdAndKeyIdAndType(userId, parentId);
        if (fileFolderEntity != null) {
            List parentList = ((FileFolderDao)this.dao).findByParentIdAndDelFlagFalse(parentId);
            List tree = this.getChildren(parentList);
            return ResultModel.suc((Object)parentList);
        }
        return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_NO_EXIST, (String)languageType);
    }

    public ResultModel<List<FileFolderEntity>> folderPersonalTree(Long userId, Long keyId, String type, String languageType) {
        List parentList = ((FileFolderDao)this.dao).findByKeyIdAndTypeAndParentIdAndDelFlagFalse(keyId, type, Long.valueOf(0L));
        List tree = this.getChildren(parentList);
        return ResultModel.suc((Object)parentList);
    }

    private List<FileFolderEntity> getChildren(List<FileFolderEntity> parentList) {
        for (FileFolderEntity fileFolderEntity : parentList) {
            List childrenList = this.findByParentIdAndDelFlag(fileFolderEntity.getId());
            fileFolderEntity.setChildren(childrenList);
            if (childrenList == null) continue;
            this.getChildren(childrenList);
        }
        return parentList;
    }

    private List<Map<String, Object>> getFolderNavigationList(String parentids) {
        String[] strings;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String folderId : strings = StringUtils.arrayEmpty((String)parentids)) {
            FileFolderEntity fileFolderEntity = ((FileFolderDao)this.dao).findByIdAndDelFlag(Long.valueOf(folderId), Boolean.valueOf(false));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", fileFolderEntity.getId());
            map.put("name", fileFolderEntity.getName());
            list.add(map);
        }
        return list;
    }

    public FileFolderEntity findByMongodbId(String mongodbId) {
        return ((FileFolderDao)this.dao).findByMongodbId(mongodbId);
    }

    public void updateParentIdsById(Long id, String parentIds) {
        ((FileFolderDao)this.dao).updateParentIdsById(id, parentIds);
    }

    public Map<String, Object> findByRootParentIdAndName(Long rootParentId, String name, Long userId) {
        HashMap<String, Object> seachMap = new HashMap<String, Object>();
        List seachFolderEntityList = new ArrayList();
        List seachFolderEntityObject = null;
        List seachFileEntityList = new ArrayList();
        List seachFileEntityObject = null;
        name = "%" + name + "%";
        seachFolderEntityObject = ((FileFolderDao)this.dao).findFileFolderByRootParentIdAndName("%," + rootParentId + ",%", rootParentId, name, userId);
        if (seachFolderEntityObject != null) {
            seachFolderEntityList = this.listFileFolderInfoModel(seachFolderEntityObject);
        }
        if ((seachFileEntityObject = this.fileService.findByRootParentIdAndNameLike("%," + rootParentId + ",%", rootParentId, name, userId)) != null) {
            seachFileEntityList = this.listFileInfoModel(seachFileEntityObject);
        }
        seachMap.put("dirs", seachFolderEntityList);
        seachMap.put("files", seachFileEntityList);
        return seachMap;
    }

    public ResultModel addRootFileFolder(AddRootFileFolderModel addRootFileFolderModel, String languageType) throws Exception {
        Boolean aBoolean = this.verifyUser(addRootFileFolderModel.getAdminId(), addRootFileFolderModel.getType(), addRootFileFolderModel.getKeyId(), addRootFileFolderModel.getCompanyId());
        if (!aBoolean.booleanValue()) {
            return ResultModel.error((ResultStatus)ResultStatus.SYS_BUSY, (String)languageType);
        }
        FileFolderEntity fileFolderEntity = new FileFolderEntity(addRootFileFolderModel.getFileFolderName(), Long.valueOf(0L), null, null, addRootFileFolderModel.getType(), addRootFileFolderModel.getKeyId(), "0", addRootFileFolderModel.getAdminId(), addRootFileFolderModel.getAdminId(), addRootFileFolderModel.getCompanyId());
        fileFolderEntity = this.sava(fileFolderEntity);
        FileFolderPowerEntity fileFolderPowerEntity = new FileFolderPowerEntity(addRootFileFolderModel.getAdminId(), "0", fileFolderEntity.getId(), addRootFileFolderModel.getAdminId(), addRootFileFolderModel.getAdminId());
        this.fileFolderPowerService.saveEntity(fileFolderPowerEntity);
        for (PowerUserInfo powerUserInfo : addRootFileFolderModel.getPowerUserInfoList()) {
            if ("0".equals(powerUserInfo.getPowerType())) continue;
            aBoolean = this.verifyUser(powerUserInfo.getId(), addRootFileFolderModel.getType(), addRootFileFolderModel.getKeyId(), addRootFileFolderModel.getCompanyId());
            if (!aBoolean.booleanValue()) {
                throw new Exception();
            }
            FileFolderPowerEntity fileFolderPower = new FileFolderPowerEntity(powerUserInfo.getId(), powerUserInfo.getPowerType(), fileFolderEntity.getId(), addRootFileFolderModel.getAdminId(), addRootFileFolderModel.getAdminId());
            this.fileFolderPowerService.saveEntity(fileFolderPower);
        }
        return ResultModel.ok();
    }

    public ResultModel<FileFolderEntity> newUpdateFileFolder(Long userId, UpdateFileFolderNameModel updateFileFolderNameModel, String languageType) {
        FileFolderEntity fileFolderEntity = this.findById(updateFileFolderNameModel.getFileFolderId());
        if (fileFolderEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NO_EXIST, (String)languageType);
        }
        FileFolderEntity validerFileFolderName = this.findByKeyIdAndTypeAndParentIdAndName(fileFolderEntity.getKeyId(), fileFolderEntity.getType(), fileFolderEntity.getParentId(), updateFileFolderNameModel.getFileFolderName());
        if (validerFileFolderName != null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_NAME_EXIST, (String)languageType);
        }
        FileFolderPowerEntity fileFolderPowerEntity = this.fileFolderPowerService.findByFileFolderIdAndUserIdAndDelFlagFalse(updateFileFolderNameModel.getRootParentId(), userId);
        if (fileFolderPowerEntity == null) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_POWER_USER_EXIST, (String)languageType);
        }
        if ("2".equals(fileFolderPowerEntity.getPowerType())) {
            return ResultModel.error((ResultStatus)ResultStatus.FILE_FOLDER_ADMIN_NO_EXIST, (String)languageType);
        }
        fileFolderEntity.setName(updateFileFolderNameModel.getFileFolderName());
        fileFolderEntity.setUpdateBy(userId);
        fileFolderEntity.setUpdateDate(new Date());
        return ResultModel.suc((Object)this.sava(fileFolderEntity));
    }

    public Map<String, Object> findByKeyIdAndTypeAndName(Long keyId, String type, String name) {
        User user;
        HashMap<String, Object> map = new HashMap<String, Object>();
        List folderEntityList = null;
        List fileEntityList = null;
        name = "%" + name + "%";
        folderEntityList = this.findByKeyIdAndTypeAndNameLike(keyId, type, name);
        fileEntityList = this.fileService.findByKeyIdAndTypeAndNameLike(keyId, type, name);
        for (FileFolderEntity fileFolderEntity : folderEntityList) {
            user = this.userService.findById(fileFolderEntity.getUpdateBy());
            fileFolderEntity.setUpdateByMap(this.getUserMapInfo(user));
        }
        for (FileEntity fileEntity : fileEntityList) {
            user = this.userService.findById(fileEntity.getUpdateBy());
            fileEntity.setUpdateByMap(this.getUserMapInfo(user));
        }
        map.put("dirs", folderEntityList);
        map.put("files", fileEntityList);
        return map;
    }

    public List<FileFolderEntity> findByKeyIdAndTypeAndNameLike(Long keyId, String type, String name) {
        return ((FileFolderDao)this.dao).findByKeyIdAndTypeAndNameLikeAndDelFlagFalse(keyId, type, name);
    }

    Boolean verifyUser(Long adminId, String type, Long keyId, Long companyId) {
        if ("1".equals(type)) {
            return this.companyUserRelationService.findFlagByUserIdAndCompanyId(adminId, companyId);
        }
        if ("2".equals(type)) {
            return this.projectUserService.findByUserIdAndProjectId(adminId, keyId);
        }
        return false;
    }

    private Map<String, Object> getUserMapInfo(User user) {
        HashMap<String, Object> userMap = new HashMap<String, Object>();
        userMap.put("name", user.getName());
        userMap.put("id", user.getId());
        userMap.put("avatar", user.getAvatar());
        return userMap;
    }

    private List<FileFolderInfoModel> listFileFolderInfoModel(List<Object> objectList) {
        ArrayList<FileFolderInfoModel> fileFolderInfo = new ArrayList<FileFolderInfoModel>();
        for (int i = 0; i < objectList.size(); ++i) {
            FileFolderInfoModel fileFolderInfoModel = new FileFolderInfoModel();
            Object[] objs = (Object[])objectList.get(i);
            fileFolderInfoModel.setId(Long.valueOf(objs[0].toString()));
            fileFolderInfoModel.setName(objs[1] != null ? objs[1].toString() : null);
            fileFolderInfoModel.setType(objs[2] != null ? objs[2].toString() : null);
            fileFolderInfoModel.setKeyId(objs[3] != null ? Long.valueOf(objs[3].toString()) : null);
            fileFolderInfoModel.setParentId(objs[4] != null ? Long.valueOf(objs[4].toString()) : null);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                fileFolderInfoModel.setCreateDate(simpleDateFormat.parse(objs[5] != null ? objs[5].toString() : null));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            fileFolderInfoModel.setAdminId(objs[6] != null ? Long.valueOf(objs[6].toString()) : null);
            fileFolderInfoModel.setAdminAvatar(objs[7] != null ? objs[7].toString() : null);
            fileFolderInfoModel.setAdminName(objs[8] != null ? objs[8].toString() : null);
            fileFolderInfoModel.setPowerType(objs[9] != null ? objs[9].toString() : null);
            fileFolderInfo.add(fileFolderInfoModel);
        }
        return fileFolderInfo;
    }

    private List<FileInfoModel> listFileInfoModel(List<Object> objectList) {
        ArrayList<FileInfoModel> fileInfoModelList = new ArrayList<FileInfoModel>();
        for (int i = 0; i < objectList.size(); ++i) {
            FileInfoModel fileInfoModel = new FileInfoModel();
            Object[] objs = (Object[])objectList.get(i);
            fileInfoModel.setId(Long.valueOf(objs[0].toString()));
            fileInfoModel.setFolderId(Long.valueOf(objs[1].toString()));
            fileInfoModel.setCompanyId(objs[2] != null ? Long.valueOf(objs[2].toString()) : null);
            fileInfoModel.setType(objs[3].toString());
            fileInfoModel.setKeyId(Long.valueOf(objs[4].toString()));
            fileInfoModel.setSize(objs[5] != null ? Long.valueOf(objs[5].toString()) : null);
            fileInfoModel.setMimetype(objs[6] != null ? objs[6].toString() : null);
            fileInfoModel.setUrl(objs[7] != null ? objs[7].toString() : null);
            fileInfoModel.setDownloadUrl(objs[8] != null ? objs[8].toString() : null);
            fileInfoModel.setName(objs[9] != null ? objs[9].toString() : null);
            fileInfoModel.setCdnBucket(objs[10] != null ? objs[10].toString() : null);
            fileInfoModel.setCdnKey(objs[11] != null ? objs[11].toString() : null);
            fileInfoModel.setContent(objs[12] != null ? objs[12].toString() : null);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                fileInfoModel.setCreateDate(simpleDateFormat.parse(objs[13] != null ? objs[13].toString() : null));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            fileInfoModel.setAdminId(objs[14] != null ? Long.valueOf(objs[14].toString()) : null);
            fileInfoModel.setAdminAvatar(objs[15] != null ? objs[15].toString() : null);
            fileInfoModel.setAdminName(objs[16] != null ? objs[16].toString() : null);
            fileInfoModel.setPowerType(objs[17] != null ? objs[17].toString() : null);
            fileInfoModelList.add(fileInfoModel);
        }
        return fileInfoModelList;
    }

    public List<FileFolderEntity> saveList(List<FileFolderEntity> fileFolderEntities) {
        return ((FileFolderDao)this.dao).save(fileFolderEntities);
    }

    public List<Object[]> findAllFirstFileFolder() {
        return ((FileFolderDao)this.dao).findAllFirstFileFolder();
    }
}

