/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.attendance.AttendanceDayCount;
import com.ym.tlifang.dao.attendance.AttendanceDayCountDao;
import com.ym.tlifang.model.attendance.DayCountDetailModel;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceDayCountService;
import com.ym.tlifang.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceDayCountService.class, timeout=30000, retries=-1)
public class AttendanceDayCountServiceImpl
extends AbstractBaseService<AttendanceDayCount, AttendanceDayCountDao>
implements AttendanceDayCountService {
    public ResultModel<List<DayCountDetailModel>> findByCompanyIdAndRecordDate(Long companyId, String recordDate, String languageType) throws Exception {
        ArrayList<DayCountDetailModel> dayCountDetailModelList = new ArrayList<DayCountDetailModel>();
        List attendanceDayCountList = ((AttendanceDayCountDao)this.dao).findByCompanyIdAndRecordDate(companyId, recordDate);
        for (AttendanceDayCount attendanceDayCount : attendanceDayCountList) {
            DayCountDetailModel dayCountDetailModel = new DayCountDetailModel(attendanceDayCount.getUser().getName(), attendanceDayCount.getUser().getAvatar(), attendanceDayCount.getDepartment());
            List reasons = (List)JsonUtil.jackson.readValue(attendanceDayCount.getReason(), List.class);
            ArrayList<String> reasonsTwo = new ArrayList<String>();
            if (Constants.LanguageType.US.getName().equals(languageType)) {
                for (String reason : reasons) {
                    if (Constants.AttendanceSituation.later.getName().equals(reason)) {
                        reasonsTwo.add(Constants.AttendanceSituation.later.getNameEnglish());
                    }
                    if (Constants.AttendanceSituation.early.getName().equals(reason)) {
                        reasonsTwo.add(Constants.AttendanceSituation.early.getNameEnglish());
                    }
                    if (Constants.AttendanceSituation.noSign.getName().equals(reason)) {
                        reasonsTwo.add(Constants.AttendanceSituation.noSign.getNameEnglish());
                    }
                    if (!Constants.AttendanceSituation.outsideAttendance.getName().equals(reason)) continue;
                    reasonsTwo.add(Constants.AttendanceSituation.outsideAttendance.getNameEnglish());
                }
                dayCountDetailModel.setReason(reasonsTwo);
            } else {
                dayCountDetailModel.setReason(reasons);
            }
            dayCountDetailModelList.add(dayCountDetailModel);
        }
        return ResultModel.suc(dayCountDetailModelList, (String)languageType);
    }

    public AttendanceDayCount save(AttendanceDayCount attendanceDayCount) {
        return (AttendanceDayCount)super.save((BaseEntity)attendanceDayCount);
    }
}

