/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.service.attendance;

import com.alibaba.dubbo.config.annotation.Service;
import com.ym.tlifang.BaseEntity;
import com.ym.tlifang.Constants;
import com.ym.tlifang.attendance.AttendanceClasses;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.dao.attendance.AttendanceClassesDao;
import com.ym.tlifang.service.AbstractBaseService;
import com.ym.tlifang.service.attendance.AttendanceClassesService;
import com.ym.tlifang.service.attendance.AttendanceWorkdayService;
import com.ym.tlifang.service.company.CompanyService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Service(interfaceClass=AttendanceClassesService.class, timeout=50000, retries=-1)
public class AttendanceClassesServiceImpl
extends AbstractBaseService<AttendanceClasses, AttendanceClassesDao>
implements AttendanceClassesService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StringRedisTemplate redis;
    @Autowired
    private AttendanceClassesService attendanceClassesService;
    @Autowired
    private AttendanceWorkdayService attendanceWorkdayService;
    @Autowired
    private CompanyService companyService;

    public AttendanceClasses save(AttendanceClasses attendanceClasses) {
        return (AttendanceClasses)super.save((BaseEntity)attendanceClasses);
    }

    public List<AttendanceClasses> findByCompanyIdAndDelFlagFalse(Long companyId) {
        return ((AttendanceClassesDao)this.dao).findByCompanyIdAndDelFlagFalse(companyId);
    }

    public AttendanceClasses findById(Long id) {
        return ((AttendanceClassesDao)this.dao).findByIdAndDelFlagFalse(id);
    }

    public AttendanceClasses findByIdAndStatusTrue(Long id) {
        return ((AttendanceClassesDao)this.dao).findByIdAndDelFlagFalseAndStatusTrue(id);
    }

    public boolean setNextNoticeTimeScheduleTask(Long companyId, Long classId) {
        try {
            AttendanceClasses attendanceClasses;
            Company company = this.companyService.findById(companyId);
            if (company != null && (attendanceClasses = this.attendanceClassesService.findByIdAndStatusTrue(classId)) != null && attendanceClasses.getCompanyId().equals(companyId)) {
                Date date = new Date();
                String remind = "-" + attendanceClasses.getRemind();
                List strings = this.attendanceWorkdayService.getRemind(classId, date, remind, attendanceClasses.getDownRemind(), Boolean.valueOf(true), attendanceClasses.getLegal(), 1);
                if (strings.size() == 0) {
                    return false;
                }
                String key = Constants.SCHEDULE + (String)strings.get(1) + "_" + companyId + "_" + classId;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                date = sdf.parse((String)strings.get(0));
                if (!this.redis.hasKey((Object)key).booleanValue()) {
                    this.redis.boundValueOps((Object)key).set((Object)key);
                    this.redis.boundValueOps((Object)key).expireAt(date);
                } else {
                    this.redis.expireAt((Object)key, date);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List<AttendanceClasses> findByDelFlagFalse() {
        return ((AttendanceClassesDao)this.dao).findByDelFlagFalse();
    }

    public List<Object[]> findCompanyId() {
        return ((AttendanceClassesDao)this.dao).findCompanyId();
    }
}

