/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.dao.task;

import com.ym.tlifang.dao.BaseDao;
import com.ym.tlifang.task.Task;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TaskDao
extends BaseDao<Task> {
    @Query(value="select t from Task t where t.id = :id and t.delFlag = :delFlag")
    public Task findById(@Param(value="id") Long var1, @Param(value="delFlag") Boolean var2);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus and t.companyId = :companyId and c.delFlag = false and t.delFlag = false order by t.priority asc,t.createDate desc")
    public List<Task> findByUserIdAndTaskStatusAndCompanyId(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2, @Param(value="companyId") Long var3);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus and t.companyId is null and c.delFlag = false and t.delFlag = false order by t.priority asc,t.createDate desc")
    public List<Task> findByUserIdAndTaskStatus(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus  and t.companyId = :companyId and c.delFlag = false and t.delFlag = false order by c.sort asc,t.createDate desc")
    public List<Task> findByUserIdAndTaskStatusAndCompanyIdSort(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2, @Param(value="companyId") Long var3);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus  and t.companyId is null  and c.delFlag = false and t.delFlag = false order by c.sort asc,t.createDate desc")
    public List<Task> findByUserIdAndTaskStatusSort(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2);

    @Modifying
    @Query(value="update tlf_task t set t.loop = ?2 where t.id = ?1", nativeQuery=true)
    public void updateLoop(Long var1, String var2);

    @Query(value="SELECT count(t.id) FROM tlf_task t where t.project_id = ?1 AND DATE_FORMAT(t.create_date,'%Y-%m-%d') = DATE_FORMAT(NOW(),'%Y-%m-%d') AND t.del_flag = 0", nativeQuery=true)
    public Integer countByProjectIdAndUpdateDateAndDelFlagFalse(Long var1);

    @Query(value="SELECT count(t.id) FROM tlf_task t where t.project_id = ?1 AND t.status = ?2 AND t.del_flag = 0", nativeQuery=true)
    public Integer countByProjectIdAndStatusAndDelFlagFalse(Long var1, String var2);

    @Query(value="SELECT count(t.id) FROM tlf_task t where t.project_id = ?1 AND t.del_flag = 0", nativeQuery=true)
    public Integer countByProjectIdAndDelFlagFalse(Long var1);

    public List<Task> findByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(Long var1, Long var2, String var3);

    public List<Task> findByCompanyIdAndStatusAndDelFlagFalse(Long var1, String var2);

    @Query(value=" SELECT DISTINCT DATE_FORMAT(t.date_start,'%Y-%m-%d') FROM tlf_task t  LEFT JOIN tlf_task_concern c on c.task_id = t.id  where (t.assignee_id = ?1 or c.user_id = ?1) and t.company_id is null  and DATE_FORMAT(t.date_start,'%Y-%m') = DATE_FORMAT(?2,'%Y-%m') and t.del_flag = 0 ", nativeQuery=true)
    public List<String> findUserMonthDateList(Long var1, String var2);

    @Query(value=" SELECT DISTINCT DATE_FORMAT(t.date_start,'%Y-%m-%d') FROM tlf_task t  LEFT JOIN tlf_task_concern c on c.task_id = t.id  where (t.assignee_id = ?1 or c.user_id = ?1)  and t.company_id = ?2  and DATE_FORMAT(t.date_start,'%Y-%m') = DATE_FORMAT(?3,'%Y-%m') and t.del_flag = 0 ", nativeQuery=true)
    public List<String> findUserMonthDateListByCompanyId(Long var1, Long var2, String var3);

    @Query(value=" SELECT DISTINCT t.* FROM tlf_task t  LEFT JOIN tlf_task_concern c on c.task_id = t.id  where (t.assignee_id = ?1 or c.user_id = ?1) and t.company_id is null and DATE_FORMAT(t.date_start,'%Y-%m') = DATE_FORMAT(?2,'%Y-%m') and t.del_flag = 0 ", nativeQuery=true)
    public List<Task> findListByDate(Long var1, String var2);

    @Query(value=" SELECT DISTINCT t.* FROM tlf_task t  LEFT JOIN tlf_task_concern c on c.task_id = t.id  where (t.assignee_id = ?1 or c.user_id = ?1) and t.company_id = ?2   and DATE_FORMAT(t.date_start,'%Y-%m') = DATE_FORMAT(?3,'%Y-%m') and t.del_flag = 0 ", nativeQuery=true)
    public List<Task> findListByCompanyIdAndDate(Long var1, Long var2, String var3);

    public Task findByMongodbId(String var1);

    @Query(value=" SELECT count(a.id) FROM tlf_task a JOIN tlf_user b on a.assignee_id = b.id INNER JOIN tlf_company_user_relation c on b.id = c.user_id WHERE c.department_id = ?1 and a.`status` = '0' and c.del_flag = '0' and a.company_id = c.company_id", nativeQuery=true)
    public Integer findByDepartId(Long var1);

    @Query(value=" SELECT count(a.id) FROM tlf_task a JOIN tlf_user b on a.assignee_id = b.id INNER JOIN tlf_company_user_relation c on b.id = c.user_id WHERE c.department_id = ?1 and a.`status` = '1' and c.del_flag = '0' and a.company_id = c.company_id", nativeQuery=true)
    public Integer findByDepartIdAndCompete(Long var1);

    @Query(value=" SELECT count(a.id) FROM tlf_task a JOIN tlf_user b on a.assignee_id = b.id INNER JOIN tlf_company_user_relation c on b.id = c.user_id WHERE c.department_id = ?1 and a.`status` = '0'and c.del_flag = '0'and a.date_due < ?2 and a.company_id = c.company_id", nativeQuery=true)
    public Integer findOverDue(Long var1, Date var2);

    public Integer countByCompanyIdAndAssigneeIdAndStatusAndDelFlagFalse(Long var1, Long var2, String var3);

    public Integer countByCompanyIdAndAssigneeIdAndStatusAndDateDueBeforeAndDelFlagFalse(Long var1, Long var2, String var3, Date var4);

    @Query(value="SELECT count(a.id) FROM tlf_task a INNER JOIN tlf_company_user_relation c on c.user_id = a.assignee_id WHERE c.department_id = ?1 and a.company_id = c.company_id and c.del_flag = '0'", nativeQuery=true)
    public Long findByDepartIdAndAll(Long var1);

    @Query(value="SELECT count(a.id) FROM tlf_task a WHERE a.`status` = '0' and a.del_flag = '0' and a.project_id = ?1 and a.date_due < ?2", nativeQuery=true)
    public Long countOverdueNumByProjectId(Long var1, Date var2);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus  and t.companyId = :companyId and c.delFlag = false and t.delFlag = false order by c.sort asc,t.createDate desc")
    public Page<Task> findByUserIdAndTaskStatusAndCompanyIdPage(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2, @Param(value="companyId") Long var3, Pageable var4);

    @Query(value="select t from TaskConcern c left join c.task t where t.id = c.taskId and c.userId = :userId and c.taskStatus = :taskStatus  and t.companyId is null and c.delFlag = false and t.delFlag = false order by c.sort asc,t.createDate desc")
    public Page<Task> findByUserIdAndTaskStatusPage(@Param(value="userId") Long var1, @Param(value="taskStatus") String var2, Pageable var3);

    public Page<Task> findByProjectIdAndTitleLikeAndDelFlagFalseOrderByCreateDateDesc(Long var1, String var2, Pageable var3);

    @Query(value="SELECT u.name, (select count(t1.assignee_id) from tlf_task t1 where t1.assignee_id = u.id and t1.`status` = 0) as noFinish, (select count(t2.assignee_id) from tlf_task t2 where t2.assignee_id = u.id and t2.`status` = 1) as finish, (select count(t3.assignee_id)  from tlf_task t3 where t3.assignee_id = u.id) as taskCount, (select count(t4.assignee_id)  from tlf_task t4 where t4.assignee_id = u.id and t4.date_due<?1) as due, (select due/count(t5.assignee_id) from tlf_task t5 where t5.assignee_id = u.id) as dueRate FROM tlf_user u left join tlf_task t on t.assignee_id = u.id   left join tlf_project p on t.project_id = ?2 GROUP BY t.assignee_id ORDER BY taskCount desc limit ?3,?4", nativeQuery=true)
    public List<Object[]> taskCount(String var1, Long var2, Integer var3, Integer var4);

    @Query(value="select count(*) from tlf_user u left join tlf_task t on t.assignee_id = u.id left join tlf_project p on t.project_id =?1 order by t.project_id desc ", nativeQuery=true)
    public int taskStatisticsCount(Long var1);

    @Query(value="SELECT count(t.id) AS yesterdayNewNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE DATEDIFF(t.update_date,NOW())=-1 AND t.project_id = ?1 AND t.`status` = '1' and t.del_flag = 0) AS yesterdayCompletedNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE t.project_id = ?1 AND t.del_flag = 0) AS projectTaskNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE t.project_id = ?1 AND t.`status` = '1' AND t.del_flag = 0) AS CompletedNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE t.project_id = ?1 AND t.`status` = '0' AND t.del_flag = 0) AS unfinishedNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE t.project_id = ?1 AND NOW() > t.date_due AND t.del_flag = 0) AS overdueNum,(SELECT COUNT(t.id) FROM tlf_task t WHERE t.project_id = ?1 AND t.update_date > t.date_due AND t.`status` = '1' AND t.del_flag = 0) AS overdueCompletedNum FROM tlf_task t WHERE DATEDIFF(t.create_date,NOW())=-1 AND t.project_id = ?1 AND t.del_flag=0", nativeQuery=true)
    public List<Object[]> findByTaskStatistics(Long var1);

    public List<Task> findByIdInAndDelFlagFalse(List<Long> var1);
}

