/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.dao.attendance;

import com.ym.tlifang.attendance.AttendanceReportUser;
import com.ym.tlifang.dao.BaseDao;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface AttendanceReportUserDao
extends BaseDao<AttendanceReportUser> {
    public List<AttendanceReportUser> findByReportIdOrderByDepartName(Long var1);

    @Query(value="SELECT a.* FROM tlf_attendance_report_user a LEFT JOIN tlf_attendance_report b ON a.report_id = b.id WHERE b.company_id = ?1 AND a.user_id = ?2 AND b.date = ?3", nativeQuery=true)
    public AttendanceReportUser findCompanyIdAndUserId(Long var1, Long var2, String var3);

    @Query(value="SELECT count(c.id) FROM (SELECT a.id FROM `tlf_attendance_report_user` a join tlf_attendance_report b on a.report_id = b.id WHERE b.company_id = ?1 and date =?2 GROUP BY a.user_id) c", nativeQuery=true)
    public Integer findMonthPeople(Long var1, String var2);

    @Query(value="SELECT count(c.id) FROM (SELECT a.id FROM `tlf_attendance_report_user` a join tlf_attendance_report b on a.report_id = b.id WHERE b.company_id = ?1 and b.date =?2 and a.attendance_times = a.attendance_success GROUP BY a.user_id) c", nativeQuery=true)
    public Integer findMonthSignOut(Long var1, String var2);

    @Query(value="SELECT count(c.id) FROM (SELECT a.id FROM `tlf_attendance_report_user` a join tlf_attendance_report b on a.report_id = b.id WHERE b.company_id = ?1 and b.date =?2  and a.fail_attendance_array != '[]'  GROUP BY a.user_id) c", nativeQuery=true)
    public Integer findMonthFail(Long var1, String var2);

    @Query(value="select        company.userId,\n       company.userName,\n       company.userAvatar,\n       company.companyId,\n       company.departmentId,\n       company.companyName,\n\n       reportUser.attendance_success,\n       fc.sign_back_num,\n       reportUser.later_num,\n       reportUser.early_num,\n       reportUser.fail_attendance_array,\n       reportUser.outside_Times,\n       fc.approve_use_num,\n\n       (select count(id)\n        from tlf_project_user\n        where id = company.userId\n          and company_id = company.companyId) as projectNum,\n\n       (select completed_num\n        from tlf_task_statistics\n        where id = company.userId\n          and company_id = company.companyId) as completeTaskNum,\n\n       (select count(id)\n        from tlf_meeting\n        where id = company.userId\n          and company_id = company.companyId) as meetingNum,\n       fc.report_use_num\n\nfrom (\n       select u.id           as userId,\n              u.name         as userName,\n              u.avatar       as userAvatar,\n              cur.company_id as companyId,\n              c.name         as companyName,\n              c.id           as departmentId\n       from tlf_company_user_relation cur\n              left join tlf_company c on cur.department_id = c.id\n              left join tlf_user u on cur.user_id = u.id\n       where cur.company_id = ?1\n         and case when ?2 is null then department_id else cur.department_id = ?2 end\n         and c.del_flag = 0\n         and cur.del_flag = 0\n         and cur.update_date >= ?3\n         and cur.update_date < ?4\n     ) as company\n\n       left join tlf_attendance_report report on company.companyId = report.company_id\n       left join tlf_attendance_report_user reportUser on report.id = reportUser.report_id\n       left join tlf_function_count fc on company.companyId = fc.company_id\n\nwhere report.del_flag = 0\n  and reportUser.del_flag = 0\n  and fc.del_flag = 0\ngroup by userId,departmentId limit ?5,?6\n", nativeQuery=true)
    public List<Object[]> findMemberStatistics(Long var1, Long var2, String var3, String var4, Integer var5, Integer var6);

    @Query(value="SELECT a.user_id,a.fail_attendance_array FROM `tlf_attendance_report_user` a join tlf_attendance_report b ON a.report_id = b.id WHERE b.company_id = ?1 and a.user_id = ?2 and b.date = ?3 AND a.fail_attendance_array != '[]'", nativeQuery=true)
    public List<Object[]> findAttendanceFail(Long var1, Long var2, String var3);

    @Query(value="SELECT\n count(a.id) FROM\n `tlf_attendance_report_user` a\nLEFT JOIN tlf_attendance_report b ON a.report_id = b.id\nLEFT JOIN tlf_user c ON a.user_id = c.id\nWHERE\n b.date = ?1\nAND b.company_id = ?2\nAND (\n CASE\n WHEN ?3 IS NULL THEN\n  1 = 1\n ELSE\n  a.user_name = ?3\n END\n)\nAND (\n CASE\n WHEN ?4 IS NULL THEN\n  1 = 1\n ELSE\n  a.depart_name = ?4\n END\n)", nativeQuery=true)
    public Integer findAttendanceNum(String var1, Long var2, String var3, String var4);
}

