/*
 * Decompiled with CFR 0.152.
 */
package com.ym.tlifang.api.controller.workreport;

import com.alibaba.dubbo.config.annotation.Reference;
import com.ym.tlifang.Constants;
import com.ym.tlifang.PageInfo;
import com.ym.tlifang.ResultModel;
import com.ym.tlifang.ResultStatus;
import com.ym.tlifang.api.authorization.annotation.Authorization;
import com.ym.tlifang.api.authorization.annotation.CurrentUser;
import com.ym.tlifang.api.authorization.annotation.LanguageType;
import com.ym.tlifang.api.controller.BaseController;
import com.ym.tlifang.company.Company;
import com.ym.tlifang.company.CompanyMemberInfo;
import com.ym.tlifang.company.CompanyUserRelation;
import com.ym.tlifang.model.workreport.WorkReportModel;
import com.ym.tlifang.service.company.CompanyMemberInfoService;
import com.ym.tlifang.service.company.CompanyService;
import com.ym.tlifang.service.company.CompanyUserRelationService;
import com.ym.tlifang.service.push.XgPushService;
import com.ym.tlifang.service.system.EnclosureService;
import com.ym.tlifang.service.system.NoticeService;
import com.ym.tlifang.service.user.UserService;
import com.ym.tlifang.service.workreport.WorkReportDetailService;
import com.ym.tlifang.service.workreport.WorkReportService;
import com.ym.tlifang.system.EnclosureEntity;
import com.ym.tlifang.user.User;
import com.ym.tlifang.util.StringUtils;
import com.ym.tlifang.workreport.WorkReport;
import com.ym.tlifang.workreport.WorkReportDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"workReport"})
@Api(value="workReport", description="\u5de5\u4f5c\u6c47\u62a5")
public class WorkReportController
extends BaseController {
    @Reference(timeout=100000)
    private WorkReportService workReportService;
    @Reference(timeout=100000)
    private WorkReportDetailService workReportDetailService;
    @Reference(timeout=100000)
    private CompanyMemberInfoService companyMemberInfoService;
    @Reference(timeout=100000)
    private NoticeService noticeService;
    @Reference(timeout=100000)
    private EnclosureService enclosureService;
    @Reference(timeout=100000)
    private CompanyUserRelationService companyUserRelationService;
    @Reference(timeout=100000)
    private CompanyService companyService;
    @Reference
    private XgPushService xgPushService;
    @Reference
    private UserService userService;

    @PostMapping
    @ApiOperation(value="\u4fdd\u5b58\u5de5\u4f5c\u6c47\u62a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<WorkReport> addWorkReport(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody WorkReport workReport) {
        WorkReport workReportTwo;
        workReport.setLooked(Boolean.valueOf(false));
        workReport.setReceiveType(Boolean.valueOf(true));
        workReport.setSendId(currentUser.getId());
        workReport.setTab(Boolean.valueOf(true));
        WorkReportDetail workReportDetail = workReport.getWorkReportDetail();
        List tabList = workReportDetail.getReportList();
        if ("0".equals(workReportDetail.getType())) {
            Company company = this.companyService.findById(workReportDetail.getDepartId());
            if (company != null) {
                CompanyUserRelation companyUserRelation = this.companyUserRelationService.findByExecutiveAndDepartmentIdAndDelFlagFalse("1", workReportDetail.getDepartId());
                if (companyUserRelation == null) {
                    return ResultModel.error((ResultStatus)ResultStatus.DEPARTMENTEXECUTIVE_NO_EXIST, (String)languageType);
                }
                workReport.setReceiveId(companyUserRelation.getUserId());
            } else {
                if (tabList == null || tabList.size() == 0) {
                    return ResultModel.error((ResultStatus)ResultStatus.WORK_DEPART_ALREADY, (String)languageType);
                }
                workReport.setReceiveId(((CompanyMemberInfo)tabList.get(0)).getUserId());
                tabList.remove(0);
            }
        }
        String theme = workReportDetail.getTheme();
        String content = workReportDetail.getContent();
        if (StringUtils.containsEmoji((String)theme)) {
            workReportDetail.setTheme(StringEscapeUtils.escapeJava((String)theme));
        }
        if (StringUtils.containsEmoji((String)content)) {
            workReportDetail.setContent(StringEscapeUtils.escapeJava((String)(content == null ? "" : workReportDetail.getContent())));
        }
        workReportDetail.setReporterId(currentUser.getId());
        Long[] appendix = workReportDetail.getAppendix();
        List companyMemberInfoList = workReportDetail.getCompanyMemberInfoList();
        workReportDetail = this.workReportDetailService.save(workReportDetail);
        workReportDetail.setTheme(theme);
        workReportDetail.setContent(content);
        List enclosureEntities = this.enclosureService.findAppendix(workReportDetail.getId(), "5");
        for (EnclosureEntity enclosureEntity : enclosureEntities) {
            enclosureEntity.setKeyId(null);
            this.enclosureService.saveEnclosure(enclosureEntity);
        }
        if (appendix.length != 0) {
            for (int i = 0; i < appendix.length; ++i) {
                EnclosureEntity enclosureEntity;
                enclosureEntity = this.enclosureService.findById(appendix[i]);
                enclosureEntity.setKeyId(workReportDetail.getId());
                this.enclosureService.saveEnclosure(enclosureEntity);
            }
        }
        if ((workReportTwo = this.workReportService.receive(workReportDetail.getId())) != null) {
            workReport.setId(workReportTwo.getId());
        }
        workReport.setDetailId(workReportDetail.getId());
        workReport.setWorkReportDetail(null);
        workReport = this.workReportService.save(workReport);
        WorkReport workReportReturn = this.workReportService.findByIdAndDelFlagFalse(workReport.getId());
        workReportReturn.setWorkReportDetail(workReportDetail);
        if (workReport.getSendOut().booleanValue()) {
            if ("day".equals(theme)) {
                theme = "\u65e5\u62a5";
            }
            if ("week".equals(theme)) {
                theme = "\u5468\u62a5";
            }
            if ("month".equals(theme)) {
                theme = "\u6708\u62a5";
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("workReportId", workReportReturn.getId());
            map.put("action", "\u6536\u5230\u6c47\u62a5");
            map.put("msg", Constants.NoticeContent.receive.getName() + workReportReturn.getSendUser().getName() + Constants.NoticeContent.oneReport.getName() + ":" + theme);
            map.put("msgEn", Constants.NoticeContent.receive.getNameEnglish() + Constants.NoticeContent.oneReport.getNameEnglish() + workReportReturn.getSendUser().getName());
            try {
                this.noticeService.saveSendNotice(workReport.getReceiveId(), Constants.NoticeParentType.workReport, Constants.NoticeType.mailBox, Constants.Originator.member, workReport.getSendId(), map, "2");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        List tabTwo = this.workReportService.findTabTwo(workReportDetail.getId());
        for (Object workReportThree : tabTwo) {
            workReportThree.setDelFlag(Boolean.valueOf(true));
            this.workReportService.save((WorkReport)workReportThree);
        }
        Long receiveId = workReport.getReceiveId();
        workReport.setId(null);
        workReport.setTab(Boolean.valueOf(false));
        if (tabList != null) {
            for (Object companyMemberInfo : tabList) {
                if (companyMemberInfo.getUserId().equals(receiveId)) continue;
                workReport.setReceiveId(companyMemberInfo.getUserId());
                this.workReportService.save(workReport);
            }
        }
        List workReports = this.workReportService.copyTo(workReportDetail.getId());
        for (WorkReport workReportThree : workReports) {
            workReportThree.setDelFlag(Boolean.valueOf(true));
            this.workReportService.save(workReportThree);
        }
        workReport.setReceiveType(Boolean.valueOf(false));
        workReport.setTab(Boolean.valueOf(true));
        for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
            if (companyMemberInfo.getUserId().equals(receiveId)) continue;
            workReport.setReceiveId(companyMemberInfo.getUserId());
            this.workReportService.save(workReport);
        }
        WorkReport workReporty = this.workReportService.receive(workReport.getDetailId());
        if ("0".equals(workReportDetail.getType())) {
            if ("0".equals("0")) {
                if (!StringUtils.isEmpty((Object)workReporty.getReceiveUser()) && StringUtils.isNotBlank((String)workReporty.getReceiveUser().getPushToken())) {
                    this.xgPushService.pushTokenIosOrAndroidBelievers(workReporty.getReceiveUser().getPushToken(), Constants.TitleNotify.workReport.getName(), Constants.ContentNotify.head.getName() + workReportReturn.getSendUser().getName() + Constants.ContentNotify.workReport.getName(), null, Constants.IntentType.systemNotice.getType());
                }
                for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
                    User user = this.userService.findById(companyMemberInfo.getUserId());
                    if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                    this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.workReport.getName(), Constants.ContentNotify.head.getName() + workReportReturn.getSendUser().getName() + Constants.ContentNotify.workReport.getName(), null, Constants.IntentType.systemNotice.getType());
                }
            } else {
                if (!StringUtils.isEmpty((Object)workReporty.getReceiveUser()) && StringUtils.isNotBlank((String)workReporty.getReceiveUser().getPushToken())) {
                    this.xgPushService.pushTokenForeign(workReporty.getReceiveUser().getPushToken(), Constants.TitleNotify.workReport.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + Constants.ContentNotify.workReport.getEnglishName() + workReportReturn.getSendUser().getName(), Constants.SHOWFLAG);
                }
                for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
                    User user = this.userService.findById(companyMemberInfo.getUserId());
                    if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                    this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.workReport.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + Constants.ContentNotify.email.getEnglishName() + workReportReturn.getSendUser().getName(), Constants.SHOWFLAG);
                }
            }
        } else if ("0".equals("0")) {
            if (!StringUtils.isEmpty((Object)workReporty.getReceiveUser()) && StringUtils.isNotBlank((String)workReporty.getReceiveUser().getPushToken())) {
                this.xgPushService.pushTokenIosOrAndroidBelievers(workReporty.getReceiveUser().getPushToken(), Constants.TitleNotify.workReport.getName(), Constants.ContentNotify.head.getName() + workReportReturn.getSendUser().getName() + Constants.ContentNotify.email.getName(), null, Constants.IntentType.systemNotice.getType());
            }
            for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
                User user = this.userService.findById(companyMemberInfo.getUserId());
                if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                this.xgPushService.pushTokenIosOrAndroidBelievers(user.getPushToken(), Constants.TitleNotify.workReport.getName(), Constants.ContentNotify.head.getName() + workReportReturn.getSendUser().getName() + Constants.ContentNotify.email.getName(), null, Constants.IntentType.systemNotice.getType());
            }
        } else {
            if (!StringUtils.isEmpty((Object)workReporty.getReceiveUser()) && StringUtils.isNotBlank((String)workReporty.getReceiveUser().getPushToken())) {
                this.xgPushService.pushTokenForeign(workReporty.getReceiveUser().getPushToken(), Constants.TitleNotify.workReport.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + Constants.ContentNotify.email.getEnglishName() + workReportReturn.getSendUser().getName(), Constants.SHOWFLAG);
            }
            for (CompanyMemberInfo companyMemberInfo : companyMemberInfoList) {
                User user = this.userService.findById(companyMemberInfo.getUserId());
                if (StringUtils.isEmpty((Object)user) || !StringUtils.isNotBlank((String)user.getPushToken())) continue;
                this.xgPushService.pushTokenForeign(user.getPushToken(), Constants.TitleNotify.workReport.getEnglishName(), Constants.ContentNotify.head.getEnglishName() + Constants.ContentNotify.email.getEnglishName() + workReportReturn.getSendUser().getName(), Constants.SHOWFLAG);
            }
        }
        return ResultModel.suc((Object)workReportReturn, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/mailbox"})
    @ApiOperation(value="\u83b7\u53d6\u90ae\u7bb1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="type", value="\u7c7b\u578b  0:\u6536\u4ef6,1:\u53d1\u4ef6\uff0c2\u8349\u7a3f, 3\u6536\u4ef6\u672a\u8bfb\uff0c 4\u6536\u4ef6\u5df2\u8bfb", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="pageNo", value="\u7b2c\u51e0\u9875", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<PageInfo<WorkReport>> getMailbox(@LanguageType String languageType, @CurrentUser User currentUser, String type, Integer pageNo, Integer pageSize) {
        return ResultModel.suc((Object)this.workReportService.mailbox(currentUser.getCurrentCompany(), currentUser.getId(), type, pageNo, pageSize), (String)languageType);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/mailbox/detail"})
    @ApiOperation(value="\u67e5\u770b\u6c47\u62a5\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u6c47\u62a5id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<WorkReport> getDetail(@LanguageType String languageType, @CurrentUser User currentUser, Long id) {
        WorkReport workReport = this.workReportService.findByIdAndDelFlagFalse(id);
        if (StringUtils.isEmpty((Object)workReport)) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_NO_EXIST, (String)languageType);
        }
        WorkReportDetail workReportDetail = this.workReportDetailService.findByIdAndDelFlagFalse(workReport.getDetailId());
        if (currentUser.getId().equals(workReport.getReceiveId()) && workReport.getSendOut().booleanValue()) {
            workReport.setLooked(Boolean.valueOf(true));
            if (!workReport.getSendOut().booleanValue()) {
                workReport.setLooked(Boolean.valueOf(false));
            }
            workReport = this.workReportService.save(workReport);
        } else if (!workReport.getSendId().equals(currentUser.getId())) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_POWER, (String)languageType);
        }
        List workReports = this.workReportService.copyTo(workReportDetail.getId());
        ArrayList<CompanyMemberInfo> companyMemberInfoList = new ArrayList<CompanyMemberInfo>();
        for (WorkReport workReportTwo : workReports) {
            CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(workReportTwo.getCompanyId(), workReportTwo.getReceiveId(), Constants.AuditStatus.adopt.getType());
            if (companyMemberInfo == null) continue;
            companyMemberInfoList.add(companyMemberInfo);
        }
        Company company = this.companyService.findById(workReportDetail.getDepartId());
        if (company != null) {
            company.setMembers(null);
            company.setPositions(null);
            company.setChildren(null);
            workReportDetail.setCompany(company);
        }
        List workReportsTwo = this.workReportService.findAllReceive(workReportDetail.getId());
        ArrayList<CompanyMemberInfo> companyMemberInfoListTwo = new ArrayList<CompanyMemberInfo>();
        for (WorkReport workReportTwo : workReportsTwo) {
            CompanyMemberInfo companyMemberInfo = this.companyMemberInfoService.findByCompanyIdAndUserIdAndStatus(workReportTwo.getCompanyId(), workReportTwo.getReceiveId(), Constants.AuditStatus.adopt.getType());
            companyMemberInfoListTwo.add(companyMemberInfo);
        }
        workReportDetail.setReportList(companyMemberInfoListTwo);
        workReportDetail.setCompanyMemberInfoList(companyMemberInfoList);
        workReportDetail.setEnclosureEntityList(this.enclosureService.findAppendix(workReportDetail.getId(), "5"));
        workReportDetail.setTheme(StringEscapeUtils.unescapeJava((String)workReportDetail.getTheme()));
        workReportDetail.setContent(StringEscapeUtils.unescapeJava((String)workReportDetail.getContent()));
        workReport.setWorkReportDetail(workReportDetail);
        return ResultModel.suc((Object)workReport, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/forward"})
    @ApiOperation(value="\u8f6c\u53d1\u6c47\u62a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel addForward(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody WorkReportModel workReportModel) {
        List workReports = workReportModel.getWorkReportList();
        for (WorkReport workReport : workReports) {
            WorkReport workReportTwo = new WorkReport(workReport.getDetailId(), currentUser.getId(), workReport.getCompanyId(), workReportModel.getCompanyMemberInfo().getUserId(), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), "2");
            this.workReportService.save(workReportTwo);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/withdraw"})
    @ApiOperation(value="\u64a4\u56de\u6c47\u62a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="id", value="\u6c47\u62a5id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel putReport(@LanguageType String languageType, @CurrentUser User currentUser, Long id) {
        WorkReport workReport = this.workReportService.findByIdAndDelFlagFalse(id);
        if (StringUtils.isEmpty((Object)workReport)) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_NO_EXIST, (String)languageType);
        }
        if (!currentUser.getId().equals(workReport.getSendId())) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_DOWN_POWER, (String)languageType);
        }
        if ("0".equals(workReport.getStatus()) || "1".equals(workReport.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_ALREADY, (String)languageType);
        }
        Long time = System.currentTimeMillis();
        Long beginTime = workReport.getCreateDate().getTime();
        int minutes = (int)((time - beginTime) / 60000L);
        if (minutes >= 30) {
            return ResultModel.error((ResultStatus)ResultStatus.REPORT_TIME_ERROR, (String)languageType);
        }
        workReport.setSendOut(Boolean.valueOf(false));
        if (!"2".equals(workReport.getStatus())) {
            List workReports = this.workReportService.copyTo(workReport.getDetailId());
            for (WorkReport workReportThree : workReports) {
                workReportThree.setSendOut(Boolean.valueOf(false));
                this.workReportService.save(workReportThree);
            }
            List tabTwo = this.workReportService.findTabTwo(workReport.getDetailId());
            for (WorkReport workReportThree : tabTwo) {
                workReportThree.setDelFlag(Boolean.valueOf(true));
                this.workReportService.save(workReportThree);
            }
        } else {
            workReport.setDelFlag(Boolean.valueOf(true));
        }
        workReport.setLooked(Boolean.valueOf(false));
        this.workReportService.save(workReport);
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mailbox/reject"})
    @ApiOperation(value="\u5df2\u9605\u6216\u9a73\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<WorkReport> status(@LanguageType String languageType, @CurrentUser User currentUser, @RequestBody WorkReport workReport) {
        WorkReport workReportTwo = this.workReportService.findByIdAndDelFlagFalse(workReport.getId());
        if ("0".equals(workReportTwo.getStatus()) || "1".equals(workReportTwo.getStatus())) {
            return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_ALREADY, (String)languageType);
        }
        workReportTwo.setStatus(workReport.getStatus());
        this.workReportService.save(workReportTwo);
        if ("0".equals(workReport.getStatus())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", workReport.getId());
            map.put("action", "\u5df2\u9605");
            map.put("msg", Constants.NoticeContent.workReportRead.getName());
            map.put("msgEn", Constants.NoticeContent.workReportRead.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(workReportTwo.getSendId(), Constants.NoticeParentType.workReport, Constants.NoticeType.readAlready, Constants.Originator.member, workReportTwo.getReceiveId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", workReport.getId());
            map.put("action", "\u9a73\u56de");
            map.put("msg", Constants.NoticeContent.workReportReject.getName());
            map.put("msgEn", Constants.NoticeContent.workReportReject.getNameEnglish());
            try {
                this.noticeService.saveSendNotice(workReportTwo.getSendId(), Constants.NoticeParentType.workReport, Constants.NoticeType.reject, Constants.Originator.member, workReportTwo.getReceiveId(), map, "1");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return ResultModel.suc((Object)workReportTwo, (String)languageType);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/mailbox/looked/ids/{ids}"})
    @ApiOperation(value="\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="ids", value="\u6c47\u62a5id\u7ec4", required=true, dataType="List<long>", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel looked(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable List<Long> ids) {
        for (Long id : ids) {
            WorkReport workReport = this.workReportService.findByIdAndDelFlagFalse(id);
            if (workReport == null) {
                return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_NO_EXIST, (String)languageType);
            }
            workReport.setLooked(Boolean.valueOf(true));
            this.workReportService.save(workReport);
        }
        return ResultModel.ok((String)languageType);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/delWorkReport/{ids}"})
    @ApiOperation(value="\u5220\u9664\u8349\u7a3f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer token", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="ids", value="\u6c47\u62a5id", required=true, dataType="List<long>", paramType="path"), @ApiImplicitParam(name="currentUser", value="\u5f53\u524d\u7528\u6237\uff08\u53ef\u4e0d\u4f20\uff09", required=false, dataType="user", paramType="body")})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful \u2014 \u8bf7\u6c42\u5df2\u5b8c\u6210"), @ApiResponse(code=400, message="\u8bf7\u6c42\u4e2d\u6709\u8bed\u6cd5\u95ee\u9898\uff0c\u6216\u4e0d\u80fd\u6ee1\u8db3\u8bf7\u6c42"), @ApiResponse(code=401, message="\u672a\u6388\u6743\u5ba2\u6237\u673a\u8bbf\u95ee\u6570\u636e"), @ApiResponse(code=404, message="\u670d\u52a1\u5668\u627e\u4e0d\u5230\u7ed9\u5b9a\u7684\u8d44\u6e90\uff1b\u6587\u6863\u4e0d\u5b58\u5728"), @ApiResponse(code=500, message="\u670d\u52a1\u5668\u4e0d\u80fd\u5b8c\u6210\u8bf7\u6c42")})
    @Authorization
    public ResultModel<String> deleteReport(@LanguageType String languageType, @CurrentUser User currentUser, @PathVariable List<Long> ids) {
        for (Long id : ids) {
            WorkReport workReport = this.workReportService.findByIdAndDelFlagFalse(id);
            if (StringUtils.isEmpty((Object)workReport)) {
                return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_NO_EXIST, (String)languageType);
            }
            if (!currentUser.getId().equals(workReport.getSendId())) {
                return ResultModel.error((ResultStatus)ResultStatus.WORK_REPORT_DOWN_POWER, (String)languageType);
            }
            workReport.setDelFlag(Boolean.valueOf(true));
            this.workReportService.save(workReport);
            List workReports = this.workReportService.copyTo(workReport.getDetailId());
            for (WorkReport workReportThree : workReports) {
                workReportThree.setDelFlag(Boolean.valueOf(false));
                this.workReportService.save(workReportThree);
            }
            List tabTwo = this.workReportService.findTabTwo(workReport.getDetailId());
            for (WorkReport workReportThree : tabTwo) {
                workReportThree.setDelFlag(Boolean.valueOf(true));
                this.workReportService.save(workReportThree);
            }
        }
        return ResultModel.ok((String)languageType);
    }
}

