package com.wecloud.im.push.huawei.messaging;

import org.apache.http.client.HttpClient;

/**
 * Provides trampolines into package-private APIs used by components of HCM
 */
public final class ImplHuaweiTrampolines {
    private ImplHuaweiTrampolines() {}

    public static HuaweiCredential getCredential(HuaweiApp app) {
        return app.getOption().getCredential();
    }

    public static String getAccessToken(HuaweiApp app) {
        return app.getOption().getCredential().getAccessToken();
    }

    public static String getAppId(HuaweiApp app) {
        return app.getOption().getCredential().getAppId();
    }
    public static String getPushOpenUrl(HuaweiApp app) {
        return app.getOption().getCredential().getPushOpenUrl();
    }

    public static HttpClient getHttpClient(HuaweiApp app) {
        return app.getOption().getHttpClient();
    }

    public static <T extends HuaweiService> T getService(HuaweiApp app, String id, Class<T> type) {
        return type.cast(app.getService(id));
    }

    public static <T extends HuaweiService> T addService(HuaweiApp app, T service) {
        app.addService(service);
        return service;
    }
}
