package com.wecloud.netty.dispatch.common;

import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.SynthesizingMethodParameter;

import java.lang.reflect.Method;

/**
 * @author lixiaozhong
 */
public class ActionMethod {

	private Class<?> actionClass;
	private Method method;
	private MethodParameter[] methodParameters;
	private String methodPath;

//	public ActionMethod(Class<?> actionClass, Method method) {
//		this.actionClass = actionClass;
//		this.method = method;
//		initialize(method);
//	}

	public ActionMethod(Method method, String methodPath) {
		this.actionClass = method.getDeclaringClass();
		this.method = method;
		this.methodPath = methodPath;
		initialize(method);
	}

	private void initialize(Method method) {
		methodParameters = initMethodParameters(method);
	}

	private MethodParameter[] initMethodParameters(Method method) {
		int count = method.getParameterCount();
		MethodParameter[] result = new MethodParameter[count];
		for (int i = 0; i < count; i++) {
			SynthesizingMethodParameter parameter = SynthesizingMethodParameter.forExecutable(method, i);
			parameter.withContainingClass(this.actionClass);
			parameter.initParameterNameDiscovery(new DefaultParameterNameDiscoverer());
			result[i] = parameter;
		}
		return result;
	}

	public Class<?> getActionClass() {
		return actionClass;
	}

	public Method getMethod() {
		return method;
	}

	public MethodParameter[] getMethodParameters() {
		return methodParameters;
	}

	public String getMethodPath() {
		return methodPath;
	}

	public void setMethodPath(String methodPath) {
		this.methodPath = methodPath;
	}
}
