package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * 单聊消息
 * @Author luozh
 * @Date 2022年05月05日 11:49
 * @Version 1.0
 */
@Data
public class PrivateChatMessageParam {
    /**
     * 发送人id
     */
    @NotEmpty(message = "发送人id不能为空")
    @ApiModelProperty("发送人id")
    private String fromUserId;

    /**
     * 指定一个或多个用户
     */
    @NotEmpty(message = "接收用户id不能为空")
    @ApiModelProperty("接收用户id")
    private String toUserIds;

    /**
     * 消息类型
     */
    @NotEmpty(message = "消息类型不能为空")
    @ApiModelProperty("消息类型")
    private String messageType;

    /**
     * 消息
     */
    @NotNull(message = "消息不能为空")
    @ApiModelProperty("消息")
    private Map<String, Object> content;

    /**
     * 指定离线推送通知中的推送内容
     */
    @ApiModelProperty("指定离线推送通知中的推送内容")
    private String pushContent;

    /**
     * 是否包含发送用户
     */
    @ApiModelProperty("是否包含发送用户")
    private Boolean includeSender;

    /**
     * 是否过滤黑名单
     */
    @ApiModelProperty("是否过滤黑名单")
    private Boolean includeBlacklist;

    /**
     * 是否存储此条消息
     */
    @ApiModelProperty("是否存储此条消息")
    private Boolean persisted;

    /**
     * 是否为静默消息
     */
    @ApiModelProperty("是否为静默消息")
    private Boolean silent;

    /**
     * 推送拓展配置
     */
    @ApiModelProperty("推送拓展配置")
    private PushExtParam pushExt;
}
