package com.wecloud.im.biz.externalaccess.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.wecloud.can.core.base.controller.BaseController;
import com.wecloud.can.core.enums.ApiCode;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.im.biz.externalaccess.param.FriendDto;
import com.wecloud.im.biz.externalaccess.service.FriendService;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.param.ImFriendBaseParam;
import com.wecloud.im.biz.module.message.service.ImClientService;

/**
 * @Author wenzhida
 * @Date 2022/2/22 23:09
 * @Description 非sdk朋友相关控制器
 */
@Slf4j
@RestController
@RequestMapping("/friends")
@Api(value = "好友相关API", tags = {"好友"})
public class FriendController extends BaseController {

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private FriendService friendService;

    /**
     * 查询好友信息，只有自己的好友才查得到
     */
    @PostMapping("/info")
    @ApiOperation(value = "查询好友信息，只有自己的好友才查得到")
    public ApiResult<FriendDto> getFriendInfo(@RequestBody ImFriendBaseParam param) {
        ImClient imClient = imClientService.getCurrentClient();
        if(param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        return ApiResult.ok(friendService.getFriendInfo(imClient, param));
    }

    @PostMapping("/getFriends")
    @ApiOperation(value = "全量获取好友列表")
    public ApiResult<List<FriendDto>> getFriends() {
        ImClient imClient = imClientService.getCurrentClient();
        return ApiResult.ok(friendService.getFriends(imClient));
    }

    /**
     * 好友请求列表，最多只返回1000个
     */
    @PostMapping("/unsureFriends")
    @ApiOperation(value = "获取好友请求列表，最多只返回1000个")
    public ApiResult<List<FriendDto>> getUnsureFriends() {
        ImClient imClient = imClientService.getCurrentClient();
        List<FriendDto> applyFriends = friendService.getApplyFriends(imClient);
        return ApiResult.ok(applyFriends);
    }

}

