package com.wecloud.im.sdk.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * im 客户端
 * @Author luozh
 * @Date 2022年04月07日 16:38
 * @Version 1.0
 */
@Data
public class ImClient implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 客户端id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后离线时间
     */
    private Date lastOfflineTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 应用appid
     */
    private Long fkAppid;

    /**
     * 可选	自定义属性，供开发者扩展使用。
     */
    private String attributes;

    /**
     * 客户方提供的唯一id
     */
    private String clientId;

    /**
     * 头像
     */
    private String headPortrait;

    /**
     * 主昵称
     */
    private String nickname;
}
