package com.wecloud.im.sdk;

import com.wecloud.im.sdk.model.GetSignParam;
import com.wecloud.im.sdk.model.ImClient;
import com.wecloud.im.sdk.model.ImFriend;
import com.wecloud.im.sdk.model.ImTokenVerify;
import com.wecloud.im.sdk.model.Token;

/**
 * wecloud im
 * @Author luozh
 * @Date 2022年04月07日 16:36
 * @Version 1.0
 */
public interface WecloudIm {

    /**
     * 签名
     * @Author luozh
     * @Date 2022年04月07日 06:10:01
     * @param signParam
     * @Return
     */
    String sign(GetSignParam signParam);

    /**
     *
     * @Author luozh
     * @Date 2022年04月07日 05:59:58
     * @param
     * @Return
     */
    Token token(ImTokenVerify tokenVerify);

    /**
     * 获取用户客户端信息
     * @Author luozh
     * @Date 2022年04月07日 04:40:03
     * @param userId 用户id
     * @Return
     */
    ImClient getUserClient(Long userId);


    /**
     * 创建客户端
     * @Author luozh
     * @Date 2022年04月07日 04:41:50
     * @param userId 用户id
     * @param headPortrait 头像
     * @param nickname 昵称
     * @Return
     */
    Boolean createClient(Long userId, String headPortrait, String nickname, Integer deviceType);


    /**
     * 获取朋友信息
     * @Author luozh
     * @Date 2022年04月07日 05:12:19
     * @param clientId 当前客户端id
     * @param userId 用户Id(朋友)
     * @Return
     */
    ImFriend getFriendInfo(Long clientId, Long userId);

    /**
     * 更新头像
     * @Author luozh
     * @Date 2022年04月07日 05:18:03
     * @param clientId 当前客户端id
     * @param headPortrait 头像
     * @Return
     */
    Boolean updateHeadPortrait(Long clientId, String headPortrait);

    /**
     * 更新昵称
     * @Author luozh
     * @Date 2022年04月07日 05:18:03
     * @param clientId 当前客户端id
     * @param nickname 昵称
     * @Return
     */
    Boolean updateNickname(Long clientId, String nickname);

}
